/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.tables;

import de.hannse.netobjects.user.Privileges;
import de.hannse.netobjects.util.Babel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import mausoleum.gui.MToggleButton;
import mausoleum.gui.SortButton;
import mausoleum.main.DefaultManager;
import mausoleum.tables.FilterCombo;
import mausoleum.tables.MausoleumTable;
import mausoleum.tables.MausoleumTableModel;

public class HeaderRenderer
implements TableCellRenderer {
    private SortButton[] ivButtons = new SortButton[50];
    private SortButton ivLastClickedSortButton = null;
    private SortButton ivFilterButton = new SortButton("");
    private SortButton ivFilterButton2 = new SortButton("");

    public HeaderRenderer(JTable table, JScrollPane scrollPane, MausoleumTable mausoleumTable) {
        MausoleumTableModel mtm = (MausoleumTableModel)table.getModel();
        int cc = table.getColumnCount();
        TableColumnModel tcm = table.getColumnModel();
        int col = 0;
        while (col < cc) {
            TableColumn tc = tcm.getColumn(col);
            tc.setHeaderRenderer(this);
            ++col;
        }
        this.ivFilterButton2.setImage("redButton");
        this.ivFilterButton2.setForeground(Color.white);
        if (mtm.ichWillEinenOwnerKnopf() && table.isEnabled()) {
            if (Privileges.hasPrivilege("VIEW_OTHERS_OBJECTS")) {
                MToggleButton allbut = new MToggleButton("A");
                scrollPane.setCorner("UPPER_RIGHT_CORNER", allbut);
                allbut.addActionListener(mtm);
                allbut.setActionCommand("OWN");
                mausoleumTable.ivOwnerKnopf = allbut;
                allbut.setToolTipText(Babel.get("TT_OWENERKNOPF"));
                if (DefaultManager.getAButtonAlwaysPressed()) {
                    mausoleumTable.ivOwnerKnopf.setPressed(true);
                    mausoleumTable.ivModel.checkOwnerButton(mausoleumTable.ivOwnerKnopf);
                }
            }
        } else if (mtm.ichWillEinenSichtbarkeitsKnopf()) {
            MToggleButton allbut = new MToggleButton("A");
            scrollPane.setCorner("UPPER_RIGHT_CORNER", allbut);
            allbut.addActionListener(mtm);
            allbut.setActionCommand("VISIBILITY");
            allbut.setToolTipText(Babel.get("TT_VISIBILITYKNOPF"));
            allbut.setEnabled(Privileges.hasPrivilege("VIEW_INVISIBLE_OBJECTS"));
        }
        table.getTableHeader().addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                int col;
                Rectangle r;
                int dccol;
                JTableHeader jth = (JTableHeader)e.getSource();
                if (jth.getResizingColumn() == null && (dccol = HeaderRenderer.this.getResizeColByKante(r = jth.getHeaderRect(col = jth.getTable().columnAtPoint(e.getPoint())), e.getPoint().x, col)) == -1) {
                    Component hc = HeaderRenderer.this.getTableCellRendererComponent(jth.getTable(), "", false, false, -1, col);
                    if (hc instanceof JPanel) {
                        Component c = HeaderRenderer.this.getClickedHeaderComp((JPanel)hc, col, e.getPoint(), jth);
                        if (c instanceof SortButton && c != HeaderRenderer.this.ivFilterButton && c != HeaderRenderer.this.ivFilterButton2) {
                            HeaderRenderer.this.ivButtons[col].setPressed(true);
                            jth.repaint();
                        }
                    } else {
                        HeaderRenderer.this.ivButtons[col].setPressed(true);
                        jth.repaint();
                    }
                }
            }

            public void mouseReleased(MouseEvent e) {
                boolean tuWas = false;
                int i = 0;
                while (i < HeaderRenderer.this.ivButtons.length) {
                    if (HeaderRenderer.this.ivButtons[i] != null && HeaderRenderer.this.ivButtons[i].isPressed()) {
                        HeaderRenderer.this.ivButtons[i].setPressed(false);
                        tuWas = true;
                    }
                    ++i;
                }
                if (tuWas) {
                    JTableHeader jth = (JTableHeader)e.getSource();
                    jth.repaint();
                }
            }

            public void mouseClicked(MouseEvent e) {
                JTableHeader jth = (JTableHeader)e.getSource();
                if (jth.getResizingColumn() == null) {
                    int col = jth.getTable().columnAtPoint(e.getPoint());
                    Rectangle r = jth.getHeaderRect(col);
                    int dccol = HeaderRenderer.this.getResizeColByKante(r, e.getPoint().x, col);
                    if (dccol != -1) {
                        if (e.getClickCount() == 2) {
                            MausoleumTableModel tableModel = (MausoleumTableModel)jth.getTable().getModel();
                            tableModel.adjustSingleColWidth(dccol);
                        }
                    } else {
                        Component hc = HeaderRenderer.this.getTableCellRendererComponent(jth.getTable(), "", false, false, -1, col);
                        if (hc instanceof JPanel) {
                            Component c = HeaderRenderer.this.getClickedHeaderComp((JPanel)hc, col, e.getPoint(), jth);
                            if (c instanceof SortButton) {
                                if (c == HeaderRenderer.this.ivFilterButton || c == HeaderRenderer.this.ivFilterButton2) {
                                    Vector pv;
                                    MausoleumTableModel tmtm = (MausoleumTableModel)jth.getTable().getModel();
                                    String colKennung = tmtm.getDefinedColumnName(col);
                                    if (tmtm.ivFilterVerwendet && tmtm.ivFilterValues != null && (pv = (Vector)tmtm.ivFilterableValues.get(colKennung)) != null) {
                                        Integer inti = (Integer)tmtm.ivFilterValues.get(colKennung);
                                        FilterCombo fc = new FilterCombo(pv, colKennung, tmtm, inti);
                                        Rectangle b = c.getBounds();
                                        b.x += r.x;
                                        b.width = fc.getPreferredSize().width;
                                        if (r.width > b.width) {
                                            b.width = r.width;
                                        }
                                        fc.setBounds(b);
                                        jth.add(fc);
                                        fc.showPopup();
                                    }
                                } else {
                                    HeaderRenderer.this.sortButtonClicked(HeaderRenderer.this.ivButtons[col], jth);
                                }
                            }
                        } else {
                            HeaderRenderer.this.sortButtonClicked(HeaderRenderer.this.ivButtons[col], jth);
                        }
                    }
                }
            }
        });
    }

    public void tausche(int fromIndex, int toIndex) {
        SortButton[] vor = this.ivButtons;
        SortButton[] nach = new SortButton[vor.length];
        nach[toIndex] = vor[fromIndex];
        int f = 0;
        while (f < vor.length) {
            if (f != fromIndex) {
                boolean cont = true;
                SortButton s = vor[f];
                if (s != null) {
                    int t = 0;
                    while (t < nach.length && cont) {
                        if (nach[t] == null) {
                            nach[t] = s;
                            cont = false;
                        }
                        ++t;
                    }
                }
            }
            ++f;
        }
        this.ivButtons = nach;
    }

    private int getResizeColByKante(Rectangle r, int mx, int col) {
        int diffvorn;
        int diffhinten = mx - (r.x + r.width);
        if (diffhinten < 0) {
            diffhinten = -diffhinten;
        }
        if ((diffvorn = mx - r.x) < 0) {
            diffvorn = -diffvorn;
        }
        int dccol = -1;
        int diff = diffvorn;
        if (diffhinten < diffvorn) {
            diff = diffhinten;
            if (diff < 4) {
                dccol = col;
            }
        } else if (diff < 4) {
            dccol = col - 1;
        }
        return dccol;
    }

    private void sortButtonClicked(SortButton mgb, JTableHeader jth) {
        if (mgb != null) {
            TableModel tm;
            mgb.setPressed(false);
            if (this.ivLastClickedSortButton != null && mgb != this.ivLastClickedSortButton) {
                this.ivLastClickedSortButton.setMode(0);
            }
            if ((tm = jth.getTable().getModel()) instanceof MausoleumTableModel) {
                MausoleumTableModel mtm = (MausoleumTableModel)tm;
                mtm.setSortFaktor(mgb.toggleMode());
                jth.repaint();
                mtm.sortObjectsByColumn(mgb.getActionCommand());
                this.ivLastClickedSortButton = mgb;
            }
        }
    }

    private Component getClickedHeaderComp(JPanel pan, int col, Point clickPoint, JTableHeader jth) {
        Rectangle r = jth.getHeaderRect(col);
        Point cp = new Point(clickPoint.x - r.x, clickPoint.y - r.y);
        Component[] carr = pan.getComponents();
        int i = 0;
        while (i < carr.length) {
            Rectangle bounds = carr[i].getBounds();
            bounds.width = r.width;
            if (bounds.contains(cp)) {
                return carr[i];
            }
            ++i;
        }
        return null;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        int indexInCombo;
        Integer inti;
        Vector possibleValues;
        MausoleumTableModel mtm = (MausoleumTableModel)table.getModel();
        if (this.ivButtons[column] == null) {
            this.ivButtons[column] = new SortButton(table.getColumnName(column));
        }
        String tooltip = null;
        String ttPreBabel = mtm.getColumnTooltip(column);
        if (ttPreBabel != null && ttPreBabel.trim().length() != 0) {
            tooltip = Babel.get(ttPreBabel);
        }
        this.ivButtons[column].setToolTipText(tooltip);
        String colName = mtm.getDefinedColumnName(column);
        this.ivButtons[column].setActionCommand(colName);
        if (mtm.ivFilterVerwendet && mtm.ivFilterValues != null && (possibleValues = (Vector)mtm.ivFilterableValues.get(mtm.getDefinedColumnName(column))) != null && (inti = (Integer)mtm.ivFilterValues.get(mtm.getDefinedColumnName(column))) != null && (indexInCombo = inti.intValue()) >= 0 && indexInCombo < possibleValues.size()) {
            SortButton fbut = this.ivFilterButton;
            if (indexInCombo != 0) {
                fbut = this.ivFilterButton2;
            }
            if (indexInCombo == 3 || indexInCombo == 4) {
                MausoleumTableModel.SpecifiedString sps = mtm.getSpecifiedString(mtm.getDefinedColumnName(column));
                String prefix = Babel.get(indexInCombo == 3 ? "WITH" : "WITHOUT");
                fbut.setText(String.valueOf(prefix) + " " + (sps != null ? sps.toString() : "<???>"));
            } else {
                Object ppp = possibleValues.elementAt(indexInCombo);
                if (ppp instanceof String) {
                    fbut.setText((String)ppp);
                } else {
                    fbut.setText(ppp.toString());
                }
            }
            fbut.setToolTipText(tooltip);
            JPanel pan = new JPanel(new GridLayout(2, 1));
            pan.add(this.ivButtons[column]);
            fbut.setPreferredSize(new Dimension(200, 24));
            pan.setToolTipText(tooltip);
            pan.add(fbut);
            return pan;
        }
        return this.ivButtons[column];
    }
}

