/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.tables;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.util.Babel;
import java.awt.BorderLayout;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JFrame;
import mausoleum.gui.ClosableTabbedPane;
import mausoleum.gui.RequesterPane;
import mausoleum.helper.MausoleumImageStore;
import mausoleum.helper.WindowUtils;
import mausoleum.tables.MausoleumTable;
import mausoleum.tables.models.MTLegacyCage;
import mausoleum.tables.models.MTLegacyLine;
import mausoleum.tables.models.MTLegacyLocus;
import mausoleum.tables.models.MTLegacyMouse;
import mausoleum.tables.models.MTLegacyStrain;
import mausoleum.tables.models.MTLegacyUser;
import mausoleum.ui.UIDef;

public class LegacyObjectsFrame
extends JFrame {
    private static final long serialVersionUID = 14861313L;
    private static final int[] TYPES = new int[]{1, 2, 7, 14, 8, 6};
    private static final String[] BABELS = new String[]{"MICE", "CAGES", "LINES", "LOCI", "STRAINS", "USERS"};
    private final ClosableTabbedPane ivTabbedPane = new ClosableTabbedPane(true, true);

    public static void showLegacyObjects(HashMap requestObject, String group) {
        HashMap neueObjekte;
        HashMap newObjectsByGroup;
        if (requestObject != null && (newObjectsByGroup = (HashMap)requestObject.get("#sno")) != null && (neueObjekte = (HashMap)newObjectsByGroup.get(group)) != null && !neueObjekte.isEmpty()) {
            new LegacyObjectsFrame(neueObjekte, group);
        }
    }

    private LegacyObjectsFrame(HashMap neueObjekte, String group) {
        this.setTitle(Babel.get("IMPORTED_OBJECTS"));
        this.setIconImage(MausoleumImageStore.getLogo());
        this.setContentPane(new RequesterPane(new BorderLayout()));
        this.getContentPane().add("Center", this.ivTabbedPane);
        this.setBounds(UIDef.getScaled(10), UIDef.getScaled(10), UIDef.getScaled(500), UIDef.getScaled(400));
        int i = 0;
        while (i < TYPES.length) {
            this.getImportTable(neueObjekte, TYPES[i], group);
            ++i;
        }
        WindowUtils.bringUpFrame(this);
    }

    private MausoleumTable getImportTable(HashMap neueObjekte, int objType, String group) {
        Vector objectIds;
        MausoleumTable table = null;
        if (neueObjekte != null && (objectIds = (Vector)neueObjekte.get(new Integer(objType))) != null) {
            Vector<IDObject> objects = new Vector<IDObject>();
            Iterator iter = objectIds.iterator();
            while (iter.hasNext()) {
                Long objectID = (Long)iter.next();
                IDObject ido = ObjectStore.getClientObject(objType, objectID, group);
                if (ido == null) continue;
                objects.add(ido);
            }
            if (!objects.isEmpty()) {
                switch (objType) {
                    case 2: {
                        table = new MausoleumTable(new MTLegacyCage(), false);
                        break;
                    }
                    case 7: {
                        table = new MausoleumTable(new MTLegacyLine(), false);
                        break;
                    }
                    case 14: {
                        table = new MausoleumTable(new MTLegacyLocus(), false);
                        break;
                    }
                    case 1: {
                        table = new MausoleumTable(new MTLegacyMouse(), false);
                        break;
                    }
                    case 8: {
                        table = new MausoleumTable(new MTLegacyStrain(), false);
                        break;
                    }
                    case 6: {
                        table = new MausoleumTable(new MTLegacyUser(), false);
                        break;
                    }
                }
                if (table != null) {
                    table.ivModel.setTable(objects);
                    table.setIsSubdisplay();
                    table.ivModel.sortObjectsByColumn("FKEY");
                }
                String title = StringHelper.getStringForInt(objType, TYPES, BABELS, true, "?");
                this.ivTabbedPane.addTab(title, table);
            }
        }
        return table;
    }
}

