/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.tables;

import de.hannse.netobjects.user.Privileges;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import mausoleum.gui.MDisposable;
import mausoleum.gui.MToggleButton;
import mausoleum.gui.ScrollPaneHelper;
import mausoleum.helper.FontManager;
import mausoleum.inspector.Inspector;
import mausoleum.main.DefaultManager;
import mausoleum.tables.HeaderRenderer;
import mausoleum.tables.JTableForCages;
import mausoleum.tables.MausoleumTableModel;
import mausoleum.tables.models.MTCage;
import mausoleum.tables.models.MTPopuMenu;
import mausoleum.tables.models.MTWedding;
import mausoleum.ui.UIDef;

public class MausoleumTable
extends JPanel
implements MDisposable {
    private static final long serialVersionUID = 4252014529655272145L;
    private static final int BORDER_WIDTH = UIDef.getScaled(5);
    public static final LineBorder ACTIVE_BORDER = new LineBorder(new Color(170, 0, 0), BORDER_WIDTH);
    public static final LineBorder PASSIVE_BORDER = new LineBorder(UIDef.BACKGROUND_NORMAL, BORDER_WIDTH);
    private static final LineBorder PASSIVE_SUB_BORDER = new LineBorder(UIDef.BACKGROUND_SUB, BORDER_WIDTH);
    private static final Dimension DIM_300 = new Dimension(UIDef.getScaled(300), UIDef.getScaled(150));
    private static final Dimension DIM_100 = new Dimension(UIDef.getScaled(100), UIDef.getScaled(100));
    public final MausoleumTableModel ivModel;
    public final JTable ivJTable;
    public final JScrollPane ivScrollPane;
    private JComponent ivHeaderComponent = null;
    public MToggleButton ivOwnerKnopf = null;
    public boolean ivIsSubDisplay = false;
    private boolean ivIsActive = false;
    public boolean ivInspectorWillReact = true;
    private boolean ivColResize = false;
    static /* synthetic */ Class class$0;

    public MausoleumTable(MausoleumTableModel mtm, boolean isInspectorDisplay) {
        this(mtm, isInspectorDisplay, true);
    }

    public MausoleumTable(MausoleumTableModel mtm, boolean isInspectorDisplay, boolean active) {
        super(new BorderLayout());
        this.ivModel = mtm;
        this.ivJTable = mtm instanceof MTCage || mtm instanceof MTWedding ? new JTableForCages(mtm) : new JTable(mtm);
        this.ivJTable.setRowSelectionAllowed(false);
        this.ivJTable.setColumnSelectionAllowed(false);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.ivJTable.setDefaultRenderer(clazz, mtm);
        if (active) {
            mtm.sortDefault();
        }
        this.setOpaque(true);
        this.setBackground(UIDef.BACKGROUND_NORMAL);
        if (active) {
            if (isInspectorDisplay) {
                mtm.setIsSubDisplay();
                this.ivInspectorWillReact = false;
            } else {
                this.setBorder(PASSIVE_BORDER);
            }
        }
        this.ivJTable.setEnabled(active);
        mtm.setJTable(this.ivJTable);
        mtm.setMausoleumTable(this);
        this.ivScrollPane = new JScrollPane(this.ivJTable);
        this.add("Center", this.ivScrollPane);
        this.ivScrollPane.setOpaque(true);
        if (isInspectorDisplay) {
            this.ivScrollPane.setBackground(UIDef.BACKGROUND_SUB);
            this.ivScrollPane.getViewport().setBackground(UIDef.BACKGROUND_SUB);
            this.ivJTable.setBackground(UIDef.BACKGROUND_SUB);
        } else {
            this.ivScrollPane.setBackground(UIDef.BACKGROUND_NORMAL);
            this.ivScrollPane.getViewport().setBackground(UIDef.BACKGROUND_NORMAL);
            if (mtm.ichWillEinenOwnerKnopf() && Privileges.hasPrivilege("VIEW_OTHERS_OBJECTS") || mtm.ichWillEinenSichtbarkeitsKnopf()) {
                this.ivScrollPane.setVerticalScrollBarPolicy(22);
            } else {
                this.ivScrollPane.setVerticalScrollBarPolicy(20);
            }
            this.ivJTable.setBackground(UIDef.BACKGROUND_NORMAL);
        }
        if (active) {
            this.ivScrollPane.getViewport().addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    if (!e.isMetaDown()) {
                        MausoleumTable.this.ivModel.selectNone();
                    }
                }
            });
        }
        this.ivScrollPane.getViewport().setOpaque(true);
        this.ivJTable.setOpaque(true);
        this.ivJTable.setGridColor(Color.black);
        this.ivJTable.setRowHeight(FontManager.getTableRowHeight());
        if (active) {
            this.ivJTable.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

                public void columnAdded(TableColumnModelEvent e) {
                }

                public void columnMarginChanged(ChangeEvent e) {
                    MausoleumTable.this.ivColResize = true;
                }

                public void columnMoved(TableColumnModelEvent e) {
                    int toIndex;
                    int fromIndex = e.getFromIndex();
                    if (fromIndex != (toIndex = e.getToIndex())) {
                        MausoleumTableModel mtm = (MausoleumTableModel)MausoleumTable.this.ivJTable.getModel();
                        String[] vor = mtm.ivColumnNames;
                        String[] nach = new String[vor.length];
                        nach[toIndex] = vor[fromIndex];
                        int f = 0;
                        while (f < vor.length) {
                            if (f != fromIndex) {
                                boolean cont = true;
                                String s = vor[f];
                                int t = 0;
                                while (t < nach.length && cont) {
                                    if (nach[t] == null) {
                                        nach[t] = s;
                                        cont = false;
                                    }
                                    ++t;
                                }
                            }
                            ++f;
                        }
                        mtm.ivColumnNames = nach;
                        if (mtm.ivAktHeaderRenderer != null) {
                            mtm.ivAktHeaderRenderer.tausche(fromIndex, toIndex);
                        }
                        DefaultManager.storeTableDefObject(mtm);
                    }
                }

                public void columnRemoved(TableColumnModelEvent e) {
                }

                public void columnSelectionChanged(ListSelectionEvent e) {
                }
            });
            this.ivJTable.getTableHeader().addMouseListener(new MouseAdapter(){

                public void mouseReleased(MouseEvent e) {
                    if (MausoleumTable.this.ivColResize) {
                        DefaultManager.storeTableDefObject(MausoleumTable.this.ivModel);
                        MausoleumTable.this.ivColResize = false;
                    }
                }
            });
        }
        mtm.ivAktHeaderRenderer = new HeaderRenderer(this.ivJTable, this.ivScrollPane, this);
        if (active) {
            mtm.setFilter(DefaultManager.isFiltering(mtm));
            new MTPopuMenu(this);
        }
    }

    public void mDispose() {
        if (this.ivModel != null) {
            this.ivModel.mDispose();
        }
        this.ivHeaderComponent = null;
        if (this.ivOwnerKnopf != null) {
            this.ivOwnerKnopf.dispose();
            this.ivOwnerKnopf = null;
        }
    }

    public void setIsSubdisplay() {
        this.ivIsSubDisplay = true;
        this.ivModel.setIsSubDisplay();
        this.setYourBackground(UIDef.BACKGROUND_SUB);
        if (!this.ivIsActive) {
            this.setBorder(PASSIVE_SUB_BORDER);
        }
    }

    public void setYourBackground(Color bg) {
        this.setBackground(bg);
        this.ivScrollPane.setBackground(bg);
        this.ivScrollPane.getViewport().setBackground(bg);
        this.ivJTable.setBackground(bg);
        if (this.ivHeaderComponent != null) {
            this.ivHeaderComponent.setBackground(bg);
        }
    }

    public void setOwnerButtonState(boolean pressed) {
        if (this.ivOwnerKnopf != null && this.ivOwnerKnopf.isPressed() != pressed) {
            this.ivOwnerKnopf.setPressed(pressed);
            this.ivModel.checkOwnerButton(this.ivOwnerKnopf);
        }
    }

    public void setHeader(String s) {
        this.setHeader(s, FontManager.getFont("SSB16"));
    }

    public void setHeader(String s, Font f) {
        if (this.ivHeaderComponent == null) {
            JLabel lab = new JLabel(s);
            this.ivHeaderComponent = lab;
            lab.setFont(f);
            lab.setOpaque(true);
            lab.setBackground(this.getBackground());
            lab.setHorizontalAlignment(0);
            lab.setForeground(Color.black);
            this.add("North", this.ivHeaderComponent);
        } else if (this.ivHeaderComponent instanceof JLabel) {
            JLabel lab = (JLabel)this.ivHeaderComponent;
            lab.setText(s);
            lab.setFont(f);
            lab.repaint();
        }
    }

    public void setHeaderComponent(JComponent comp) {
        this.ivHeaderComponent = comp;
        this.add("North", this.ivHeaderComponent);
    }

    public Vector getSelectedObjects() {
        return this.ivModel.getSelectedObjects();
    }

    public void windowActivation(boolean act) {
        this.setIsActive(act);
        if (act && Inspector.cvActTable != this) {
            Inspector.adjustToTable(this);
        }
    }

    public void setIsActive(boolean act) {
        if (act != this.ivIsActive) {
            this.ivIsActive = act;
            if (act) {
                this.setBorder(ACTIVE_BORDER);
            } else {
                this.setBorder(this.ivIsSubDisplay ? PASSIVE_SUB_BORDER : PASSIVE_BORDER);
            }
        }
    }

    public boolean getIsActive() {
        return this.ivIsActive;
    }

    public void ensureSelectionIsVisible() {
        JScrollBar sb;
        if (this.ivModel.ivSelectedRows.size() != 0 && this.ivScrollPane != null && (sb = this.ivScrollPane.getVerticalScrollBar()) != null && sb.isEnabled()) {
            Integer inti = (Integer)this.ivModel.ivSelectedRows.last();
            ScrollPaneHelper.ensureVisibility(sb, inti, this.ivModel.getRowCount());
        }
    }

    public Dimension getPreferredSize() {
        return DIM_300;
    }

    public Dimension getMinimumSize() {
        return DIM_100;
    }
}

