/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.tables;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.ObjectStoreClient;
import de.hannse.netobjects.util.Log;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import mausoleum.helper.MausoleumImageStore;
import mausoleum.helper.WindowUtils;
import mausoleum.inspector.Inspector;
import mausoleum.tables.MausoleumTable;
import mausoleum.tables.MausoleumTableModel;
import mausoleum.tables.TableFrameBasicObjects;
import mausoleum.tables.TableFrameMouse;

public abstract class MausoleumTableFrame
extends JFrame {
    private static final long serialVersionUID = 1123131L;
    private static final Vector ALL_TABLES = new Vector();
    public static final HashMap MAIN_TABLES = new HashMap(20);
    private static TableFrameBasicObjects cvBasicFrame = null;
    public MausoleumTable ivMausoleumTable = null;
    private boolean ivSubDisplayShouldDispose = true;
    static /* synthetic */ Class class$0;

    public static JFrame showComponent(Component c) {
        JFrame res = WindowUtils.getJFrameAndSelectTabs(c);
        WindowUtils.bringUpFrame(res);
        return res;
    }

    public static JFrame showMainTableForType(int type) {
        Component comp = (Component)MAIN_TABLES.get(new Integer(type));
        if (comp != null) {
            if (comp instanceof MausoleumTable) {
                MausoleumTable foundTable = (MausoleumTable)comp;
                Inspector.adjustToTable(foundTable);
            } else if (comp instanceof JTabbedPane) {
                JTabbedPane jtb = (JTabbedPane)comp;
                jtb.setSelectedIndex(jtb.getSelectedIndex());
            }
            return MausoleumTableFrame.showComponent(comp);
        }
        String string = "UNBEDIENT " + IDObject.getFilenameForTypeClientSide(type);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("mausoleum.tables.MausoleumTableFrame");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Log.error(string, null, clazz);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeAllTables(boolean isForSleep) {
        if (ALL_TABLES != null) {
            Vector vector = ALL_TABLES;
            synchronized (vector) {
                Vector toRemove = new Vector(ALL_TABLES);
                Iterator iter = toRemove.iterator();
                while (iter.hasNext()) {
                    MausoleumTableFrame mtf = (MausoleumTableFrame)iter.next();
                    mtf.dispose();
                }
            }
            if (!isForSleep) {
                TableFrameMouse.removeSessionTables();
            }
        }
    }

    public static void repaintAllTables(boolean removeMainTable) {
        if (removeMainTable) {
            MausoleumTableFrame.initMainTables();
        } else if (cvBasicFrame != null && cvBasicFrame.isShowing()) {
            cvBasicFrame.repaint();
        }
        HashSet hs = ObjectStoreClient.getAllMausoleumTables();
        Iterator iter = hs.iterator();
        while (iter.hasNext()) {
            MausoleumTableModel mtm = (MausoleumTableModel)iter.next();
            if (mtm.ivMausoleumTable == null) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("mausoleum.tables.MausoleumTableFrame");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.error("Try to redraw MausoleumTableModel without table", null, clazz);
                continue;
            }
            mtm.ivMausoleumTable.repaint();
        }
    }

    public static void initMainTables() {
        MausoleumTableFrame.removeMainFrame();
        cvBasicFrame = new TableFrameBasicObjects();
    }

    public static void updateDefinitionlistsIfPresent() {
        if (cvBasicFrame != null) {
            cvBasicFrame.updateDefinitionlists();
        }
    }

    public static void updateListDefinitionPane() {
        if (cvBasicFrame != null) {
            cvBasicFrame.updateDefinitionlists();
        }
    }

    public static void removeMainFrame() {
        if (cvBasicFrame != null) {
            cvBasicFrame.clearCompletely();
            cvBasicFrame = null;
        }
    }

    public static boolean isMainFrame(JFrame jf) {
        return cvBasicFrame != null && cvBasicFrame.equals(jf);
    }

    public MausoleumTableFrame(MausoleumTable mt) {
        this.ivMausoleumTable = mt;
        this.getContentPane().setLayout(new BorderLayout());
        if (this.ivMausoleumTable != null) {
            this.getContentPane().add("Center", this.ivMausoleumTable);
        }
        this.setIconImage(MausoleumImageStore.getLogo());
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent evt) {
                MausoleumTableFrame.this.rememberBounds();
            }

            public void componentMoved(ComponentEvent evt) {
                MausoleumTableFrame.this.rememberBounds();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                if (MausoleumTableFrame.this.ivMausoleumTable != null && MausoleumTableFrame.this.ivMausoleumTable.ivIsSubDisplay) {
                    Inspector.setToDefault();
                    if (MausoleumTableFrame.this.ivSubDisplayShouldDispose) {
                        MausoleumTableFrame.this.dispose();
                    } else {
                        MausoleumTableFrame.this.setVisible(false);
                    }
                } else {
                    MausoleumTableFrame.this.rememberBounds();
                    MausoleumTableFrame.this.setVisible(false);
                    Inspector.setToDefault();
                }
            }

            public void windowActivated(WindowEvent e) {
                MausoleumTable mt = MausoleumTableFrame.this.getActiveTableForInspector();
                if (mt != null) {
                    mt.windowActivation(true);
                }
            }
        });
        ALL_TABLES.add(this);
    }

    public MausoleumTable getActiveTableForInspector() {
        return this.ivMausoleumTable;
    }

    public void dispose() {
        ALL_TABLES.remove(this);
        super.dispose();
    }

    public void setVisible(boolean vis) {
        if (vis && !this.isVisible()) {
            if (this.ivMausoleumTable != null && this.ivMausoleumTable.ivIsSubDisplay) {
                this.setSize(this.getDefaultSize());
            } else {
                WindowUtils.setRememberedBounds(this, new Rectangle(0, 0, this.getDefaultSize().width, this.getDefaultSize().height));
            }
        }
        super.setVisible(vis);
    }

    public abstract Dimension getDefaultSize();

    public void rememberBounds() {
        if (this.ivMausoleumTable != null && !this.ivMausoleumTable.ivIsSubDisplay) {
            WindowUtils.rememberBounds(this);
        }
    }

    public void setSubDisplayShouldDispose(boolean b) {
        this.ivSubDisplayShouldDispose = b;
    }

    public void setWindowTitle() {
    }

    public void printIt() {
    }
}

