/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.tables;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.IDObjectXMLHandler;
import de.hannse.netobjects.objectstore.IdentifiableObject;
import de.hannse.netobjects.objectstore.LifeStateReporter;
import de.hannse.netobjects.objectstore.ObjectConsumer;
import de.hannse.netobjects.objectstore.ObjectManager;
import de.hannse.netobjects.objectstore.ObjectStoreClient;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.user.Privileges;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.ArrayHelper;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.Log;
import de.hannse.netobjects.util.MilliSpender;
import de.hannse.netobjects.util.MyDate;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import mausoleum.cage.Cage;
import mausoleum.gui.MDisposable;
import mausoleum.gui.MToggleButton;
import mausoleum.gui.MausoleumTableLabel;
import mausoleum.helper.AllgUtils;
import mausoleum.helper.ClipboardObject;
import mausoleum.helper.DatumFormat;
import mausoleum.helper.FontManager;
import mausoleum.helper.ImageProvider;
import mausoleum.helper.WindowUtils;
import mausoleum.helper.Zeile;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.sensitives.ChangeSensitive;
import mausoleum.main.DefaultManager;
import mausoleum.main.MausoleumClient;
import mausoleum.mouse.Mouse;
import mausoleum.rack.ExtendedRackPos;
import mausoleum.rack.frame.RackFrame;
import mausoleum.rack.frame.RackFrameMouseManager;
import mausoleum.reports.TrafficReport;
import mausoleum.requester.CopyRequester;
import mausoleum.requester.preferences.Preferences;
import mausoleum.tables.HeaderRenderer;
import mausoleum.tables.JTableForCages;
import mausoleum.tables.MausoleumTable;
import mausoleum.tables.MausoleumTableSelectionListener;
import mausoleum.tables.MausoleumTableTabbedPane;
import mausoleum.tables.OwnAllListener;
import mausoleum.tables.SplitFilterObject;
import mausoleum.tables.TableDefinitionObjectExtended;
import mausoleum.tables.models.MTCage;
import mausoleum.tables.models.MTMouse;
import mausoleum.tables.models.MTTaskInSchedule;
import mausoleum.tables.sorting.ExtendedSortDialog;
import mausoleum.tables.sorting.MultiSortEntry;
import mausoleum.task.DisplayTask;
import mausoleum.ui.UIDef;

public abstract class MausoleumTableModel
implements TableModel,
TableCellRenderer,
ObjectConsumer,
ActionListener,
MouseListener,
MouseMotionListener,
KeyListener,
MDisposable {
    public static final String COM_OWN = "OWN";
    public static final String COM_VISIBILITY = "VISIBILITY";
    public static final String STR_ID = "ID";
    public static final String STR_FKEY = "FKEY";
    public static final String STR_GROUP = "GROUP";
    public static final String STR_START = "START";
    public static final String STR_END = "END";
    public static final String TT_ID = "MTM_TT_ID";
    public static final String TT_FKEY = "MTM_TT_FKEY";
    public static final String TT_GROUP = "MTM_TT_GROUP";
    public static final String TT_START = "MTC_TT_START";
    public static final String TT_END = "MTC_TT_END";
    private static final String[] TT_DICT = new String[]{"ID", "MTM_TT_ID", "FKEY", "MTM_TT_FKEY", "GROUP", "MTM_TT_GROUP", "START", "MTC_TT_START", "END", "MTC_TT_END"};
    private static final String[] POSSIBLES = new String[]{"ID", "FKEY", "GROUP", "START", "END"};
    private static final String[] SORTABLES = new String[]{"ID", "FKEY", "GROUP", "START", "END"};
    private static final String[] EDITABLES = new String[0];
    private static final String[] FILTERABLES = new String[]{"GROUP", "START", "END"};
    private static final Boolean EMPTY_SIGNAL = new Boolean(true);
    private static final Boolean NON_EMPTY_SIGNAL = new Boolean(false);
    public static final int FILTER_COMBO_ALL = 0;
    public static final int FILTER_COMBO_EMPTY = 1;
    public static final int FILTER_COMBO_NON_EMPTY = 2;
    public static final int FILTER_COMBO_CONTAINING = 3;
    public static final int FILTER_COMBO_NOT_CONTAINING = 4;
    public static final Border EDITABLE_BORDER = new LineBorder(Color.yellow, 1);
    public static final Integer EINS = new Integer(1);
    public static final Integer NULL_INT = new Integer(0);
    public static final HashMap GENERAL_PLAIN_SORTINGS = new HashMap();
    private static final MouseWheelListener WHEELY = new MouseWheelListener(){

        public void mouseWheelMoved(MouseWheelEvent e) {
            if (DefaultManager.cvUseMouseWheelInTables && ((e.getModifiers() & 2) != 0 || (e.getModifiers() & 1) != 0)) {
                JTable table = (JTable)e.getSource();
                MausoleumTableModel mtm = (MausoleumTableModel)table.getModel();
                int asel = mtm.ivZoomIndex;
                int notches = e.getWheelRotation();
                int nsel = asel + notches;
                if (nsel < 0) {
                    nsel = 0;
                } else if (nsel >= Preferences.ZOOM_FACTORS.length) {
                    nsel = Preferences.ZOOM_FACTORS.length - 1;
                }
                if (asel != nsel) {
                    mtm.ivZoomIndex = nsel;
                    mtm.ivZoom = Preferences.ZOOM_FACTORS[nsel];
                    table.repaint();
                    DefaultManager.setTableZoom(mtm);
                }
            } else {
                e.getComponent().getParent().dispatchEvent(e);
            }
        }
    };
    public final String ivMUTEX = "MUTEX" + MilliSpender.getMillis();
    public final Vector ivObjects = new Vector();
    public final Vector ivOriginalObjects = new Vector();
    public final TreeSet ivSelectedRows = new TreeSet();
    private MausoleumTableLabel ivLabel = new MausoleumTableLabel();
    protected String[] ivColumnNames = null;
    public final HashSet ivColouredColumns = new HashSet();
    private boolean ivIsSubDisplay = false;
    private boolean ivIsExecutable = true;
    protected boolean ivFilterByVisibility = this.ichWillEinenSichtbarkeitsKnopf();
    protected boolean ivOwnedObjects = this.ichWillEinenOwnerKnopf();
    private int ivObjectType = -1;
    private JTable ivTable;
    public MausoleumTable ivMausoleumTable = null;
    protected int ivSortFaktor = 1;
    private String[] ivLastSortColNames = null;
    private boolean[] ivLastSortInverteds = null;
    private final Vector ivOwnAllListeners = new Vector();
    private final Vector ivSelectionListeners = new Vector();
    private int ivDragStart = -1;
    private int ivLastPressed = -1;
    private ExtendedRackPos ivExtendedRackPos = null;
    public boolean ivFilterVerwendet = false;
    public Hashtable ivFilterableValues = null;
    public Hashtable ivFilterValues = null;
    private MausoleumTableLabel ivFilterLabel = new MausoleumTableLabel();
    public boolean ivUseDefaultFontSize = false;
    public boolean ivStoreSettingsUponChange = true;
    public HeaderRenderer ivAktHeaderRenderer = null;
    private final HashMap ivFilterSpecifiedStrings = new HashMap();
    private String ivGroupFilter = null;
    public boolean ivOwnerFiltered = false;
    private final HashMap ivComboMusts = new HashMap();
    public boolean ivAdjustInspector = true;
    JMenuItem ivNormalTrafficItem = null;
    JMenuItem ivExtendedTrafficItem = null;
    public double ivZoom = 1.0;
    public int ivZoomIndex = 0;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        GENERAL_PLAIN_SORTINGS.put(STR_START, "IDO_START_DATE");
        GENERAL_PLAIN_SORTINGS.put(STR_END, "IDO_END_DATE");
        GENERAL_PLAIN_SORTINGS.put(STR_FKEY, "IDO_FKEY");
        GENERAL_PLAIN_SORTINGS.put(STR_GROUP, "IDO_GROUP");
        GENERAL_PLAIN_SORTINGS.put(STR_ID, "IDO_ID");
    }

    public static boolean isGeneralColDef(String val) {
        if (val != null) {
            int i = 0;
            while (i < POSSIBLES.length) {
                if (POSSIBLES[i].equals(val)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private static boolean isEmptyVal(Object val) {
        if (val != null) {
            if (val instanceof String) {
                String s = (String)val;
                return s.trim().length() == 0;
            }
            return false;
        }
        return true;
    }

    public MausoleumTableModel() {
        this.ivLabel.setOpaque(true);
        try {
            Integer typeid;
            ObjectStoreClient.addConsumer((ObjectConsumer)this, this.getConsumertypes());
            TableDefinitionObjectExtended tdo = DefaultManager.getTableDefinitionObject(this);
            String[] coloreds = null;
            if (tdo != null) {
                this.ivColumnNames = this.checkColumns(tdo.ivNames);
                coloreds = this.checkColumns(tdo.ivColoredNames);
            }
            if (this.ivColumnNames == null) {
                this.ivColumnNames = this.checkColumns(this.getDefaultColumnNames());
            }
            if (coloreds == null) {
                coloreds = this.checkColumns(this.getDefaultColorableColumns());
            }
            if (coloreds != null) {
                int i = 0;
                while (i < coloreds.length) {
                    this.ivColouredColumns.add(coloreds[i]);
                    ++i;
                }
            }
            if ((typeid = IDObject.getTypeByClass(this.getServedClass())) != null) {
                this.ivObjectType = typeid;
            }
        }
        catch (Exception e) {
            Log.error("Kacke MausoleumTableModel Initializer", e, this);
        }
        this.ivZoom = DefaultManager.getTableZoom(this);
        this.ivZoomIndex = ArrayHelper.finddoubleInArray(this.ivZoom, Preferences.ZOOM_FACTORS);
    }

    public void mDispose() {
        ObjectStoreClient.removeConsumer((ObjectConsumer)this, this.getConsumertypes());
        this.ivObjects.clear();
        this.ivOriginalObjects.clear();
        this.ivSelectedRows.clear();
        this.ivLabel.dispose();
        this.ivColumnNames = null;
        this.ivColouredColumns.clear();
        this.ivTable = null;
        this.ivMausoleumTable = null;
        this.ivLastSortColNames = null;
        this.ivOwnAllListeners.clear();
        this.ivSelectionListeners.clear();
        if (this.ivExtendedRackPos != null) {
            this.ivExtendedRackPos.mDispose();
            this.ivExtendedRackPos = null;
        }
        if (this.ivFilterableValues != null) {
            this.ivFilterableValues.clear();
            this.ivFilterableValues = null;
        }
        if (this.ivFilterValues != null) {
            this.ivFilterValues.clear();
            this.ivFilterValues = null;
        }
        if (this.ivFilterLabel != null) {
            this.ivFilterLabel.dispose();
            this.ivFilterLabel = null;
        }
        this.ivAktHeaderRenderer = null;
        if (this.ivFilterSpecifiedStrings != null) {
            this.ivFilterSpecifiedStrings.clear();
        }
    }

    public abstract MausoleumTableModel getDefaultModel();

    public abstract String[] getPossibleColumns();

    public abstract String[] getSortableColumns();

    public abstract String[] getEditableColumns();

    public abstract String[] getTooltipDict();

    public abstract String[] getColorableColumns();

    public abstract String[] getDefaultColorableColumns();

    public abstract int[] getConsumertypes();

    public abstract int[] getWidths();

    public abstract String[] getDefaultColumnNames();

    public abstract Class getServedClass();

    public abstract ObjectManager getManager();

    public abstract String getDefaultSortColumn();

    public abstract String getDisplayName();

    public abstract HashMap getPlainSortings();

    public abstract void writeTheCodedElement(MausoleumTableLabel var1, Object var2, String var3, boolean var4);

    public abstract void fillSortVector(Vector var1, String var2, int var3);

    public abstract ActionListener getActionListenerForColumn(String var1);

    public abstract int getTableType();

    public String getHTMLDescription() {
        String headerStyle = "style=\"border:thin solid black; padding:8px;font-weight:bold;background-color:#E3E3E3;\"";
        String tdStyle = "style=\"border:thin solid black; padding:3px;background-color:#F9F8E3;\"";
        StringBuilder msb = new StringBuilder();
        msb.append("<br>\n<br>\nDescription for: ").append(this.getClass().getName()).append("<br>\n\n");
        msb.append("<p align=\"center\">\n");
        msb.append("<table border=\"0\" style=\"border-collapse:collapse\">\n");
        msb.append("<tr>\n");
        msb.append("<td ").append(headerStyle).append(">").append("Column header").append("</td>\n");
        msb.append("<td ").append(headerStyle).append(">").append("Description").append("</td>\n");
        msb.append("<td ").append(headerStyle).append(">").append("Sortable").append("</td>\n");
        msb.append("<td ").append(headerStyle).append(">").append("Filterable").append("</td>\n");
        msb.append("<td ").append(headerStyle).append(">").append("Colorable").append("</td>\n");
        msb.append("</tr>\n");
        String[] all = this.getAllPossibleColumns();
        String[] sort = this.getAllSortableColumns();
        String[] filt = this.getAllFilterableCols();
        String[] col = this.getColorableColumns();
        String[] ttarr = this.getAllTooltipDict();
        TreeMap<String, String[]> tm = new TreeMap<String, String[]>();
        int i = 0;
        while (i < all.length) {
            String name = Babel.get(all[i], "en");
            String tt = "";
            int j = 0;
            while (j < ttarr.length) {
                if (ttarr[j].equals(all[i])) {
                    tt = Babel.get(ttarr[j + 1]);
                }
                j += 2;
            }
            String check = "&#x2713;";
            String ts = "";
            int j2 = 0;
            while (j2 < sort.length) {
                if (sort[j2].equals(all[i])) {
                    ts = check;
                }
                ++j2;
            }
            String tf = "";
            int j3 = 0;
            while (j3 < filt.length) {
                if (filt[j3].equals(all[i])) {
                    tf = check;
                }
                ++j3;
            }
            String tc = "";
            int j4 = 0;
            while (j4 < col.length) {
                if (col[j4].equals(all[i])) {
                    tc = check;
                }
                ++j4;
            }
            String[] arr = new String[]{name, tt, ts, tf, tc};
            tm.put(name, arr);
            ++i;
        }
        Iterator iter = tm.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String[] arr = (String[])tm.get(key);
            msb.append("<tr>\n");
            msb.append("<td ").append(tdStyle).append(">").append(arr[0]).append("</td>\n");
            msb.append("<td ").append(tdStyle).append(">").append(arr[1]).append("</td>\n");
            msb.append("<td align=\"center\" ").append(tdStyle).append(">").append(arr[2]).append("</td>\n");
            msb.append("<td align=\"center\" ").append(tdStyle).append(">").append(arr[3]).append("</td>\n");
            msb.append("<td align=\"center\" ").append(tdStyle).append(">").append(arr[4]).append("</td>\n");
            msb.append("</tr>\n");
            msb.append("\n");
        }
        msb.append("</table>\n");
        msb.append("</p>");
        return msb.toString();
    }

    public boolean displaysIDObjects() {
        return true;
    }

    public String[] checkColumns(String[] arr) {
        return arr;
    }

    public String[] getAllPossibleColumns() {
        if (this.wantsGeneralColumns()) {
            return this.checkColumns(this.getCombined(POSSIBLES, this.getPossibleColumns()));
        }
        return this.checkColumns(this.getPossibleColumns());
    }

    public String[] getAllSortableColumns() {
        if (this.wantsGeneralColumns()) {
            return this.checkColumns(this.getCombined(SORTABLES, this.getSortableColumns()));
        }
        return this.checkColumns(this.getSortableColumns());
    }

    public String[] getAllEditableColumns() {
        if (this.wantsGeneralColumns()) {
            return this.checkColumns(this.getCombined(EDITABLES, this.getEditableColumns()));
        }
        return this.checkColumns(this.getEditableColumns());
    }

    public String[] getAllTooltipDict() {
        if (this.wantsGeneralColumns()) {
            return this.getCombined(TT_DICT, this.getTooltipDict());
        }
        return this.getTooltipDict();
    }

    public String[] getAllFilterableCols() {
        if (this.wantsGeneralColumns()) {
            return this.checkColumns(this.getCombined(FILTERABLES, this.getFilterableCols()));
        }
        return this.checkColumns(this.getFilterableCols());
    }

    public String[] getAllSplitableCols() {
        if (this.wantsGeneralColumns()) {
            return this.checkColumns(this.getCombined(FILTERABLES, this.getSplitableCols()));
        }
        return this.checkColumns(this.getSplitableCols());
    }

    public boolean isMutliDimPossible() {
        return false;
    }

    public boolean isExtendedSortingPossible() {
        return true;
    }

    public String[] getFilterableCols() {
        return null;
    }

    public String[] getSplitableCols() {
        return this.checkColumns(this.getFilterableCols());
    }

    private String[] getCombined(String[] a, String[] b) {
        if (a == null) {
            a = new String[]{};
        }
        if (b == null) {
            b = new String[]{};
        }
        String[] res = new String[a.length + b.length];
        int i = 0;
        while (i < a.length) {
            res[i] = a[i];
            ++i;
        }
        i = 0;
        while (i < b.length) {
            res[i + a.length] = b[i];
            ++i;
        }
        return this.checkColumns(res);
    }

    public void writeGeneralElement(MausoleumTableLabel label, Object obj, String colName, boolean isForFilterSplit) {
        if (this.wantsGeneralColumns() && obj != null && obj instanceof IDObject) {
            IDObject ido = (IDObject)obj;
            if (colName.equals(STR_ID)) {
                label.setHorizontalAlignment(4);
                label.setText(Long.toString(ido.getID()));
            } else if (colName.equals(STR_FKEY)) {
                label.setText(ido.getString("IDO_FKEY", ""));
            } else if (colName.equals(STR_GROUP)) {
                label.setText(ido.getString("IDO_GROUP", ""));
            } else if (colName.equals(STR_START)) {
                if (isForFilterSplit) {
                    label.setText(ido.getFilterSplitDateString("IDO_START_DATE"));
                } else {
                    Date d = ido.getDate("IDO_START_DATE");
                    if (d != null) {
                        MyDate md = MyDate.getMyDate(d.getTime());
                        label.setText(DatumFormat.getDateTimeString(md));
                        label.setHorizontalAlignment(0);
                    } else {
                        label.setText("");
                    }
                }
            } else if (colName.equals(STR_END)) {
                if (isForFilterSplit) {
                    label.setText(ido.getFilterSplitDateString("IDO_END_DATE"));
                } else {
                    Date d = ido.getDate("IDO_END_DATE");
                    if (d != null) {
                        label.setText(DatumFormat.getJustDateString(d.getTime()));
                        label.setHorizontalAlignment(0);
                    } else {
                        label.setText("");
                    }
                }
            } else {
                Log.error("Unknown Name >" + colName + "< in " + this.getClass().getName() + " writeGeneralElement", null, this);
            }
        }
    }

    public void addOwnAllListener(OwnAllListener oal) {
        if (!this.ivOwnAllListeners.contains(oal)) {
            this.ivOwnAllListeners.addElement(oal);
        }
    }

    public void removeOwnAllListener(OwnAllListener oal) {
        if (this.ivOwnAllListeners.contains(oal)) {
            this.ivOwnAllListeners.remove(oal);
        }
    }

    public void addSelectionListener(MausoleumTableSelectionListener listener) {
        if (!this.ivSelectionListeners.contains(listener)) {
            this.ivSelectionListeners.addElement(listener);
        }
    }

    public void removeOwnAllListener(MausoleumTableSelectionListener listener) {
        if (this.ivSelectionListeners.contains(listener)) {
            this.ivSelectionListeners.remove(listener);
        }
    }

    public void selectionChanged() {
        int i = 0;
        while (i < this.ivSelectionListeners.size()) {
            MausoleumTableSelectionListener mtsl = (MausoleumTableSelectionListener)this.ivSelectionListeners.elementAt(i);
            mtsl.selectionChanged(this);
            ++i;
        }
    }

    public boolean displaysPersistentObjectType() {
        return this.ivObjectType != 4;
    }

    public JTable getJTable() {
        return this.ivTable;
    }

    public void setMausoleumTable(MausoleumTable parent) {
        this.ivMausoleumTable = parent;
    }

    public void setJTable(JTable parent) {
        this.ivTable = parent;
        if (this.ivTable != null && this.ivTable.isEnabled()) {
            this.ivTable.addMouseListener(this);
            this.ivTable.addMouseMotionListener(this);
            this.ivTable.addMouseWheelListener(WHEELY);
        }
        this.ivTable.addKeyListener(this);
        int[] widths = null;
        TableDefinitionObjectExtended tdo = DefaultManager.getTableDefinitionObject(this);
        if (tdo != null && tdo.ivWidths != null) {
            widths = tdo.ivWidths;
        }
        if (widths == null) {
            widths = this.getWidths();
        }
        if (widths != null) {
            int i = 0;
            while (i < widths.length) {
                try {
                    TableColumn tc;
                    if (this.ivTable != null && this.ivTable.getColumnModel().getColumnCount() > i && (tc = this.ivTable.getColumnModel().getColumn(i)) != null) {
                        tc.setPreferredWidth(widths[i]);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++i;
            }
        }
    }

    public boolean ichWillEinenOwnerKnopf() {
        return false;
    }

    public boolean ichWillFactSheets() {
        return false;
    }

    public boolean ichWillEinenSichtbarkeitsKnopf() {
        return false;
    }

    public boolean istDragNDroppable() {
        return false;
    }

    public boolean wantsGeneralColumns() {
        return true;
    }

    public Vector getAdditionalPopupItems(Vector selectedObjects) {
        return null;
    }

    public void addAdditionalReportItems(Vector selectedObjects, Vector target) {
        if (this.isTrafficReportable() && selectedObjects != null && selectedObjects.size() == 1 && (MausoleumClient.isHeadOfService() || MausoleumClient.isRegular() && UserManager.cvIsGURU)) {
            target.add(this.getTrafficItem(false));
            target.add(this.getTrafficItem(true));
        }
    }

    private JMenuItem getTrafficItem(boolean extended) {
        JMenuItem item;
        JMenuItem jMenuItem = item = extended ? this.ivExtendedTrafficItem : this.ivNormalTrafficItem;
        if (item == null) {
            item = new JMenuItem(Babel.get(extended ? "MOUSE_TRAFFIC_REPORT_EXTENDED" : "MOUSE_TRAFFIC_REPORT"));
            item.setActionCommand(extended ? "1" : "0");
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TrafficReport.getTrafficReportClientSide(MausoleumTableModel.this.getSelectedObjects(), MausoleumTableModel.this.ivMausoleumTable, "1".equals(e.getActionCommand()));
                }
            });
            if (extended) {
                this.ivExtendedTrafficItem = item;
            } else {
                this.ivNormalTrafficItem = item;
            }
        }
        return item;
    }

    public boolean isTrafficReportable() {
        return false;
    }

    public boolean getOnlyOwnObjects() {
        return this.ivOwnedObjects;
    }

    public int getObjectType() {
        return this.ivObjectType;
    }

    public void setIsSubDisplay() {
        this.ivIsSubDisplay = true;
    }

    public void setToNonExecutable() {
        this.ivIsExecutable = false;
    }

    public void processDoubleClick(Point p, Point originalPoint) {
    }

    public void sortDefault() {
        boolean sorted = ExtendedSortDialog.sortByStandard(this);
        if (!sorted && !(sorted = this.sortComplexDefault())) {
            this.sortObjectsByColumn(this.getDefaultSortColumn());
        }
    }

    public boolean sortComplexDefault() {
        return false;
    }

    protected void sortBySharedGroups(Vector mses, int pos) {
        Iterator iterator = mses.iterator();
        while (iterator.hasNext()) {
            MultiSortEntry mse = (MultiSortEntry)iterator.next();
            IDObject ido = (IDObject)mse.ivObject;
            mse.ivVals[pos] = MultiSortEntry.getComp(ido.getSharedGroupNames());
        }
    }

    public void fillMainTable() {
        ObjectManager om = this.getManager();
        if (om != null) {
            try {
                this.setTable(om.getActualObjectVectorAllGroups());
                this.sortDefault();
            }
            catch (Exception e) {
                Log.error("Problem fillMainTable", e, this);
            }
        }
    }

    public String getDefinedColumnName(int col) {
        if (this.ivColumnNames != null && col >= 0 && col < this.ivColumnNames.length) {
            return this.ivColumnNames[col];
        }
        return null;
    }

    public Vector getDefinedColumnNames() {
        Vector<String> erg = new Vector<String>(this.ivColumnNames.length);
        int i = 0;
        while (i < this.ivColumnNames.length) {
            erg.addElement(this.ivColumnNames[i]);
            ++i;
        }
        return erg;
    }

    public void setDefinedColumnNames(Vector v, HashSet coloreds) {
        this.setDefinedColumnNames(v, coloreds, true);
    }

    public void ensurePresenceOfColumn(String colKennung, boolean storeDefinitons) {
        if (!ArrayHelper.contained(colKennung, this.ivColumnNames)) {
            Vector v = ArrayHelper.createVector(this.ivColumnNames);
            v.add(colKennung);
            this.setDefinedColumnNames(v, new HashSet(this.ivColouredColumns), storeDefinitons);
        }
    }

    public void setDefinedColumnNames(Vector v, HashSet coloreds, boolean storeDefinitons) {
        this.ivColumnNames = new String[v.size()];
        int i = 0;
        while (i < v.size()) {
            this.ivColumnNames[i] = (String)v.elementAt(i);
            ++i;
        }
        this.refreshFilterCombos();
        if (this.ivTable != null) {
            this.ivTable.setModel(new DefaultTableModel());
            this.ivTable.setModel(this);
            this.ivAktHeaderRenderer = new HeaderRenderer(this.ivTable, this.ivMausoleumTable.ivScrollPane, this.ivMausoleumTable);
        }
        this.ivColouredColumns.clear();
        this.ivColouredColumns.addAll(coloreds);
        if (storeDefinitons) {
            DefaultManager.storeTableDefObject(this);
        }
    }

    public void takeColumnDefinitionsFromModel(MausoleumTableModel model) {
        HashSet coloreds = new HashSet();
        coloreds.addAll(model.ivColouredColumns);
        this.setDefinedColumnNames(model.getDefinedColumnNames(), coloreds, false);
    }

    public void takeWidthsFromModel(MausoleumTableModel model) {
        int tcs = model.ivTable.getColumnModel().getColumnCount();
        int i = 0;
        while (i < tcs) {
            TableColumn tc = this.ivTable.getColumnModel().getColumn(i);
            if (tc != null) {
                tc.setPreferredWidth(model.ivTable.getColumnModel().getColumn(i).getWidth());
            }
            ++i;
        }
    }

    public int getColumnIndex(String columnName) {
        int i = 0;
        while (i < this.ivColumnNames.length) {
            if (this.ivColumnNames[i].equals(columnName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObjectsToTable(Vector v) {
        if (v != null && !v.isEmpty()) {
            Vector vector = this.ivOriginalObjects;
            synchronized (vector) {
                int i = 0;
                while (i < v.size()) {
                    Object o = v.elementAt(i);
                    int ind = this.ivOriginalObjects.indexOf(o);
                    if (ind != -1) {
                        this.ivOriginalObjects.setElementAt(o, ind);
                    } else {
                        this.ivOriginalObjects.addElement(o);
                    }
                    ++i;
                }
            }
            this.setTable(this.ivOriginalObjects);
        }
    }

    public int getAnzOrigObjects() {
        return this.ivOriginalObjects.size();
    }

    public void addOriginalObjects(Vector target) {
        target.addAll(this.ivOriginalObjects);
    }

    public void setOrigObjectsAgain() {
        this.setTable(this.ivOriginalObjects, true);
    }

    public void setTable(Vector objects) {
        this.setTable(objects, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTable(Vector objects, boolean keepPresentObjects) {
        String string = this.ivMUTEX;
        synchronized (string) {
            Vector vorherSelektiert = this.getSelectedObjects();
            if (objects == null || objects.isEmpty()) {
                this.ivOriginalObjects.clear();
                this.ivObjects.clear();
                if (this.ivFilterVerwendet) {
                    this.makeCombos();
                }
            } else {
                if (objects != this.ivOriginalObjects) {
                    this.ivOriginalObjects.clear();
                    Iterator iterator = objects.iterator();
                    while (iterator.hasNext()) {
                        Object ooo = iterator.next();
                        if (ooo instanceof IDObject) {
                            IDObject ido = (IDObject)ooo;
                            if (!ido.existed()) continue;
                            this.ivOriginalObjects.add(ido);
                            continue;
                        }
                        this.ivOriginalObjects.add(ooo);
                    }
                }
                Vector filteredObjects = this.fullFilterObjects(this.ivOriginalObjects);
                if (keepPresentObjects) {
                    IdentifiableObject iob;
                    HashMap<String, IdentifiableObject> filteredObjectsByIdentifier = new HashMap<String, IdentifiableObject>(filteredObjects.size() + 10);
                    Iterator iterator = filteredObjects.iterator();
                    while (iterator.hasNext()) {
                        iob = (IdentifiableObject)iterator.next();
                        filteredObjectsByIdentifier.put(iob.getIdentifierString(), iob);
                    }
                    filteredObjects.clear();
                    iterator = this.ivObjects.iterator();
                    while (iterator.hasNext()) {
                        iob = (IdentifiableObject)iterator.next();
                        String key = iob.getIdentifierString();
                        IdentifiableObject itp = (IdentifiableObject)filteredObjectsByIdentifier.get(key);
                        if (itp == null) continue;
                        filteredObjects.addElement(itp);
                        filteredObjectsByIdentifier.remove(key);
                    }
                    filteredObjects.addAll(filteredObjectsByIdentifier.values());
                    filteredObjectsByIdentifier.clear();
                    filteredObjectsByIdentifier = null;
                }
                this.ivObjects.clear();
                this.ivObjects.addAll(filteredObjects);
                filteredObjects.clear();
                filteredObjects = null;
                if (this.ivFilterVerwendet) {
                    this.makeCombos();
                }
            }
            this.klaereAlarm();
            this.tableChanged(vorherSelektiert);
        }
    }

    public void selectAll() {
        this.ivSelectedRows.clear();
        int i = 0;
        while (i < this.ivObjects.size()) {
            this.ivSelectedRows.add(new Integer(i));
            ++i;
        }
        this.selectionChanged();
        if (this.ivAdjustInspector) {
            Inspector.adjustToTable(this.ivMausoleumTable);
        }
        if (this.ivTable != null) {
            this.ivTable.repaint();
        }
    }

    public void selectNone() {
        this.ivSelectedRows.clear();
        this.selectionChanged();
        if (this.ivAdjustInspector) {
            Inspector.adjustToTable(this.ivMausoleumTable);
        }
        if (this.ivTable != null) {
            this.ivTable.repaint();
        }
    }

    public void adjustSelection(Vector objectsToSelect) {
        this.ivSelectedRows.clear();
        if (objectsToSelect.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < this.ivObjects.size()) {
            IdentifiableObject iob = (IdentifiableObject)this.ivObjects.elementAt(i);
            if (this.isIDObjectContained(iob, objectsToSelect)) {
                this.ivSelectedRows.add(new Integer(i));
            }
            ++i;
        }
    }

    protected boolean isIDObjectContainedInOriginals(IdentifiableObject to) {
        return this.isIDObjectContained(to, this.ivOriginalObjects);
    }

    protected boolean isIDObjectContained(IdentifiableObject to, Vector v) {
        if (to != null) {
            String toID = to.getIdentifierString();
            Iterator iterator = v.iterator();
            while (iterator.hasNext()) {
                IdentifiableObject iob = (IdentifiableObject)iterator.next();
                if (!iob.getIdentifierString().equals(toID)) continue;
                return true;
            }
        }
        return false;
    }

    protected int getIndexIfContained(IdentifiableObject to, Vector v) {
        String toID = to.getIdentifierString();
        int i = 0;
        while (i < v.size()) {
            IdentifiableObject iob = (IdentifiableObject)v.elementAt(i);
            if (iob.getIdentifierString().equals(toID)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void setSortFaktor(int faktor) {
        this.ivSortFaktor = faktor;
    }

    public Vector getSelectedObjects() {
        Vector erg = null;
        if (this.ivSelectedRows != null && !this.ivSelectedRows.isEmpty()) {
            erg = new Vector(this.ivSelectedRows.size());
            Iterator iter = this.ivSelectedRows.iterator();
            while (iter.hasNext()) {
                Integer sri = (Integer)iter.next();
                int ind = sri;
                if (ind < 0 || ind >= this.ivObjects.size()) continue;
                erg.add(this.ivObjects.elementAt(ind));
            }
        }
        return erg == null ? new Vector() : erg;
    }

    public void addSelectedObjects(Vector erg) {
        if (this.ivSelectedRows != null && !this.ivSelectedRows.isEmpty()) {
            Iterator iter = this.ivSelectedRows.iterator();
            while (iter.hasNext()) {
                Integer sri = (Integer)iter.next();
                int ind = sri;
                if (ind < 0 || ind >= this.ivObjects.size()) continue;
                erg.add(this.ivObjects.elementAt(ind));
            }
        }
    }

    public int[] getSelectRowsAsArray() {
        if (this.ivSelectedRows != null && !this.ivSelectedRows.isEmpty()) {
            int[] res = new int[this.ivSelectedRows.size()];
            int pos = 0;
            Iterator iterator = this.ivSelectedRows.iterator();
            while (iterator.hasNext()) {
                Integer inti = (Integer)iterator.next();
                res[pos++] = inti;
            }
            return res;
        }
        return null;
    }

    private Vector fullFilterObjects(Vector v) {
        this.ivOwnerFiltered = false;
        if (v != null && !v.isEmpty()) {
            this.evalComboMusts();
            Vector erg = new Vector(v.size());
            Iterator iterator = v.iterator();
            while (iterator.hasNext()) {
                Object ooo = iterator.next();
                if (!this.filterSingleObject(ooo)) continue;
                erg.add(ooo);
            }
            this.ownerFilterAlarm();
            return erg;
        }
        return v;
    }

    private boolean filterSingleObject(Object ooo) {
        return ooo != null && this.filterByGroup(ooo) && this.filterObject(ooo) && this.filterByVisibility(ooo) && this.filterByCombos(ooo);
    }

    public boolean filterObject(Object ooo) {
        return true;
    }

    public void ownerFilterAlarm() {
        MToggleButton allBut;
        if (this.ivMausoleumTable != null && this.ivMausoleumTable.ivScrollPane != null && (allBut = (MToggleButton)this.ivMausoleumTable.ivScrollPane.getCorner("UPPER_RIGHT_CORNER")) != null) {
            allBut.setAlarm(this.ivOwnerFiltered);
        }
    }

    public boolean filterByGroup(Object ooo) {
        if (this.ivGroupFilter != null && ooo instanceof IDObject) {
            return this.ivGroupFilter.equals(((IDObject)ooo).getGroup());
        }
        return true;
    }

    public void refreshFilterCombos() {
        if (this.ivFilterVerwendet) {
            this.makeCombos();
        }
    }

    public void setFilter(boolean filter) {
        String[] filterables = this.getAllFilterableCols();
        if (filterables != null && filterables.length != 0 && filter != this.ivFilterVerwendet) {
            if (filter && !this.ivFilterVerwendet) {
                this.ivFilterVerwendet = true;
                if (this.ivOriginalObjects != null) {
                    this.makeCombos();
                }
            } else if (!filter && this.ivFilterVerwendet) {
                this.ivFilterVerwendet = false;
                if (this.ivFilterableValues != null) {
                    this.ivFilterableValues.clear();
                    this.ivFilterableValues = null;
                }
                if (this.ivFilterValues != null) {
                    this.ivFilterValues.clear();
                    this.ivFilterValues = null;
                }
                this.setTable(this.ivOriginalObjects);
            }
            this.tableChanged(null);
            if (this.ivTable != null) {
                this.ivTable.getTableHeader().invalidate();
            }
            if (this.ivMausoleumTable != null && this.ivMausoleumTable.ivScrollPane != null) {
                this.ivMausoleumTable.ivScrollPane.repaint();
            }
            DefaultManager.storeFiltering(this);
        }
    }

    public void filterClicked(String colKennung, int ind) {
        this.ivFilterValues.put(colKennung, new Integer(ind));
        this.setTable(this.ivOriginalObjects);
        this.resort();
        if (this.ivAdjustInspector) {
            Inspector.adjustToTable(this.ivMausoleumTable);
        }
    }

    private boolean filterByVisibility(Object ooo) {
        if (this.ivFilterByVisibility && ooo instanceof IDObject) {
            return ((IDObject)ooo).getBoolean("IDO_VISIBLE", true);
        }
        return true;
    }

    private boolean filterByCombos(Object ooo) {
        boolean takeit = true;
        if (!this.ivComboMusts.isEmpty()) {
            Iterator iter = this.ivComboMusts.keySet().iterator();
            while (takeit && iter.hasNext()) {
                String key = (String)iter.next();
                Object must = this.ivComboMusts.get(key);
                if (must == null) continue;
                this.ivFilterLabel.setText("");
                this.ivFilterLabel.setIcon(null);
                boolean isForFilterSplit = !(must instanceof SpecifiedString);
                this.writeTheCodedElement(this.ivFilterLabel, ooo, key, isForFilterSplit);
                Object val = this.ivFilterLabel.getIcon();
                String s = this.ivFilterLabel.getText();
                if (s != null && s.trim().length() > 0) {
                    val = s.trim();
                }
                if (must == EMPTY_SIGNAL) {
                    if (MausoleumTableModel.isEmptyVal(val)) continue;
                    takeit = false;
                    continue;
                }
                if (must == NON_EMPTY_SIGNAL) {
                    if (!MausoleumTableModel.isEmptyVal(val)) continue;
                    takeit = false;
                    continue;
                }
                if (must instanceof SpecifiedString) {
                    takeit = false;
                    SpecifiedString specStr = (SpecifiedString)must;
                    takeit = specStr.match(s);
                    continue;
                }
                if (must instanceof SplitFilterObject) {
                    SplitFilterObject sfo = (SplitFilterObject)must;
                    if (sfo.ivComboFilterString.equals(val)) continue;
                    takeit = false;
                    continue;
                }
                if (must.equals(val)) continue;
                takeit = false;
            }
        }
        return takeit;
    }

    private void evalComboMusts() {
        this.ivComboMusts.clear();
        if (this.ivFilterVerwendet && this.ivFilterValues != null) {
            Enumeration en = this.ivFilterValues.keys();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                Integer index = (Integer)this.ivFilterValues.get(key);
                int selInd = index;
                if (selInd == 0) continue;
                if (selInd == 1) {
                    this.ivComboMusts.put(key, EMPTY_SIGNAL);
                    continue;
                }
                if (selInd == 2) {
                    this.ivComboMusts.put(key, NON_EMPTY_SIGNAL);
                    continue;
                }
                if (selInd == 3 || selInd == 4) {
                    this.ivComboMusts.put(key, this.ivFilterSpecifiedStrings.get(key));
                    continue;
                }
                Vector v = (Vector)this.ivFilterableValues.get(key);
                this.ivComboMusts.put(key, v.elementAt(selInd));
            }
        }
    }

    public void setSpecifiedFilterString(String colName, String specified, boolean inverted) {
        if (specified == null) {
            this.ivFilterSpecifiedStrings.remove(colName);
        } else {
            this.ivFilterSpecifiedStrings.put(colName, new SpecifiedString(specified, inverted));
        }
    }

    public SpecifiedString getSpecifiedString(String colname) {
        return (SpecifiedString)this.ivFilterSpecifiedStrings.get(colname);
    }

    private void makeCombos() {
        if (this.ivFilterableValues == null) {
            this.ivFilterableValues = new Hashtable();
            this.ivFilterValues = new Hashtable();
            String[] filterCols = this.getAllFilterableCols();
            int i = 0;
            while (i < this.ivColumnNames.length) {
                this.makeCombo(this.ivColumnNames[i], filterCols);
                ++i;
            }
        } else {
            Hashtable<String, Integer> merkValues = new Hashtable<String, Integer>();
            Enumeration en = this.ivFilterValues.keys();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                Integer inti = (Integer)this.ivFilterValues.get(key);
                if (inti <= 2) {
                    merkValues.put(key, inti);
                    continue;
                }
                Vector v = (Vector)this.ivFilterableValues.get(key);
                if (v == null || v.size() <= inti) continue;
                merkValues.put(key, (Integer)v.elementAt(inti));
            }
            this.ivFilterableValues.clear();
            this.ivFilterValues.clear();
            String[] filterCols = this.getAllFilterableCols();
            int i = 0;
            while (i < this.ivColumnNames.length) {
                this.makeCombo(this.ivColumnNames[i], filterCols);
                ++i;
            }
            en = merkValues.keys();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                Object ooo = merkValues.get(key);
                if (ooo instanceof Integer) {
                    this.ivFilterValues.put(key, ooo);
                    continue;
                }
                Vector v = (Vector)this.ivFilterableValues.get(key);
                if (v == null) continue;
                int ind = v.indexOf(ooo);
                if (ind != -1) {
                    this.ivFilterValues.put(key, new Integer(ind));
                    continue;
                }
                this.ivFilterValues.put(key, new Integer(0));
                if (this.ivTable == null) continue;
                this.ivTable.getTableHeader().repaint();
            }
        }
    }

    private void makeCombo(String colKennung, String[] filterableCols) {
        Vector<String> filterNamen = new Vector<String>();
        filterNamen.add("[" + Babel.get("ALL") + "]");
        filterNamen.add("[" + Babel.get("EMPTY") + "]");
        filterNamen.add("[" + Babel.get("NON_EMPTY") + "]");
        filterNamen.add("[" + Babel.get("CONTAINING_TEXT") + "...]");
        filterNamen.add("[" + Babel.get("NOT_CONTAINING_TEXT") + "...]");
        boolean filterable = false;
        int i = 0;
        while (i < filterableCols.length) {
            if (filterableCols[i].equalsIgnoreCase(colKennung)) {
                filterable = true;
            }
            ++i;
        }
        if (filterable) {
            this.ermittleFilterUndSplitte(colKennung, filterNamen, null, null, null, null);
        }
        this.ivFilterableValues.put(colKennung, filterNamen);
        this.ivFilterValues.put(colKennung, new Integer(0));
    }

    public void ermittleFilterUndSplitte(String colKennung, Vector filterNamen, HashMap splitMap, String allSignal, String emptySignal, String nonEmptySignal) {
        if (this.ivObjects != null && !this.ivObjects.isEmpty()) {
            TreeSet<SplitFilterObject> ts = new TreeSet<SplitFilterObject>();
            Iterator iterator = this.ivObjects.iterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                this.ivFilterLabel.setText("");
                this.ivFilterLabel.setIcon(null);
                this.writeTheCodedElement(this.ivFilterLabel, object, colKennung, true);
                SplitFilterObject key = null;
                boolean isEmpty = true;
                String val = this.ivFilterLabel.getText();
                if (val != null && val.trim().length() != 0) {
                    key = this.getSFO(colKennung, val.trim());
                    ts.add(key);
                } else {
                    boolean bl = isEmpty = this.ivFilterLabel.getIcon() == null;
                }
                if (splitMap == null) continue;
                if (key != null) {
                    AllgUtils.enterValueInVector(splitMap, key, object);
                    AllgUtils.enterValueInVector(splitMap, nonEmptySignal, object);
                } else if (isEmpty) {
                    AllgUtils.enterValueInVector(splitMap, emptySignal, object);
                } else {
                    AllgUtils.enterValueInVector(splitMap, nonEmptySignal, object);
                }
                AllgUtils.enterValueInVector(splitMap, allSignal, object);
            }
            filterNamen.addAll(ts);
        }
    }

    public void handleNewObjects(Vector idObjects) {
        Class servedClass = this.getServedClass();
        Vector<IDObject> meine = new Vector<IDObject>(idObjects.size());
        Iterator iterator = idObjects.iterator();
        while (iterator.hasNext()) {
            IDObject ido = (IDObject)iterator.next();
            if (!servedClass.isInstance(ido)) continue;
            meine.add(ido);
        }
        if (meine.isEmpty()) {
            this.repaintTable();
            return;
        }
        Vector prevsel = this.getSelectedObjects();
        boolean selected = false;
        int sizeVorher = this.ivObjects.size();
        boolean alarm = false;
        Iterator iterator2 = meine.iterator();
        while (iterator2.hasNext()) {
            IDObject ido = (IDObject)iterator2.next();
            if (this.ivMausoleumTable != null && this.ivMausoleumTable.getIsActive()) {
                selected |= prevsel.contains(ido);
            }
            this.incorporateObjectInVector(ido, this.ivOriginalObjects, true, false);
            this.incorporateObjectInVector(ido, this.ivObjects, this.filterSingleObject(ido), false);
            alarm |= this.ivObjects.contains(ido);
        }
        if (alarm) {
            this.klaereAlarm();
        }
        if (this.ivObjects.size() != sizeVorher) {
            this.tableChanged(prevsel);
            return;
        }
        if (this.ivTable != null) {
            this.repaintTable();
        }
        if (selected && this.ivAdjustInspector) {
            Inspector.adjustToTable(this.ivMausoleumTable);
        }
    }

    public void handleNewObject(IDObject object) {
        if (!this.getServedClass().isInstance(object)) {
            this.repaintTable();
            return;
        }
        Vector prevsel = this.getSelectedObjects();
        boolean selected = false;
        if (this.ivMausoleumTable != null && this.ivMausoleumTable.getIsActive()) {
            selected = prevsel.contains(object);
        }
        boolean matchFilter = this.filterSingleObject(object);
        int sizeVorher = this.ivObjects.size();
        this.incorporateObjectInVector(object, this.ivOriginalObjects, true, false);
        this.incorporateObjectInVector(object, this.ivObjects, matchFilter, false);
        if (this.ivObjects.contains(object)) {
            this.klaereAlarm();
        }
        if (this.ivObjects.size() != sizeVorher) {
            this.tableChanged(prevsel);
            return;
        }
        if (this.ivTable != null) {
            this.repaintTable();
        }
        if (selected && this.ivAdjustInspector) {
            Inspector.adjustToTable(this.ivMausoleumTable);
        }
    }

    private void repaintTable() {
        if (this.ivTable != null) {
            boolean repaint = true;
            JTabbedPane jtb = WindowUtils.getJTabbedPane(this.ivMausoleumTable);
            if (!(jtb == null || jtb.isVisible() && this.ivMausoleumTable == jtb.getSelectedComponent())) {
                repaint = false;
            }
            if (repaint) {
                this.ivTable.repaint();
            }
        }
    }

    public int getRealObjectType() {
        return this.ivObjectType;
    }

    public void objectLeftServiceRoom(int objectTyp, String group, HashSet objectIDs) {
        if (objectTyp == this.getRealObjectType()) {
            Vector<IDObject> raus = new Vector<IDObject>();
            Iterator iter = this.ivOriginalObjects.iterator();
            while (iter.hasNext()) {
                IDObject iob = (IDObject)iter.next();
                if (!iob.getGroup().equals(group) || !objectIDs.contains(iob.get("IDO_ID"))) continue;
                raus.add(iob);
            }
            Vector prevsel = this.getSelectedObjects();
            int sizeVorher = this.ivObjects.size();
            Iterator iter2 = raus.iterator();
            while (iter2.hasNext()) {
                IDObject object = (IDObject)iter2.next();
                this.incorporateObjectInVector(object, this.ivOriginalObjects, true, true);
                this.incorporateObjectInVector(object, this.ivObjects, true, true);
            }
            if (this.ivObjects.size() != sizeVorher) {
                this.tableChanged(prevsel);
            }
        }
    }

    public void tableChanged(Vector prevsel) {
        if (this.ivTable != null) {
            this.ivTable.tableChanged(new TableModelEvent(this.ivTable.getModel()));
        }
        if (prevsel != null) {
            this.adjustSelection(prevsel);
        }
    }

    public void handleReplObjectInSubdisplay(IDObject obi, Vector list, boolean matchFilter) {
    }

    public void handleDeadObjectInSubdisplay(IDObject obi, Vector list, int ind) {
        list.setElementAt(obi, ind);
    }

    public boolean handleNewObjectsLikeSubDisplay() {
        return this.ivIsSubDisplay;
    }

    protected void incorporateObjectInVector(IDObject object, Vector list, boolean matchFilter, boolean forceRemove) {
        int objectIndex = list.indexOf(object);
        if (object.isAlive() && !forceRemove) {
            if (objectIndex == -1) {
                if (this.handleNewObjectsLikeSubDisplay()) {
                    this.handleReplObjectInSubdisplay(object, list, matchFilter);
                } else if (matchFilter) {
                    list.addElement(object);
                }
            } else if (matchFilter) {
                list.setElementAt(object, objectIndex);
            } else {
                list.removeElementAt(objectIndex);
            }
        } else {
            if (objectIndex == -1) {
                return;
            }
            if (object.neverExisted()) {
                list.removeElementAt(objectIndex);
            } else if (this.handleNewObjectsLikeSubDisplay() && !forceRemove) {
                this.handleDeadObjectInSubdisplay(object, list, objectIndex);
            } else {
                list.removeElementAt(objectIndex);
            }
        }
    }

    public void sortObjectsByColumn(String colName) {
        if (colName != null && this.isCodeSortable(colName) && this.getRowCount() > 1) {
            boolean doSort = false;
            if (this.ivColumnNames != null) {
                int i = 0;
                while (i < this.ivColumnNames.length) {
                    if (this.ivColumnNames[i].equalsIgnoreCase(colName)) {
                        doSort = true;
                    }
                    ++i;
                }
            }
            if (doSort) {
                this.sortIt(new String[]{colName}, new boolean[]{this.ivSortFaktor < 0});
            }
        }
    }

    public void resortOrDefault() {
        if (this.ivLastSortColNames != null && this.ivLastSortInverteds != null) {
            this.sortIt(this.ivLastSortColNames, this.ivLastSortInverteds);
        } else {
            this.sortDefault();
        }
    }

    public void resort() {
        if (this.ivLastSortColNames != null && this.ivLastSortInverteds != null) {
            this.sortIt(this.ivLastSortColNames, this.ivLastSortInverteds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sortIt(String[] colnames, boolean[] inverteds) {
        String string = this.ivMUTEX;
        synchronized (string) {
            this.ivLastSortColNames = colnames;
            this.ivLastSortInverteds = inverteds;
            Vector vorherSelektiert = this.getSelectedObjects();
            MultiSortEntry.sort(this, colnames, inverteds, this.ivOriginalObjects, this.ivObjects);
            this.tableChanged(vorherSelektiert);
            if (this.ivSelectedRows != null && this.ivMausoleumTable != null) {
                this.ivMausoleumTable.ensureSelectionIsVisible();
            }
        }
    }

    protected void sortItDirect(String[] colnames, boolean[] inverteds) {
        MultiSortEntry.sort(this, colnames, inverteds, this.ivOriginalObjects, this.ivObjects);
    }

    protected boolean isCodeSortable(String name) {
        return this.isNameContained(name, this.getAllSortableColumns());
    }

    protected boolean isColumnEditable(String name) {
        return this.isNameContained(name, this.getAllEditableColumns());
    }

    private boolean isNameContained(String name, String[] arr) {
        if (name != null && arr != null) {
            int i = 0;
            while (i < arr.length) {
                if (name.equals(arr[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public String getColumnTooltip(int col) {
        if (col >= 0 && this.ivColumnNames != null && col < this.ivColumnNames.length) {
            return this.getColumnTooltip(this.ivColumnNames[col]);
        }
        return null;
    }

    public String getColumnTooltip(String colName) {
        return colName == null ? null : MausoleumTableModel.getColumnTooltip(colName, this.getAllTooltipDict());
    }

    public static String getColumnTooltip(String colName, String[] dict) {
        if (dict != null) {
            int i = 0;
            while (i < dict.length) {
                if (dict[i].equals(colName)) {
                    return dict[i + 1];
                }
                i += 2;
            }
        }
        return null;
    }

    public void klaereAlarm() {
    }

    public void setForegroundAccordingToOwnership(JLabel label, boolean mayTouch) {
        if (mayTouch) {
            label.setForeground(UIDef.NEW_FOREGROUND);
        } else {
            label.setForeground(UIDef.NOT_MINE_FOREGROUND);
        }
    }

    public void checkOwnerButton(MToggleButton but) {
        this.ivOwnedObjects = !but.isPressed();
        this.setTable(this.ivOriginalObjects);
        this.resort();
        int i = 0;
        while (i < this.ivOwnAllListeners.size()) {
            OwnAllListener oal = (OwnAllListener)this.ivOwnAllListeners.elementAt(i);
            oal.ownAllStatusChanged();
            ++i;
        }
    }

    public void checkVisibilityButton(MToggleButton but) {
        this.ivFilterByVisibility = !but.isPressed();
        this.setTable(this.ivOriginalObjects);
        this.resort();
    }

    private int getFirstSelectedRow() {
        return this.ivSelectedRows.isEmpty() ? -1 : (Integer)this.ivSelectedRows.first();
    }

    private int getLastSelectedRow() {
        return this.ivSelectedRows.isEmpty() ? -1 : (Integer)this.ivSelectedRows.last();
    }

    public void selectElement(IdentifiableObject ido) {
        if (ido != null && this.ivObjects != null) {
            String identifier = ido.getIdentifierString();
            int row = 0;
            while (row < this.ivObjects.size()) {
                IdentifiableObject tido = (IdentifiableObject)this.ivObjects.elementAt(row);
                if (tido.getIdentifierString().equals(identifier)) {
                    this.ivSelectedRows.clear();
                    this.ivSelectedRows.add(new Integer(row));
                    this.ivMausoleumTable.ensureSelectionIsVisible();
                    if (this.ivIsExecutable && this.ivAdjustInspector) {
                        Inspector.adjustToTable(this.ivMausoleumTable);
                    }
                    if (this.ivTable != null) {
                        this.ivTable.repaint();
                    }
                    this.selectionChanged();
                }
                ++row;
            }
        }
    }

    public void selectElements(Vector identifieableObjects) {
        if (identifieableObjects != null && !identifieableObjects.isEmpty() && this.ivObjects != null) {
            HashSet<String> hs = new HashSet<String>();
            Iterator iterator = identifieableObjects.iterator();
            while (iterator.hasNext()) {
                IdentifiableObject ido = (IdentifiableObject)iterator.next();
                hs.add(ido.getIdentifierString());
            }
            Vector<Integer> rows = new Vector<Integer>(hs.size());
            int row = 0;
            while (row < this.ivObjects.size()) {
                IdentifiableObject tido = (IdentifiableObject)this.ivObjects.elementAt(row);
                if (hs.contains(tido.getIdentifierString())) {
                    rows.add(new Integer(row));
                }
                ++row;
            }
            if (!rows.isEmpty()) {
                this.ivSelectedRows.clear();
                this.ivSelectedRows.addAll(rows);
                this.ivMausoleumTable.ensureSelectionIsVisible();
                if (this.ivIsExecutable && this.ivAdjustInspector) {
                    Inspector.adjustToTable(this.ivMausoleumTable);
                }
                if (this.ivTable != null) {
                    this.ivTable.repaint();
                }
                this.selectionChanged();
            }
            rows.clear();
            rows = null;
            hs.clear();
            Object var2_2 = null;
        }
    }

    public void makeBoppelIfNotEmpty() {
        MausoleumTableTabbedPane tp;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("mausoleum.tables.MausoleumTableTabbedPane");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((tp = (MausoleumTableTabbedPane)WindowUtils.getParent(this.ivMausoleumTable, clazz)) != null) {
            try {
                int index = tp.indexOfComponent(this.ivMausoleumTable);
                if (index != -1) {
                    tp.setIconAt(index, !this.ivObjects.isEmpty() ? ImageProvider.getBulletIcon(Color.red) : null);
                }
            }
            catch (Exception e) {
                Log.error("Problem with tab index for boppel", e, this);
            }
        }
    }

    public void adjustWidths() {
        int[] spaltenBreiten = this.getcolWidths(2);
        int colTotWidth = 0;
        int i = 0;
        while (i < spaltenBreiten.length) {
            colTotWidth += spaltenBreiten[i];
            ++i;
        }
        int width = this.ivTable.getSize().width;
        double faktor = (double)width / (double)colTotWidth;
        int anzCols = this.getColumnCount();
        int col = 0;
        while (col < anzCols) {
            int w = (int)(faktor * (double)spaltenBreiten[col]);
            this.ivTable.getColumnModel().getColumn(col).setPreferredWidth(w);
            this.ivTable.getColumnModel().getColumn(col).setWidth(w);
            ++col;
        }
    }

    public void adjustSingleColWidth(int dccol) {
        if (this.ivTable != null) {
            int maxw;
            int ww = this.getWidthOfCol(dccol, 2);
            if (ww > (maxw = this.ivTable.getSize().width / 2)) {
                ww = maxw;
            }
            int[] spaltenBreiten = this.getcolWidths(2);
            int colTotWidth = 0;
            int i = 0;
            while (i < spaltenBreiten.length) {
                colTotWidth += spaltenBreiten[i];
                ++i;
            }
            int width = this.ivTable.getSize().width;
            double faktor = (double)(width - ww) / (double)(colTotWidth -= spaltenBreiten[dccol]);
            int anzCols = this.getColumnCount();
            int col = 0;
            while (col < anzCols) {
                int w = (int)(faktor * (double)spaltenBreiten[col]);
                if (col == dccol) {
                    w = ww;
                }
                this.ivTable.getColumnModel().getColumn(col).setPreferredWidth(w);
                this.ivTable.getColumnModel().getColumn(col).setWidth(w);
                ++col;
            }
            DefaultManager.storeTableDefObject(this);
        }
    }

    public int[] getcolWidths(int rand) {
        int anzCols = this.getColumnCount();
        int[] spaltenBreiten = new int[anzCols];
        int col = 0;
        while (col < anzCols) {
            spaltenBreiten[col] = this.getWidthOfCol(col, rand);
            ++col;
        }
        return spaltenBreiten;
    }

    public int getWidthOfCol(int col, int rand) {
        int anzRows = this.getRowCount();
        int colWidth = 10;
        int ww = StringHelper.getStringWidth(" " + this.getColumnName(col) + " ", FontManager.getTableFont(false, this.ivUseDefaultFontSize, this.ivZoom), 10);
        if (ww > colWidth) {
            colWidth = ww;
        }
        int row = 0;
        while (row < anzRows) {
            Component jc = this.getTableCellRendererComponent(this.ivTable, null, false, false, row, col);
            ww = jc.getPreferredSize().width + 2 * rand;
            if (ww > colWidth) {
                colWidth = ww;
            }
            ++row;
        }
        return colWidth;
    }

    public void setDateInLabel(MausoleumTableLabel label, long millis) {
        if (millis != 0L) {
            label.setHorizontalAlignment(0);
            label.setText(DatumFormat.getJustDateString(millis));
        } else {
            label.setText("");
        }
    }

    public void setDateTimeInLabel(MausoleumTableLabel label, long millis) {
        if (millis != 0L) {
            label.setHorizontalAlignment(0);
            label.setText(DatumFormat.getDateTimeString(millis));
        } else {
            label.setText("");
        }
    }

    public void setGroupFilter(String group) {
        this.ivGroupFilter = group;
        this.setTable(new Vector(this.ivOriginalObjects));
        if (this.ivAdjustInspector) {
            Inspector.adjustToTable(this.ivMausoleumTable);
        }
    }

    public int getRowCount() {
        return this.ivObjects == null ? 0 : this.ivObjects.size();
    }

    public int getColumnCount() {
        return this.ivColumnNames == null ? 0 : this.ivColumnNames.length;
    }

    public String getColumnName(int columnIndex) {
        if (this.ivColumnNames == null || columnIndex < 0 || columnIndex >= this.ivColumnNames.length) {
            return "[?]";
        }
        return Babel.get(this.ivColumnNames[columnIndex]);
    }

    public Class getColumnClass(int columnIndex) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        return "";
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    public void addTableModelListener(TableModelListener l) {
    }

    public void removeTableModelListener(TableModelListener l) {
    }

    public SplitFilterObject getSFO(String colKennung, String val) {
        return new SplitFilterObject(val, val, (Comparable)((Object)val));
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Font labelFont = FontManager.getTableFont(false, this.ivUseDefaultFontSize, this.ivZoom);
        int lh = labelFont.getSize() + 4;
        if (this.ivTable != null && this.ivTable.getRowHeight() != lh) {
            this.ivTable.setRowHeight(lh);
        }
        isSelected = this.ivSelectedRows.contains(new Integer(row));
        this.ivLabel.setHorizontalAlignment(2);
        this.ivLabel.setEditBorder(false);
        this.ivLabel.clearMultiFontStrings();
        this.ivLabel.setMultiBackgroundStrings(null);
        this.ivLabel.setTriangleColor(null);
        this.ivLabel.ivUseDefaultFontSize = this.ivUseDefaultFontSize;
        String colName = this.ivColumnNames != null ? this.ivColumnNames[column] : "";
        boolean dead = false;
        if (row >= this.ivObjects.size()) {
            return this.ivLabel;
        }
        Object obj = this.ivObjects.elementAt(row);
        if (obj instanceof LifeStateReporter) {
            LifeStateReporter lsr = (LifeStateReporter)obj;
            boolean bl = dead = lsr.isDead() || !lsr.isVisible();
        }
        if (obj == null) {
            return this.ivLabel;
        }
        if (dead) {
            this.ivLabel.setForeground(UIDef.OLD_FOREGROUND);
            this.ivLabel.setFont(FontManager.getTableFont(false, this.ivUseDefaultFontSize, this.ivZoom));
            if (isSelected) {
                this.ivLabel.setBackground(UIDef.OLD_BACKGROUND);
            } else if (table != null) {
                this.ivLabel.setBackground(table.getBackground());
            } else {
                this.ivLabel.setBackground(null);
            }
        } else {
            this.ivLabel.setForeground(UIDef.NEW_FOREGROUND);
            this.ivLabel.setFont(FontManager.getTableFont(true, this.ivUseDefaultFontSize, this.ivZoom));
            if (isSelected) {
                ActionListener al;
                if (this.ivMausoleumTable.getIsActive() && this.isColumnEditable(colName) && this.ivIsExecutable && DefaultManager.getExecuteInTable() && Privileges.hasPrivilege("EXECUTE_IN_TABLE") && (al = this.getActionListenerForColumn(colName)) != null) {
                    boolean enabled = false;
                    if (al instanceof ChangeSensitive) {
                        enabled = ((ChangeSensitive)((Object)al)).isActive();
                    } else if (al instanceof JTextField) {
                        enabled = ((JTextField)((Object)al)).isEditable();
                    }
                    if (enabled) {
                        this.ivLabel.setEditBorder(true);
                    }
                }
                this.ivLabel.setBackground(UIDef.NEW_BACKGROUND);
            } else if (table != null) {
                this.ivLabel.setBackground(table.getBackground());
            } else {
                this.ivLabel.setBackground(null);
            }
        }
        this.ivLabel.setIcon(null);
        this.ivLabel.setText(null);
        this.ivLabel.setCage(null);
        try {
            this.writeTheCodedElement(this.ivLabel, obj, colName, false);
        }
        catch (Exception e) {
            Log.error("MausoleumTableModel getTableCellRendererComponent Problem bei Tabelle: " + this.getClass().getName() + " OBJECT  " + obj + " Column: " + column, e, this);
        }
        return this.ivLabel;
    }

    public void actionPerformed(ActionEvent e) {
        String comm = e.getActionCommand();
        if (comm.equals(COM_OWN)) {
            this.ivMausoleumTable.ivScrollPane.setCursor(Cursor.getPredefinedCursor(3));
            try {
                this.checkOwnerButton((MToggleButton)e.getSource());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.ivMausoleumTable.ivScrollPane.setCursor(Cursor.getDefaultCursor());
        }
        if (comm.equals(COM_VISIBILITY)) {
            this.checkVisibilityButton((MToggleButton)e.getSource());
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (!e.isMetaDown() && e.getClickCount() == 2 && this.ivTable != null) {
            Point p1 = this.ivTable.getLocationOnScreen();
            Point p2 = e.getPoint();
            this.processDoubleClick(new Point(p1.x + p2.x, p1.y + p2.y), p2);
        }
    }

    public void makeAktTable(MouseEvent e) {
        if (this.ivTable != null) {
            if (this.ivAdjustInspector) {
                Inspector.adjustToTable(this.ivMausoleumTable);
            }
            this.ivTable.repaint();
            this.selectionChanged();
        }
    }

    public void mousePressed(MouseEvent e) {
        int rap;
        int n = rap = this.ivTable != null ? this.ivTable.rowAtPoint(e.getPoint()) : -1;
        if (rap == -1) {
            this.ivSelectedRows.clear();
            this.makeAktTable(e);
        } else {
            Vector v;
            if (e.isShiftDown() && e.isControlDown() && (v = this.getSelectedObjects()) != null && !v.isEmpty()) {
                StringBuilder msb = new StringBuilder();
                Iterator iter = v.iterator();
                while (iter.hasNext()) {
                    Object ooo = iter.next();
                    if (!(ooo instanceof IDObject)) continue;
                    IDObject iob = (IDObject)ooo;
                    msb.append("--------------------------------------------\r\n");
                    msb.append(IDObjectXMLHandler.getXMLString(iob, iob.getGroup()).trim()).append("\r\n");
                    msb.append("--------------------------------------------\r\n");
                    msb.append(iob.ivProperties.toString()).append("\r\n");
                    msb.append("--------------------------------------------\r\n");
                }
                ClipboardObject.manageCopy(null, msb.toString());
            }
            if (e.isShiftDown()) {
                int ey = rap;
                int ay = this.ivLastPressed;
                if (ey < ay) {
                    ey = this.ivLastPressed;
                    ay = rap;
                }
                this.ivSelectedRows.clear();
                int i = ay;
                while (i <= ey) {
                    this.ivSelectedRows.add(new Integer(i));
                    ++i;
                }
                this.makeAktTable(e);
            } else if (e.isControlDown()) {
                this.ivDragStart = rap;
                this.ivLastPressed = rap;
                Integer rowi = new Integer(this.ivDragStart);
                if (!this.ivSelectedRows.contains(rowi)) {
                    this.ivSelectedRows.add(rowi);
                } else {
                    this.ivSelectedRows.remove(rowi);
                }
                this.makeAktTable(e);
            } else if (!e.isMetaDown()) {
                this.ivDragStart = rap;
                this.ivLastPressed = rap;
                boolean usedEvent = false;
                Integer rowkey = new Integer(rap);
                if (this.ivSelectedRows.contains(rowkey) && !(usedEvent = this.editInTable(e, rap))) {
                    usedEvent = this.dragStart(e);
                }
                if (!usedEvent) {
                    this.ivSelectedRows.clear();
                    this.ivSelectedRows.add(new Integer(rap));
                    this.makeAktTable(e);
                } else if (this.ivAdjustInspector) {
                    Inspector.adjustToTable(this.ivMausoleumTable);
                }
            }
        }
    }

    private boolean editInTable(MouseEvent e, int rap) {
        int col;
        String colName;
        boolean didEdit = false;
        if (this.ivTable != null && this.ivIsExecutable && DefaultManager.getExecuteInTable() && Privileges.hasPrivilege("EXECUTE_IN_TABLE") && Inspector.cvActPanel != null && Inspector.cvActPanel.ivSelObjects.contains(this.ivObjects.elementAt(rap)) && this.isColumnEditable(colName = this.ivColumnNames[col = this.ivTable.columnAtPoint(e.getPoint())])) {
            try {
                ActionListener al = this.getActionListenerForColumn(colName);
                if (al != null) {
                    boolean enabled = false;
                    if (al instanceof ChangeSensitive) {
                        ChangeSensitive cs = (ChangeSensitive)((Object)al);
                        enabled = cs.isActive();
                    } else if (al instanceof JTextField) {
                        enabled = ((JTextField)((Object)al)).isEditable();
                    }
                    if (enabled) {
                        al.actionPerformed(null);
                        didEdit = true;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return didEdit;
    }

    private boolean dragStart(MouseEvent e) {
        boolean didDragStart = false;
        if (this.istDragNDroppable()) {
            didDragStart = true;
            if (this instanceof MTTaskInSchedule) {
                MTTaskInSchedule mttask = (MTTaskInSchedule)this;
                mttask.handleDragStart();
            } else if (RackFrame.getInstance() != null && RackFrame.getInstance().isVisible()) {
                Vector cages;
                if (this instanceof MTMouse) {
                    Vector mice = this.getSelectedObjects();
                    if (Mouse.areMiceTouchable(mice) && Privileges.hasPrivilege("MOVE_MICE") && !Mouse.areMiceRoomAccesibilityRestricted(mice)) {
                        this.ivExtendedRackPos = new ExtendedRackPos();
                        this.ivExtendedRackPos.setMice(mice);
                        this.ivExtendedRackPos.ivFeldKennung = 4;
                        RackFrameMouseManager.cvInstance.evaluateStartERP(this.ivExtendedRackPos, e, e.getPoint(), true);
                        this.ivMausoleumTable.ivScrollPane.getHorizontalScrollBar().setEnabled(false);
                        this.ivMausoleumTable.ivScrollPane.getVerticalScrollBar().setEnabled(false);
                        this.ivMausoleumTable.ivScrollPane.getViewport().getView().setEnabled(false);
                        this.ivMausoleumTable.setCursor(RackFrameMouseManager.cvInstance.ivDragCursor);
                    }
                } else if (this instanceof MTCage && Privileges.hasPrivilege("MOVE_CAGES") && (cages = this.getSelectedObjects()) != null && !cages.isEmpty()) {
                    Vector<Cage> dragCages = new Vector<Cage>();
                    Iterator iter = cages.iterator();
                    while (iter.hasNext()) {
                        Cage cage = (Cage)iter.next();
                        if (!cage.itsMine(null) && !Privileges.hasPrivilege("TOUCH_FOREIGN_CAGES") || cage.isRoomAccesibilityRestricted()) continue;
                        dragCages.add(cage.getSuperCageIfThere());
                    }
                    if (!dragCages.isEmpty()) {
                        this.ivExtendedRackPos = new ExtendedRackPos();
                        this.ivExtendedRackPos.setCages(dragCages);
                        this.ivExtendedRackPos.ivFeldKennung = 4;
                        RackFrameMouseManager.cvInstance.evaluateStartERP(this.ivExtendedRackPos, e, e.getPoint(), true);
                        this.ivMausoleumTable.ivScrollPane.getHorizontalScrollBar().setEnabled(false);
                        this.ivMausoleumTable.ivScrollPane.getVerticalScrollBar().setEnabled(false);
                        this.ivMausoleumTable.ivScrollPane.getViewport().getView().setEnabled(false);
                        this.ivMausoleumTable.setCursor(RackFrameMouseManager.cvInstance.ivDragCursor);
                    }
                }
            }
        }
        return didDragStart;
    }

    public void mouseReleased(MouseEvent e) {
        if (e.isMetaDown()) {
            return;
        }
        JScrollPane jsp = this.ivMausoleumTable.ivScrollPane;
        if (this.ivTable != null && this.istDragNDroppable() && this.ivExtendedRackPos != null) {
            Point jetzt = e.getPoint();
            Point jetztMitSP = new Point(jetzt);
            if (jsp.getVerticalScrollBar() != null) {
                jetztMitSP.y -= jsp.getVerticalScrollBar().getValue();
            }
            Dimension d = jsp.getSize();
            if (jetzt.x < 0 || jetztMitSP.y < 0 || jetzt.x > d.width || jetztMitSP.y > d.height) {
                Point ziel = RackFrameMouseManager.getComponentLocation();
                if (ziel != null) {
                    Point start = this.ivTable.getLocationOnScreen();
                    Point p = new Point(start.x - ziel.x + jetzt.x, start.y - ziel.y + jetzt.y);
                    MouseEvent nevent = new MouseEvent(RackFrameMouseManager.cvComponent, 3467, System.currentTimeMillis(), e.getModifiers(), p.x, p.y, e.getClickCount(), e.isPopupTrigger());
                    RackFrameMouseManager.cvInstance.mouseReleased(nevent);
                }
            } else {
                RackFrameMouseManager.clearDragTargetInFields(true);
                RackFrameMouseManager.clearCursor();
            }
        }
        this.ivExtendedRackPos = null;
        jsp.getHorizontalScrollBar().setEnabled(true);
        jsp.getVerticalScrollBar().setEnabled(true);
        jsp.getViewport().getView().setEnabled(true);
        this.ivMausoleumTable.setCursor(Cursor.getDefaultCursor());
        this.ivDragStart = -1;
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
        if (this.ivTable != null) {
            this.ivTable.setToolTipText(null);
        }
    }

    public void mouseDragged(MouseEvent e) {
        int rap;
        if (this.ivTable != null && this.istDragNDroppable() && this.ivExtendedRackPos != null) {
            Point jetzt = e.getPoint();
            Dimension d = this.ivMausoleumTable.ivScrollPane.getSize();
            Point jetztMitSP = new Point(jetzt);
            if (this.ivMausoleumTable.ivScrollPane.getVerticalScrollBar() != null) {
                jetztMitSP.y -= this.ivMausoleumTable.ivScrollPane.getVerticalScrollBar().getValue();
            }
            if (jetzt.x < 0 || jetztMitSP.y < 0 || jetzt.x > d.width || jetztMitSP.y > d.height) {
                Point ziel = RackFrameMouseManager.getComponentLocation();
                if (ziel != null) {
                    Point start = this.ivTable.getLocationOnScreen();
                    Point p = new Point(start.x - ziel.x + jetzt.x, start.y - ziel.y + jetzt.y);
                    MouseEvent nevent = new MouseEvent(RackFrameMouseManager.cvComponent, 3467, System.currentTimeMillis(), e.getModifiers(), p.x, p.y, e.getClickCount(), e.isPopupTrigger());
                    RackFrameMouseManager.cvInstance.mouseDragged(nevent);
                    e.consume();
                    return;
                }
            } else {
                RackFrameMouseManager.clearDragTargetInFields(false);
                e.consume();
                return;
            }
        }
        int n = rap = this.ivTable != null ? this.ivTable.rowAtPoint(e.getPoint()) : -1;
        if (rap != -1 && this.ivDragStart != -1) {
            int ey = rap;
            int ay = this.ivDragStart;
            if (ey < ay) {
                ey = this.ivDragStart;
                ay = rap;
            }
            if (!e.isControlDown()) {
                this.ivSelectedRows.clear();
            }
            int i = ay;
            while (i <= ey) {
                this.ivSelectedRows.add(new Integer(i));
                ++i;
            }
        }
        this.makeAktTable(e);
    }

    public void mouseMoved(MouseEvent e) {
        if (this.ivTable != null && DefaultManager.getWantsTooltips()) {
            try {
                int rap = this.ivTable.rowAtPoint(e.getPoint());
                int cap = this.ivTable.columnAtPoint(e.getPoint());
                if (rap != -1 && this.ivObjects.size() > rap) {
                    Object ooo = this.ivObjects.elementAt(rap);
                    if (ooo instanceof Cage) {
                        int mode = DefaultManager.getCageTooltipMode();
                        if (mode == 3) {
                            this.ivTable.setToolTipText(((Cage)ooo).getToolTipString(true));
                        } else if (mode == 1) {
                            this.ivTable.setToolTipText(((Cage)ooo).getToolTipString(false));
                        } else if (this.ivTable instanceof JTableForCages) {
                            JTableForCages jtfc = (JTableForCages)this.ivTable;
                            jtfc.setCageForTooltip((Cage)ooo);
                        }
                    } else if (ooo instanceof Mouse) {
                        if (this instanceof MTMouse) {
                            MTMouse mtm = (MTMouse)this;
                            this.ivTable.setToolTipText(mtm.getTooltip(cap, (Mouse)ooo));
                        } else {
                            this.ivTable.setToolTipText(((Mouse)ooo).getToolTipStringTasks());
                        }
                    } else if (ooo instanceof DisplayTask) {
                        DisplayTask dt = (DisplayTask)ooo;
                        this.ivTable.setToolTipText(dt.getToolTipString());
                    }
                } else {
                    this.mouseExited(e);
                }
            }
            catch (Exception exc) {
                Log.error("Problem bei ToolTip", exc, this);
            }
        }
    }

    public void keyTyped(KeyEvent arg0) {
    }

    public void keyPressed(KeyEvent e) {
        int kc = e.getKeyCode();
        if (kc == 67 && e.isControlDown()) {
            if (this.ivMausoleumTable != null) {
                new CopyRequester((Frame)Inspector.getInspector(), this, this, this.ivTable.getSelectedRows()).setVisible(true);
            }
        } else if (!(kc == 88 && e.isControlDown() || kc == 86 && e.isControlDown())) {
            if (kc == 38) {
                int fsr;
                if (this.ivTable != null && this.ivTable.isEnabled() && (fsr = this.getFirstSelectedRow()) > 0) {
                    if (!e.isShiftDown()) {
                        this.ivSelectedRows.clear();
                    }
                    this.ivSelectedRows.add(new Integer(fsr - 1));
                    if (this.ivAdjustInspector) {
                        Inspector.adjustToTable(this.ivMausoleumTable);
                    }
                    this.ivMausoleumTable.ensureSelectionIsVisible();
                    this.selectionChanged();
                    this.ivTable.repaint();
                }
            } else if (kc != 39 && kc != 37) {
                if (kc == 40) {
                    int fsr;
                    if (this.ivTable != null && this.ivTable.isEnabled() && (fsr = this.getLastSelectedRow()) >= 0 && fsr < this.ivObjects.size() - 1) {
                        if (!e.isShiftDown()) {
                            this.ivSelectedRows.clear();
                        }
                        this.ivSelectedRows.add(new Integer(fsr + 1));
                        if (this.ivAdjustInspector) {
                            Inspector.adjustToTable(this.ivMausoleumTable);
                        }
                        this.ivMausoleumTable.ensureSelectionIsVisible();
                        this.selectionChanged();
                        this.ivTable.repaint();
                    }
                } else if (e.getKeyCode() == 65 && e.isControlDown()) {
                    if (this.ivTable != null && this.ivTable.isEnabled()) {
                        this.selectAll();
                    }
                } else if (e.getKeyCode() == 81 && e.isControlDown() && this.ivTable != null && this.ivTable.isEnabled()) {
                    this.selectNone();
                }
            }
        }
    }

    public void keyReleased(KeyEvent arg0) {
    }

    class SpecifiedString {
        public final boolean ivInverted;
        public final Vector ivValues = new Vector();

        public SpecifiedString(String val, boolean inverted) {
            Zeile z = new Zeile(val, ' ');
            int i = 0;
            while (i < z.size()) {
                String s = z.getString(i, null);
                if (s != null && s.length() != 0) {
                    this.ivValues.add(s.toLowerCase());
                }
                ++i;
            }
            this.ivInverted = inverted;
        }

        public boolean match(String s) {
            boolean res = false;
            if (s != null && s.length() != 0) {
                String t = s.toLowerCase();
                Iterator iterator = this.ivValues.iterator();
                while (!res && iterator.hasNext()) {
                    String vs = (String)iterator.next();
                    if (!t.contains(vs)) continue;
                    res = true;
                }
            }
            return this.ivInverted ? !res : res;
        }

        public String toString() {
            StringBuilder msb = new StringBuilder("<");
            Iterator iterator = this.ivValues.iterator();
            while (iterator.hasNext()) {
                String s = (String)iterator.next();
                msb.append(s);
                if (!iterator.hasNext()) continue;
                msb.append(", ");
            }
            msb.append(">");
            return msb.toString();
        }
    }
}

