/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.tables;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.ObjectConsumer;
import de.hannse.netobjects.objectstore.ObjectStoreClient;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.util.Babel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mausoleum.gui.RequesterPane;
import mausoleum.helper.FontManager;
import mausoleum.helper.MausoleumImageStore;
import mausoleum.helper.WindowUtils;
import mausoleum.main.MausoleumClient;
import mausoleum.tables.MausoleumTable;
import mausoleum.tables.MausoleumTableModel;
import mausoleum.ui.UIDef;

public class SplitContentFrame
extends JFrame
implements ObjectConsumer {
    private static final long serialVersionUID = 14861313L;
    private final JList ivFilterNameList;
    private final HashMap ivObjectKeysByFilterName;
    private final HashMap ivAllObjectsByKey;
    private final MausoleumTableModel ivModel;
    private final JLabel ivListLabel = new JLabel();
    private final HashSet ivDrin = new HashSet(1000);

    public static void showSplittedTable(MausoleumTableModel model, int splitIndex) {
        String[] filterCols = model.getAllSplitableCols();
        if (filterCols != null && splitIndex >= 0 && splitIndex < filterCols.length) {
            HashMap splitMap = new HashMap();
            Vector<String> filterNamen = new Vector<String>();
            String allSignal = Babel.get("ALL");
            splitMap.put(allSignal, new Vector());
            filterNamen.add(allSignal);
            String emptySignal = Babel.get("EMPTY");
            splitMap.put(emptySignal, new Vector());
            filterNamen.add(emptySignal);
            String nonEmptySignal = Babel.get("NON_EMPTY");
            splitMap.put(nonEmptySignal, new Vector());
            filterNamen.add(nonEmptySignal);
            model.ermittleFilterUndSplitte(filterCols[splitIndex], filterNamen, splitMap, allSignal, emptySignal, nonEmptySignal);
            MausoleumTableModel mtm = model.getDefaultModel();
            mtm.ivStoreSettingsUponChange = false;
            SplitContentFrame scf = new SplitContentFrame(filterCols[splitIndex], filterNamen, splitMap, mtm, model);
            WindowUtils.bringUpFrame(scf);
            if (MausoleumClient.isServiceCaretaker() && IDObject.canSitInRoom(model.getObjectType())) {
                ObjectStoreClient.addConsumer((ObjectConsumer)scf, 1);
            }
        }
    }

    public SplitContentFrame(String col, Vector filterNames, HashMap objectsByFilterName, MausoleumTableModel mtm, MausoleumTableModel model) {
        this.setTitle(StringHelper.gSub(Babel.get("SPLITTED_TABLES"), "_COL_", ">" + Babel.get(col) + "<", true));
        this.setIconImage(MausoleumImageStore.getLogo());
        this.ivModel = mtm;
        this.ivObjectKeysByFilterName = new HashMap();
        this.ivAllObjectsByKey = new HashMap(1000);
        Iterator iter = objectsByFilterName.keySet().iterator();
        while (iter.hasNext()) {
            Object filterName = iter.next();
            Vector v = (Vector)objectsByFilterName.get(filterName);
            Vector<String> nv = new Vector<String>(v.size());
            Iterator iterator = v.iterator();
            while (iterator.hasNext()) {
                IDObject ido = (IDObject)iterator.next();
                String key = ido.getIdentifierString();
                this.ivAllObjectsByKey.put(key, ido);
                nv.add(key);
            }
            this.ivObjectKeysByFilterName.put(filterName, nv);
        }
        this.ivFilterNameList = new JList(filterNames);
        this.ivFilterNameList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent arg0) {
                if (!arg0.getValueIsAdjusting()) {
                    SplitContentFrame.this.subsetsSelected();
                }
            }
        });
        this.ivListLabel.setFont(FontManager.getFont("SSB12"));
        this.ivFilterNameList.setCellRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList rlist, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String name = value instanceof String ? (String)value : value.toString();
                Vector v = (Vector)SplitContentFrame.this.ivObjectKeysByFilterName.get(value);
                if (v != null) {
                    SplitContentFrame.this.ivListLabel.setText(String.valueOf(name) + " [" + v.size() + "]");
                } else {
                    SplitContentFrame.this.ivListLabel.setText(name);
                }
                if (isSelected) {
                    SplitContentFrame.this.ivListLabel.setBackground(UIDef.SELECTED_BACKGROUND);
                    SplitContentFrame.this.ivListLabel.setOpaque(true);
                } else {
                    SplitContentFrame.this.ivListLabel.setBackground(null);
                    SplitContentFrame.this.ivListLabel.setOpaque(false);
                }
                return SplitContentFrame.this.ivListLabel;
            }
        });
        this.ivFilterNameList.setSelectionMode(2);
        this.ivFilterNameList.setBorder(new EmptyBorder(UIDef.getScaled(3), UIDef.getScaled(3), UIDef.getScaled(3), UIDef.getScaled(3)));
        this.ivModel.takeColumnDefinitionsFromModel(model);
        MausoleumTable table = new MausoleumTable(this.ivModel, false);
        table.setIsSubdisplay();
        this.ivModel.takeWidthsFromModel(model);
        JSplitPane split = new JSplitPane(1, new JScrollPane(this.ivFilterNameList), table);
        split.setDividerLocation(180);
        this.setContentPane(new RequesterPane(new BorderLayout()));
        this.getContentPane().add("Center", split);
        this.setBounds(UIDef.getScaled(10), UIDef.getScaled(10), UIDef.getScaled(700), UIDef.getScaled(500));
    }

    private synchronized void subsetsSelected() {
        Vector sammler = null;
        Object[] names = this.ivFilterNameList.getSelectedValues();
        if (names.length == 0) {
            sammler = new Vector();
        } else if (names.length == 1) {
            Vector v = (Vector)this.ivObjectKeysByFilterName.get(names[0]);
            sammler = new Vector(v.size());
            Iterator iter = v.iterator();
            while (iter.hasNext()) {
                sammler.add(this.ivAllObjectsByKey.get(iter.next()));
            }
        } else {
            this.ivDrin.clear();
            sammler = new Vector(1000);
            int i = 0;
            while (i < names.length) {
                Vector v = (Vector)this.ivObjectKeysByFilterName.get(names[i]);
                Iterator iter = v.iterator();
                while (iter.hasNext()) {
                    String id = (String)iter.next();
                    if (this.ivDrin.contains(id)) continue;
                    this.ivDrin.add(id);
                    sammler.add(this.ivAllObjectsByKey.get(id));
                }
                ++i;
            }
        }
        this.ivModel.ivSelectedRows.clear();
        this.ivModel.setTable(sammler);
        this.ivModel.resort();
        this.ivModel.makeAktTable(null);
    }

    public void objectLeftServiceRoom(int objectTyp, String group, HashSet objectIDs) {
        if (objectTyp == this.ivModel.getObjectType()) {
            Vector prevsel = this.ivModel.getSelectedObjects();
            Iterator iter = this.ivObjectKeysByFilterName.values().iterator();
            while (iter.hasNext()) {
                Vector v = (Vector)iter.next();
                Vector<IDObject> raus = new Vector<IDObject>();
                Iterator iter2 = v.iterator();
                while (iter2.hasNext()) {
                    IDObject iob = (IDObject)this.ivAllObjectsByKey.get(iter2.next());
                    if (!iob.getGroup().equals(group) || !objectIDs.contains(iob.get("IDO_ID"))) continue;
                    raus.add(iob);
                }
                if (raus.isEmpty()) continue;
                Iterator iterator = raus.iterator();
                while (iterator.hasNext()) {
                    v.remove(iterator.next());
                }
            }
            this.subsetsSelected();
            if (!prevsel.isEmpty()) {
                this.ivModel.adjustSelection(prevsel);
            }
        }
    }

    public void handleNewObjects(Vector idObjects) {
    }

    public void handleNewObject(IDObject obj) {
    }
}

