/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.tables;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.user.Privileges;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.Babel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mausoleum.definitionlists.ListDefinitionPane;
import mausoleum.gui.RequesterPane;
import mausoleum.gui.VerticalText;
import mausoleum.helper.FontManager;
import mausoleum.helper.WindowUtils;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.actions.room.RoomAction;
import mausoleum.main.MausoleumClient;
import mausoleum.room.RoomStatusListener;
import mausoleum.tables.MausoleumTable;
import mausoleum.tables.MausoleumTableFrame;
import mausoleum.tables.MausoleumTableModel;
import mausoleum.tables.MausoleumTableTabbedPane;
import mausoleum.tables.TableFrameCage;
import mausoleum.tables.TableFrameMouse;
import mausoleum.tables.TableFrameTasks;
import mausoleum.tables.models.MTBuilding;
import mausoleum.tables.models.MTExperiment;
import mausoleum.tables.models.MTLicense;
import mausoleum.tables.models.MTLine;
import mausoleum.tables.models.MTLocus;
import mausoleum.tables.models.MTMailReceived;
import mausoleum.tables.models.MTMailSent;
import mausoleum.tables.models.MTOwnerGroup;
import mausoleum.tables.models.MTRack;
import mausoleum.tables.models.MTRoom;
import mausoleum.tables.models.MTStrain;
import mausoleum.tables.models.MTUser;
import mausoleum.tables.models.MTUserGroup;
import mausoleum.ui.UIDef;
import mausoleum.util.InstallationType;

public class TableFrameBasicObjects
extends MausoleumTableFrame
implements RoomStatusListener {
    private static final long serialVersionUID = -281349878574068106L;
    private final JTabbedPane ivTabbedPane = new TFBOMainTabbedPane();
    private ListDefinitionPane ivListDefinitionPane = null;
    private boolean ivReact = true;

    public TableFrameBasicObjects() {
        super((MausoleumTable)null);
        this.setContentPane(new RequesterPane(new BorderLayout()));
        this.getContentPane().add("Center", this.ivTabbedPane);
        this.ivTabbedPane.setOpaque(false);
        this.ivTabbedPane.setTabLayoutPolicy(1);
        int step = 0;
        int maxStep = 0;
        if (MausoleumClient.isRegular()) {
            maxStep = 14;
            MausoleumClient.setSubMessage(step++, maxStep, Babel.get("MICE"));
            this.ivTabbedPane.addTab(Babel.get("MICE"), TableFrameMouse.createMainTabbedPane());
            MausoleumClient.setSubMessage(step++, maxStep, Babel.get("CAGES"));
            this.ivTabbedPane.addTab(Babel.get("CAGES"), TableFrameCage.createMainTabbedPane());
            MausoleumClient.setSubMessage(step++, maxStep, Babel.get("TASKS"));
            TableFrameTasks.init();
            this.ivTabbedPane.addTab(Babel.get("TASKS"), TableFrameTasks.TABBED_PANE);
            MausoleumTableTabbedPane basics = new MausoleumTableTabbedPane();
            basics.setOpaque(false);
            MausoleumClient.setSubMessage(step++, maxStep, Babel.get("STRAINS"));
            this.addStandard("STRAINS", new MTStrain(), basics);
            MausoleumClient.setSubMessage(step++, maxStep, Babel.get("LOCI"));
            this.addStandard("LOCI", new MTLocus(), basics);
            MausoleumClient.setSubMessage(step++, maxStep, Babel.get("LINES"));
            this.addStandard("LINES", new MTLine(), basics);
            MausoleumClient.setSubMessage(step++, maxStep, Babel.get("EXPERIMENTS"));
            this.addStandard("EXPERIMENTS", new MTExperiment(), basics);
            MausoleumClient.setSubMessage(step++, maxStep, Babel.get("ROOMS"));
            this.addStandard("ROOMS", new MTRoom(), basics);
            MausoleumClient.setSubMessage(step++, maxStep, Babel.get("USERS"));
            this.addStandard("USERS", new MTUser(), basics);
            MausoleumClient.setSubMessage(step++, maxStep, Babel.get("OWNER_GROUPS"));
            this.addStandard("OWNER_GROUPS", new MTOwnerGroup(), basics);
            MausoleumClient.setSubMessage(step++, maxStep, Babel.get("LICENSES"));
            this.addStandard("LICENSES", new MTLicense(), basics);
            if (Privileges.hasPrivilege("VIEW_DEFINITION_LISTS")) {
                MausoleumClient.setSubMessage(step++, maxStep, Babel.get("DEFINITION_LISTS"));
                this.ivListDefinitionPane = new ListDefinitionPane();
                basics.add(Babel.get("DEFINITION_LISTS"), this.ivListDefinitionPane);
            }
            MausoleumClient.setSubMessage(step++, maxStep, Babel.get("MAIL"));
            this.addMail();
            MausoleumClient.setSubMessage(step++, maxStep, Babel.get("GENERALS"));
            this.ivTabbedPane.addTab(Babel.get("GENERALS"), basics);
        } else if (MausoleumClient.isHeadOfService()) {
            maxStep = 12;
            MausoleumClient.setSubMessage(step++, maxStep, Babel.get("TASKS"));
            TableFrameTasks.init();
            this.ivTabbedPane.addTab(Babel.get("TASKS"), TableFrameTasks.TABBED_PANE);
            MausoleumTableTabbedPane basics = new MausoleumTableTabbedPane();
            basics.setOpaque(false);
            MausoleumClient.setSubMessage(step++, maxStep, Babel.get("RACKS"));
            this.addStandard("RACKS", new MTRack(), basics);
            MausoleumClient.setSubMessage(step++, maxStep, Babel.get("ROOMS"));
            this.addStandard("ROOMS", new MTRoom(), basics);
            MausoleumClient.setSubMessage(step++, maxStep, Babel.get("BUILDINGS"));
            this.addStandard("BUILDINGS", new MTBuilding(), basics);
            MausoleumClient.setSubMessage(step++, maxStep, Babel.get("GROUPS"));
            this.addStandard("GROUPS", new MTUserGroup(), basics);
            MausoleumClient.setSubMessage(step++, maxStep, Babel.get("USERS"));
            this.addStandard("USERS", new MTUser(), basics);
            MausoleumClient.setSubMessage(step++, maxStep, Babel.get("STRAINS"));
            this.addStandard("STRAINS", new MTStrain(), basics);
            MausoleumClient.setSubMessage(step++, maxStep, Babel.get("LOCI"));
            this.addStandard("LOCI", new MTLocus(), basics);
            MausoleumClient.setSubMessage(step++, maxStep, Babel.get("LINES"));
            this.addStandard("LINES", new MTLine(), basics);
            MausoleumClient.setSubMessage(step++, maxStep, Babel.get("LICENSES"));
            this.addStandard("LICENSES", new MTLicense(), basics);
            MausoleumClient.setSubMessage(step++, maxStep, Babel.get("EXPERIMENTS"));
            this.addStandard("EXPERIMENTS", new MTExperiment(), basics);
            this.addMail();
            if (Privileges.hasPrivilege("VIEW_DEFINITION_LISTS")) {
                MausoleumClient.setSubMessage(step++, maxStep, Babel.get("DEFINITION_LISTS"));
                this.ivListDefinitionPane = new ListDefinitionPane();
                basics.add(Babel.get("DEFINITION_LISTS"), this.ivListDefinitionPane);
            }
            MausoleumClient.setSubMessage(step++, maxStep, Babel.get("GENERALS"));
            this.ivTabbedPane.addTab(Babel.get("GENERALS"), basics);
        } else if (MausoleumClient.isServiceCaretaker()) {
            maxStep = 8;
            MausoleumClient.setSubMessage(step++, maxStep, Babel.get("TASKS"));
            TableFrameTasks.init();
            this.ivTabbedPane.addTab(Babel.get("TASKS"), TableFrameTasks.TABBED_PANE);
            MausoleumClient.setSubMessage(step++, maxStep, Babel.get("MICE"));
            this.ivTabbedPane.addTab(Babel.get("MICE"), TableFrameMouse.createMainTabbedPane());
            MausoleumClient.setSubMessage(step++, maxStep, Babel.get("CAGES"));
            this.ivTabbedPane.addTab(Babel.get("CAGES"), TableFrameCage.createMainTabbedPane());
            this.addMail();
            MausoleumTableTabbedPane basics = new MausoleumTableTabbedPane();
            basics.setOpaque(false);
            MausoleumClient.setSubMessage(step++, maxStep, Babel.get("STRAINS"));
            this.addStandardWithGroupFilter("STRAINS", new MTStrain(), basics);
            MausoleumClient.setSubMessage(step++, maxStep, Babel.get("LOCI"));
            this.addStandardWithGroupFilter("LOCI", new MTLocus(), basics);
            MausoleumClient.setSubMessage(step++, maxStep, Babel.get("LINES"));
            this.addStandardWithGroupFilter("LINES", new MTLine(), basics);
            MausoleumClient.setSubMessage(step++, maxStep, Babel.get("USERS"));
            this.addStandard("USERS", new MTUser(), basics);
            MausoleumClient.setSubMessage(step++, maxStep, Babel.get("GENERALS"));
            this.ivTabbedPane.addTab(Babel.get("GENERALS"), basics);
        } else if (MausoleumClient.isHeadOfTGService()) {
            maxStep = 14;
            MausoleumClient.setSubMessage(step++, maxStep, Babel.get("MICE"));
            this.ivTabbedPane.addTab(Babel.get("MICE"), TableFrameMouse.createMainTabbedPane());
            MausoleumClient.setSubMessage(step++, maxStep, Babel.get("CAGES"));
            this.ivTabbedPane.addTab(Babel.get("CAGES"), TableFrameCage.createMainTabbedPane());
            MausoleumClient.setSubMessage(step++, maxStep, Babel.get("TASKS"));
            TableFrameTasks.init();
            this.ivTabbedPane.addTab(Babel.get("TASKS"), TableFrameTasks.TABBED_PANE);
            MausoleumTableTabbedPane basics = new MausoleumTableTabbedPane();
            basics.setOpaque(false);
            MausoleumClient.setSubMessage(step++, maxStep, Babel.get("STRAINS"));
            this.addStandard("STRAINS", new MTStrain(), basics);
            MausoleumClient.setSubMessage(step++, maxStep, Babel.get("LOCI"));
            this.addStandard("LOCI", new MTLocus(), basics);
            MausoleumClient.setSubMessage(step++, maxStep, Babel.get("LINES"));
            this.addStandard("LINES", new MTLine(), basics);
            MausoleumClient.setSubMessage(step++, maxStep, Babel.get("EXPERIMENTS"));
            this.addStandard("EXPERIMENTS", new MTExperiment(), basics);
            MausoleumClient.setSubMessage(step++, maxStep, Babel.get("ROOMS"));
            this.addStandard("ROOMS", new MTRoom(), basics);
            MausoleumClient.setSubMessage(step++, maxStep, Babel.get("USERS"));
            this.addStandard("USERS", new MTUser(), basics);
            MausoleumClient.setSubMessage(step++, maxStep, Babel.get("OWNER_GROUPS"));
            this.addStandard("OWNER_GROUPS", new MTOwnerGroup(), basics);
            MausoleumClient.setSubMessage(step++, maxStep, Babel.get("LICENSES"));
            this.addStandard("LICENSES", new MTLicense(), basics);
            if (Privileges.hasPrivilege("VIEW_DEFINITION_LISTS")) {
                MausoleumClient.setSubMessage(step++, maxStep, Babel.get("DEFINITION_LISTS"));
                this.ivListDefinitionPane = new ListDefinitionPane();
                basics.add(Babel.get("DEFINITION_LISTS"), this.ivListDefinitionPane);
            }
            MausoleumClient.setSubMessage(step++, maxStep, Babel.get("MAIL"));
            this.addMail();
            MausoleumClient.setSubMessage(step++, maxStep, Babel.get("GENERALS"));
            this.ivTabbedPane.addTab(Babel.get("GENERALS"), basics);
        } else if (MausoleumClient.isTGServiceCaretaker()) {
            maxStep = 14;
            MausoleumClient.setSubMessage(step++, maxStep, Babel.get("MICE"));
            this.ivTabbedPane.addTab(Babel.get("MICE"), TableFrameMouse.createMainTabbedPane());
            MausoleumClient.setSubMessage(step++, maxStep, Babel.get("CAGES"));
            this.ivTabbedPane.addTab(Babel.get("CAGES"), TableFrameCage.createMainTabbedPane());
            MausoleumClient.setSubMessage(step++, maxStep, Babel.get("TASKS"));
            TableFrameTasks.init();
            this.ivTabbedPane.addTab(Babel.get("TASKS"), TableFrameTasks.TABBED_PANE);
            MausoleumTableTabbedPane basics = new MausoleumTableTabbedPane();
            basics.setOpaque(false);
            MausoleumClient.setSubMessage(step++, maxStep, Babel.get("STRAINS"));
            this.addStandard("STRAINS", new MTStrain(), basics);
            MausoleumClient.setSubMessage(step++, maxStep, Babel.get("LOCI"));
            this.addStandard("LOCI", new MTLocus(), basics);
            MausoleumClient.setSubMessage(step++, maxStep, Babel.get("LINES"));
            this.addStandard("LINES", new MTLine(), basics);
            MausoleumClient.setSubMessage(step++, maxStep, Babel.get("EXPERIMENTS"));
            this.addStandard("EXPERIMENTS", new MTExperiment(), basics);
            MausoleumClient.setSubMessage(step++, maxStep, Babel.get("ROOMS"));
            this.addStandard("ROOMS", new MTRoom(), basics);
            MausoleumClient.setSubMessage(step++, maxStep, Babel.get("USERS"));
            this.addStandard("USERS", new MTUser(), basics);
            MausoleumClient.setSubMessage(step++, maxStep, Babel.get("OWNER_GROUPS"));
            this.addStandard("OWNER_GROUPS", new MTOwnerGroup(), basics);
            MausoleumClient.setSubMessage(step++, maxStep, Babel.get("LICENSES"));
            this.addStandard("LICENSES", new MTLicense(), basics);
            if (Privileges.hasPrivilege("VIEW_DEFINITION_LISTS")) {
                MausoleumClient.setSubMessage(step++, maxStep, Babel.get("DEFINITION_LISTS"));
                this.ivListDefinitionPane = new ListDefinitionPane();
                basics.add(Babel.get("DEFINITION_LISTS"), this.ivListDefinitionPane);
            }
            MausoleumClient.setSubMessage(step++, maxStep, Babel.get("MAIL"));
            this.addMail();
            MausoleumClient.setSubMessage(step++, maxStep, Babel.get("GENERALS"));
            this.ivTabbedPane.addTab(Babel.get("GENERALS"), basics);
        }
        this.ivTabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                if (TableFrameBasicObjects.this.ivReact) {
                    TableFrameBasicObjects.switchInspector(TableFrameBasicObjects.this.ivTabbedPane);
                }
            }
        });
        RoomAction.addListener(this);
        this.setAppropriateTitle();
    }

    public void clearCompletely() {
        this.ivReact = false;
        this.setVisible(false);
        this.clearTabbedPaneCompletely(this.ivTabbedPane);
        this.dispose();
    }

    private void clearTabbedPaneCompletely(JTabbedPane pane) {
        if (pane.getTabCount() != 0) {
            Component[] arr = pane.getComponents();
            int i = 0;
            while (i < arr.length) {
                if (arr[i] instanceof MausoleumTable) {
                    MausoleumTable mt = (MausoleumTable)arr[i];
                    mt.mDispose();
                } else if (arr[i] instanceof JTabbedPane) {
                    this.clearTabbedPaneCompletely((JTabbedPane)arr[i]);
                }
                ++i;
            }
            while (pane.getTabCount() > 0) {
                pane.remove(0);
            }
        }
    }

    public void updateDefinitionlists() {
        if (this.ivListDefinitionPane != null) {
            this.ivListDefinitionPane.typeListSelected();
        }
    }

    public void roomStatusChanged() {
        this.setAppropriateTitle();
    }

    public void setAppropriateTitle() {
        StringBuilder msb = new StringBuilder();
        msb.append(InstallationType.getCapitalProgramName()).append(" ");
        msb.append("6.9.8 \u03b23").append(" <").append(UserManager.getNameOfUser()).append(">");
        msb.append(" ").append(RoomAction.cvRoomStatus).append(" ");
        this.setTitle(msb.toString());
    }

    private static void switchInspector(JTabbedPane pan) {
        Component c = pan.getSelectedComponent();
        if (c instanceof MausoleumTable) {
            MausoleumTable mt = (MausoleumTable)c;
            Inspector.adjustToTable(mt);
        } else if (c == TableFrameTasks.TABBED_PANE) {
            TableFrameTasks.manageInspectorAdaption();
        } else if (c instanceof JTabbedPane) {
            TableFrameBasicObjects.switchInspector((JTabbedPane)c);
        }
    }

    private void addMail() {
        if (UserManager.isRealUser()) {
            MausoleumTableTabbedPane mailPane = new MausoleumTableTabbedPane();
            MausoleumTable inBox = new MausoleumTable(new MTMailReceived(), false);
            MausoleumTable outBox = new MausoleumTable(new MTMailSent(), false);
            inBox.ivModel.fillMainTable();
            outBox.ivModel.fillMainTable();
            mailPane.addTab(Babel.get("INBOX"), inBox);
            mailPane.addTab(Babel.get("OUTBOX"), outBox);
            MausoleumTableFrame.MAIN_TABLES.put(new Integer(11), inBox);
            this.ivTabbedPane.addTab(Babel.get("MAIL"), mailPane);
        }
    }

    private MausoleumTable addStandardWithGroupFilter(String title, MausoleumTableModel mtm, JTabbedPane target) {
        MausoleumTable table = this.addStandard(title, mtm, target);
        table.add("North", new TFBOGroupCombo(mtm));
        return table;
    }

    private MausoleumTable addStandard(String title, MausoleumTableModel mtm, JTabbedPane target) {
        MausoleumTable table = new MausoleumTable(mtm, false);
        table.ivModel.fillMainTable();
        try {
            MausoleumTableFrame.MAIN_TABLES.put(IDObject.getTypeByClass(mtm.getServedClass()), table);
        }
        catch (Exception exception) {
            // empty catch block
        }
        target.add(Babel.get(title), table);
        return table;
    }

    public void rememberBounds() {
        WindowUtils.rememberBounds(this);
    }

    public MausoleumTable getActiveTableForInspector() {
        Component c = this.ivTabbedPane.getSelectedComponent();
        if (c != null) {
            JTabbedPane tp;
            Component sc;
            if (c instanceof MausoleumTable) {
                return (MausoleumTable)c;
            }
            if (c == TableFrameTasks.TABBED_PANE) {
                return TableFrameTasks.manageInspectorAdaption();
            }
            if (c instanceof JTabbedPane && (sc = (tp = (JTabbedPane)c).getSelectedComponent()) instanceof MausoleumTable) {
                MausoleumTable mt = (MausoleumTable)sc;
                return mt;
            }
        }
        return null;
    }

    public Dimension getDefaultSize() {
        return new Dimension(UIDef.getScaled(600), UIDef.getScaled(400));
    }

    public void processDoubleClick() {
    }

    public static class TFBOGroupCombo
    extends JComboBox {
        private static final long serialVersionUID = 1123235L;
        private final MausoleumTableModel ivModel;

        public TFBOGroupCombo(MausoleumTableModel mtm) {
            super(UserManager.getGroupNamesWithoutService());
            this.setFont(FontManager.getFont("SSB13"));
            this.ivModel = mtm;
            this.ivModel.setGroupFilter((String)this.getModel().getElementAt(0));
            this.addActionListener(new ActionListener(this){
                final /* synthetic */ TFBOGroupCombo this$1;
                {
                    this.this$1 = tFBOGroupCombo;
                }

                public void actionPerformed(ActionEvent arg0) {
                    TFBOGroupCombo.access$0(this.this$1).setGroupFilter((String)this.this$1.getSelectedItem());
                }
            });
        }

        static /* synthetic */ MausoleumTableModel access$0(TFBOGroupCombo tFBOGroupCombo) {
            return tFBOGroupCombo.ivModel;
        }
    }

    public static class TFBOMainPanel
    extends RequesterPane {
        private static final long serialVersionUID = 11234L;
        public final Component ivInnerComponent;

        public TFBOMainPanel(Component innerComp) {
            super(new BorderLayout());
            this.add("Center", innerComp);
            this.ivInnerComponent = innerComp;
        }
    }

    public static class TFBOMainTabbedPane
    extends JTabbedPane {
        private static final long serialVersionUID = 11234L;

        public TFBOMainTabbedPane() {
            super(2);
        }

        public void addTab(String title, Component table) {
            this.addTab(null, VerticalText.getIcon(Babel.get(title)), new TFBOMainPanel(table));
        }

        public Component getSelectedComponent() {
            TFBOMainPanel mp = (TFBOMainPanel)super.getSelectedComponent();
            return mp != null ? mp.ivInnerComponent : null;
        }
    }
}

