/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.tables;

import de.hannse.netobjects.util.Babel;
import java.util.Vector;
import javax.swing.JTabbedPane;
import mausoleum.main.ProcessDefinition;
import mausoleum.room.RoomStatusListener;
import mausoleum.tables.MausoleumTable;
import mausoleum.tables.MausoleumTableFrame;
import mausoleum.tables.MausoleumTableModel;
import mausoleum.tables.MausoleumTableTabbedPane;
import mausoleum.tables.OwnAllListener;
import mausoleum.tables.TableFrameForCollections;
import mausoleum.tables.models.MTCage;
import mausoleum.tables.models.MTCageCreated;
import mausoleum.tables.models.MTCageTouched;
import mausoleum.tables.models.MTWedding;
import mausoleum.util.InstallationType;

public class TableFrameCage
extends TableFrameForCollections
implements RoomStatusListener,
OwnAllListener {
    private static final long serialVersionUID = -6137181534767561982L;
    private static String PREFIX = Babel.get("CAGE_COLLECTIONS");
    private static final MausoleumTable NEW_CAGES = new MausoleumTable(new MTCageCreated(), false);
    private static final MausoleumTable TOUCHED_CAGES = new MausoleumTable(new MTCageTouched(), false);
    public static final MausoleumTable MATING_CAGES = InstallationType.useMatings() ? new MausoleumTable(new MTWedding(), false) : null;
    private static TableFrameCage cvInstance = null;

    static {
        if (ProcessDefinition.isClient()) {
            NEW_CAGES.setIsSubdisplay();
            TableFrameCage.NEW_CAGES.ivModel.setTable(new Vector());
            TOUCHED_CAGES.setIsSubdisplay();
            TableFrameCage.TOUCHED_CAGES.ivModel.setTable(new Vector());
        }
    }

    public static void addNewCages(Vector cages) {
        TableFrameCage.addReportObjects(cages, NEW_CAGES, Babel.get("CREATED_CAGES"), 6);
    }

    public static void addTouchedCages(Vector cages) {
        TableFrameCage.addReportObjects(cages, TOUCHED_CAGES, Babel.get("TOUCHED_CAGES"), 7);
    }

    public static void getNewCagesOfSession(Vector target) {
        TableFrameCage.NEW_CAGES.ivModel.addOriginalObjects(target);
    }

    public static void getTouchedCagesOfSession(Vector target) {
        TableFrameCage.TOUCHED_CAGES.ivModel.addOriginalObjects(target);
    }

    public static JTabbedPane createMainTabbedPane() {
        MausoleumTableTabbedPane mainPane = new MausoleumTableTabbedPane();
        mainPane.setOpaque(false);
        MausoleumTable mainTable = new MausoleumTable(new MTCage(), false);
        mainPane.addTab(Babel.get("ALL_CAGES"), mainTable);
        mainTable.ivModel.fillMainTable();
        if (InstallationType.useMatings()) {
            TableFrameCage.MATING_CAGES.ivModel.fillMainTable();
            mainPane.add(Babel.get("WEDDINGS"), MATING_CAGES);
        }
        mainPane.add(String.valueOf(Babel.get("CREATED_CAGES")) + " [0]", NEW_CAGES);
        mainPane.add(String.valueOf(Babel.get("TOUCHED_CAGES")) + " [0]", TOUCHED_CAGES);
        MausoleumTableFrame.MAIN_TABLES.put(new Integer(2), mainTable);
        MausoleumTableFrame.MAIN_TABLES.put(new Integer(4), MATING_CAGES);
        return mainPane;
    }

    public static void showCageTable(MausoleumTableModel mtm, String header, String tabTitle) {
        if (cvInstance == null) {
            cvInstance = new TableFrameCage();
        }
        cvInstance.showCollection(mtm, header, tabTitle);
    }

    public static void hideIt() {
        if (cvInstance != null) {
            cvInstance.setVisible(false);
        }
    }

    public String getTitelPrefix() {
        return PREFIX;
    }
}

