/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.tables;

import de.hannse.netobjects.util.MyDate;
import java.awt.BorderLayout;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.GregorianCalendar;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mausoleum.factsheets.sessionreports.SessionReport;
import mausoleum.gui.ClosableTabbedPane;
import mausoleum.gui.RequesterPane;
import mausoleum.helper.DatumFormat;
import mausoleum.helper.MausoleumImageStore;
import mausoleum.helper.WindowUtils;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.actions.room.RoomAction;
import mausoleum.room.RoomStatusListener;
import mausoleum.tables.MausoleumTable;
import mausoleum.tables.MausoleumTableModel;
import mausoleum.tables.MausoleumTableTabbedPane;
import mausoleum.tables.OwnAllListener;
import mausoleum.tables.models.MTMouse;

public abstract class TableFrameForCollections
extends JFrame
implements RoomStatusListener,
OwnAllListener {
    private static final long serialVersionUID = 14881153L;
    private final ClosableTabbedPane ivTabbedPane = new ClosableTabbedPane(true, true);

    public static void addReportObjects(Vector objects, MausoleumTable target, String prefix, int typ) {
        if (target != null) {
            target.ivModel.addObjectsToTable(objects);
            if (target.ivModel instanceof MTMouse) {
                target.ivModel.tableChanged(target.ivModel.getSelectedObjects());
            } else {
                MausoleumTableTabbedPane.setCountTitleFor(prefix, target);
            }
            SessionReport.setDirty(typ);
        }
    }

    public TableFrameForCollections() {
        this.setIconImage(MausoleumImageStore.getLogo());
        this.setContentPane(new RequesterPane(new BorderLayout()));
        this.getContentPane().add("Center", this.ivTabbedPane);
        WindowUtils.setRememberedBounds(this, new Rectangle(10, 10, 500, 400));
        this.setWindowTitle();
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent evt) {
                TableFrameForCollections.this.rememberBounds();
            }

            public void componentMoved(ComponentEvent evt) {
                TableFrameForCollections.this.rememberBounds();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                TableFrameForCollections.this.rememberBounds();
                TableFrameForCollections.this.setVisible(false);
                Inspector.setToDefault();
            }

            public void windowActivated(WindowEvent e) {
                Inspector.adjustToTable((MausoleumTable)TableFrameForCollections.this.ivTabbedPane.getSelectedComponent());
            }
        });
        this.ivTabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                Inspector.adjustToTable((MausoleumTable)TableFrameForCollections.this.ivTabbedPane.getSelectedComponent());
            }
        });
        RoomAction.addListener(this);
        this.setWindowTitle();
    }

    public void showCollection(MausoleumTableModel mtm, String header, String tabTitle) {
        MausoleumTable mt = new MausoleumTable(mtm, false);
        mt.setHeader(header);
        mt.setIsSubdisplay();
        mt.setOwnerButtonState(true);
        String datum = DatumFormat.getTimeString(new MyDate(new GregorianCalendar()));
        this.ivTabbedPane.addTab(tabTitle != null ? String.valueOf(tabTitle) + " " + datum : datum, mt);
        this.ivTabbedPane.selectLastTab();
        WindowUtils.bringUpFrame(this);
    }

    private void rememberBounds() {
        WindowUtils.rememberBounds(this);
    }

    public void roomStatusChanged() {
        this.setWindowTitle();
    }

    public void ownAllStatusChanged() {
        this.setWindowTitle();
    }

    public void setWindowTitle() {
        StringBuilder msb = new StringBuilder(this.getTitelPrefix());
        msb.append(" ").append(RoomAction.cvRoomStatus).append(" ");
        this.setTitle(msb.toString());
    }

    public abstract String getTitelPrefix();
}

