/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.tables.models;

import de.hannse.netobjects.objectstore.ObjectManager;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.user.User;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.user.UserRoomRestriction;
import de.hannse.netobjects.util.ArrayHelper;
import de.hannse.netobjects.util.Babel;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.cage.Cage;
import mausoleum.cage.CageManager;
import mausoleum.cage.colors.Herzeloyde;
import mausoleum.cage.colors.MixColorMode;
import mausoleum.cage.colors.MouseCount;
import mausoleum.gui.ColorManager;
import mausoleum.gui.MausoleumTableLabel;
import mausoleum.helper.AllgUtils;
import mausoleum.helper.ImageProvider;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.InspectorPanelCage;
import mausoleum.inspector.actions.room.RoomAction;
import mausoleum.main.DefaultManager;
import mausoleum.main.MausoleumClient;
import mausoleum.mouse.Mouse;
import mausoleum.printing.labelprinters.LabelPrinter;
import mausoleum.rack.RackPos;
import mausoleum.room.Room;
import mausoleum.room.RoomStatusListener;
import mausoleum.tables.MausoleumTableModel;
import mausoleum.tables.SplitFilterObject;
import mausoleum.tables.TableFrameCage;
import mausoleum.tables.TableFrameMouse;
import mausoleum.tables.models.MTMouse;
import mausoleum.tables.models.TableUtil;
import mausoleum.tables.sorting.MultiSortEntry;
import mausoleum.util.InstallationType;
import mausoleum.visit.Visit;

public class MTCage
extends MausoleumTableModel
implements RoomStatusListener {
    public static final String STR_NUMBER = "CAGENUMBER";
    public static final String STR_MICE = "MICE";
    public static final String STR_LINES = "LINES";
    public static final String STR_STRAINS = "STRAINS";
    public static final String STR_GENOTYPES = "GTS";
    public static final String STR_COMMENT = "COMMENT";
    public static final String STR_VISITS = "VISITS";
    public static final String STR_FATHER = "FATHER";
    public static final String STR_MOTHER = "MOTHER";
    public static final String STR_UNISEX = "UNISEX";
    public static final String STR_PRIMARY_OWNER = "PRIMARY_OWNER";
    public static final String STR_TASKS = "TASKS";
    private static final String ALL_ARE_OWNERS = "[" + Babel.get("ALL_MEMBERS_SHORT") + "]";
    private static final String[] TT_DICT = new String[]{"CAGENUMBER", "MTC_TT_CAGENUMBER", "MICE", "MTC_TT_MICE", "RACK", "MTC_TT_RACK", "RACK_POS", "MTC_TT_RACK_POS", "RACK_AND_POS", "MTC_TT_RACK_AND_POS", "ROOM", "TT_ROOM_NAME", "WEDDINGSHORT", "MTM_TT_WEDDINGSHORT", "WEDDING_EXT", "MTM_TT_WEDDING_EXT", "MARKSHORT", "MTC_TT_MARKSHORT", "LINES", "MTC_TT_LINES", "STRAINS", "MTC_TT_STRAINS", "GTS", "MTC_TT_GENOTYPES", "COMMENT", "MTC_TT_COMMENT", "ANTAG", "MTM_TT_ANTAG", "VISITS", "MTC_TT_VISITS", "MOTHER", "MTC_TT_MOTHER", "FATHER", "MTC_TT_FATHER", "UNISEX", "MTC_TT_UNISEX", "PRIMARY_OWNER", "MTC_TT_PRIMARY_OWNER", "TASKS", "MTC_TT_TASKS"};
    private static final String[] POSSIBLES = new String[]{"CAGENUMBER", "MICE", "RACK", "ROOM", "WEDDINGSHORT", "WEDDING_EXT", "MARKSHORT", "LINES", "STRAINS", "GTS", "COMMENT", "ANTAG", "VISITS", "MOTHER", "FATHER", "UNISEX", "PRIMARY_OWNER", "TASKS", "RACK_POS", "RACK_AND_POS"};
    private static final String[] SORTABLES = new String[]{"CAGENUMBER", "MICE", "RACK", "RACK_POS", "RACK_AND_POS", "ROOM", "WEDDINGSHORT", "WEDDING_EXT", "MARKSHORT", "LINES", "STRAINS", "GTS", "COMMENT", "ANTAG", "VISITS", "MOTHER", "FATHER", "UNISEX", "PRIMARY_OWNER", "TASKS"};
    private static final String[] EDITABLES = new String[]{"MARKSHORT", "ANTAG"};
    private static final String[] FILTERABLES = new String[]{"CAGENUMBER", "RACK", "ROOM", "MICE", "TASKS", "WEDDINGSHORT", "MARKSHORT", "LINES", "STRAINS", "MOTHER", "FATHER", "UNISEX", "PRIMARY_OWNER"};
    private static final String[] COLORABLES = new String[]{"CAGENUMBER", "MICE", "RACK", "ROOM", "WEDDINGSHORT", "WEDDING_EXT", "LINES", "STRAINS", "PRIMARY_OWNER", "RACK_AND_POS"};
    private static final String[] DEFAULT_COLUMNS = new String[]{"MARKSHORT", "CAGENUMBER", "MICE", "RACK", "WEDDINGSHORT", "LINES"};
    private static final String[] FISH_UNWANTED = new String[]{"WEDDINGSHORT", "WEDDING_EXT"};
    private TableFrameCage ivTableFrame = null;
    private static final HashMap PLAIN_SORTINGS = new HashMap(GENERAL_PLAIN_SORTINGS);
    protected boolean ivFilterByRooms = true;
    static /* synthetic */ Class class$0;

    static {
        PLAIN_SORTINGS.put("ANTAG", "CAG_ANTAG");
        PLAIN_SORTINGS.put("MARKSHORT", "CAG_FLAG");
    }

    public MTCage() {
        this(true);
    }

    public MTCage(Vector v) {
        this(true);
        this.setTable(v);
        this.sortDefault();
    }

    public MTCage(boolean addRoomlistener) {
        if (addRoomlistener) {
            RoomAction.addListener(this);
        }
    }

    public MausoleumTableModel getDefaultModel() {
        return new MTCage();
    }

    public int getTableType() {
        return 1;
    }

    public String getDisplayName() {
        return Babel.get("TDN_CAGE");
    }

    public ActionListener getActionListenerForColumn(String colName) {
        if (Inspector.cvActPanel != null && Inspector.cvActPanel instanceof InspectorPanelCage) {
            InspectorPanelCage ipc = (InspectorPanelCage)Inspector.cvActPanel;
            if (colName.equals("MARKSHORT")) {
                return ipc.ivMarkButton;
            }
            if (colName.equals("ANTAG")) {
                return ipc.ivANTagButton;
            }
        }
        return null;
    }

    public int[] getConsumertypes() {
        return new int[]{2, 7, 8, 1, 3, 6, 19, 20, 21};
    }

    public String[] getSortableColumns() {
        return SORTABLES;
    }

    public String[] getPossibleColumns() {
        return POSSIBLES;
    }

    public String[] getEditableColumns() {
        return EDITABLES;
    }

    public String[] getColorableColumns() {
        return COLORABLES;
    }

    public String[] getFilterableCols() {
        return FILTERABLES;
    }

    public String[] getDefaultColumnNames() {
        return DEFAULT_COLUMNS;
    }

    public String[] checkColumns(String[] arr) {
        if (arr != null && arr.length != 0 && !InstallationType.useMatings()) {
            int i = 0;
            while (i < FISH_UNWANTED.length) {
                arr = ArrayHelper.getArrayWithout(arr, FISH_UNWANTED[i]);
                ++i;
            }
        }
        return arr;
    }

    public HashMap getPlainSortings() {
        return PLAIN_SORTINGS;
    }

    public String getDefaultSortColumn() {
        return STR_NUMBER;
    }

    public int[] getWidths() {
        return new int[]{20, 45, 35, 65, 35, 250};
    }

    public String[] getDefaultColorableColumns() {
        return new String[]{STR_NUMBER};
    }

    public String[] getTooltipDict() {
        return TT_DICT;
    }

    public Class getServedClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("mausoleum.cage.Cage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public ObjectManager getManager() {
        return CageManager.cvInstance;
    }

    public SplitFilterObject getSFO(String colKennung, String val) {
        if (colKennung.equals(STR_MICE) || colKennung.equals(STR_TASKS)) {
            Integer key = null;
            try {
                key = new Integer(val);
            }
            catch (Exception e) {
                key = new Integer(0);
            }
            return new SplitFilterObject(val, val, key);
        }
        if (colKennung.equals(STR_NUMBER)) {
            Integer key = new Integer(0);
            try {
                int ind = val.indexOf("-");
                if (ind != -1) {
                    key = new Integer(val.substring(0, ind).trim());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return new SplitFilterObject(val, val, key);
        }
        return super.getSFO(colKennung, val);
    }

    public boolean istDragNDroppable() {
        return true;
    }

    public boolean isMutliDimPossible() {
        return true;
    }

    public boolean ichWillEinenOwnerKnopf() {
        return !UserManager.cvIsCareTaker;
    }

    public boolean ichWillFactSheets() {
        return true;
    }

    public void setTableFrame(TableFrameCage mtf) {
        this.ivTableFrame = mtf;
    }

    public void roomStatusChanged() {
        this.setOrigObjectsAgain();
    }

    public void setTable(Vector v) {
        super.setTable(v);
        if (this.ivTableFrame != null) {
            this.ivTableFrame.setWindowTitle();
        }
    }

    public boolean filterObject(Object ooo) {
        if (ooo instanceof Cage) {
            Cage cage = (Cage)ooo;
            return this.filterByDoubleCage(cage) && !UserRoomRestriction.isObjectRestricted(cage) && this.filterByRoom(cage) && this.filterByOwner(cage);
        }
        return false;
    }

    public boolean filterByDoubleCage(Cage c) {
        return !c.hasSubCages();
    }

    public boolean filterByOwner(Cage cage) {
        if (!UserManager.cvIsCareTaker && this.getOnlyOwnObjects()) {
            if (cage.itsMine(null)) {
                return true;
            }
            this.ivOwnerFiltered = true;
            return false;
        }
        return true;
    }

    public boolean filterByRoom(Cage cage) {
        if (this.ivFilterByRooms) {
            long roomid = RoomAction.cvRoomID;
            if (MausoleumClient.isServiceCaretaker()) {
                roomid = MausoleumClient.cvServiceCTRoomID;
            } else if (roomid == 0L) {
                return true;
            }
            if (MausoleumClient.isServiceCaretaker()) {
                Room room = cage.getRoom();
                if (room != null) {
                    Long srid = room.getServiceRoomID();
                    return srid != null && srid == roomid;
                }
            } else {
                return cage.isCageInRoomOrTransfer(roomid);
            }
        }
        return true;
    }

    public void processDoubleClick(Point p, Point originalPoint) {
        MTCage.showSnapshot(this.getSelectedObjects());
    }

    public static void showSnapshot(Vector cagesToShow) {
        Vector<Cage> cages = new Vector<Cage>();
        if (cagesToShow != null) {
            Iterator iter = cagesToShow.iterator();
            while (iter.hasNext()) {
                Cage c = (Cage)iter.next();
                if (!c.isAliveAndVisible()) continue;
                cages.add(c);
            }
        }
        if (!cages.isEmpty()) {
            TableFrameMouse.showCageContents(cages, false);
        }
    }

    public void processRightClick(int row) {
        String key;
        if (row >= 0 && row < this.ivObjects.size() && (key = DefaultManager.getLabelPrinter()) != null) {
            Vector preview = new Vector();
            preview.addElement(this.ivObjects.elementAt(row));
            LabelPrinter.previewIt(preview, key);
        }
    }

    public static void writeCageNumber(MausoleumTableLabel label, Cage cage) {
        label.setHorizontalAlignment(4);
        label.setCage(cage);
        label.setText(cage.getNumberString());
    }

    public void writeTheCodedElement(MausoleumTableLabel label, Object obj, String colName, boolean isForFilterSplit) {
        Cage cage = (Cage)obj;
        boolean maytouch = UserManager.cvIsCareTaker || cage.itsMine(null);
        this.setForegroundAccordingToOwnership(label, maytouch);
        if (this.getColumnIndex(colName) == 0) {
            label.setTriangleColor(Mouse.getTaskColor(cage.getActualMice(), null));
        }
        if (colName.equals("MARKSHORT")) {
            label.setHorizontalAlignment(0);
            if (cage.getChar("CAG_FLAG") == '\u0001') {
                label.setIcon(ImageProvider.HAND_ICON);
            } else if (cage.getChar("CAG_FLAG") != '\u0000') {
                char[] ica = new char[]{cage.getChar("CAG_FLAG")};
                label.setText(new String(ica));
            }
        } else if (colName.equals(STR_NUMBER)) {
            MTCage.writeCageNr(label, cage, colName, this.ivColouredColumns, isForFilterSplit);
        } else if (colName.equals(STR_MICE)) {
            label.setHorizontalAlignment(4);
            int numMice = cage.getNumberOfMice();
            if (numMice == 0) {
                if (isForFilterSplit) {
                    label.setText("");
                } else {
                    label.setText(" - ");
                }
            } else {
                label.setText(Integer.toString(numMice));
            }
            if (this.ivColouredColumns.contains(colName) && numMice != 0) {
                Color c = MixColorMode.getColor(numMice, MouseCount.VALUES, MouseCount.COLORS);
                label.setBackground(c);
                label.setForeground(ColorManager.getForegroundColorForBackground(c));
            }
        } else if (colName.equals("RACK")) {
            MTCage.writeRack(label, cage, colName, this.ivColouredColumns);
        } else if (colName.equals("RACK_POS")) {
            MTCage.writeRackPos(label, cage, colName, this.ivColouredColumns);
        } else if (colName.equals("RACK_AND_POS")) {
            MTCage.writeRackAndPos(label, cage, colName, this.ivColouredColumns);
        } else if (colName.equals("ROOM")) {
            MTCage.writeRoom(label, cage, colName, this.ivColouredColumns);
        } else if ("WEDDINGSHORT".equals(colName) || "WEDDING_EXT".equals(colName)) {
            TableUtil.handleMating(label, this.ivUseDefaultFontSize, cage.ivIsSterileWeddingCage, this.ivColouredColumns, colName, null, cage, cage.isMatingCage(), "WEDDING_EXT".equals(colName));
        } else if (colName.equals(STR_LINES)) {
            if (this.ivColouredColumns.contains(colName)) {
                label.setMultiBackgroundStrings(AllgUtils.getTypeMultiBackground(cage.getActualMice(), 0, null));
            } else {
                label.setText(AllgUtils.getTypeString(cage, cage.getActualMice(), 0, true));
            }
        } else if (colName.equals(STR_STRAINS)) {
            if (this.ivColouredColumns.contains(colName)) {
                label.setMultiBackgroundStrings(AllgUtils.getTypeMultiBackground(cage.getActualMice(), 1, null));
            } else {
                label.setText(AllgUtils.getTypeString(cage, cage.getActualMice(), 1, true));
            }
        } else if (colName.equals(STR_GENOTYPES)) {
            label.setText(AllgUtils.getTypeString(cage, cage.getActualMice(), 2, true));
        } else if (colName.equals(STR_COMMENT)) {
            label.setText(AllgUtils.getTypeString(cage, cage.getActualMice(), 3, true));
        } else if (colName.equals("ANTAG")) {
            label.setText(cage.getString("CAG_ANTAG", ""));
        } else if (colName.equals(STR_VISITS)) {
            Visit[] arr = (Visit[])cage.get("CAG_VISIT");
            if (arr != null) {
                label.setText(Integer.toString(arr.length));
                label.setHorizontalAlignment(4);
            } else {
                label.setText("");
            }
        } else if (colName.equals(STR_MOTHER)) {
            if (cage.ivMotherPresent) {
                label.setText("\u2713");
            }
            label.setHorizontalAlignment(0);
        } else if (colName.equals(STR_FATHER)) {
            if (cage.ivFatherPresent) {
                label.setText("\u2713");
            }
            label.setHorizontalAlignment(0);
        } else if (colName.equals(STR_UNISEX)) {
            if (cage.ivUniSex) {
                label.setText("\u2713");
            }
            label.setHorizontalAlignment(0);
        } else if (colName.equals(STR_PRIMARY_OWNER)) {
            Color c;
            User user;
            label.setText(cage.getOwnerStringOslo("", ALL_ARE_OWNERS));
            label.setHorizontalAlignment(0);
            if (this.ivColouredColumns.contains(colName) && (user = cage.getOwnerOslo()) != null && (c = (Color)user.get("USR_COLOR", null)) != null) {
                label.setBackground(c);
                label.setForeground(ColorManager.getForegroundColorForBackground(c));
            }
        } else if (colName.equals(STR_TASKS)) {
            int tasks = cage.getTaskCount();
            if (tasks > 0) {
                label.setHorizontalAlignment(4);
                label.setText(Integer.toString(tasks));
            }
        } else {
            super.writeGeneralElement(label, obj, colName, isForFilterSplit);
        }
    }

    public static void writeCageNr(MausoleumTableLabel label, Cage cage, String colName, HashSet colouredColumns, boolean isForFilterSplit) {
        if (isForFilterSplit) {
            int et = cage.getIntNumber();
            if (et == 0) {
                label.setText("");
            } else {
                int unten = et / 10;
                label.setText(String.valueOf(unten * 10) + " - " + ((unten + 1) * 10 - 1));
            }
        } else if (colouredColumns.contains(colName)) {
            MTCage.writeCageNumber(label, cage);
        } else {
            label.setHorizontalAlignment(4);
            label.setText(cage.getNumberString());
        }
    }

    public static void writeRack(MausoleumTableLabel label, Cage cage, String colName, HashSet colouredColumns) {
        label.setHorizontalAlignment(0);
        label.setText(cage.getRackName());
        MTMouse.setBGByRack(label, cage.getRoom(), colName, colouredColumns);
    }

    public static void writeRackPos(MausoleumTableLabel label, Cage cage, String colName, HashSet colouredColumns) {
        label.setHorizontalAlignment(0);
        label.setText(cage.getRackPosName());
    }

    public static void writeRackAndPos(MausoleumTableLabel label, Cage cage, String colName, HashSet colouredColumns) {
        label.setHorizontalAlignment(0);
        label.setText(cage.getRackAndPosName());
        MTMouse.setBGByRack(label, cage.getRoom(), colName, colouredColumns);
    }

    public static void writeRoom(MausoleumTableLabel label, Cage cage, String colName, HashSet colouredColumns) {
        Color c;
        Room room;
        label.setHorizontalAlignment(0);
        label.setText(cage.getSuperCageIfThere().getRoomName());
        if (colouredColumns.contains(colName) && (room = cage.getRoom()) != null && (c = (Color)StringHelper.getObjectForInt(room.getInt("ROM_SECURITY", 0), Room.SECURITY_INTS, Room.SECURITY_COLORS, null)) != null) {
            label.setBackground(c);
            label.setForeground(ColorManager.getForegroundColorForBackground(c));
        }
    }

    public void fillSortVector(Vector mses, String column, int pos) {
        block19: {
            block34: {
                block33: {
                    block32: {
                        block31: {
                            block30: {
                                block29: {
                                    block28: {
                                        block27: {
                                            block26: {
                                                block25: {
                                                    block24: {
                                                        block23: {
                                                            block22: {
                                                                block21: {
                                                                    block20: {
                                                                        block18: {
                                                                            if (!column.equals(STR_NUMBER)) break block18;
                                                                            if (DefaultManager.useCagePseudoIDs()) {
                                                                                MultiSortEntry.fillSortVector(mses, "CAG_PSEUDOID", pos);
                                                                            } else {
                                                                                MultiSortEntry.fillSortVector(mses, "IDO_ID", pos);
                                                                            }
                                                                            break block19;
                                                                        }
                                                                        if (!column.equals(STR_MICE)) break block20;
                                                                        Iterator iterator = mses.iterator();
                                                                        while (iterator.hasNext()) {
                                                                            MultiSortEntry mse = (MultiSortEntry)iterator.next();
                                                                            mse.ivVals[pos] = new Integer(((Cage)mse.ivObject).getNumberOfMice());
                                                                        }
                                                                        break block19;
                                                                    }
                                                                    if (!column.equals("RACK")) break block21;
                                                                    Iterator iterator = mses.iterator();
                                                                    while (iterator.hasNext()) {
                                                                        MultiSortEntry mse = (MultiSortEntry)iterator.next();
                                                                        mse.ivVals[pos] = ((Cage)mse.ivObject).getRackName();
                                                                    }
                                                                    break block19;
                                                                }
                                                                if (!column.equals("ROOM")) break block22;
                                                                Iterator iterator = mses.iterator();
                                                                while (iterator.hasNext()) {
                                                                    MultiSortEntry mse = (MultiSortEntry)iterator.next();
                                                                    mse.ivVals[pos] = ((Cage)mse.ivObject).getSuperCageIfThere().getRoomName();
                                                                }
                                                                break block19;
                                                            }
                                                            if (!"WEDDINGSHORT".equals(column) && !"WEDDING_EXT".equals(column)) break block23;
                                                            Iterator iterator = mses.iterator();
                                                            while (iterator.hasNext()) {
                                                                int daysSeparated;
                                                                MultiSortEntry mse = (MultiSortEntry)iterator.next();
                                                                Cage cage = (Cage)mse.ivObject;
                                                                Comparable<Integer> comparable = mse.ivVals[pos] = cage.isMatingCage() ? NULL_INT : null;
                                                                if (mse.ivVals[pos] != null || !"WEDDING_EXT".equals(column) || cage == null || (daysSeparated = Herzeloyde.getValueForCageOrMouse(cage.getActualMice())) == Integer.MIN_VALUE) continue;
                                                                mse.ivVals[pos] = new Integer(daysSeparated + 1);
                                                            }
                                                            break block19;
                                                        }
                                                        if (!column.equals(STR_LINES)) break block24;
                                                        Iterator iterator = mses.iterator();
                                                        while (iterator.hasNext()) {
                                                            MultiSortEntry mse = (MultiSortEntry)iterator.next();
                                                            Cage c = (Cage)mse.ivObject;
                                                            mse.ivVals[pos] = MultiSortEntry.getComp(AllgUtils.getTypeString(c, c.getActualMice(), 0, false));
                                                        }
                                                        break block19;
                                                    }
                                                    if (!column.equals(STR_STRAINS)) break block25;
                                                    Iterator iterator = mses.iterator();
                                                    while (iterator.hasNext()) {
                                                        MultiSortEntry mse = (MultiSortEntry)iterator.next();
                                                        Cage c = (Cage)mse.ivObject;
                                                        mse.ivVals[pos] = MultiSortEntry.getComp(AllgUtils.getTypeString(c, c.getActualMice(), 1, false));
                                                    }
                                                    break block19;
                                                }
                                                if (!column.equals(STR_GENOTYPES)) break block26;
                                                Iterator iterator = mses.iterator();
                                                while (iterator.hasNext()) {
                                                    MultiSortEntry mse = (MultiSortEntry)iterator.next();
                                                    Cage c = (Cage)mse.ivObject;
                                                    mse.ivVals[pos] = MultiSortEntry.getComp(AllgUtils.getTypeString(c, c.getActualMice(), 2, false));
                                                }
                                                break block19;
                                            }
                                            if (!column.equals(STR_COMMENT)) break block27;
                                            Iterator iterator = mses.iterator();
                                            while (iterator.hasNext()) {
                                                MultiSortEntry mse = (MultiSortEntry)iterator.next();
                                                Cage c = (Cage)mse.ivObject;
                                                mse.ivVals[pos] = MultiSortEntry.getComp(AllgUtils.getTypeString(c, c.getActualMice(), 3, false));
                                            }
                                            break block19;
                                        }
                                        if (!column.equals(STR_VISITS)) break block28;
                                        Iterator iterator = mses.iterator();
                                        while (iterator.hasNext()) {
                                            MultiSortEntry mse = (MultiSortEntry)iterator.next();
                                            Cage c = (Cage)mse.ivObject;
                                            Visit[] arr = (Visit[])c.get("CAG_VISIT");
                                            Comparable<Integer> comparable = mse.ivVals[pos] = arr != null ? new Integer(arr.length) : null;
                                        }
                                        break block19;
                                    }
                                    if (!column.equals(STR_FATHER)) break block29;
                                    Iterator iterator = mses.iterator();
                                    while (iterator.hasNext()) {
                                        MultiSortEntry mse = (MultiSortEntry)iterator.next();
                                        Cage c = (Cage)mse.ivObject;
                                        Comparable<Integer> comparable = mse.ivVals[pos] = c.ivFatherPresent ? EINS : null;
                                    }
                                    break block19;
                                }
                                if (!column.equals(STR_MOTHER)) break block30;
                                Iterator iterator = mses.iterator();
                                while (iterator.hasNext()) {
                                    MultiSortEntry mse = (MultiSortEntry)iterator.next();
                                    Cage c = (Cage)mse.ivObject;
                                    Comparable<Integer> comparable = mse.ivVals[pos] = c.ivMotherPresent ? EINS : null;
                                }
                                break block19;
                            }
                            if (!column.equals(STR_UNISEX)) break block31;
                            Iterator iterator = mses.iterator();
                            while (iterator.hasNext()) {
                                MultiSortEntry mse = (MultiSortEntry)iterator.next();
                                Cage c = (Cage)mse.ivObject;
                                Comparable<Integer> comparable = mse.ivVals[pos] = c.ivUniSex ? EINS : null;
                            }
                            break block19;
                        }
                        if (!column.equals(STR_PRIMARY_OWNER)) break block32;
                        Iterator iterator = mses.iterator();
                        while (iterator.hasNext()) {
                            MultiSortEntry mse = (MultiSortEntry)iterator.next();
                            Cage c = (Cage)mse.ivObject;
                            mse.ivVals[pos] = MultiSortEntry.getComp(c.getOwnerStringOslo("", ALL_ARE_OWNERS));
                        }
                        break block19;
                    }
                    if (!column.equals(STR_TASKS)) break block33;
                    Iterator iterator = mses.iterator();
                    while (iterator.hasNext()) {
                        MultiSortEntry mse = (MultiSortEntry)iterator.next();
                        Cage c = (Cage)mse.ivObject;
                        mse.ivVals[pos] = new Integer(c.getTaskCount());
                    }
                    break block19;
                }
                if (!column.equals("RACK_POS")) break block34;
                Iterator iterator = mses.iterator();
                while (iterator.hasNext()) {
                    MultiSortEntry mse = (MultiSortEntry)iterator.next();
                    Cage c = (Cage)mse.ivObject;
                    RackPos rp = c.getRackPos();
                    Comparable<Integer> comparable = mse.ivVals[pos] = rp != null ? new Integer(rp.getSortValue()) : null;
                }
                break block19;
            }
            if (!column.equals("RACK_AND_POS")) break block19;
            Iterator iterator = mses.iterator();
            while (iterator.hasNext()) {
                MultiSortEntry mse = (MultiSortEntry)iterator.next();
                Cage c = (Cage)mse.ivObject;
                RackPos rp = c.getRackPos();
                Comparable comparable = mse.ivVals[pos] = rp != null ? MultiSortEntry.getComp(String.valueOf(c.getRackName()) + rp.getSortValue()) : null;
            }
        }
    }
}

