/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.tables.models;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.ObjectStore;
import java.util.HashSet;
import java.util.Vector;
import mausoleum.cage.Cage;
import mausoleum.main.MausoleumClient;
import mausoleum.rack.Rack;
import mausoleum.rack.RackPos;
import mausoleum.rack.frame.RackFrame;
import mausoleum.rack.frame.RackOrcusField;
import mausoleum.tables.models.MTCage;

public abstract class MTCageInRackDisplay
extends MTCage {
    private final RackOrcusField ivOrcusField;

    public MTCageInRackDisplay(RackOrcusField orcus) {
        super(false);
        this.ivOrcusField = orcus;
    }

    public int[] getWidths() {
        return new int[]{20, 30, 25, 25, 160};
    }

    public String[] getDefaultColumnNames() {
        return new String[]{"MARKSHORT", "CAGENUMBER", "MICE", "WEDDINGSHORT", "LINES"};
    }

    public void handleNewObject(IDObject obj) {
        super.handleNewObject(obj);
        if (this.ivOrcusField != null) {
            this.ivOrcusField.setCages(this.ivObjects);
        }
    }

    public void sortObjectsByColumn(String colName) {
        super.sortObjectsByColumn(colName);
        if (this.ivOrcusField != null) {
            this.ivOrcusField.setCages(this.ivObjects);
        }
    }

    public void objectLeftServiceRoom(int objectTyp, String group, HashSet objectIDs) {
        super.objectLeftServiceRoom(objectTyp, group, objectIDs);
        if (this.ivOrcusField != null) {
            this.ivOrcusField.setCages(this.ivObjects);
        }
    }

    public void selectionChanged() {
        super.selectionChanged();
        RackFrame.getMouseTableModel().setCages(this.getSelectedObjects());
        RackFrame.getMouseTableModel().sortDefault();
        RackFrame.getParallelCageTableModel((MTCageInRackDisplay)this).ivSelectedRows.clear();
        RackFrame.getParallelCageTableModel(this).getJTable().repaint();
        RackFrame.getInstance().selectCages(this.getSelectedObjects(), 1);
        this.getJTable().repaint();
    }

    public void rackChanged() {
        this.setOrigObjectsAgain();
        this.sortDefault();
    }

    public void setTable(Vector v) {
        super.setTable(v);
        if (this.ivOrcusField != null) {
            this.ivOrcusField.setCages(this.ivObjects);
        }
    }

    public void handleReplObjectInSubdisplay(IDObject obi, Vector list, boolean matchFilter) {
        if (matchFilter) {
            list.addElement(obi);
            if (this.ivOrcusField != null) {
                this.ivOrcusField.setCages(this.ivObjects);
            }
        }
    }

    public void handleDeadObjectInSubdisplay(IDObject obi, Vector list, int ind) {
        list.removeElementAt(ind);
        if (this.ivOrcusField != null) {
            this.ivOrcusField.setCages(this.ivObjects);
        }
    }

    public boolean filterObject(Object ooo) {
        if (ooo instanceof Cage) {
            Cage cage = (Cage)ooo;
            return this.filterByDoubleCage(cage) && (this.ivOrcusField != null ? this.filterByOrcus(cage) : this.filterByRackID(cage)) && this.filterByOwner(cage);
        }
        return false;
    }

    private boolean filterByRackID(Cage cage) {
        long rackID = RackFrame.getRackID();
        if (rackID == -1L) {
            return false;
        }
        Cage cfc = cage.getSuperCageIfThere();
        RackPos rp = (RackPos)cfc.get("CAG_POS");
        if (rp != null) {
            if (MausoleumClient.isServiceCaretaker()) {
                Rack rack = (Rack)ObjectStore.getClientObject(3, rp.ivRackID, cfc.getGroup());
                if (rack != null && rack.isSharedWithOtherGroups()) {
                    return rack.getLong("IDO_SERVID", 0L) == rackID;
                }
            } else {
                return rp.ivRackID == rackID;
            }
        }
        return false;
    }

    private boolean filterByOrcus(Cage cage) {
        return cage.getSuperCageIfThere().get("CAG_POS") == null;
    }
}

