/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.tables.models;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.user.Privileges;
import de.hannse.netobjects.util.Babel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.cage.Cage;
import mausoleum.inspector.InspectorPanel;
import mausoleum.inspector.util.InspectorCommandSender;
import mausoleum.mouse.WeaningControl;
import mausoleum.tables.models.MTCage;
import mausoleum.tables.util.MTPUItem;
import mausoleum.tables.util.MTPopupHelper;

public class MTCageWeaning
extends MTCage {
    private static MTPUItem MARK_AS_WEANED_ITEM = new MTPUItem("MARK_AS_WEANED", new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            HashMap obsByGroup;
            Vector mice = new Vector();
            Vector cages = MTPopupHelper.getSelectedObjects(e);
            long jetzt = System.currentTimeMillis();
            Vector tempTarget = new Vector();
            Iterator iter = cages.iterator();
            while (iter.hasNext()) {
                Cage cage = (Cage)iter.next();
                WeaningControl.isWeaningNecessary(cage, jetzt, mice, tempTarget);
            }
            tempTarget.clear();
            tempTarget = null;
            if (!mice.isEmpty() && (obsByGroup = IDObject.sortByGroup(mice)) != null) {
                Iterator iter2 = obsByGroup.keySet().iterator();
                while (iter2.hasNext()) {
                    String group = (String)iter2.next();
                    Vector obs = (Vector)obsByGroup.get(group);
                    StringBuffer csb = new StringBuffer();
                    InspectorPanel.makeCommand("MMARKABGESETZT", null, 1, csb, obs);
                    InspectorCommandSender.executeCommand(csb.toString(), group);
                }
            }
        }
    }, null);

    public String getDisplayName() {
        return Babel.get("TDN_CAGE_WEANING");
    }

    public void handleNewObject(IDObject object) {
        if (object instanceof Cage) {
            Cage cage = (Cage)object;
            if (this.isIDObjectContainedInOriginals(cage)) {
                Vector<IDObject> v = new Vector<IDObject>();
                if (!WeaningControl.isWeaningNecessary(cage, System.currentTimeMillis(), null, v)) {
                    long cid = cage.getID();
                    v.clear();
                    Iterator iter = this.ivOriginalObjects.iterator();
                    while (iter.hasNext()) {
                        IDObject iob = (IDObject)iter.next();
                        if (iob.getID() == cid) continue;
                        v.add(iob);
                    }
                    this.setTable(v);
                }
            } else {
                Vector<Cage> v = new Vector<Cage>();
                if (WeaningControl.isWeaningNecessary(cage, System.currentTimeMillis(), null, v)) {
                    v.clear();
                    this.addOriginalObjects(v);
                    v.add(cage);
                    this.setTable(v);
                }
            }
        }
        super.handleNewObject(object);
    }

    public Vector getAdditionalPopupItems(Vector selectedObjects) {
        Vector sv;
        Vector res = null;
        if (Privileges.hasPrivilege("MARK_AS_WEANED") && selectedObjects != null && !selectedObjects.isEmpty()) {
            res = new Vector();
            MARK_AS_WEANED_ITEM.add(selectedObjects, res);
        }
        if ((sv = super.getAdditionalPopupItems(selectedObjects)) == null) {
            return res;
        }
        if (res != null) {
            sv.addAll(res);
        }
        return sv;
    }
}

