/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.tables.models;

import de.hannse.netobjects.objectstore.ObjectManager;
import de.hannse.netobjects.util.Babel;
import java.awt.Color;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.gui.MausoleumTableLabel;
import mausoleum.helper.DatumFormat;
import mausoleum.license.License;
import mausoleum.license.LicenseManager;
import mausoleum.main.MausoleumClient;
import mausoleum.tables.MausoleumTableModel;
import mausoleum.tables.sorting.MultiSortEntry;

public class MTLicense
extends MausoleumTableModel {
    public static final String STR_NAME = "LIC_NAME";
    public static final String STR_HOLDER = "LIC_HOLDER";
    public static final String STR_STARTDATE = "LIC_STARTDATE";
    public static final String STR_ENDDATE = "LIC_ENDDATE";
    public static final String STR_MOUSECOUNT = "LIC_MOUSECOUNT";
    public static final String STR_USERS = "LIC_USERS";
    public static final String STR_COMMENT = "LIC_COMMENT";
    public static final String STR_COLOR = "LIC_COLOR";
    public static final String STR_TYPE = "LIC_LICENSE_TYPE";
    public static final String STR_SUBTYPE = "LIC_LICENSE_SUBTYPE";
    public static final String STR_GROUPS = "GROUPS";
    private static final String[] TT_DICT = new String[]{"LIC_NAME", "LIC_TT_NAME", "LIC_HOLDER", "LIC_TT_HOLDER", "LIC_STARTDATE", "LIC_TT_STARTDATE", "LIC_ENDDATE", "LIC_TT_ENDDATE", "LIC_MOUSECOUNT", "LIC_TT_MOUSECOUNT", "LIC_USERS", "LIC_TT_USERS", "LIC_COMMENT", "LIC_TT_COMMENT", "LIC_COLOR", "LIC_TT_COLOR", "GROUPS", "MTLIC_TT_GROUPS", "LIC_LICENSE_TYPE", "MTLIC_TT_TYPE", "LIC_LICENSE_SUBTYPE", "MTLIC_TT_SUBTYPE"};
    private static final String[] POSSIBLES = new String[]{"LIC_NAME", "LIC_HOLDER", "LIC_STARTDATE", "LIC_ENDDATE", "LIC_MOUSECOUNT", "LIC_USERS", "LIC_COMMENT", "LIC_COLOR", "LIC_LICENSE_TYPE", "LIC_LICENSE_SUBTYPE"};
    private static final String[] POSSIBLES_HEAD_OF_SERVICE = new String[]{"LIC_NAME", "LIC_HOLDER", "LIC_STARTDATE", "LIC_ENDDATE", "LIC_MOUSECOUNT", "LIC_USERS", "LIC_COMMENT", "LIC_COLOR", "LIC_LICENSE_TYPE", "LIC_LICENSE_SUBTYPE", "GROUPS"};
    private static final String[] SORTABLES = new String[]{"LIC_NAME", "LIC_HOLDER", "LIC_STARTDATE", "LIC_ENDDATE", "LIC_MOUSECOUNT", "LIC_USERS", "LIC_COMMENT", "LIC_COLOR", "LIC_LICENSE_TYPE", "LIC_LICENSE_SUBTYPE", "GROUPS"};
    private static final String[] EDITABLES = new String[0];
    private static final String[] FILTERABLES = new String[0];
    private static final String[] COLORABLES = new String[0];
    private static final HashMap PLAIN_SORTINGS = new HashMap(GENERAL_PLAIN_SORTINGS);
    static /* synthetic */ Class class$0;

    static {
        PLAIN_SORTINGS.put(STR_NAME, STR_NAME);
        PLAIN_SORTINGS.put(STR_HOLDER, "LIC_LH");
        PLAIN_SORTINGS.put(STR_STARTDATE, "LIC_SD");
        PLAIN_SORTINGS.put(STR_ENDDATE, "LIC_ED");
        PLAIN_SORTINGS.put(STR_MOUSECOUNT, "LIC_MMC");
        PLAIN_SORTINGS.put(STR_COMMENT, "LIC_CO");
        PLAIN_SORTINGS.put(STR_COLOR, "LIC_COL");
    }

    public MausoleumTableModel getDefaultModel() {
        return new MTLicense();
    }

    public int getTableType() {
        return 4;
    }

    public boolean ichWillEinenSichtbarkeitsKnopf() {
        return true;
    }

    public boolean ichWillFactSheets() {
        return true;
    }

    public String getDisplayName() {
        return Babel.get("TDN_LICENSE");
    }

    public ActionListener getActionListenerForColumn(String colName) {
        return null;
    }

    public int[] getConsumertypes() {
        return new int[]{16};
    }

    public String[] getPossibleColumns() {
        return MausoleumClient.isHeadOfService() ? POSSIBLES_HEAD_OF_SERVICE : POSSIBLES;
    }

    public String[] getSortableColumns() {
        return SORTABLES;
    }

    public String[] getEditableColumns() {
        return EDITABLES;
    }

    public String[] getFilterableCols() {
        return FILTERABLES;
    }

    public HashMap getPlainSortings() {
        return PLAIN_SORTINGS;
    }

    public String[] getColorableColumns() {
        return COLORABLES;
    }

    public String[] getDefaultColorableColumns() {
        return new String[0];
    }

    public String getDefaultSortColumn() {
        return STR_NAME;
    }

    public int[] getWidths() {
        return new int[]{30, 100, 80, 80, 40, 40};
    }

    public String[] getDefaultColumnNames() {
        String[] stringArray;
        if (MausoleumClient.isHeadOfService()) {
            String[] stringArray2 = new String[6];
            stringArray2[0] = STR_COLOR;
            stringArray2[1] = STR_NAME;
            stringArray2[2] = STR_STARTDATE;
            stringArray2[3] = STR_ENDDATE;
            stringArray2[4] = STR_MOUSECOUNT;
            stringArray = stringArray2;
            stringArray2[5] = STR_GROUPS;
        } else {
            String[] stringArray3 = new String[5];
            stringArray3[0] = STR_COLOR;
            stringArray3[1] = STR_NAME;
            stringArray3[2] = STR_STARTDATE;
            stringArray3[3] = STR_ENDDATE;
            stringArray = stringArray3;
            stringArray3[4] = STR_MOUSECOUNT;
        }
        return stringArray;
    }

    public String[] getTooltipDict() {
        return TT_DICT;
    }

    public Class getServedClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("mausoleum.license.License");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public ObjectManager getManager() {
        return LicenseManager.cvInstance;
    }

    public void writeTheCodedElement(MausoleumTableLabel label, Object obj, String column, boolean isForFilterSplit) {
        License license = (License)obj;
        if (column.equals(STR_NAME)) {
            label.setText(license.getBrowseNameInclServicePrefix());
        } else if (column.equals(STR_HOLDER)) {
            label.setText(license.getString("LIC_LH", ""));
        } else if (column.equals(STR_STARTDATE)) {
            int d = license.getInt("LIC_SD", Integer.MIN_VALUE);
            if (d != Integer.MIN_VALUE) {
                label.setHorizontalAlignment(0);
                label.setText(DatumFormat.getJustDateString(d));
            }
        } else if (column.equals(STR_ENDDATE)) {
            int d = license.getInt("LIC_ED", Integer.MIN_VALUE);
            if (d != Integer.MIN_VALUE) {
                label.setHorizontalAlignment(0);
                label.setText(DatumFormat.getJustDateString(d));
            }
        } else if (column.equals(STR_MOUSECOUNT)) {
            this.handleCount(license, "LIC_MMC", label);
        } else if (column.equals(STR_COMMENT)) {
            label.setHorizontalAlignment(2);
            label.setText(license.getString("LIC_CO", ""));
        } else if (column.equals(STR_USERS)) {
            label.setText(license.getUserNames());
        } else if (column.equals(STR_COLOR)) {
            Color col = (Color)license.get("LIC_COL");
            if (col != null) {
                label.setBackground(col);
            }
        } else if (column.equals(STR_GROUPS)) {
            label.setText(license.getSharedGroupNames());
        } else if (column.equals(STR_TYPE)) {
            label.setHorizontalAlignment(0);
            label.setText(license.isLineLicense() ? Babel.get("LIC_LINE_LICENSE") : Babel.get("LIC_MOUSE_LICENSE"));
        } else if (column.equals(STR_SUBTYPE)) {
            label.setHorizontalAlignment(0);
            label.setText(license.getSubtypeLabel());
        } else {
            super.writeGeneralElement(label, obj, column, isForFilterSplit);
        }
    }

    private void handleCount(License license, String tag, MausoleumTableLabel label) {
        int anz = license.getInt(tag, -1);
        if (anz != -1) {
            label.setHorizontalAlignment(4);
            label.setText(Integer.toString(anz));
        }
    }

    public void fillSortVector(Vector mses, String column, int pos) {
        if (column.equals(STR_USERS)) {
            Iterator iterator = mses.iterator();
            while (iterator.hasNext()) {
                MultiSortEntry mse = (MultiSortEntry)iterator.next();
                License lic = (License)mse.ivObject;
                mse.ivVals[pos] = MultiSortEntry.getComp(lic.getUserNames());
            }
        } else if (column.equals(STR_TYPE)) {
            Iterator iterator = mses.iterator();
            while (iterator.hasNext()) {
                MultiSortEntry mse = (MultiSortEntry)iterator.next();
                License lic = (License)mse.ivObject;
                mse.ivVals[pos] = new Boolean(lic.isLineLicense());
            }
        } else if (column.equals(STR_SUBTYPE)) {
            Iterator iterator = mses.iterator();
            while (iterator.hasNext()) {
                MultiSortEntry mse = (MultiSortEntry)iterator.next();
                License lic = (License)mse.ivObject;
                Integer subtype = (Integer)lic.get("IDO_SUBTYP");
                Comparable<Integer> comparable = mse.ivVals[pos] = subtype == null ? new Integer(0) : subtype;
            }
        } else if (column.equals(STR_GROUPS)) {
            this.sortBySharedGroups(mses, pos);
        }
    }
}

