/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.tables.models;

import de.hannse.netobjects.objectstore.ObjectManager;
import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.util.ArrayHelper;
import de.hannse.netobjects.util.Babel;
import java.awt.Color;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.gui.ColorManager;
import mausoleum.gui.MausoleumTableLabel;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.InspectorPanelLine;
import mausoleum.license.License;
import mausoleum.line.Line;
import mausoleum.line.LineManager;
import mausoleum.main.MausoleumClient;
import mausoleum.mouse.tierschutz.Stress;
import mausoleum.mouse.tierschutz.StressRule;
import mausoleum.mouse.tierschutz.TierSchutz;
import mausoleum.tables.MausoleumTableModel;
import mausoleum.tables.sorting.MultiSortEntry;

public class MTLine
extends MausoleumTableModel {
    public static final String STR_NAME = "NAME";
    public static final String STR_COL = "COLOR";
    public static final String STR_MATLIM = "MATLIM";
    public static final String STR_ANTAG = "ANTAG";
    public static final String STR_PREFIX = "PREFIX";
    public static final String STR_GROUPS = "GROUPS";
    public static final String STR_LOCI_GT = "LOCI_GT";
    public static final String STR_STRESS_MIN = "LINE_MINIMAL_STRESS_LEVEL";
    public static final String STR_STRESS_MAX = "LINE_MAXIMAL_STRESS_LEVEL";
    public static final String STR_LICENSE = "LICENSE";
    public static final String STR_EVALUATION = "TS_LINE_UNDER_EVALUATION";
    private static final String[] TT_DICT = new String[]{"NAME", "MTL_TT_NAME", "COLOR", "MTL_TT_COLORSHORT", "MATLIM", "MTM_TT_MATLIM", "ANTAG", "MTM_TT_ANTAG", "PREFIX", "MTL_TT_PREFIX", "GROUPS", "MTLIN_TT_GROUPS", "LINE_MINIMAL_STRESS_LEVEL", "MTL_TT_STRESS_MIN", "LINE_MAXIMAL_STRESS_LEVEL", "MTL_TT_STRESS_MAX", "LICENSE", "MTL_TT_LIC", "TS_LINE_UNDER_EVALUATION", "MTL_TT_EAVLUATION", "LOCI_GT", "MTL_LOCI_GT"};
    private static final String[] POSSIBLES = new String[]{"NAME", "COLOR", "MATLIM", "ANTAG", "PREFIX", "LINE_MINIMAL_STRESS_LEVEL", "LINE_MAXIMAL_STRESS_LEVEL", "LICENSE", "TS_LINE_UNDER_EVALUATION", "LOCI_GT"};
    private static final String[] POSSIBLES_HEAD_OF_SERVICE = new String[]{"NAME", "COLOR", "MATLIM", "ANTAG", "PREFIX", "GROUPS", "LINE_MINIMAL_STRESS_LEVEL", "LINE_MAXIMAL_STRESS_LEVEL", "TS_LINE_UNDER_EVALUATION"};
    private static final String[] SORTABLES = new String[]{"NAME", "COLOR", "MATLIM", "ANTAG", "PREFIX", "GROUPS", "LINE_MINIMAL_STRESS_LEVEL", "LINE_MAXIMAL_STRESS_LEVEL", "LICENSE", "TS_LINE_UNDER_EVALUATION", "LOCI_GT"};
    private static final String[] EDITABLES = new String[]{"NAME", "COLOR", "MATLIM", "ANTAG", "PREFIX", "LINE_MINIMAL_STRESS_LEVEL", "LICENSE", "TS_LINE_UNDER_EVALUATION"};
    private static final String[] FILTERABLES = new String[]{"MATLIM", "ANTAG", "PREFIX", "LINE_MINIMAL_STRESS_LEVEL", "LINE_MAXIMAL_STRESS_LEVEL", "TS_LINE_UNDER_EVALUATION"};
    private static final String[] COLORABLES = new String[]{"LINE_MINIMAL_STRESS_LEVEL", "LINE_MAXIMAL_STRESS_LEVEL", "LICENSE"};
    private static final HashMap PLAIN_SORTINGS = new HashMap(GENERAL_PLAIN_SORTINGS);
    private static final String[] UNWANTED_WITHOUT_STRESS = new String[]{"LINE_MINIMAL_STRESS_LEVEL", "LINE_MAXIMAL_STRESS_LEVEL"};
    private static final String[] UNWANTED_WITHOUT_EVALUATION = new String[]{"TS_LINE_UNDER_EVALUATION"};
    static /* synthetic */ Class class$0;

    static {
        PLAIN_SORTINGS.put(STR_COL, "LIN_COLOR");
        PLAIN_SORTINGS.put(STR_MATLIM, "LIN_MATLIM");
        PLAIN_SORTINGS.put(STR_ANTAG, "LIN_TAG");
        PLAIN_SORTINGS.put(STR_PREFIX, "LIN_ETPREFIX");
        PLAIN_SORTINGS.put(STR_NAME, "LIN_NAME");
    }

    public MausoleumTableModel getDefaultModel() {
        return new MTLine();
    }

    public int getTableType() {
        return 5;
    }

    public boolean ichWillEinenSichtbarkeitsKnopf() {
        return true;
    }

    public boolean ichWillFactSheets() {
        return true;
    }

    public String getDisplayName() {
        return Babel.get("TDN_LINE");
    }

    public String[] checkColumns(String[] arr) {
        int i;
        if (arr != null && arr.length != 0 && !TierSchutz.belastungNeeded()) {
            i = 0;
            while (i < UNWANTED_WITHOUT_STRESS.length) {
                arr = ArrayHelper.getArrayWithout(arr, UNWANTED_WITHOUT_STRESS[i]);
                ++i;
            }
        }
        if (arr != null && arr.length != 0 && !TierSchutz.isLineEvaluationPossible()) {
            i = 0;
            while (i < UNWANTED_WITHOUT_EVALUATION.length) {
                arr = ArrayHelper.getArrayWithout(arr, UNWANTED_WITHOUT_EVALUATION[i]);
                ++i;
            }
        }
        return arr;
    }

    public ActionListener getActionListenerForColumn(String colName) {
        if (colName.equals(STR_NAME)) {
            return ((InspectorPanelLine)Inspector.cvActPanel).ivNameField;
        }
        if (colName.equals(STR_COL)) {
            return ((InspectorPanelLine)Inspector.cvActPanel).ivColorButton;
        }
        if (colName.equals(STR_MATLIM)) {
            return ((InspectorPanelLine)Inspector.cvActPanel).ivMatLimButton;
        }
        if (colName.equals(STR_ANTAG)) {
            return ((InspectorPanelLine)Inspector.cvActPanel).ivANTagButton;
        }
        if (colName.equals(STR_PREFIX)) {
            return ((InspectorPanelLine)Inspector.cvActPanel).ivPrefixButton;
        }
        if (colName.equals(STR_STRESS_MIN)) {
            return ((InspectorPanelLine)Inspector.cvActPanel).ivMinStressLevel;
        }
        if (colName.equals(STR_LICENSE)) {
            return ((InspectorPanelLine)Inspector.cvActPanel).ivCSLicense;
        }
        if (colName.equals(STR_EVALUATION)) {
            return ((InspectorPanelLine)Inspector.cvActPanel).ivLineEvaluation;
        }
        return null;
    }

    public int[] getConsumertypes() {
        return new int[]{7, 16};
    }

    public String[] getPossibleColumns() {
        return MausoleumClient.isHeadOfService() ? POSSIBLES_HEAD_OF_SERVICE : POSSIBLES;
    }

    public String[] getSortableColumns() {
        return SORTABLES;
    }

    public String[] getEditableColumns() {
        return EDITABLES;
    }

    public String[] getFilterableCols() {
        return FILTERABLES;
    }

    public HashMap getPlainSortings() {
        return PLAIN_SORTINGS;
    }

    public String[] getColorableColumns() {
        return COLORABLES;
    }

    public String[] getDefaultColorableColumns() {
        return new String[0];
    }

    public String getDefaultSortColumn() {
        return STR_NAME;
    }

    public int[] getWidths() {
        return new int[]{20, 150};
    }

    public String[] getDefaultColumnNames() {
        String[] stringArray;
        if (MausoleumClient.isHeadOfService()) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = STR_COL;
            stringArray2[1] = STR_NAME;
            stringArray = stringArray2;
            stringArray2[2] = STR_GROUPS;
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = STR_COL;
            stringArray = stringArray3;
            stringArray3[1] = STR_NAME;
        }
        return stringArray;
    }

    public String[] getTooltipDict() {
        return TT_DICT;
    }

    public Class getServedClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("mausoleum.line.Line");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public ObjectManager getManager() {
        return LineManager.cvInstance;
    }

    public void writeTheCodedElement(MausoleumTableLabel label, Object obj, String colName, boolean isForFilterSplit) {
        Line line = (Line)obj;
        if (colName.equals(STR_NAME)) {
            label.setText(line.getBrowseNameInclServicePrefix());
        } else if (colName.equals(STR_COL)) {
            Color col = (Color)line.get("LIN_COLOR");
            if (col != null) {
                label.setBackground(col);
            }
        } else if (colName.equals(STR_MATLIM)) {
            Integer ml = (Integer)line.get("LIN_MATLIM");
            label.setText(ml != null ? ml.toString() : "");
        } else if (colName.equals(STR_ANTAG)) {
            label.setText(line.getString("LIN_TAG", ""));
        } else if (colName.equals(STR_PREFIX)) {
            label.setText(line.getString("LIN_ETPREFIX", ""));
        } else if (colName.equals(STR_GROUPS)) {
            label.setText(line.getSharedGroupNames());
        } else if (colName.equals(STR_STRESS_MIN)) {
            this.handleStress(line, false, label, colName, isForFilterSplit);
        } else if (colName.equals(STR_STRESS_MAX)) {
            this.handleStress(line, true, label, colName, isForFilterSplit);
        } else if (colName.equals(STR_LICENSE)) {
            License lic = (License)ObjectStore.getObjectDeadOrAlive(16, line.getLong("LIN_LIC", 0L), line.getGroup(), null, false);
            if (lic != null) {
                Color c;
                label.setText(lic.getBrowseNameInclServicePrefix());
                if (this.ivColouredColumns.contains(colName) && (c = (Color)lic.get("LIC_COL")) != null) {
                    label.setOpaque(true);
                    label.setBackground(c);
                    label.setForeground(ColorManager.getForegroundColorForBackground(c));
                }
            }
        } else if (colName.equals(STR_EVALUATION)) {
            int evaluationType;
            if (TierSchutz.isLineEvaluationPossible() && (evaluationType = line.getInt("LIN_EVAL", -1)) > 0) {
                label.setText(TierSchutz.getEvaluationDescr(evaluationType));
            }
        } else if (colName.equals(STR_LOCI_GT)) {
            label.setText(line.getTableLocusString());
        } else {
            super.writeGeneralElement(label, obj, colName, isForFilterSplit);
        }
    }

    private void handleStress(Line line, boolean withRules, MausoleumTableLabel label, String colName, boolean isForFilterSplit) {
        if (TierSchutz.belastungNeeded()) {
            StringBuilder msb = new StringBuilder();
            int defLevel = line.getMaxStressLevel(withRules, -1);
            if (defLevel != -1) {
                msb.append(StringHelper.getStringForInt(defLevel, Stress.STRESS_INTS, Stress.STRESS_BABELS, true, ""));
            }
            if (isForFilterSplit) {
                label.setText(msb.toString());
            } else {
                Color c;
                StressRule[] rules = (StressRule[])line.get("LIN_STRRUL");
                if (rules != null && rules.length != 0) {
                    if (msb.length() != 0) {
                        msb.append(" ");
                    }
                    msb.append("[").append(rules.length).append("]");
                }
                if (this.ivColouredColumns.contains(colName) && (c = Stress.getColor(defLevel)) != null) {
                    label.setBackground(c);
                    label.setForeground(ColorManager.getForegroundColorForBackground(c));
                }
                label.setText(msb.toString());
            }
        }
    }

    public void fillSortVector(Vector mses, String column, int pos) {
        block6: {
            block10: {
                block9: {
                    block8: {
                        block7: {
                            block5: {
                                if (!column.equals(STR_GROUPS)) break block5;
                                this.sortBySharedGroups(mses, pos);
                                break block6;
                            }
                            if (!column.equals(STR_STRESS_MIN)) break block7;
                            Iterator iterator = mses.iterator();
                            while (iterator.hasNext()) {
                                MultiSortEntry mse = (MultiSortEntry)iterator.next();
                                Line line = (Line)mse.ivObject;
                                int defLevel = line.getMaxStressLevel(false, -1);
                                Comparable<Integer> comparable = defLevel != -1 ? new Integer(defLevel) : (mse.ivVals[pos] = line.get("LIN_STRRUL") != null ? new Integer(0) : null);
                            }
                            break block6;
                        }
                        if (!column.equals(STR_STRESS_MAX)) break block8;
                        Iterator iterator = mses.iterator();
                        while (iterator.hasNext()) {
                            MultiSortEntry mse = (MultiSortEntry)iterator.next();
                            Line line = (Line)mse.ivObject;
                            int defLevel = line.getMaxStressLevel(true, -1);
                            Comparable<Integer> comparable = defLevel != -1 ? new Integer(defLevel) : (mse.ivVals[pos] = line.get("LIN_STRRUL") != null ? new Integer(0) : null);
                        }
                        break block6;
                    }
                    if (!column.equals(STR_LICENSE)) break block9;
                    Iterator iterator = mses.iterator();
                    while (iterator.hasNext()) {
                        MultiSortEntry mse = (MultiSortEntry)iterator.next();
                        Line line = (Line)mse.ivObject;
                        License lic = (License)ObjectStore.getObjectDeadOrAlive(16, line.getLong("LIN_LIC", 0L), line.getGroup(), null, false);
                        Object object = mse.ivVals[pos] = lic != null ? lic.getBrowseName() : null;
                    }
                    break block6;
                }
                if (!column.equals(STR_EVALUATION)) break block10;
                Iterator iterator = mses.iterator();
                while (iterator.hasNext()) {
                    MultiSortEntry mse = (MultiSortEntry)iterator.next();
                    Line line = (Line)mse.ivObject;
                    int evaluationType = line.getInt("LIN_EVAL", -1);
                    Comparable<Integer> comparable = mse.ivVals[pos] = evaluationType != -1 ? new Integer(evaluationType) : null;
                }
                break block6;
            }
            if (!STR_LOCI_GT.equals(column)) break block6;
            Iterator iterator = mses.iterator();
            while (iterator.hasNext()) {
                MultiSortEntry mse = (MultiSortEntry)iterator.next();
                Line line = (Line)mse.ivObject;
                mse.ivVals[pos] = line.getTableLocusString();
            }
        }
    }
}

