/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.tables.models;

import de.hannse.netobjects.objectstore.ObjectManager;
import de.hannse.netobjects.util.Babel;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.gui.MausoleumTableLabel;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.InspectorPanelLocus;
import mausoleum.locus.Locus;
import mausoleum.locus.LocusManager;
import mausoleum.main.MausoleumClient;
import mausoleum.tables.MausoleumTableModel;
import mausoleum.tables.sorting.MultiSortEntry;

public class MTLocus
extends MausoleumTableModel {
    public static final String STR_NAME = "NAME";
    public static final String STR_WILDTYPE = "WILDTYPE";
    public static final String STR_AUTOSOMAL = "AUTO";
    public static final String STR_ALLELES = "ALLELES";
    public static final String STR_GROUPS = "GROUPS";
    private static final String[] TT_DICT = new String[]{"NAME", "MTLOC_TT_NAME", "WILDTYPE", "MTLOC_TT_TYPE", "AUTO", "MTLOC_TT_AUTOSOMAL", "ALLELES", "MTLOC_TT_ALLELES", "GROUPS", "MTLOC_TT_GROUPS"};
    private static final String[] POSSIBLES = new String[]{"NAME", "WILDTYPE", "AUTO", "ALLELES"};
    private static final String[] POSSIBLES_HEAD_OF_SERVICE = new String[]{"NAME", "WILDTYPE", "AUTO", "ALLELES", "GROUPS"};
    private static final String[] SORTABLES = new String[]{"NAME", "WILDTYPE", "AUTO", "ALLELES", "GROUPS"};
    private static final String[] EDITABLES = new String[]{"NAME"};
    private static final String[] COLORABLES = new String[0];
    private static final String[] FILTERABLES = new String[]{"WILDTYPE", "AUTO"};
    private static final HashMap PLAIN_SORTINGS = new HashMap(GENERAL_PLAIN_SORTINGS);
    static /* synthetic */ Class class$0;

    static {
        PLAIN_SORTINGS.put(STR_NAME, "LOC_NAME");
        PLAIN_SORTINGS.put(STR_WILDTYPE, "LOC_WT_ALLEL");
    }

    public MausoleumTableModel getDefaultModel() {
        return new MTLocus();
    }

    public int getTableType() {
        return 6;
    }

    public boolean ichWillEinenSichtbarkeitsKnopf() {
        return true;
    }

    public boolean ichWillFactSheets() {
        return true;
    }

    public String getDisplayName() {
        return Babel.get("TDN_LOCUS");
    }

    public ActionListener getActionListenerForColumn(String colName) {
        if (colName.equals(STR_NAME) && Inspector.cvActPanel != null && Inspector.cvActPanel instanceof InspectorPanelLocus) {
            return ((InspectorPanelLocus)Inspector.cvActPanel).ivNameField;
        }
        return null;
    }

    public int[] getConsumertypes() {
        return new int[]{14};
    }

    public String[] getPossibleColumns() {
        return MausoleumClient.isHeadOfService() ? POSSIBLES_HEAD_OF_SERVICE : POSSIBLES;
    }

    public String[] getSortableColumns() {
        return SORTABLES;
    }

    public String[] getEditableColumns() {
        return EDITABLES;
    }

    public String[] getColorableColumns() {
        return COLORABLES;
    }

    public String[] getDefaultColorableColumns() {
        return new String[0];
    }

    public String getDefaultSortColumn() {
        return STR_NAME;
    }

    public String[] getFilterableCols() {
        return FILTERABLES;
    }

    public HashMap getPlainSortings() {
        return PLAIN_SORTINGS;
    }

    public int[] getWidths() {
        return new int[]{120, 50, 50, 50};
    }

    public String[] getDefaultColumnNames() {
        String[] stringArray;
        if (MausoleumClient.isHeadOfService()) {
            String[] stringArray2 = new String[4];
            stringArray2[0] = STR_NAME;
            stringArray2[1] = STR_WILDTYPE;
            stringArray2[2] = STR_ALLELES;
            stringArray = stringArray2;
            stringArray2[3] = STR_GROUPS;
        } else {
            String[] stringArray3 = new String[4];
            stringArray3[0] = STR_NAME;
            stringArray3[1] = STR_WILDTYPE;
            stringArray3[2] = STR_AUTOSOMAL;
            stringArray = stringArray3;
            stringArray3[3] = STR_ALLELES;
        }
        return stringArray;
    }

    public String[] getTooltipDict() {
        return TT_DICT;
    }

    public Class getServedClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("mausoleum.locus.Locus");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public ObjectManager getManager() {
        return LocusManager.cvInstance;
    }

    public void writeTheCodedElement(MausoleumTableLabel label, Object obj, String colName, boolean isForFilterSplit) {
        Locus locus = (Locus)obj;
        if (colName.equals(STR_NAME)) {
            String name = locus.getBrowseName();
            if (name == null) {
                label.setText(Babel.get("UNKNOWN"));
            } else if (locus.isSharedWithOtherGroups()) {
                name = "[S] " + name;
            }
            label.setText(name);
        } else if (colName.equals(STR_WILDTYPE)) {
            String wtAllel = locus.getString("LOC_WT_ALLEL");
            if (wtAllel == null) {
                label.setText("");
            } else {
                label.setText(locus.getAlias(wtAllel));
            }
            label.setHorizontalAlignment(0);
        } else if (colName.equals(STR_AUTOSOMAL)) {
            if (locus.isAutosomal()) {
                label.setText("\u2713");
            } else {
                label.setText("");
            }
            label.setHorizontalAlignment(0);
        } else if (colName.equals(STR_ALLELES)) {
            int anzAlleles = 0;
            String[] alleles = (String[])locus.get("LOC_ALLELES");
            if (alleles != null) {
                anzAlleles = alleles.length;
            }
            label.setText(Integer.toString(anzAlleles));
        } else if (colName.equals(STR_GROUPS)) {
            label.setText(locus.getSharedGroupNames());
        } else {
            super.writeGeneralElement(label, obj, colName, isForFilterSplit);
        }
    }

    public void fillSortVector(Vector mses, String column, int pos) {
        if (column.equals(STR_AUTOSOMAL)) {
            Iterator iterator = mses.iterator();
            while (iterator.hasNext()) {
                MultiSortEntry mse = (MultiSortEntry)iterator.next();
                Locus locus = (Locus)mse.ivObject;
                Comparable<Integer> comparable = mse.ivVals[pos] = locus.isAutosomal() ? EINS : null;
            }
        } else if (column.equals(STR_ALLELES)) {
            Iterator iterator = mses.iterator();
            while (iterator.hasNext()) {
                MultiSortEntry mse = (MultiSortEntry)iterator.next();
                Locus locus = (Locus)mse.ivObject;
                String[] alleles = (String[])locus.get("LOC_ALLELES");
                Comparable<Integer> comparable = mse.ivVals[pos] = alleles != null ? new Integer(alleles.length) : null;
            }
        } else if (column.equals(STR_GROUPS)) {
            this.sortBySharedGroups(mses, pos);
        }
    }
}

