/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.tables.models;

import de.hannse.netobjects.util.Babel;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.cage.Cage;
import mausoleum.mouse.Mouse;
import mausoleum.tables.models.MTMouse;

public class MTMouseInRackDisplay
extends MTMouse {
    private final HashSet ivCageIDsOnDisplay = new HashSet();

    public MTMouseInRackDisplay() {
        super(true, false);
    }

    public int[] getPositions() {
        return new int[]{30, 45, 25, 40, 60, 35, 65, 150, 130, 60};
    }

    public String[] getDefaultColumnNames() {
        return new String[]{"MARKSHORT", "EARTAGSHORT", "S", "CAGE", "AGE", "WEDDINGSHORT", "LINE", "GENOTYPE", "STRAIN", "PD"};
    }

    public String getDisplayName() {
        return Babel.get("TDN_MOUSE_RACK");
    }

    public void setCages(Vector cages) {
        this.ivCageIDsOnDisplay.clear();
        Vector mice = new Vector();
        if (cages != null) {
            Iterator iter = cages.iterator();
            while (iter.hasNext()) {
                Cage cage = (Cage)iter.next();
                String idString = cage.getIdentifierString();
                if (this.ivCageIDsOnDisplay.contains(idString)) continue;
                this.ivCageIDsOnDisplay.add(idString);
                Iterator iterator = cage.getActualMice().iterator();
                while (iterator.hasNext()) {
                    mice.addElement(iterator.next());
                }
            }
        }
        this.setTable(mice);
    }

    public boolean filterObject(Object ooo) {
        if (ooo instanceof Mouse) {
            Mouse mausi = (Mouse)ooo;
            return this.filterByCages(mausi) && (!this.ivWantOwnerButton || this.filterByOwner(mausi));
        }
        return false;
    }

    public boolean filterByCages(Mouse mausi) {
        Cage cage = mausi.getActCage();
        return cage != null && this.ivCageIDsOnDisplay.contains(cage.getIdentifierString());
    }

    public boolean handleNewObjectsLikeSubDisplay() {
        return false;
    }
}

