/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.tables.models;

import de.hannse.netobjects.datalayer.GroupFileManager;
import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.tools.FileManager;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.user.User;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.ArrayHelper;
import de.hannse.netobjects.util.Babel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.gui.MausoleumTableLabel;
import mausoleum.helper.FontManager;
import mausoleum.helper.Zeile;
import mausoleum.main.MausoleumClient;
import mausoleum.mouse.Mouse;
import mausoleum.mouse.MouseManager;
import mausoleum.tables.MausoleumTable;
import mausoleum.tables.models.MTMouse;
import mausoleum.tables.models.TableUtil;
import mausoleum.tables.sorting.MultiSortEntry;

public class MTMouseKilledThirdParty
extends MTMouse {
    public static final String STR_KILLER = "MKTP_KILLER";
    public static final String STR_ACTION_TIME = "MKTP_ACTION_TIME";
    private static final String[] ADDONS = new String[]{"MKTP_KILLER", "MKTP_ACTION_TIME"};
    private static MTMouseKilledThirdParty cvInstance = null;
    private static MausoleumTable cvExtraTable = null;
    private static final HashMap ENTRIES_BY_MOUSE_ID = new HashMap();
    private String[] cvPossibles = null;
    private String[] cvSortables = null;
    private String[] cvFilterables = null;

    public static MausoleumTable getKilledThirdPartyTable() {
        if (cvInstance == null) {
            cvInstance = new MTMouseKilledThirdParty();
            cvExtraTable = new MausoleumTable(cvInstance, false);
            cvExtraTable.setIsSubdisplay();
        }
        cvInstance.initFromServer();
        cvExtraTable.setHeader(Babel.get("KILLED_THIRD_PARTY_LONG"), FontManager.getFont("SSB12"));
        return cvExtraTable;
    }

    private MTMouseKilledThirdParty() {
    }

    public String[] getPossibleColumns() {
        if (this.cvPossibles == null) {
            this.cvPossibles = ArrayHelper.enlargeStringArray(super.getPossibleColumns(), ADDONS);
        }
        return this.cvPossibles;
    }

    public String[] getSortableColumns() {
        if (this.cvSortables == null) {
            this.cvSortables = ArrayHelper.enlargeStringArray(super.getSortableColumns(), ADDONS);
        }
        return this.cvSortables;
    }

    public String[] getEditableColumns() {
        return null;
    }

    public String getDefaultSortColumn() {
        return "EARTAGSHORT";
    }

    public String[] getFilterableCols() {
        if (this.cvFilterables == null) {
            this.cvFilterables = ArrayHelper.enlargeStringArray(super.getFilterableCols(), ADDONS);
        }
        return this.cvFilterables;
    }

    public String[] getColorableColumns() {
        return super.getColorableColumns();
    }

    public void initFromServer() {
        String path;
        String s;
        Vector mice = new Vector();
        ENTRIES_BY_MOUSE_ID.clear();
        if (MausoleumClient.isRegularOrTGService() && !UserManager.isPseudoGuruSession() && (s = FileManager.getStringContentFromServer(path = GroupFileManager.getKilledThirdPartyFilename(UserManager.getFirstGroup(), UserManager.getIDOFUser()))) != null && s.length() != 0) {
            FileManager.saveStringContentToServer(path, "", null, UserManager.getFirstGroup());
            Vector lines = StringHelper.splitStringByAny(s, "\n");
            Iterator iter = lines.iterator();
            while (iter.hasNext()) {
                String line = (String)iter.next();
                if (line.length() == 0) continue;
                new MKTPSonderInfo(line);
            }
        }
        if (!ENTRIES_BY_MOUSE_ID.isEmpty()) {
            int col = 0;
            long[] wanteds = new long[ENTRIES_BY_MOUSE_ID.size()];
            Iterator iter = ENTRIES_BY_MOUSE_ID.keySet().iterator();
            while (iter.hasNext()) {
                Long id = (Long)iter.next();
                wanteds[col++] = id;
            }
            Vector v = MouseManager.cvInstance.getObjects(wanteds, UserManager.getFirstGroup());
            if (v != null) {
                mice.addAll(v);
                this.setTable(mice);
            }
        }
    }

    public String[] getDefaultColumnNames() {
        return new String[]{"EARTAGSHORT", "WEDDINGSHORT", "S", "LINE", "GENOTYPE", "END", "END_MODE", STR_KILLER};
    }

    public void writeTheCodedElement(MausoleumTableLabel label, Object obj, String colName, boolean isForFilterSplit) {
        Mouse maus = (Mouse)obj;
        label.setText("");
        label.setIcon(null);
        if (colName.equals("WEDDINGSHORT")) {
            MKTPSonderInfo sinf = (MKTPSonderInfo)ENTRIES_BY_MOUSE_ID.get(maus.get("IDO_ID"));
            if (sinf != null && sinf.ivWarMating) {
                this.setForegroundAccordingToOwnership(label, UserManager.cvIsCareTaker || maus.itsMine(null));
                TableUtil.handleMating(label, this.ivUseDefaultFontSize, maus.isNonFertile(), this.ivColouredColumns, colName, null, null, true, false);
            }
        } else if (colName.equals(STR_KILLER)) {
            MKTPSonderInfo sinf = (MKTPSonderInfo)ENTRIES_BY_MOUSE_ID.get(maus.get("IDO_ID"));
            if (sinf != null) {
                this.setForegroundAccordingToOwnership(label, UserManager.cvIsCareTaker || maus.itsMine(null));
                label.setText(sinf.ivKillerUsername);
            }
        } else if (colName.equals(STR_ACTION_TIME)) {
            MKTPSonderInfo sinf = (MKTPSonderInfo)ENTRIES_BY_MOUSE_ID.get(maus.get("IDO_ID"));
            if (sinf != null) {
                this.setForegroundAccordingToOwnership(label, UserManager.cvIsCareTaker || maus.itsMine(null));
                this.setDateTimeInLabel(label, sinf.ivActionMillis);
            }
        } else {
            super.writeTheCodedElement(label, obj, colName, isForFilterSplit);
        }
    }

    public void fillSortVector(Vector mses, String column, int pos) {
        if (column.equals("WEDDINGSHORT")) {
            Iterator iterator = mses.iterator();
            while (iterator.hasNext()) {
                MultiSortEntry mse = (MultiSortEntry)iterator.next();
                Mouse m = (Mouse)mse.ivObject;
                MKTPSonderInfo sinf = (MKTPSonderInfo)ENTRIES_BY_MOUSE_ID.get(m.get("IDO_ID"));
                Comparable<Integer> comparable = mse.ivVals[pos] = sinf != null && sinf.ivWarMating ? EINS : null;
            }
        } else if (column.equals(STR_KILLER)) {
            Iterator iterator = mses.iterator();
            while (iterator.hasNext()) {
                MultiSortEntry mse = (MultiSortEntry)iterator.next();
                Mouse m = (Mouse)mse.ivObject;
                MKTPSonderInfo sinf = (MKTPSonderInfo)ENTRIES_BY_MOUSE_ID.get(m.get("IDO_ID"));
                Comparable comparable = mse.ivVals[pos] = sinf != null && sinf.ivWarMating ? sinf.ivKillerUsername : null;
            }
        } else if (column.equals(STR_ACTION_TIME)) {
            Iterator iterator = mses.iterator();
            while (iterator.hasNext()) {
                MultiSortEntry mse = (MultiSortEntry)iterator.next();
                Mouse m = (Mouse)mse.ivObject;
                MKTPSonderInfo sinf = (MKTPSonderInfo)ENTRIES_BY_MOUSE_ID.get(m.get("IDO_ID"));
                Comparable<Long> comparable = mse.ivVals[pos] = sinf != null ? new Long(sinf.ivActionMillis) : null;
            }
        } else {
            super.fillSortVector(mses, column, pos);
        }
    }

    public static class MKTPSonderInfo {
        public String ivKillerUsername = "?";
        public long ivActionMillis;
        public boolean ivWarMating;

        public MKTPSonderInfo(String line) {
            Zeile z = new Zeile(line, '|');
            int col = 0;
            Long key = new Long(z.getLong(col++, 0L));
            if (!ENTRIES_BY_MOUSE_ID.containsKey(key)) {
                User user;
                boolean invert = false;
                long userID = z.getLong(col++, 0L);
                String group = UserManager.getFirstGroup();
                if (userID < 0L) {
                    userID = -userID;
                    group = "service";
                    invert = true;
                }
                if ((user = (User)ObjectStore.getObjectDeadOrAlive(6, userID, group, null, true)) != null) {
                    this.ivKillerUsername = user.getName();
                    if (invert) {
                        this.ivKillerUsername = String.valueOf(this.ivKillerUsername) + " [" + group + "]";
                    }
                }
                this.ivActionMillis = z.getLong(col++, System.currentTimeMillis());
                this.ivWarMating = "1".equals(z.getString(col++, ""));
                ENTRIES_BY_MOUSE_ID.put(key, this);
            }
        }
    }
}

