/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.tables.models;

import de.hannse.netobjects.objectstore.ObjectManager;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.util.ArrayHelper;
import de.hannse.netobjects.util.Babel;
import java.awt.Color;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import mausoleum.building.Building;
import mausoleum.gui.ColorManager;
import mausoleum.gui.MausoleumTableLabel;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.InspectorPanelRoom;
import mausoleum.main.MausoleumClient;
import mausoleum.rack.Rack;
import mausoleum.rack.RackManager;
import mausoleum.room.Room;
import mausoleum.room.RoomManager;
import mausoleum.tables.MausoleumTableModel;
import mausoleum.tables.sorting.MultiSortEntry;

public class MTRoom
extends MausoleumTableModel {
    private static final String STR_NAME = "NAME";
    private static final String STR_GROUPS = "GROUPS";
    private static final String STR_GROUPS_WITH_RACK = "GROUPS_WITH_RACK";
    private static final String STR_SECURITY = "SECURITY_LEVEL";
    private static final String STR_BUILDING = "BUILDING";
    private static final String STR_ACCESSIBILITY = "ROOM_ACCESSIBILITY";
    private static final String[] TT_DICT = new String[]{"NAME", "MTR_TT_NAME", "GROUPS", "MTRM_TT_GROUPS", "SECURITY_LEVEL", "MTRM_TT_SECURITY_LEVEL", "BUILDING", "BUILDING_OF_ROOM", "ROOM_ACCESSIBILITY", "TT_ROOM_ACCESSIBILITY", "GROUPS_WITH_RACK", "MTRM_TT_GROUPS_WITH_RACKS"};
    private static final String[] POSSIBLES_HOS = new String[]{"NAME", "GROUPS", "SECURITY_LEVEL", "BUILDING", "ROOM_ACCESSIBILITY", "GROUPS_WITH_RACK"};
    private static final String[] POSSIBLES_REGULAR = new String[]{"NAME", "SECURITY_LEVEL"};
    private static final String[] DEFAULTS_HOS = new String[]{"NAME", "GROUPS", "BUILDING", "ROOM_ACCESSIBILITY"};
    private static final String[] DEFAULTS_REGULAR = new String[]{"NAME"};
    private static final String[] SORTABLES = new String[]{"NAME", "SECURITY_LEVEL", "BUILDING", "ROOM_ACCESSIBILITY", "GROUPS", "GROUPS_WITH_RACK"};
    private static final String[] EDITABLES = new String[]{"NAME", "SECURITY_LEVEL", "ROOM_ACCESSIBILITY"};
    private static final String[] COLORABLES = new String[]{"SECURITY_LEVEL", "ROOM_ACCESSIBILITY"};
    private static final String[] FILTERABLES = new String[]{"SECURITY_LEVEL", "ROOM_ACCESSIBILITY"};
    private static final HashMap PLAIN_SORTINGS = new HashMap(GENERAL_PLAIN_SORTINGS);
    private static final Color[] ACCESSIBLE_COLORS = new Color[]{ColorManager.getColorFromString("greenyellow"), ColorManager.getColorFromString("tomato")};
    static /* synthetic */ Class class$0;

    static {
        PLAIN_SORTINGS.put(STR_NAME, "ROM_NAME");
        PLAIN_SORTINGS.put(STR_SECURITY, "ROM_SECURITY");
    }

    public MausoleumTableModel getDefaultModel() {
        return new MTRoom();
    }

    public int getTableType() {
        return 12;
    }

    public String getDisplayName() {
        return Babel.get("TDN_ROOM");
    }

    public boolean ichWillFactSheets() {
        return true;
    }

    public ActionListener getActionListenerForColumn(String colName) {
        if (colName.equals(STR_NAME)) {
            return ((InspectorPanelRoom)Inspector.cvActPanel).ivNameField;
        }
        if (colName.equals(STR_SECURITY)) {
            return ((InspectorPanelRoom)Inspector.cvActPanel).ivSecurityButton;
        }
        if (colName.equals(STR_ACCESSIBILITY)) {
            return ((InspectorPanelRoom)Inspector.cvActPanel).ivAccesible;
        }
        return null;
    }

    public int[] getConsumertypes() {
        return new int[]{10, 3};
    }

    public String[] getPossibleColumns() {
        if (MausoleumClient.isHeadOfService()) {
            return POSSIBLES_HOS;
        }
        return POSSIBLES_REGULAR;
    }

    public String[] getSortableColumns() {
        return SORTABLES;
    }

    public String[] getEditableColumns() {
        return EDITABLES;
    }

    public String[] getFilterableCols() {
        return FILTERABLES;
    }

    public HashMap getPlainSortings() {
        return PLAIN_SORTINGS;
    }

    public String getDefaultSortColumn() {
        return STR_NAME;
    }

    public String[] getColorableColumns() {
        return COLORABLES;
    }

    public String[] getDefaultColorableColumns() {
        return new String[]{STR_SECURITY};
    }

    public int[] getWidths() {
        return new int[]{100};
    }

    public String[] getDefaultColumnNames() {
        if (MausoleumClient.isHeadOfService()) {
            return DEFAULTS_HOS;
        }
        return DEFAULTS_REGULAR;
    }

    public String[] getTooltipDict() {
        return TT_DICT;
    }

    public Class getServedClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("mausoleum.room.Room");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public ObjectManager getManager() {
        return RoomManager.cvInstance;
    }

    public boolean isTrafficReportable() {
        return true;
    }

    public void writeTheCodedElement(MausoleumTableLabel label, Object obj, String colName, boolean isForFilterSplit) {
        Room room = (Room)obj;
        if (colName.equals(STR_NAME)) {
            if (room.getString("ROM_NAME") == null) {
                label.setText(Babel.get("UNKNOWN"));
            } else {
                label.setText(room.getName());
            }
        } else if (colName.equals(STR_GROUPS)) {
            label.setText(room.getSharedGroupNames());
        } else if (STR_GROUPS_WITH_RACK.equals(colName)) {
            label.setText(MTRoom.getSharedGroupsWithRack(room));
        } else if (colName.equals(STR_BUILDING)) {
            Building building;
            String rein = "";
            if (MausoleumClient.isHeadOfService() && (building = room.getBuilding()) != null) {
                rein = building.getName();
            }
            label.setText(rein);
        } else if (colName.equals(STR_SECURITY)) {
            int security = room.getInt("ROM_SECURITY", 0);
            label.setText(StringHelper.getStringForInt(security, Room.SECURITY_INTS, Room.SECURITY_STRINGS, true, ""));
            if (this.ivColouredColumns.contains(colName)) {
                label.setBackground((Color)StringHelper.getObjectForInt(security, Room.SECURITY_INTS, Room.SECURITY_COLORS, Color.white));
                label.setOpaque(true);
            }
        } else if (colName.equals(STR_ACCESSIBILITY)) {
            boolean access = room.isAccessibleForGroups();
            label.setText(Babel.get(access ? "ROOM_ACCESSIBLE" : "ROOM_NOT_ACCESSIBLE"));
            if (this.ivColouredColumns.contains(colName)) {
                label.setBackground(ACCESSIBLE_COLORS[access ? 0 : 1]);
                label.setOpaque(true);
            }
        } else {
            super.writeGeneralElement(label, obj, colName, isForFilterSplit);
        }
    }

    private static String getSharedGroupsWithRack(Room room) {
        Vector groups = room.getSharedGroups();
        Vector racks = RackManager.getRacksInRoom(room.getID());
        TreeSet<String> gts = new TreeSet<String>(StringHelper.CASE_INSENSITIVE_COMPARER);
        Iterator iteratorRack = racks.iterator();
        while (iteratorRack.hasNext() && gts.size() != groups.size()) {
            Rack rack = (Rack)iteratorRack.next();
            String[] rGroups = (String[])rack.get("IDO_UGROUPS");
            if (rGroups == null) continue;
            Iterator iterator = groups.iterator();
            while (iterator.hasNext()) {
                String group = (String)iterator.next();
                if (gts.contains(group) || ArrayHelper.findStringInArray(group, rGroups) == -1) continue;
                gts.add(group);
            }
        }
        StringBuilder msb = new StringBuilder();
        Iterator iter = gts.iterator();
        while (iter.hasNext()) {
            String group = (String)iter.next();
            if (msb.length() != 0) {
                msb.append(", ");
            }
            msb.append(group);
        }
        return msb.toString();
    }

    public void fillSortVector(Vector mses, String column, int pos) {
        block4: {
            block6: {
                block5: {
                    block3: {
                        if (!column.equals(STR_BUILDING)) break block3;
                        Iterator iterator = mses.iterator();
                        while (iterator.hasNext()) {
                            MultiSortEntry mse = (MultiSortEntry)iterator.next();
                            Room room = (Room)mse.ivObject;
                            Building building = room.getBuilding();
                            Object object = mse.ivVals[pos] = building != null ? building.getName() : null;
                        }
                        break block4;
                    }
                    if (!column.equals(STR_ACCESSIBILITY)) break block5;
                    Iterator iterator = mses.iterator();
                    while (iterator.hasNext()) {
                        MultiSortEntry mse = (MultiSortEntry)iterator.next();
                        Object object = mse.ivVals[pos] = ((Room)mse.ivObject).isAccessibleForGroups() ? "1" : "0";
                    }
                    break block4;
                }
                if (!STR_GROUPS.equals(column)) break block6;
                this.sortBySharedGroups(mses, pos);
                break block4;
            }
            if (!STR_GROUPS_WITH_RACK.equals(column)) break block4;
            Iterator iterator = mses.iterator();
            while (iterator.hasNext()) {
                MultiSortEntry mse = (MultiSortEntry)iterator.next();
                mse.ivVals[pos] = MTRoom.getSharedGroupsWithRack((Room)mse.ivObject);
            }
        }
    }
}

