/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.tables.models;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.ObjectManager;
import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.Babel;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.experiment.Experiment;
import mausoleum.gui.MausoleumTableLabel;
import mausoleum.helper.FontManager;
import mausoleum.main.DefaultManager;
import mausoleum.tables.MausoleumTableModel;
import mausoleum.tables.sorting.MultiSortEntry;
import mausoleum.task.standards.StandardTask;

public class MTStandardTask
extends MausoleumTableModel {
    private static final String STR_DESCR = "MTST_DESCR";
    private static final String STR_SEX_RESTRICTION = "MTST_SEX_RESTRICTION";
    private static final String STR_DATE_RESTRICTION = "MTST_DATE_RESTRICTION";
    private static final String STR_AUTO_COMPLETION = "MTST_AUTO_COMPLETION";
    private static final String STR_CHANGEABLE = "MTST_CHANGEABLE";
    private static final String STR_COMBI = "MTST_COMBI";
    private static final String STR_PRIMARIES = "MTST_PRIMARIES";
    private static final String STR_COLOR = "MTST_COLOR";
    private static final String STR_DEFINITIONTYPE = "MTST_DEFINITION_TYPE";
    private static final String STR_GROUP_RESTRICTION = "MTST_GROUP_RESTRICTION";
    private static final String STR_MINIMUM_AGE = "MINIMUM_AGE";
    private static final String STR_MAXIMUM_AGE = "MAXIMUM_AGE";
    private static final String[] TT_DICT = new String[]{"MTST_DESCR", "MTST_TT_DESCR", "MTST_SEX_RESTRICTION", "MTST_TT_SEX_RESTRICTION", "MTST_DATE_RESTRICTION", "MTST_TT_DATE_RESTRICTION", "MTST_AUTO_COMPLETION", "MTST_TT_AUTO_COMPLETION", "MTST_CHANGEABLE", "MTST_TT_CHANGEABLE", "MTST_COMBI", "MTST_TT_COMBI", "MTST_PRIMARIES", "MTST_TT_PRIMARIES", "MTST_COLOR", "MTST_TT_COLOR", "MTST_DEFINITION_TYPE", "MTST_TT_DEFINITION_TYPE", "MTST_GROUP_RESTRICTION", "MTST_TT_GROUP_RESTRICTION"};
    private static final String[] POSSIBLES = new String[]{"MTST_DESCR", "MTST_SEX_RESTRICTION", "MTST_DATE_RESTRICTION", "MTST_GROUP_RESTRICTION", "MTST_AUTO_COMPLETION", "MTST_CHANGEABLE", "MTST_COMBI", "MTST_PRIMARIES", "MTST_COLOR", "MTST_DEFINITION_TYPE", "MINIMUM_AGE", "MAXIMUM_AGE"};
    private static final String[] SORTABLES = new String[]{"MTST_DESCR", "MTST_SEX_RESTRICTION", "MTST_DATE_RESTRICTION", "MTST_GROUP_RESTRICTION", "MTST_AUTO_COMPLETION", "MTST_CHANGEABLE", "MTST_COMBI", "MTST_PRIMARIES", "MTST_DEFINITION_TYPE", "MINIMUM_AGE", "MAXIMUM_AGE"};
    private static final String[] EDITABLES = new String[0];
    private static final String[] COLORABLES = new String[0];
    private static final String[] FILTERABLES = new String[]{"MTST_SEX_RESTRICTION", "MTST_DATE_RESTRICTION", "MTST_GROUP_RESTRICTION", "MTST_AUTO_COMPLETION", "MTST_CHANGEABLE", "MTST_COMBI", "MTST_DEFINITION_TYPE"};
    static /* synthetic */ Class class$0;

    public MausoleumTableModel getDefaultModel() {
        return new MTStandardTask();
    }

    public int getTableType() {
        return 13;
    }

    public boolean ichWillEinenSichtbarkeitsKnopf() {
        return true;
    }

    public ActionListener getActionListenerForColumn(String colName) {
        return null;
    }

    public String getDisplayName() {
        return Babel.get("TDN_STANDARDTASK");
    }

    public int[] getConsumertypes() {
        return null;
    }

    public String[] getPossibleColumns() {
        return POSSIBLES;
    }

    public String[] getSortableColumns() {
        return SORTABLES;
    }

    public String[] getEditableColumns() {
        return EDITABLES;
    }

    public String[] getFilterableCols() {
        return FILTERABLES;
    }

    public HashMap getPlainSortings() {
        return null;
    }

    public String[] getColorableColumns() {
        return COLORABLES;
    }

    public String[] getDefaultColorableColumns() {
        return new String[0];
    }

    public String getDefaultSortColumn() {
        return STR_DESCR;
    }

    public int[] getWidths() {
        return new int[]{100, 30, 80, 20};
    }

    public String[] getDefaultColumnNames() {
        return new String[]{STR_DESCR, STR_SEX_RESTRICTION, STR_DATE_RESTRICTION, STR_GROUP_RESTRICTION, STR_AUTO_COMPLETION, STR_DEFINITIONTYPE, STR_CHANGEABLE, STR_COLOR};
    }

    public String[] getTooltipDict() {
        return TT_DICT;
    }

    public Class getServedClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("mausoleum.task.standards.StandardTask");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public ObjectManager getManager() {
        return null;
    }

    public void processDoubleClick(Point p, Point originalPoint) {
    }

    public void fillMainTable() {
        this.setTable(new Vector());
    }

    public boolean ichWillEinenOwnerKnopf() {
        return false;
    }

    public boolean wantsGeneralColumns() {
        return false;
    }

    public void writeTheCodedElement(MausoleumTableLabel label, Object obj, String colName, boolean isForFilterSplit) {
        StandardTask st = (StandardTask)obj;
        this.setForegroundAccordingToOwnership(label, true);
        if (!st.isVisible()) {
            label.setFont(FontManager.getTableFont(false, this.ivUseDefaultFontSize, this.ivZoom));
        } else {
            label.setFont(FontManager.getTableFont(true, this.ivUseDefaultFontSize, this.ivZoom));
        }
        if (colName.equals(STR_DESCR)) {
            label.setHorizontalAlignment(2);
            label.setText(st.getComboVal());
        } else if (colName.equals(STR_SEX_RESTRICTION)) {
            label.setHorizontalAlignment(0);
            String s = "";
            if (st.ivSexRestriction.equals("TASK_SEX_MALE")) {
                s = DefaultManager.getMale();
            } else if (st.ivSexRestriction.equals("TASK_SEX_FEMALE")) {
                s = DefaultManager.getFemale();
            } else if (st.ivSexRestriction.equals("TASK_SEX_UNSET")) {
                s = "?";
            } else if (st.ivSexRestriction.equalsIgnoreCase("TASK_SEX_MATING")) {
                s = String.valueOf(DefaultManager.getMale()) + " + " + DefaultManager.getFemale();
            }
            label.setText(s);
        } else if (colName.equals(STR_DATE_RESTRICTION)) {
            label.setHorizontalAlignment(2);
            if ("TASK_DATE_ANY".equals(st.getDateRestriction())) {
                label.setFont(FontManager.getTableFont(false, this.ivUseDefaultFontSize, this.ivZoom));
            }
            label.setText(Babel.get(st.getDateRestriction()));
        } else if (colName.equals(STR_AUTO_COMPLETION)) {
            label.setHorizontalAlignment(2);
            if (st.ivAutocompletion.equals("TASK_AC_NONE")) {
                label.setFont(FontManager.getTableFont(false, this.ivUseDefaultFontSize, this.ivZoom));
                label.setText(Babel.get(st.ivAutocompletion));
            } else if (st.ivAutocompletion.equals("TASK_AC_RESULT")) {
                if (st.ivAdditionalObjectID == -42L) {
                    label.setText(Babel.get("TASK_AC_HEALTH_REPORT"));
                } else {
                    Experiment exp = (Experiment)ObjectStore.getClientObject(12, st.ivAdditionalObjectID, st.getGroup());
                    if (exp != null) {
                        label.setText(String.valueOf(Babel.get(st.ivAutocompletion)) + ": " + exp.getBrowseName());
                    } else {
                        label.setText(Babel.get(st.ivAutocompletion));
                    }
                }
            } else {
                label.setText(Babel.get(st.ivAutocompletion));
            }
        } else if (colName.equals(STR_CHANGEABLE)) {
            label.setHorizontalAlignment(0);
            if (st.ivChangeable) {
                label.setText("\u2713");
            } else {
                label.setText("");
            }
        } else if (colName.equals(STR_MINIMUM_AGE)) {
            label.setHorizontalAlignment(4);
            label.setText(st.ivMinimumAge > 0 ? Integer.toString(st.ivMinimumAge) : "");
        } else if (colName.equals(STR_MAXIMUM_AGE)) {
            label.setHorizontalAlignment(4);
            label.setText(st.ivMaximumAge > 0 ? Integer.toString(st.ivMaximumAge) : "");
        } else if (colName.equals(STR_GROUP_RESTRICTION)) {
            label.setHorizontalAlignment(0);
            if (st.ivSingleGroupOnly) {
                label.setText("\u2713");
            } else {
                label.setText("");
            }
        } else if (colName.equals(STR_COMBI)) {
            label.setHorizontalAlignment(0);
            if (st.isCombiTask()) {
                label.setText("\u2713");
            } else {
                label.setText("");
            }
        } else if (colName.equals(STR_PRIMARIES)) {
            if (st.isPrimaerTask()) {
                label.setText("");
            } else {
                StringBuffer msb = new StringBuffer();
                int i = 0;
                while (i < st.ivCombiIDs.length) {
                    if (i != 0) {
                        msb.append(" / ");
                    }
                    msb.append(StandardTask.getDescription(UserManager.getFirstGroup(), st.ivCombiIDs[i], "", true, null));
                    ++i;
                }
                label.setText(msb.toString());
            }
        } else if (colName.equals(STR_COLOR)) {
            if (st.ivTriangleColor != null) {
                label.setBackground(st.ivTriangleColor);
            }
        } else if (colName.equals(STR_DEFINITIONTYPE)) {
            label.setHorizontalAlignment(0);
            label.setText(st.getDefTypeBabel(""));
        }
    }

    public void fillSortVector(Vector mses, String column, int pos) {
        block19: {
            block27: {
                block26: {
                    block25: {
                        block24: {
                            block23: {
                                block22: {
                                    block21: {
                                        block20: {
                                            block18: {
                                                if (!column.equals(STR_DESCR)) break block18;
                                                Iterator iterator = mses.iterator();
                                                while (iterator.hasNext()) {
                                                    MultiSortEntry mse = (MultiSortEntry)iterator.next();
                                                    StandardTask st = (StandardTask)mse.ivObject;
                                                    mse.ivVals[pos] = MultiSortEntry.getComp(st.getComboVal());
                                                }
                                                break block19;
                                            }
                                            if (!column.equals(STR_SEX_RESTRICTION)) break block20;
                                            Iterator iterator = mses.iterator();
                                            while (iterator.hasNext()) {
                                                MultiSortEntry mse = (MultiSortEntry)iterator.next();
                                                StandardTask st = (StandardTask)mse.ivObject;
                                                String s = "";
                                                if (st.ivSexRestriction.equals("TASK_SEX_MALE")) {
                                                    s = DefaultManager.getMale();
                                                } else if (st.ivSexRestriction.equals("TASK_SEX_FEMALE")) {
                                                    s = DefaultManager.getFemale();
                                                } else if (st.ivSexRestriction.equals("TASK_SEX_UNSET")) {
                                                    s = "?";
                                                }
                                                mse.ivVals[pos] = s;
                                            }
                                            break block19;
                                        }
                                        if (!column.equals(STR_AUTO_COMPLETION)) break block21;
                                        Iterator iterator = mses.iterator();
                                        while (iterator.hasNext()) {
                                            MultiSortEntry mse = (MultiSortEntry)iterator.next();
                                            StandardTask st = (StandardTask)mse.ivObject;
                                            mse.ivVals[pos] = MultiSortEntry.getComp(Babel.get(st.ivAutocompletion));
                                        }
                                        break block19;
                                    }
                                    if (!column.equals(STR_CHANGEABLE)) break block22;
                                    Iterator iterator = mses.iterator();
                                    while (iterator.hasNext()) {
                                        MultiSortEntry mse = (MultiSortEntry)iterator.next();
                                        StandardTask st = (StandardTask)mse.ivObject;
                                        mse.ivVals[pos] = "" + st.ivChangeable;
                                    }
                                    break block19;
                                }
                                if (!column.equals(STR_MINIMUM_AGE)) break block23;
                                Iterator iterator = mses.iterator();
                                while (iterator.hasNext()) {
                                    MultiSortEntry mse = (MultiSortEntry)iterator.next();
                                    StandardTask st = (StandardTask)mse.ivObject;
                                    Comparable<Integer> comparable = mse.ivVals[pos] = st.ivMinimumAge > 0 ? new Integer(st.ivMinimumAge) : Integer.valueOf(0);
                                }
                                break block19;
                            }
                            if (!column.equals(STR_MAXIMUM_AGE)) break block24;
                            Iterator iterator = mses.iterator();
                            while (iterator.hasNext()) {
                                MultiSortEntry mse = (MultiSortEntry)iterator.next();
                                StandardTask st = (StandardTask)mse.ivObject;
                                Comparable<Integer> comparable = mse.ivVals[pos] = st.ivMaximumAge > 0 ? new Integer(st.ivMaximumAge) : Integer.valueOf(0);
                            }
                            break block19;
                        }
                        if (!column.equals(STR_GROUP_RESTRICTION)) break block25;
                        Iterator iterator = mses.iterator();
                        while (iterator.hasNext()) {
                            MultiSortEntry mse = (MultiSortEntry)iterator.next();
                            StandardTask st = (StandardTask)mse.ivObject;
                            mse.ivVals[pos] = "" + st.ivSingleGroupOnly;
                        }
                        break block19;
                    }
                    if (!column.equals(STR_COMBI)) break block26;
                    Iterator iterator = mses.iterator();
                    while (iterator.hasNext()) {
                        MultiSortEntry mse = (MultiSortEntry)iterator.next();
                        StandardTask st = (StandardTask)mse.ivObject;
                        mse.ivVals[pos] = "" + st.isCombiTask();
                    }
                    break block19;
                }
                if (!column.equals(STR_PRIMARIES)) break block27;
                Iterator iterator = mses.iterator();
                while (iterator.hasNext()) {
                    MultiSortEntry mse = (MultiSortEntry)iterator.next();
                    StandardTask st = (StandardTask)mse.ivObject;
                    StringBuilder msb = new StringBuilder();
                    if (st.isCombiTask()) {
                        int ii = 0;
                        while (ii < st.ivCombiIDs.length) {
                            if (ii != 0) {
                                msb.append(" / ");
                            }
                            msb.append(StandardTask.getDescription(UserManager.getFirstGroup(), st.ivCombiIDs[ii], "", true, null));
                            ++ii;
                        }
                    }
                    mse.ivVals[pos] = MultiSortEntry.getComp(msb.toString());
                }
                break block19;
            }
            if (!column.equals(STR_DEFINITIONTYPE)) break block19;
            Iterator iterator = mses.iterator();
            while (iterator.hasNext()) {
                MultiSortEntry mse = (MultiSortEntry)iterator.next();
                StandardTask st = (StandardTask)mse.ivObject;
                mse.ivVals[pos] = st.getDefTypeBabel("");
            }
        }
    }

    public void handleNewObject(IDObject obj) {
    }
}

