/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.tables.models;

import de.hannse.netobjects.objectstore.ObjectManager;
import de.hannse.netobjects.util.Babel;
import java.awt.Color;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Vector;
import mausoleum.gui.MausoleumTableLabel;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.InspectorPanelStrain;
import mausoleum.main.MausoleumClient;
import mausoleum.strain.Strain;
import mausoleum.strain.StrainManager;
import mausoleum.tables.MausoleumTableModel;
import mausoleum.tables.models.TableUtil;

public class MTStrain
extends MausoleumTableModel {
    protected static final String STR_NAME = "NAME";
    protected static final String STR_MATLIM = "MATLIM";
    protected static final String STR_COL = "COLOR";
    public static final String STR_GROUPS = "GROUPS";
    public static final String STR_PREFIX = "PREFIX";
    public static final String STR_COAT_COLOR = "COAT_COLOR";
    private static final String[] TT_DICT = new String[]{"NAME", "MTS_TT_NAME", "MATLIM", "MTM_TT_MATLIM", "COLOR", "MTS_TT_COLORSHORT", "GROUPS", "MTSTR_TT_GROUPS", "PREFIX", "MTL_TT_PREFIX_STRAIN", "COAT_COLOR", "MTM_TT_COAT_COLOR"};
    private static final String[] POSSIBLES = new String[]{"COLOR", "NAME", "MATLIM", "PREFIX", "COAT_COLOR"};
    private static final String[] POSSIBLES_HEAD_OF_SERVICE = new String[]{"COLOR", "NAME", "MATLIM", "GROUPS", "PREFIX", "COAT_COLOR"};
    private static final String[] SORTABLES = new String[]{"COLOR", "NAME", "MATLIM", "PREFIX", "GROUPS", "COAT_COLOR"};
    private static final String[] EDITABLES = new String[]{"COLOR", "NAME", "MATLIM", "PREFIX", "COAT_COLOR"};
    private static final String[] FILTERABLES = new String[]{"MATLIM", "PREFIX", "COAT_COLOR"};
    private static final String[] COLORABLES = new String[]{"COAT_COLOR"};
    private static final HashMap PLAIN_SORTINGS = new HashMap(GENERAL_PLAIN_SORTINGS);
    static /* synthetic */ Class class$0;

    static {
        PLAIN_SORTINGS.put(STR_NAME, "STR_NAME");
        PLAIN_SORTINGS.put(STR_MATLIM, "STR_MATLIM");
        PLAIN_SORTINGS.put(STR_COL, "STR_COLOR");
        PLAIN_SORTINGS.put(STR_PREFIX, "STR_ETPREFIX");
    }

    public MausoleumTableModel getDefaultModel() {
        return new MTStrain();
    }

    public int getTableType() {
        return 14;
    }

    public boolean ichWillEinenSichtbarkeitsKnopf() {
        return true;
    }

    public boolean ichWillFactSheets() {
        return true;
    }

    public String getDisplayName() {
        return Babel.get("TDN_STRAIN");
    }

    public ActionListener getActionListenerForColumn(String colName) {
        if (STR_NAME.equals(colName)) {
            return ((InspectorPanelStrain)Inspector.cvActPanel).ivNameField;
        }
        if (STR_MATLIM.equals(colName)) {
            return ((InspectorPanelStrain)Inspector.cvActPanel).ivMatLimButton;
        }
        if (STR_COL.equals(colName)) {
            return ((InspectorPanelStrain)Inspector.cvActPanel).ivColorButton;
        }
        if (STR_PREFIX.equals(colName)) {
            return ((InspectorPanelStrain)Inspector.cvActPanel).ivPrefixButton;
        }
        if (colName.equals(STR_COAT_COLOR)) {
            return ((InspectorPanelStrain)Inspector.cvActPanel).ivCSCoat;
        }
        return null;
    }

    public int[] getConsumertypes() {
        return new int[]{8};
    }

    public String[] getSortableColumns() {
        return SORTABLES;
    }

    public String[] getPossibleColumns() {
        return MausoleumClient.isHeadOfService() ? POSSIBLES_HEAD_OF_SERVICE : POSSIBLES;
    }

    public String[] getEditableColumns() {
        return EDITABLES;
    }

    public String[] getFilterableCols() {
        return FILTERABLES;
    }

    public HashMap getPlainSortings() {
        return PLAIN_SORTINGS;
    }

    public String[] getColorableColumns() {
        return COLORABLES;
    }

    public String[] getDefaultColorableColumns() {
        return new String[0];
    }

    public String getDefaultSortColumn() {
        return STR_NAME;
    }

    public int[] getWidths() {
        return new int[]{80, 100};
    }

    public String[] getDefaultColumnNames() {
        String[] stringArray;
        if (MausoleumClient.isHeadOfService()) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = STR_COL;
            stringArray2[1] = STR_NAME;
            stringArray = stringArray2;
            stringArray2[2] = STR_GROUPS;
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = STR_COL;
            stringArray = stringArray3;
            stringArray3[1] = STR_NAME;
        }
        return stringArray;
    }

    public String[] getTooltipDict() {
        return TT_DICT;
    }

    public Class getServedClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("mausoleum.strain.Strain");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public ObjectManager getManager() {
        return StrainManager.cvInstance;
    }

    public void writeTheCodedElement(MausoleumTableLabel label, Object obj, String colName, boolean isForFilterSplit) {
        Strain strain = (Strain)obj;
        if (STR_NAME.equals(colName)) {
            String name = strain.getBrowseName();
            if (name == null) {
                label.setText(Babel.get("UNKNOWN"));
            } else if (strain.isSharedWithOtherGroups()) {
                name = "[S] " + name;
            }
            label.setText(name);
        } else if (STR_MATLIM.equals(colName)) {
            Integer ml = (Integer)strain.get("STR_MATLIM");
            if (ml != null) {
                label.setText(ml.toString());
            } else {
                label.setText("");
            }
        } else if (STR_COL.equals(colName)) {
            Color col = (Color)strain.get("STR_COLOR");
            if (col != null) {
                label.setBackground(col);
            }
        } else if (STR_GROUPS.equals(colName)) {
            label.setText(strain.getSharedGroupNames());
        } else if (STR_PREFIX.equals(colName)) {
            label.setText(strain.getString("STR_ETPREFIX", ""));
        } else if (colName.equals(STR_COAT_COLOR)) {
            Integer cc = (Integer)strain.get("STR_CC");
            if (cc != null) {
                TableUtil.handleCoatColor(cc, label, this.ivColouredColumns, colName);
            }
        } else {
            super.writeGeneralElement(label, obj, colName, isForFilterSplit);
        }
    }

    public void fillSortVector(Vector mses, String column, int pos) {
        if (column.equals(STR_GROUPS)) {
            this.sortBySharedGroups(mses, pos);
        }
    }
}

