/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.tables.models;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.util.Babel;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.tables.models.MTTask;
import mausoleum.task.DisplayTask;
import mausoleum.task.TaskSchedule;
import mausoleum.task.TaskTreeNode;

public class MTTaskInSchedule
extends MTTask {
    private static MTTaskInSchedule cvInstance = null;
    private final TaskSchedule ivSchedule;
    private final Vector ivDragTasks = new Vector();
    private final Vector ivSammler = new Vector();

    public static MTTaskInSchedule getInstance(TaskSchedule schedule) {
        if (cvInstance == null) {
            cvInstance = new MTTaskInSchedule(schedule);
        }
        return cvInstance;
    }

    private MTTaskInSchedule(TaskSchedule schedule) {
        this.ivSchedule = schedule;
        TaskTreeNode.addActionListener(this);
    }

    public boolean autoExtensionPossible() {
        return false;
    }

    public void handleDragStart() {
        if (this.ivSchedule != null) {
            DisplayTask.getPermittedDateChangeDisplayTasks(this.getSelectedObjects(), this.ivDragTasks);
            this.ivSchedule.setDragDisplayTasks(this.ivDragTasks);
            if (!this.ivDragTasks.isEmpty()) {
                Cursor cursor = DisplayTask.createCursor(this.ivDragTasks, TaskSchedule.cvWithColor);
                if (cursor == null) {
                    cursor = Cursor.getPredefinedCursor(12);
                }
                this.ivMausoleumTable.setCursor(cursor);
            }
        }
    }

    public String getDisplayName() {
        return Babel.get("TDN_TASK");
    }

    public int[] getConsumertypes() {
        return new int[0];
    }

    public boolean istDragNDroppable() {
        return true;
    }

    public void handleNewObject(IDObject obj) {
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("TASK_CHANGE")) {
            this.ivSammler.clear();
            TaskTreeNode.ROOT.collectTasks(this.ivSammler);
            Vector neue = new Vector();
            Iterator iter = this.ivObjects.iterator();
            while (iter.hasNext()) {
                DisplayTask dt = (DisplayTask)iter.next();
                this.addIfFound(dt, neue);
            }
            this.setTable(neue);
        } else {
            super.actionPerformed(e);
        }
    }

    private void addIfFound(DisplayTask dt, Vector neue) {
        Iterator iter = this.ivSammler.iterator();
        while (iter.hasNext()) {
            DisplayTask dtn = (DisplayTask)iter.next();
            if (dtn.ivTask.ivPseudoID != dt.ivTask.ivPseudoID) continue;
            neue.add(dtn);
            return;
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (!this.ivDragTasks.isEmpty()) {
            Point p = this.convertPointForSchedule(e);
            if (p != null) {
                MouseEvent nevent = new MouseEvent(this.ivSchedule, 3467, System.currentTimeMillis(), e.getModifiers(), p.x, p.y, e.getClickCount(), e.isPopupTrigger());
                this.ivSchedule.mouseDragged(nevent);
                e.consume();
            }
        } else {
            super.mouseDragged(e);
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (!this.ivDragTasks.isEmpty()) {
            Point p = this.convertPointForSchedule(e);
            if (p == null) {
                p = new Point(-1, -1);
            }
            MouseEvent nevent = new MouseEvent(this.ivSchedule, 3467, System.currentTimeMillis(), e.getModifiers(), p.x, p.y, e.getClickCount(), e.isPopupTrigger());
            this.ivSchedule.mouseReleased(nevent);
            e.consume();
            this.ivMausoleumTable.setCursor(Cursor.getDefaultCursor());
            this.ivDragTasks.clear();
        }
        super.mouseReleased(e);
    }

    private Point convertPointForSchedule(MouseEvent e) {
        Point ziel;
        Point jetzt = e.getPoint();
        Dimension d = this.ivMausoleumTable.ivScrollPane.getSize();
        if ((jetzt.x < 0 || jetzt.y < 0 || jetzt.x > d.width || jetzt.y > d.height) && (ziel = this.ivSchedule.getLocationOnScreen()) != null) {
            Point start = this.getJTable().getLocationOnScreen();
            return new Point(start.x - ziel.x + jetzt.x, start.y - ziel.y + jetzt.y);
        }
        return null;
    }
}

