/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.tables.models;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.ObjectManager;
import de.hannse.netobjects.user.User;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.Babel;
import java.awt.Color;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.gui.MausoleumTableLabel;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.InspectorPanelUser;
import mausoleum.main.MausoleumClient;
import mausoleum.tables.MausoleumTableModel;

public class MTUser
extends MausoleumTableModel {
    protected static final String STR_NAME = "NAME";
    protected static final String STR_FULL_NAME = "FULL_NAME";
    protected static final String STR_STATUS = "STATUS";
    protected static final String STR_COL = "COLORSHORT";
    private static final String STR_EMAIL = "EMAIL";
    private static final String STR_TELNR = "TELNR";
    private static final String[] TT_DICT = new String[]{"NAME", "MTU_TT_NAME", "FULL_NAME", "MTU_TT_FULL_NAME", "STATUS", "MTU_TT_STATUS", "COLORSHORT", "MTU_TT_COLORSHORT", "EMAIL", "MTU_TT_EMAIL", "TELNR", "MTU_TT_TELNR"};
    private static final String[] POSSIBLES = new String[]{"NAME", "FULL_NAME", "STATUS", "COLORSHORT", "EMAIL", "TELNR"};
    private static final String[] SORTABLES = new String[]{"NAME", "FULL_NAME", "STATUS", "COLORSHORT", "EMAIL", "TELNR"};
    private static final String[] EDITABLES = new String[]{"NAME", "FULL_NAME", "STATUS", "COLORSHORT", "EMAIL", "TELNR"};
    private static final String[] FILTERABLES = new String[]{"STATUS"};
    private static final String[] COLORABLES = new String[0];
    private static final HashMap PLAIN_SORTINGS = new HashMap(GENERAL_PLAIN_SORTINGS);
    static /* synthetic */ Class class$0;

    static {
        PLAIN_SORTINGS.put(STR_NAME, "USR_NAME");
        PLAIN_SORTINGS.put(STR_FULL_NAME, "USR_FUNA");
        PLAIN_SORTINGS.put(STR_EMAIL, "USR_EMAIL");
        PLAIN_SORTINGS.put(STR_STATUS, "USR_MODE");
        PLAIN_SORTINGS.put(STR_COL, "USR_COLOR");
        PLAIN_SORTINGS.put(STR_TELNR, "USR_TELNR");
    }

    public MausoleumTableModel getDefaultModel() {
        return new MTUser();
    }

    public void setTable(Vector objects, boolean keepPresentObjects) {
        if (MausoleumClient.isServiceCaretaker()) {
            Vector<IDObject> v = new Vector<IDObject>();
            Iterator iterator = objects.iterator();
            while (iterator.hasNext()) {
                IDObject ido = (IDObject)iterator.next();
                if (!ido.getGroup().equals("service")) continue;
                v.add(ido);
            }
            objects.clear();
            objects.addAll(v);
        }
        super.setTable(objects, keepPresentObjects);
    }

    public void handleNewObject(IDObject object) {
        if (MausoleumClient.isServiceCaretaker() && !object.getGroup().equals("service")) {
            return;
        }
        super.handleNewObject(object);
    }

    public int getTableType() {
        return 16;
    }

    public boolean ichWillEinenSichtbarkeitsKnopf() {
        return true;
    }

    public boolean ichWillFactSheets() {
        return true;
    }

    public String getDisplayName() {
        return Babel.get("TDN_USER");
    }

    public ActionListener getActionListenerForColumn(String colName) {
        if (colName.equals(STR_NAME)) {
            return ((InspectorPanelUser)Inspector.cvActPanel).ivNameField;
        }
        if (colName.equals(STR_FULL_NAME)) {
            return ((InspectorPanelUser)Inspector.cvActPanel).ivFullNameField;
        }
        if (colName.equals(STR_EMAIL)) {
            return ((InspectorPanelUser)Inspector.cvActPanel).ivEmailField;
        }
        if (colName.equals(STR_TELNR)) {
            return ((InspectorPanelUser)Inspector.cvActPanel).ivTelNrField;
        }
        if (colName.equals(STR_STATUS)) {
            return ((InspectorPanelUser)Inspector.cvActPanel).ivStatusButton;
        }
        if (colName.equals(STR_COL)) {
            return ((InspectorPanelUser)Inspector.cvActPanel).ivColorButton;
        }
        return null;
    }

    public int[] getConsumertypes() {
        return new int[]{6};
    }

    public String[] getPossibleColumns() {
        return POSSIBLES;
    }

    public String[] getSortableColumns() {
        return SORTABLES;
    }

    public String[] getEditableColumns() {
        return EDITABLES;
    }

    public String[] getFilterableCols() {
        return FILTERABLES;
    }

    public HashMap getPlainSortings() {
        return PLAIN_SORTINGS;
    }

    public String[] getColorableColumns() {
        return COLORABLES;
    }

    public String[] getDefaultColorableColumns() {
        return new String[0];
    }

    public String getDefaultSortColumn() {
        return STR_NAME;
    }

    public int[] getWidths() {
        return new int[]{25, 105, 115, 200};
    }

    public String[] getDefaultColumnNames() {
        return new String[]{STR_COL, STR_NAME, STR_STATUS, STR_EMAIL};
    }

    public String[] getTooltipDict() {
        return TT_DICT;
    }

    public Class getServedClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.hannse.netobjects.user.User");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public ObjectManager getManager() {
        return UserManager.cvInstance;
    }

    public void writeTheCodedElement(MausoleumTableLabel label, Object obj, String colName, boolean isForFilterSplit) {
        User user = (User)obj;
        if (colName.equals(STR_NAME)) {
            label.setText(user.getAttibuteName(""));
        } else if (colName.equals(STR_FULL_NAME)) {
            label.setText(user.getAttibuteFullName(""));
        } else if (colName.equals(STR_EMAIL)) {
            label.setText(user.getAttibuteEmail(""));
        } else if (colName.equals(STR_TELNR)) {
            label.setText(user.getString("USR_TELNR", ""));
        } else if (colName.equals(STR_STATUS)) {
            label.setText(User.getStringForStatus(user.getInt("USR_MODE")));
        } else if (colName.equals(STR_COL)) {
            Color col = (Color)user.get("USR_COLOR");
            if (col != null) {
                label.setBackground(col);
            }
        } else {
            super.writeGeneralElement(label, obj, colName, isForFilterSplit);
        }
    }

    public void fillSortVector(Vector mses, String column, int pos) {
    }
}

