/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.tables.models;

import de.hannse.netobjects.objectstore.ObjectManager;
import de.hannse.netobjects.util.ArrayHelper;
import de.hannse.netobjects.util.Babel;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.cage.colors.GroupColorManager;
import mausoleum.gui.MausoleumTableLabel;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.InspectorPanelUserGroup;
import mausoleum.mouse.tierschutz.TierSchutz;
import mausoleum.tables.MausoleumTableModel;
import mausoleum.tables.sorting.MultiSortEntry;
import mausoleum.usergroup.UserGroup;
import mausoleum.usergroup.UsergroupManager;

public class MTUserGroup
extends MausoleumTableModel {
    private static final String STR_NAME = "NAME";
    private static final String STR_COL = "COLOR";
    private static final String STR_MISSING_STRESS = "MICE_WITH_MISSING_STRESS_LEVEL";
    private static final String[] TT_DICT = new String[]{"NAME", "MTG_TT_NAME", "COLOR", "MTG_TT_COLOR", "MICE_WITH_MISSING_STRESS_LEVEL", "MTM_TT_MICE_WITH_MISSING_STRESS_LEVEL"};
    private static final String[] POSSIBLES = new String[]{"NAME", "COLOR", "MICE_WITH_MISSING_STRESS_LEVEL"};
    private static final String[] UNWANTED_WITHOUT_STRESS = new String[]{"MICE_WITH_MISSING_STRESS_LEVEL"};
    private static final String[] SORTABLES = new String[]{"NAME", "COLOR", "MICE_WITH_MISSING_STRESS_LEVEL"};
    private static final String[] COLORABLES = new String[0];
    private static final String[] EDITABLES = new String[]{"COLOR"};
    private static final String[] FILTERABLES = new String[0];
    private static final HashMap PLAIN_SORTINGS = new HashMap(GENERAL_PLAIN_SORTINGS);
    static /* synthetic */ Class class$0;

    public MausoleumTableModel getDefaultModel() {
        return new MTUserGroup();
    }

    public int getTableType() {
        return 17;
    }

    public boolean ichWillEinenSichtbarkeitsKnopf() {
        return false;
    }

    public boolean ichWillFactSheets() {
        return true;
    }

    public String[] checkColumns(String[] arr) {
        if (arr != null && arr.length != 0 && !TierSchutz.belastungNeeded()) {
            int i = 0;
            while (i < UNWANTED_WITHOUT_STRESS.length) {
                arr = ArrayHelper.getArrayWithout(arr, UNWANTED_WITHOUT_STRESS[i]);
                ++i;
            }
        }
        return arr;
    }

    public String getDisplayName() {
        return Babel.get("TDN_GROUP");
    }

    public ActionListener getActionListenerForColumn(String colName) {
        if (colName.equals(STR_COL)) {
            return ((InspectorPanelUserGroup)Inspector.cvActPanel).ivCSColor;
        }
        return null;
    }

    public int[] getConsumertypes() {
        return new int[]{18};
    }

    public String[] getSortableColumns() {
        return SORTABLES;
    }

    public String[] getPossibleColumns() {
        return POSSIBLES;
    }

    public String[] getEditableColumns() {
        return EDITABLES;
    }

    public String[] getFilterableCols() {
        return FILTERABLES;
    }

    public HashMap getPlainSortings() {
        return PLAIN_SORTINGS;
    }

    public String[] getColorableColumns() {
        return COLORABLES;
    }

    public String[] getDefaultColorableColumns() {
        return new String[0];
    }

    public String getDefaultSortColumn() {
        return STR_NAME;
    }

    public int[] getWidths() {
        return new int[]{100};
    }

    public String[] getDefaultColumnNames() {
        if (TierSchutz.belastungNeeded()) {
            return new String[]{STR_NAME, STR_MISSING_STRESS};
        }
        return new String[]{STR_NAME};
    }

    public String[] getTooltipDict() {
        return TT_DICT;
    }

    public Class getServedClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("mausoleum.usergroup.UserGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public ObjectManager getManager() {
        return UsergroupManager.cvInstance;
    }

    public boolean wantsGeneralColumns() {
        return false;
    }

    public boolean displaysPersistentObjectType() {
        return false;
    }

    public void writeTheCodedElement(MausoleumTableLabel label, Object obj, String colName, boolean isForFilterSplit) {
        UserGroup group = (UserGroup)obj;
        if (colName.equals(STR_NAME)) {
            label.setText(group.getName());
        } else if (colName.equals(STR_COL)) {
            label.setBackground(GroupColorManager.getColor(group.getName()));
        }
        if (colName.equals(STR_MISSING_STRESS)) {
            if (group.ivNumberOfMiceWithMissingStress != 0) {
                label.setText(Integer.toString(group.ivNumberOfMiceWithMissingStress));
                label.setHorizontalAlignment(4);
            } else {
                label.setText("");
            }
        } else {
            super.writeGeneralElement(label, obj, colName, isForFilterSplit);
        }
    }

    public void fillSortVector(Vector mses, String column, int pos) {
        UserGroup ug;
        MultiSortEntry mse;
        Iterator iterator;
        if (column.equals(STR_NAME)) {
            iterator = mses.iterator();
            while (iterator.hasNext()) {
                mse = (MultiSortEntry)iterator.next();
                ug = (UserGroup)mse.ivObject;
                mse.ivVals[pos] = ug.ivName;
            }
        }
        if (column.equals(STR_COL)) {
            iterator = mses.iterator();
            while (iterator.hasNext()) {
                mse = (MultiSortEntry)iterator.next();
                ug = (UserGroup)mse.ivObject;
                mse.ivVals[pos] = MultiSortEntry.getComp(GroupColorManager.getColor(ug.getName()));
            }
        }
    }
}

