/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.tables.models;

import java.awt.Color;
import java.util.HashSet;
import mausoleum.cage.Cage;
import mausoleum.cage.colors.Herzeloyde;
import mausoleum.cage.colors.MatingColor;
import mausoleum.gui.ColorManager;
import mausoleum.gui.MausoleumTableLabel;
import mausoleum.helper.FontManager;
import mausoleum.main.DefaultManager;
import mausoleum.mouse.CoatColor;
import mausoleum.mouse.Mouse;

public abstract class TableUtil {
    public static void handleMating(MausoleumTableLabel label, boolean useDefaultFontSize, boolean nonfertile, HashSet colouredColumns, String colName, Mouse mouse, Cage cage, boolean isAMating, boolean showHerzeloydeIfNotMating) {
        if (isAMating) {
            Color[] col;
            label.setHorizontalAlignment(0);
            if (DefaultManager.showMatingSign()) {
                label.setIcon(FontManager.getRingeIcon(useDefaultFontSize, nonfertile));
            } else if (nonfertile) {
                label.setText("[x]");
            } else {
                label.setText("x");
            }
            if (colouredColumns.contains(colName) && cage != null && (col = MatingColor.INSTANCE.getCageColor(cage, null, cage.getActualMice(), null)) != null && col.length == 1) {
                label.setBackground(col[0]);
                if (!DefaultManager.showMatingSign()) {
                    label.setForeground(ColorManager.getForegroundColorForBackground(col[0]));
                }
            }
        } else if (showHerzeloydeIfNotMating && cage != null) {
            int daysSeparated;
            int n = daysSeparated = cage.ivHerzeloydeDays >= 0 && (mouse == null || mouse.getID() == cage.ivHerzeloydeMouseID) ? cage.ivHerzeloydeDays : -1;
            if (daysSeparated != -1) {
                Color col;
                label.setText("{" + daysSeparated + "}");
                label.setHorizontalAlignment(0);
                if (colouredColumns.contains(colName) && (col = Herzeloyde.getColor(daysSeparated, Herzeloyde.INSTANCE.getValues(), Herzeloyde.INSTANCE.getColors())) != null) {
                    label.setBackground(col);
                    label.setForeground(ColorManager.getForegroundColorForBackground(col));
                }
            }
        }
    }

    public static void handleCoatColor(int cc, MausoleumTableLabel label, HashSet ivColouredColumns, String colName) {
        if (cc != Integer.MIN_VALUE) {
            Color c;
            label.setText(CoatColor.getDescr(cc, true, ""));
            if (ivColouredColumns.contains(colName) && (c = CoatColor.getColor(cc)) != null) {
                label.setBackground(c);
                label.setForeground(ColorManager.getForegroundColorForBackground(c));
            }
        }
    }
}

