/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.tables.sorting;

import de.hannse.netobjects.datalayer.GroupFileManager;
import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.tools.FileManager;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.Babel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import mausoleum.alert.Alert;
import mausoleum.gui.BorderPanel;
import mausoleum.gui.MGButton;
import mausoleum.gui.SimpleLayoutManager;
import mausoleum.helper.FontManager;
import mausoleum.helper.ImageProvider;
import mausoleum.helper.Zeile;
import mausoleum.inspector.Inspector;
import mausoleum.requester.BasicRequester;
import mausoleum.requester.Requester;
import mausoleum.tables.MausoleumTableModel;
import mausoleum.ui.UIDef;

public class ExtendedSortDialog
extends BasicRequester {
    private static final long serialVersionUID = 123452345L;
    private static final int BREITE = UIDef.getScaled(750);
    private static final int HOEHE = UIDef.getScaled(480);
    private static final int INNER_BREITE = BREITE - 2 * UIDef.RAND;
    private static final int INNER_HOEHE = HOEHE - 2 * UIDef.RAND;
    private static final int LIST_BREITE = UIDef.getScaled(220);
    private static final int TABLE_BREITE = INNER_BREITE - UIDef.RAND - LIST_BREITE;
    private static final int TABLE_HOEHE = INNER_HOEHE - 1 * (UIDef.BUT_HEIGHT + UIDef.RAND);
    private static final HashMap DEFS_BY_TABLE_TYPE = new HashMap();
    private static final HashMap STANDARD_BY_TABLE_TYPE = new HashMap();
    private static ExtendedSortDialog cvInstance = null;
    private MGButton ivHeaderButton = MGButton.getInspectorActionButton("", "");
    private JLabel ivTableLabel = new JLabel();
    private JLabel ivListLabel = new JLabel();
    private JLabel ivDefListLabel = new JLabel();
    private final JComboBox ivAsDesCombo = new JComboBox<String>(new String[]{Babel.get("ASCENDING"), Babel.get("DESCENDING")});
    private JComboBox ivColumSelect = null;
    private final Vector ivActColumns = new Vector();
    private MausoleumTableModel ivModel = null;
    private final JTable ivTable;
    private final JScrollPane ivTablePane;
    private final JList ivDefList = new JList();
    private final JScrollPane ivListPane = new JScrollPane(this.ivDefList);
    private final MGButton ivAddButton = new MGButton(Babel.get("ESD_ADD"));
    private final MGButton ivRemoveButton = new MGButton(Babel.get("ESD_REMOVE"));
    private final MGButton ivUseAsStandardButton = new MGButton(Babel.get("ESD_USE_AS_STANDARD"));
    private final MGButton ivClearStandardButton = new MGButton(Babel.get("ESD_CLEAR_STANDARD"));
    private final MGButton ivUpButton = new MGButton(Babel.get("MOVEUPOBJECT"));
    private final MGButton ivDownButton = new MGButton(Babel.get("MOVEDOWNOBJECT"));
    private final MGButton ivClearButton = new MGButton(Babel.get("CLEAR_DEF"));
    private final MGButton ivResetButton = new MGButton(Babel.get("RESET"));
    private final MGButton ivStoreButton = new MGButton(Babel.get("STORE_DEF"));
    private final MGButton ivDeleteDefButton = new MGButton(Babel.get("DELETE_DEF"));
    private final MGButton ivUseDefButton = new MGButton(Babel.get("USE_DEF"));
    private static final HashMap LAST_SORTEDS = new HashMap();
    private final Vector ivESDLines = new Vector();
    private final Vector ivESDLinesAtStartup = new Vector();
    private final Vector ivSortableColBabels = new Vector();
    private final String ivAscending = Babel.get("ASCENDING");
    private final String ivDescending = Babel.get("DESCENDING");
    private String ivLastDefName = null;
    static /* synthetic */ Class class$0;

    public static void initWithUser() {
        DEFS_BY_TABLE_TYPE.clear();
        STANDARD_BY_TABLE_TYPE.clear();
        String cont = FileManager.getStringContentFromServer(GroupFileManager.getUserSortDefPath());
        if (cont != null) {
            int[] arr = null;
            Vector v = StringHelper.splitStringByAny(cont, "\n");
            Iterator iter = v.iterator();
            while (iter.hasNext()) {
                String defName;
                String line = (String)iter.next();
                if ((line = line.trim()).length() == 0) continue;
                int objectType = Zeile.getInt(line, arr = Zeile.getTrenner(line, '|', '\u0000', arr), '\u0000', 0, -1);
                if (objectType > 0) {
                    defName = Zeile.getStringB64(line, arr, '\u0000', 1, null);
                    String defVal = Zeile.getStringB64(line, arr, '\u0000', 2, null);
                    if (objectType == -1 || defName == null || defVal == null) continue;
                    Integer typKey = new Integer(objectType);
                    TreeMap<String, String> defsOfType = (TreeMap<String, String>)DEFS_BY_TABLE_TYPE.get(typKey);
                    if (defsOfType == null) {
                        defsOfType = new TreeMap<String, String>();
                        DEFS_BY_TABLE_TYPE.put(typKey, defsOfType);
                    }
                    defsOfType.put(defName, defVal);
                    continue;
                }
                defName = Zeile.getStringB64(line, arr, '\u0000', 1, null);
                if (defName == null) continue;
                STANDARD_BY_TABLE_TYPE.put(new Integer(-objectType), defName);
            }
            v.clear();
            Object var2_2 = null;
        }
    }

    private static void saveDefs() {
        Integer objectTypeKey;
        Iterator iter;
        StringBuffer msb = new StringBuffer();
        if (!DEFS_BY_TABLE_TYPE.isEmpty()) {
            iter = DEFS_BY_TABLE_TYPE.keySet().iterator();
            while (iter.hasNext()) {
                objectTypeKey = (Integer)iter.next();
                TreeMap tm = (TreeMap)DEFS_BY_TABLE_TYPE.get(objectTypeKey);
                if (tm == null) continue;
                Iterator iterator = tm.keySet().iterator();
                while (iterator.hasNext()) {
                    String name = (String)iterator.next();
                    String val = (String)tm.get(name);
                    msb.append(objectTypeKey).append("|").append(Base64Manager.encodeBase64(name));
                    msb.append("|").append(Base64Manager.encodeBase64(val)).append("\n");
                }
            }
        }
        if (!STANDARD_BY_TABLE_TYPE.isEmpty()) {
            iter = STANDARD_BY_TABLE_TYPE.keySet().iterator();
            while (iter.hasNext()) {
                objectTypeKey = (Integer)iter.next();
                String val = (String)STANDARD_BY_TABLE_TYPE.get(objectTypeKey);
                if (val == null) continue;
                msb.append("-").append(objectTypeKey).append("|").append(Base64Manager.encodeBase64(val)).append("\n");
            }
        }
        FileManager.saveStringContentToServer(GroupFileManager.getUserSortDefPath(), msb.toString(), null, UserManager.getFirstGroup());
    }

    public static Vector getSortDefNames(int tabletype) {
        Vector v = new Vector();
        Integer key1 = new Integer(tabletype);
        TreeMap tm = (TreeMap)DEFS_BY_TABLE_TYPE.get(key1);
        if (tm != null) {
            v.addAll(tm.keySet());
        }
        return v;
    }

    public static boolean hasLastDef(int tabletype) {
        return LAST_SORTEDS.containsKey(new Integer(tabletype));
    }

    public static void runLastSort(MausoleumTableModel model) {
        ExtendedSortDialog.runSort(model, (String)LAST_SORTEDS.get(new Integer(model.getTableType())));
    }

    public static boolean sortByStandard(MausoleumTableModel model) {
        Integer objectTypeKey = new Integer(model.getTableType());
        String defName = (String)STANDARD_BY_TABLE_TYPE.get(objectTypeKey);
        if (defName != null) {
            ExtendedSortDialog.runSortDef(model, defName);
            return true;
        }
        return false;
    }

    public static void runSortDef(MausoleumTableModel model, String name) {
        Integer objectTypeKey = new Integer(model.getTableType());
        TreeMap tm = (TreeMap)DEFS_BY_TABLE_TYPE.get(objectTypeKey);
        if (tm != null) {
            ExtendedSortDialog.runSort(model, (String)tm.get(name));
        }
    }

    private static void runSort(MausoleumTableModel model, String transportString) {
        if (transportString != null) {
            Zeile z = new Zeile(transportString, '|');
            Vector esds = new Vector();
            int i = 0;
            while (i < z.size()) {
                new ESDLine(z.getString(i, null), esds);
                ++i;
            }
            ExtendedSortDialog.runSort(esds, model, false);
        }
    }

    private static void runSort(Vector esdLines, MausoleumTableModel model, boolean storeDef) {
        if (esdLines != null && !esdLines.isEmpty() && model.getRowCount() > 1) {
            String[] colNames = new String[esdLines.size()];
            boolean[] inverteds = new boolean[esdLines.size()];
            int i = 0;
            while (i < esdLines.size()) {
                ESDLine line = (ESDLine)esdLines.elementAt(i);
                colNames[i] = line.ivColumn;
                inverteds[i] = line.ivInverted;
                ++i;
            }
            if (storeDef) {
                LAST_SORTEDS.put(new Integer(model.getTableType()), ExtendedSortDialog.getTransportString(esdLines));
            }
            model.sortIt(colNames, inverteds);
        }
    }

    private static String getTransportString(Vector esdLines) {
        StringBuffer msb = new StringBuffer();
        int i = 0;
        while (i < esdLines.size()) {
            ESDLine line = (ESDLine)esdLines.elementAt(i);
            if (i != 0) {
                msb.append("|");
            }
            msb.append(line.getTransportString());
            ++i;
        }
        return msb.toString();
    }

    public static void showDialog(MausoleumTableModel model, boolean useLast) {
        if (cvInstance == null) {
            cvInstance = new ExtendedSortDialog();
        }
        cvInstance.init(model, useLast);
    }

    private ExtendedSortDialog() {
        super((Frame)Inspector.getInspector(), BREITE, HOEHE);
        this.ivColumSelect = new JComboBox(new DefaultComboBoxModel(){
            private static final long serialVersionUID = 1453L;

            public Object getElementAt(int row) {
                if (row >= 0 && row < ExtendedSortDialog.this.ivSortableColBabels.size()) {
                    return ExtendedSortDialog.this.ivSortableColBabels.elementAt(row);
                }
                return null;
            }

            public int getSize() {
                return ExtendedSortDialog.this.ivSortableColBabels.size();
            }
        });
        this.ivColumSelect.setRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String colBabel = (String)value;
                if (ExtendedSortDialog.this.ivActColumns.contains(colBabel)) {
                    ExtendedSortDialog.this.ivListLabel.setFont(FontManager.getFont("SSB11"));
                } else {
                    ExtendedSortDialog.this.ivListLabel.setFont(FontManager.getFont("SSP11"));
                }
                ExtendedSortDialog.this.ivListLabel.setText(ExtendedSortDialog.this.getCol(colBabel));
                return ExtendedSortDialog.this.ivListLabel;
            }
        });
        this.ivTable = new JTable();
        this.ivTable.setModel(new TableModel(){

            public void addTableModelListener(TableModelListener arg0) {
            }

            public Class getColumnClass(int arg0) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }

            public int getColumnCount() {
                return 2;
            }

            public String getColumnName(int col) {
                if (col == 0) {
                    return Babel.get("SORT_COLUMNS");
                }
                if (col == 1) {
                    return Babel.get("SORT_MODE");
                }
                return null;
            }

            public int getRowCount() {
                return ExtendedSortDialog.this.ivESDLines.size();
            }

            public Object getValueAt(int row, int column) {
                if (row >= 0 && row < ExtendedSortDialog.this.ivESDLines.size()) {
                    ESDLine line = (ESDLine)ExtendedSortDialog.this.ivESDLines.elementAt(row);
                    if (column == 0) {
                        return line.ivColumn;
                    }
                    if (column == 1) {
                        if (line.ivInverted) {
                            return " " + ExtendedSortDialog.this.ivDescending + " ";
                        }
                        return " " + ExtendedSortDialog.this.ivAscending + " ";
                    }
                }
                return null;
            }

            public boolean isCellEditable(int row, int column) {
                return true;
            }

            public void removeTableModelListener(TableModelListener arg0) {
            }

            public void setValueAt(Object arg0, int row, int column) {
                if (row >= 0 && row < ExtendedSortDialog.this.ivESDLines.size()) {
                    ESDLine line = (ESDLine)ExtendedSortDialog.this.ivESDLines.elementAt(row);
                    if (column == 0) {
                        line.ivColumn = (String)arg0;
                    } else if (column == 1) {
                        line.ivInverted = !arg0.equals(ExtendedSortDialog.this.ivAscending);
                    }
                    ExtendedSortDialog.this.ivTable.repaint();
                }
            }
        });
        DefaultCellEditor dce = new DefaultCellEditor(this.ivColumSelect);
        this.ivTable.getColumnModel().getColumn(0).setCellEditor(dce);
        dce = new DefaultCellEditor(this.ivAsDesCombo);
        this.ivTable.getColumnModel().getColumn(1).setCellEditor(dce);
        this.ivTable.setRowHeight(UIDef.LINE_HEIGHT);
        this.ivTable.getSelectionModel().setSelectionMode(0);
        this.ivTable.getTableHeader().setPreferredSize(new Dimension(UIDef.getScaled(100), UIDef.getScaled(20)));
        this.ivTable.getColumnModel().getColumn(0).setPreferredWidth(300);
        this.ivTable.getColumnModel().getColumn(1).setPreferredWidth(60);
        this.ivTable.getTableHeader().setDefaultRenderer(new TableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                ExtendedSortDialog.this.ivHeaderButton.setLabel(" " + table.getModel().getColumnName(column) + " ");
                return ExtendedSortDialog.this.ivHeaderButton;
            }
        });
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.ivTable.setDefaultRenderer(clazz, new TableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (table.getSelectedRow() == row) {
                    ExtendedSortDialog.this.ivTableLabel.setBackground(UIDef.SELECTED_BACKGROUND);
                    ExtendedSortDialog.this.ivTableLabel.setOpaque(true);
                } else {
                    ExtendedSortDialog.this.ivTableLabel.setBackground(null);
                    ExtendedSortDialog.this.ivTableLabel.setOpaque(false);
                }
                boolean normal = true;
                if (row >= 0 && row < ExtendedSortDialog.this.ivESDLines.size()) {
                    ESDLine line = (ESDLine)ExtendedSortDialog.this.ivESDLines.elementAt(row);
                    normal = ExtendedSortDialog.this.ivActColumns.contains(line.ivColumn);
                }
                ExtendedSortDialog.this.ivTableLabel.setFont(normal ? FontManager.getFont("SSB11") : FontManager.getFont("SSP11"));
                if (column == 0) {
                    ExtendedSortDialog.this.ivTableLabel.setHorizontalAlignment(2);
                    String colBabel = (String)value;
                    ExtendedSortDialog.this.ivTableLabel.setText(" " + ExtendedSortDialog.this.getCol(colBabel) + " ");
                } else {
                    ExtendedSortDialog.this.ivTableLabel.setHorizontalAlignment(0);
                    ExtendedSortDialog.this.ivTableLabel.setText(" " + value + " ");
                }
                return ExtendedSortDialog.this.ivTableLabel;
            }
        });
        this.ivTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent arg0) {
                if (!arg0.getValueIsAdjusting()) {
                    ExtendedSortDialog.this.checkButtons();
                }
            }
        });
        this.ivTablePane = new JScrollPane(this.ivTable);
        this.ivAddButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ExtendedSortDialog.this.ivESDLines.add(new ESDLine((String)ExtendedSortDialog.this.ivSortableColBabels.firstElement(), false));
                ExtendedSortDialog.this.change(ExtendedSortDialog.this.ivESDLines.size() - 1);
            }
        });
        this.ivRemoveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                int row;
                if (ExtendedSortDialog.this.ivESDLines.size() > 1 && (row = ExtendedSortDialog.this.ivTable.getSelectedRow()) >= 0 && row < ExtendedSortDialog.this.ivESDLines.size()) {
                    ExtendedSortDialog.this.ivESDLines.removeElementAt(row);
                    ExtendedSortDialog.this.change(-1);
                }
            }
        });
        this.ivUpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                int row;
                if (ExtendedSortDialog.this.ivESDLines.size() > 1 && (row = ExtendedSortDialog.this.ivTable.getSelectedRow()) >= 1 && row < ExtendedSortDialog.this.ivESDLines.size()) {
                    Object o1 = ExtendedSortDialog.this.ivESDLines.elementAt(row);
                    Object o2 = ExtendedSortDialog.this.ivESDLines.elementAt(row - 1);
                    ExtendedSortDialog.this.ivESDLines.setElementAt(o1, row - 1);
                    ExtendedSortDialog.this.ivESDLines.setElementAt(o2, row);
                    ExtendedSortDialog.this.change(row - 1);
                }
            }
        });
        this.ivDownButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                int row;
                if (ExtendedSortDialog.this.ivESDLines.size() > 1 && (row = ExtendedSortDialog.this.ivTable.getSelectedRow()) >= 0 && row < ExtendedSortDialog.this.ivESDLines.size() - 1) {
                    Object o1 = ExtendedSortDialog.this.ivESDLines.elementAt(row);
                    Object o2 = ExtendedSortDialog.this.ivESDLines.elementAt(row + 1);
                    ExtendedSortDialog.this.ivESDLines.setElementAt(o1, row + 1);
                    ExtendedSortDialog.this.ivESDLines.setElementAt(o2, row);
                    ExtendedSortDialog.this.change(row + 1);
                }
            }
        });
        JPanel mp = new JPanel(new SimpleLayoutManager(){

            public void layoutContainer(Container arg0) {
                Dimension d = arg0.getSize();
                int iw = d.width - 2 * UIDef.INNER_RAND;
                int ih = d.height - 2 * UIDef.INNER_RAND;
                int th = ih - UIDef.BUT_HEIGHT - UIDef.INNER_RAND;
                int x = UIDef.INNER_RAND;
                int y = UIDef.INNER_RAND;
                ExtendedSortDialog.this.ivTablePane.setBounds(x, y, iw, th);
                int nw = (iw - 3 * UIDef.INNER_RAND) / 4;
                int lw = iw - 3 * (UIDef.INNER_RAND + nw);
                ExtendedSortDialog.this.ivAddButton.setBounds(x, y += th + UIDef.INNER_RAND, nw, UIDef.BUT_HEIGHT);
                ExtendedSortDialog.this.ivRemoveButton.setBounds(x += nw + UIDef.INNER_RAND, y, nw, UIDef.BUT_HEIGHT);
                ExtendedSortDialog.this.ivUpButton.setBounds(x += nw + UIDef.INNER_RAND, y, nw, UIDef.BUT_HEIGHT);
                ExtendedSortDialog.this.ivDownButton.setBounds(x += nw + UIDef.INNER_RAND, y, lw, UIDef.BUT_HEIGHT);
                x += lw + UIDef.INNER_RAND;
            }
        });
        mp.setOpaque(false);
        mp.add(this.ivTablePane);
        mp.add(this.ivAddButton);
        mp.add(this.ivRemoveButton);
        mp.add(this.ivUpButton);
        mp.add(this.ivDownButton);
        int x = UIDef.RAND;
        int y = UIDef.RAND;
        BorderPanel bp = new BorderPanel(mp, Babel.get("AKT_DEF"));
        this.addAndApplyBounds(bp, x, y, TABLE_BREITE, TABLE_HOEHE);
        x += TABLE_BREITE + UIDef.RAND;
        mp = new JPanel(new SimpleLayoutManager(){

            public void layoutContainer(Container arg0) {
                Dimension d = arg0.getSize();
                int iw = d.width - 2 * UIDef.INNER_RAND;
                int ih = d.height - 2 * UIDef.INNER_RAND;
                int th = ih - 3 * UIDef.BUT_HEIGHT - 3 * UIDef.INNER_RAND;
                int xlc = UIDef.INNER_RAND;
                int ylc = UIDef.INNER_RAND;
                ExtendedSortDialog.this.ivListPane.setBounds(xlc, ylc, iw, th);
                int nw = (iw - 1 * UIDef.INNER_RAND) / 2;
                int lw = iw - 1 * (UIDef.INNER_RAND + nw);
                ExtendedSortDialog.this.ivUseDefButton.setBounds(xlc, ylc += th + UIDef.INNER_RAND, nw, UIDef.BUT_HEIGHT);
                ExtendedSortDialog.this.ivDeleteDefButton.setBounds(xlc += nw + UIDef.INNER_RAND, ylc, lw, UIDef.BUT_HEIGHT);
                ExtendedSortDialog.this.ivUseAsStandardButton.setBounds(UIDef.INNER_RAND, ylc += UIDef.BUT_HEIGHT + UIDef.INNER_RAND, iw, UIDef.BUT_HEIGHT);
                ExtendedSortDialog.this.ivClearStandardButton.setBounds(UIDef.INNER_RAND, ylc += UIDef.BUT_HEIGHT + UIDef.INNER_RAND, iw, UIDef.BUT_HEIGHT);
            }
        });
        mp.setOpaque(false);
        this.ivDefList.setSelectionMode(0);
        this.ivDefList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent arg0) {
                ExtendedSortDialog.this.checkDefButs();
            }
        });
        this.ivDefList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ExtendedSortDialog.this.useDef();
                }
            }
        });
        this.ivDefList.setCellRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList rlist, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                ExtendedSortDialog.this.ivDefListLabel.setText(" " + value + " ");
                if (isSelected) {
                    ExtendedSortDialog.this.ivDefListLabel.setBackground(UIDef.SELECTED_BACKGROUND);
                    ExtendedSortDialog.this.ivDefListLabel.setOpaque(true);
                } else {
                    ExtendedSortDialog.this.ivDefListLabel.setBackground(null);
                    ExtendedSortDialog.this.ivDefListLabel.setOpaque(false);
                }
                if (value.equals(STANDARD_BY_TABLE_TYPE.get(new Integer(ExtendedSortDialog.this.ivModel.getTableType())))) {
                    ExtendedSortDialog.this.ivDefListLabel.setIcon(ImageProvider.getBulletIcon(Color.green));
                } else {
                    ExtendedSortDialog.this.ivDefListLabel.setIcon(ImageProvider.CLEAR_BULLET_ICON);
                }
                return ExtendedSortDialog.this.ivDefListLabel;
            }
        });
        this.ivDeleteDefButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ExtendedSortDialog.this.removeDef();
            }
        });
        this.ivUseDefButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ExtendedSortDialog.this.useDef();
            }
        });
        this.ivUseAsStandardButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ExtendedSortDialog.this.useAsStandard();
            }
        });
        this.ivClearStandardButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ExtendedSortDialog.this.clearStandard();
            }
        });
        mp.add(this.ivListPane);
        mp.add(this.ivUseDefButton);
        mp.add(this.ivDeleteDefButton);
        mp.add(this.ivUseAsStandardButton);
        mp.add(this.ivClearStandardButton);
        bp = new BorderPanel(mp, Babel.get("STORED_DEFS"));
        this.addAndApplyBounds(bp, x, y, LIST_BREITE, TABLE_HOEHE);
        x = UIDef.RAND;
        int nw = (INNER_BREITE - 3 * UIDef.RAND) / 4;
        int lw = INNER_BREITE - 3 * (UIDef.RAND + nw);
        this.ivResetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ESDLine.copy(ExtendedSortDialog.this.ivESDLinesAtStartup, ExtendedSortDialog.this.ivESDLines);
                ExtendedSortDialog.this.change(-1);
            }
        });
        this.ivResetButton.setFont(this.ivOkButton.getFont());
        this.addAndApplyBounds(this.ivResetButton, x, y += TABLE_HOEHE + UIDef.RAND, nw, UIDef.BUT_HEIGHT);
        this.ivClearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                Vector<ESDLine> v = new Vector<ESDLine>();
                v.add(new ESDLine((String)ExtendedSortDialog.this.ivSortableColBabels.firstElement(), false));
                ESDLine.copy(v, ExtendedSortDialog.this.ivESDLines);
                ExtendedSortDialog.this.change(-1);
            }
        });
        this.ivClearButton.setFont(this.ivOkButton.getFont());
        this.addAndApplyBounds(this.ivClearButton, x += nw + UIDef.RAND, y, nw, UIDef.BUT_HEIGHT);
        this.ivStoreButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ExtendedSortDialog.this.storeDef();
            }
        });
        this.ivStoreButton.setFont(this.ivOkButton.getFont());
        this.addAndApplyBounds(this.ivStoreButton, x += nw + UIDef.RAND, y, nw, UIDef.BUT_HEIGHT);
        this.ivOkButton.setText(Babel.get("SORT"));
        this.ivOkButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ExtendedSortDialog.runSort(ExtendedSortDialog.this.ivESDLines, ExtendedSortDialog.this.ivModel, true);
                ExtendedSortDialog.this.setVisible(false);
            }
        });
        this.applyBounds(this.ivOkButton, x += nw + UIDef.RAND, y, lw, UIDef.BUT_HEIGHT);
    }

    private void init(MausoleumTableModel model, boolean useLast) {
        String title = Babel.get("EDIT_SORT_DEFINITIONS_FOR_TYPE");
        title = StringHelper.gSub(title, "_TYPE_", IDObject.getASCIILabelForType(model.getObjectType()));
        this.setTitle(title);
        this.ivModel = model;
        this.ivActColumns.clear();
        this.ivActColumns.addAll(model.getDefinedColumnNames());
        this.ivSortableColBabels.clear();
        String[] sarr = model.getSortableColumns();
        int i = 0;
        while (i < sarr.length) {
            this.ivSortableColBabels.add(sarr[i]);
            ++i;
        }
        this.ivColumSelect.contentsChanged(new ListDataEvent(this.ivColumSelect, 0, 0, this.ivSortableColBabels.size() - 1));
        this.ivESDLines.clear();
        this.ivESDLinesAtStartup.clear();
        String transportString = null;
        if (useLast) {
            transportString = (String)LAST_SORTEDS.get(new Integer(this.ivModel.getTableType()));
        }
        if (transportString == null) {
            this.ivESDLines.add(new ESDLine((String)this.ivSortableColBabels.firstElement(), false));
        } else {
            Zeile z = new Zeile(transportString, '|');
            int i2 = 0;
            while (i2 < z.size()) {
                new ESDLine(z.getString(i2, null), this.ivESDLines);
                ++i2;
            }
        }
        ESDLine.copy(this.ivESDLines, this.ivESDLinesAtStartup);
        this.ivTable.tableChanged(new TableModelEvent(this.ivTable.getModel()));
        this.ivTable.clearSelection();
        this.ivLastDefName = null;
        this.initList();
        this.checkButtons();
        this.checkDefButs();
        this.setVisible(true);
    }

    public boolean okAndNoWanted() {
        return false;
    }

    public boolean onlyOKWanted() {
        return true;
    }

    private void change(int selNach) {
        this.ivTable.removeEditor();
        this.ivTable.tableChanged(new TableModelEvent(this.ivTable.getModel()));
        if (selNach == -1) {
            this.ivTable.clearSelection();
        } else {
            this.ivTable.getSelectionModel().setSelectionInterval(selNach, selNach);
        }
        this.ivTable.repaint();
        this.checkButtons();
    }

    private void checkDefButs() {
        String name = (String)this.ivDefList.getSelectedValue();
        this.ivUseDefButton.setEnabled(name != null);
        this.ivDeleteDefButton.setEnabled(name != null);
        this.ivUseAsStandardButton.setEnabled(name != null);
        this.ivClearStandardButton.setEnabled(STANDARD_BY_TABLE_TYPE.get(new Integer(this.ivModel.getObjectType())) != null);
    }

    private void checkButtons() {
        this.ivAddButton.setEnabled(true);
        if (this.ivESDLines.isEmpty()) {
            this.ivRemoveButton.setEnabled(false);
            this.ivUpButton.setEnabled(false);
            this.ivDownButton.setEnabled(false);
        } else if (this.ivESDLines.size() == 1) {
            this.ivRemoveButton.setEnabled(false);
            this.ivUpButton.setEnabled(false);
            this.ivDownButton.setEnabled(false);
        } else {
            int ind = this.ivTable.getSelectedRow();
            this.ivRemoveButton.setEnabled(ind != -1);
            this.ivUpButton.setEnabled(ind > 0);
            this.ivDownButton.setEnabled(ind >= 0 && ind < this.ivESDLines.size() - 1);
        }
    }

    public void setVisible(boolean arg0) {
        if (!arg0) {
            this.ivTable.removeEditor();
        }
        super.setVisible(arg0);
    }

    public String getCol(String col) {
        StringBuffer msb = new StringBuffer(" ");
        msb.append(Babel.get(col));
        String tt = this.ivModel.getColumnTooltip(col);
        if (tt != null) {
            msb.append(" [").append(Babel.get(tt)).append("]");
        }
        msb.append(" ");
        return msb.toString();
    }

    private void storeDef() {
        String defName;
        String oldName = this.ivLastDefName;
        if (oldName == null) {
            oldName = "";
        }
        if ((defName = Requester.getString(this, Babel.get("DEF_NAME"), oldName)) != null && defName.trim().length() != 0) {
            boolean res;
            defName = defName.trim();
            Integer key1 = new Integer(this.ivModel.getTableType());
            TreeMap<String, String> tm = (TreeMap<String, String>)DEFS_BY_TABLE_TYPE.get(key1);
            if (tm == null) {
                tm = new TreeMap<String, String>();
                DEFS_BY_TABLE_TYPE.put(key1, tm);
            }
            if (tm.containsKey(defName) && !(res = Alert.showAlert(Babel.get("DEF_NAME_TAKEN"), false))) {
                return;
            }
            tm.put(defName, ExtendedSortDialog.getTransportString(this.ivESDLines));
            ExtendedSortDialog.saveDefs();
            this.initList();
        }
    }

    private void removeDef() {
        Integer objectTypeKey;
        TreeMap tm;
        String defName = (String)this.ivDefList.getSelectedValue();
        if (defName != null && defName.length() != 0 && (tm = (TreeMap)DEFS_BY_TABLE_TYPE.get(objectTypeKey = new Integer(this.ivModel.getTableType()))) != null) {
            if (tm.containsKey(defName)) {
                tm.remove(defName);
            }
            if (defName.equals(STANDARD_BY_TABLE_TYPE.get(objectTypeKey))) {
                STANDARD_BY_TABLE_TYPE.remove(objectTypeKey);
            }
            ExtendedSortDialog.saveDefs();
            this.initList();
        }
    }

    private void useDef() {
        String transport;
        Integer key1;
        TreeMap tm;
        String name = (String)this.ivDefList.getSelectedValue();
        if (name != null && (tm = (TreeMap)DEFS_BY_TABLE_TYPE.get(key1 = new Integer(this.ivModel.getTableType()))) != null && (transport = (String)tm.get(name)) != null) {
            Zeile z = new Zeile(transport, '|');
            Vector esds = new Vector();
            int i = 0;
            while (i < z.size()) {
                new ESDLine(z.getString(i, null), esds);
                ++i;
            }
            if (!esds.isEmpty()) {
                ESDLine.copy(esds, this.ivESDLines);
                this.change(-1);
                this.ivLastDefName = name;
            }
        }
    }

    private void useAsStandard() {
        String name = (String)this.ivDefList.getSelectedValue();
        if (name != null) {
            STANDARD_BY_TABLE_TYPE.put(new Integer(this.ivModel.getTableType()), name);
            ExtendedSortDialog.saveDefs();
            this.ivDefList.repaint();
            this.checkDefButs();
        }
    }

    private void clearStandard() {
        STANDARD_BY_TABLE_TYPE.remove(new Integer(this.ivModel.getTableType()));
        ExtendedSortDialog.saveDefs();
        this.ivDefList.repaint();
        this.checkDefButs();
    }

    private void initList() {
        Vector v = new Vector();
        Integer key1 = new Integer(this.ivModel.getTableType());
        TreeMap tm = (TreeMap)DEFS_BY_TABLE_TYPE.get(key1);
        if (tm != null) {
            v.addAll(tm.keySet());
        }
        this.ivDefList.setListData(v);
        this.ivDefList.repaint();
        this.ivDefList.clearSelection();
    }

    static class ESDLine {
        public String ivColumn;
        public boolean ivInverted;

        public static void copy(Vector source, Vector target) {
            if (target == null) {
                target = new Vector<ESDLine>(source.size());
            } else {
                target.clear();
            }
            if (source != null && !source.isEmpty()) {
                Iterator iter = source.iterator();
                while (iter.hasNext()) {
                    ESDLine line = (ESDLine)iter.next();
                    target.add(line.getClone());
                }
            }
        }

        public ESDLine(String col, boolean inverted) {
            this.ivColumn = col;
            this.ivInverted = inverted;
        }

        public ESDLine(String transportString, Vector target) {
            if (transportString != null) {
                try {
                    this.ivInverted = transportString.startsWith("1");
                    this.ivColumn = transportString.substring(2, transportString.length());
                    target.add(this);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public ESDLine getClone() {
            return new ESDLine(this.ivColumn, this.ivInverted);
        }

        public String getTransportString() {
            StringBuffer msb = new StringBuffer();
            if (this.ivInverted) {
                msb.append("1;");
            } else {
                msb.append("0;");
            }
            msb.append(this.ivColumn);
            return msb.toString();
        }
    }
}

