/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.task;

import de.hannse.netobjects.util.ArrayHelper;
import de.hannse.netobjects.util.MyDate;
import java.util.Iterator;
import java.util.TreeSet;
import mausoleum.mouse.TaskExtended;
import mausoleum.requester.calendar.WeekdayPanel;

public abstract class PeriodTaskHelper {
    private static int MAX_DIFF_NACHHER = 7;

    public static int getPotentialKnipsDatesForTADone(TaskExtended task, int actionDate) {
        TreeSet ned;
        if (task.ivNextExecDates == null) {
            task.ivNextExecDates = PeriodTaskHelper.getDates(task, MyDate.HEUTE);
        }
        if (!(ned = task.ivNextExecDates).isEmpty()) {
            int latestKnipsDate = task.getLatestKnipsDate();
            Integer lastVorherOderGleich = null;
            Integer firstNachher = null;
            Iterator iterator = ned.iterator();
            while (iterator.hasNext() && firstNachher == null) {
                Integer dateI = (Integer)iterator.next();
                if (dateI <= actionDate) {
                    lastVorherOderGleich = dateI;
                    continue;
                }
                if (dateI <= actionDate || firstNachher != null || latestKnipsDate != Integer.MIN_VALUE && dateI >= latestKnipsDate) continue;
                firstNachher = dateI;
            }
            if (lastVorherOderGleich != null) {
                return lastVorherOderGleich;
            }
            if (firstNachher != null) {
                return firstNachher;
            }
        }
        return Integer.MIN_VALUE;
    }

    public static int getKnipsDate(TaskExtended task, int actionDate) {
        TreeSet ned;
        if (task.ivNextExecDates == null) {
            task.ivNextExecDates = PeriodTaskHelper.getDates(task, MyDate.HEUTE);
        }
        if (!(ned = task.ivNextExecDates).isEmpty()) {
            if (ned.contains(new Integer(actionDate))) {
                return actionDate;
            }
            int latestKnipsDate = task.getLatestKnipsDate();
            Integer lastVorher = null;
            Integer firstNachher = null;
            Iterator iterator = ned.iterator();
            while (iterator.hasNext() && firstNachher == null) {
                Integer dateI = (Integer)iterator.next();
                if (dateI < actionDate) {
                    lastVorher = dateI;
                    continue;
                }
                if (dateI <= actionDate || firstNachher != null || latestKnipsDate != Integer.MIN_VALUE && dateI >= latestKnipsDate) continue;
                firstNachher = dateI;
            }
            if (firstNachher == null && lastVorher == null) {
                return Integer.MIN_VALUE;
            }
            if (firstNachher == null) {
                return lastVorher;
            }
            if (lastVorher == null) {
                int delta = firstNachher - actionDate;
                if (delta <= MAX_DIFF_NACHHER) {
                    return firstNachher;
                }
            } else {
                int fixDelta = firstNachher - lastVorher;
                int vorneFix = fixDelta / 3;
                int rubikon = firstNachher - vorneFix;
                if (actionDate >= rubikon && firstNachher - actionDate <= MAX_DIFF_NACHHER) {
                    return firstNachher;
                }
                return lastVorher;
            }
        }
        return Integer.MIN_VALUE;
    }

    public static TreeSet getDates(TaskExtended task, int refDate) {
        TreeSet res = new TreeSet();
        PeriodTaskHelper.addDates(task, refDate, res);
        return res;
    }

    public static void addDates(TaskExtended task, int refDate, TreeSet res) {
        int maxDate = refDate + 30;
        res.clear();
        if (task.ivDatum > refDate) {
            PeriodTaskHelper.insertIfNecessary(task, PeriodTaskHelper.getFirstDayOfTask(task), res, task.ivDatum + 10, refDate);
            refDate = task.ivDatum;
        }
        if (refDate > task.ivPeriodEnd) {
            TreeSet ts = PeriodTaskHelper.getDates(task, task.ivPeriodEnd);
            if (!ts.isEmpty()) {
                res.add(ts.last());
            }
            return;
        }
        int frequency = task.ivPeriodFrequency;
        int weekDayPattern = TaskExtended.getWeekDayPatternIfRelevant(frequency);
        if (weekDayPattern != -1) {
            frequency = 128;
        }
        switch (frequency) {
            case 0: 
            case 1: {
                PeriodTaskHelper.fillDayCountArr(task, refDate, 1, res, maxDate);
                break;
            }
            case 2: {
                PeriodTaskHelper.fillDayCountArr(task, refDate, 2, res, maxDate);
                break;
            }
            case 3: {
                PeriodTaskHelper.fillDayCountArr(task, refDate, 3, res, maxDate);
                break;
            }
            case 4: {
                PeriodTaskHelper.fillDayCountArr(task, refDate, 4, res, maxDate);
                break;
            }
            case 7: {
                PeriodTaskHelper.fillDayCountArr(task, refDate, 7, res, maxDate);
                break;
            }
            case 14: {
                PeriodTaskHelper.fillDayCountArr(task, refDate, 14, res, maxDate);
                break;
            }
            case 30: {
                PeriodTaskHelper.fillMonthArr(task, refDate, 1, res, maxDate);
                break;
            }
            case 34: {
                PeriodTaskHelper.fillMonthArr(task, refDate, 2, res, maxDate);
                break;
            }
            case 35: {
                PeriodTaskHelper.fillMonthArr(task, refDate, 3, res, maxDate);
                break;
            }
            case 36: {
                PeriodTaskHelper.fillMonthArr(task, refDate, 6, res, maxDate);
                break;
            }
            case 37: {
                PeriodTaskHelper.fillMonthArr(task, refDate, 12, res, maxDate);
                break;
            }
            case 70: {
                PeriodTaskHelper.fillWeekDayArr(task, refDate, 6, res, maxDate);
                break;
            }
            case 71: {
                PeriodTaskHelper.fillWeekDayArr(task, refDate, 0, res, maxDate);
                break;
            }
            case 72: {
                PeriodTaskHelper.fillWeekDayArr(task, refDate, 1, res, maxDate);
                break;
            }
            case 73: {
                PeriodTaskHelper.fillWeekDayArr(task, refDate, 2, res, maxDate);
                break;
            }
            case 74: {
                PeriodTaskHelper.fillWeekDayArr(task, refDate, 3, res, maxDate);
                break;
            }
            case 75: {
                PeriodTaskHelper.fillWeekDayArr(task, refDate, 4, res, maxDate);
                break;
            }
            case 76: {
                PeriodTaskHelper.fillWeekDayArr(task, refDate, 5, res, maxDate);
                break;
            }
            case 128: {
                PeriodTaskHelper.fillMoreDaysArr(task, refDate, weekDayPattern, res, maxDate);
                break;
            }
        }
    }

    private static void fillDayCountArr(TaskExtended task, int refDate, int frequency, TreeSet target, int maxDate) {
        PeriodTaskHelper.fillFreqArr(task, PeriodTaskHelper.getDayCountStart(task, refDate, frequency), frequency, target, maxDate, refDate);
    }

    private static void fillWeekDayArr(TaskExtended task, int refDate, int weekday, TreeSet target, int maxDate) {
        PeriodTaskHelper.fillFreqArr(task, PeriodTaskHelper.getWeekDayStart(task, refDate, weekday), 7, target, maxDate, refDate);
    }

    private static void fillMoreDaysArr(TaskExtended task, int refDate, int weekDayPattern, TreeSet target, int maxDate) {
        TreeSet ts1 = new TreeSet();
        TreeSet ts2 = new TreeSet();
        int i = 0;
        while (i < WeekdayPanel.SUB_FREQS.length) {
            if ((weekDayPattern & WeekdayPanel.SUB_FREQS[i]) != 0) {
                ts1.clear();
                PeriodTaskHelper.fillWeekDayArr(task, refDate, WeekdayPanel.SUB_FREQ_DAYS[i], ts1, maxDate);
                ts2.addAll(ts1);
            }
            ++i;
        }
        Iterator iterator = ts2.iterator();
        while (iterator.hasNext()) {
            Integer td = (Integer)iterator.next();
            PeriodTaskHelper.insertIfNecessary(task, td, target, maxDate, refDate);
        }
    }

    private static int getDayCountStart(TaskExtended task, int refDate, int frequency) {
        int vorne = refDate;
        if (frequency != 1) {
            int delta = refDate - task.ivDatum;
            int rest = delta % frequency;
            vorne = refDate - (rest == 0 ? frequency : rest);
        }
        return vorne;
    }

    private static int getWeekDayStart(TaskExtended task, int refDate, int weekday) {
        int refWeekDay = MyDate.getWochentag(refDate);
        int delta = refWeekDay - weekday;
        if (delta < 0) {
            delta += 7;
        }
        return refDate - (delta == 0 ? 7 : delta);
    }

    private static void fillFreqArr(TaskExtended task, int vorne, int frequency, TreeSet target, int maxDate, int refDate) {
        int datum = vorne;
        boolean cont = true;
        while (cont) {
            cont = PeriodTaskHelper.insertIfNecessary(task, datum, target, maxDate, refDate);
            datum += frequency;
        }
    }

    private static boolean insertIfNecessary(TaskExtended task, int datum, TreeSet target, int maxDate, int refDate) {
        if (datum > task.ivPeriodEnd || datum > maxDate) {
            return false;
        }
        boolean doit = true;
        if (datum < task.ivDatum) {
            doit = false;
        } else if (ArrayHelper.findIndexGreaterOrEqualInArray(datum, task.ivKnipser) != -1) {
            target.clear();
            doit = false;
        } else if (datum <= refDate) {
            target.clear();
        }
        if (doit) {
            target.add(new Integer(datum));
        }
        return true;
    }

    private static int getFirstDayOfTask(TaskExtended task) {
        int datum = -1;
        int frequency = task.ivPeriodFrequency;
        int weekDayPattern = TaskExtended.getWeekDayPatternIfRelevant(frequency);
        if (weekDayPattern != -1) {
            frequency = 128;
        }
        switch (frequency) {
            case 70: {
                datum = PeriodTaskHelper.getWeekDayStart(task, task.ivDatum, 6);
                break;
            }
            case 71: {
                datum = PeriodTaskHelper.getWeekDayStart(task, task.ivDatum, 0);
                break;
            }
            case 72: {
                datum = PeriodTaskHelper.getWeekDayStart(task, task.ivDatum, 1);
                break;
            }
            case 73: {
                datum = PeriodTaskHelper.getWeekDayStart(task, task.ivDatum, 2);
                break;
            }
            case 74: {
                datum = PeriodTaskHelper.getWeekDayStart(task, task.ivDatum, 3);
                break;
            }
            case 75: {
                datum = PeriodTaskHelper.getWeekDayStart(task, task.ivDatum, 4);
                break;
            }
            case 76: {
                datum = PeriodTaskHelper.getWeekDayStart(task, task.ivDatum, 5);
                break;
            }
            case 128: {
                datum = Integer.MAX_VALUE;
                int i = 0;
                while (i < WeekdayPanel.SUB_FREQS.length) {
                    int tdatum;
                    if ((weekDayPattern & WeekdayPanel.SUB_FREQS[i]) != 0 && (tdatum = PeriodTaskHelper.getWeekDayStart(task, task.ivDatum, WeekdayPanel.SUB_FREQ_DAYS[i])) < datum) {
                        datum = tdatum;
                    }
                    ++i;
                }
                break;
            }
        }
        if (datum != -1) {
            while (datum < task.ivDatum) {
                datum += 7;
            }
            return datum;
        }
        return task.ivDatum;
    }

    private static void fillMonthArr(TaskExtended task, int refDate, int anzMonths, TreeSet target, int maxDate) {
        int monatsDiff;
        int rest;
        MyDate erstesMD = new MyDate(task.ivDatum);
        int erstesTAG = erstesMD.ivTag;
        int erstesMONAT = erstesMD.ivMonat;
        int erstesJAHR = erstesMD.ivJahr;
        MyDate refMD = new MyDate(refDate);
        int refTAG = refMD.ivTag;
        int refMONAT = refMD.ivMonat;
        int refJAHR = refMD.ivJahr;
        if (refTAG >= erstesTAG) {
            refTAG = erstesTAG;
        } else {
            refTAG = erstesTAG;
            if (--refMONAT < 1) {
                refMONAT += 12;
                --refJAHR;
            }
        }
        int monatsDeltaFin = 1;
        monatsDeltaFin = anzMonths == 1 ? 0 : ((rest = (monatsDiff = (refJAHR - erstesJAHR) * 12 + (refMONAT - erstesMONAT)) % anzMonths) == 0 ? anzMonths : rest);
        refMONAT -= monatsDeltaFin;
        while (refMONAT < 1) {
            refMONAT += 12;
            --refJAHR;
        }
        boolean cont = true;
        while (cont) {
            int datum = PeriodTaskHelper.getPossibleDate(refTAG, refMONAT, refJAHR);
            cont = PeriodTaskHelper.insertIfNecessary(task, datum, target, maxDate + anzMonths * 50, refDate);
            refMONAT += anzMonths;
            while (refMONAT > 12) {
                ++refJAHR;
                refMONAT -= 12;
            }
        }
    }

    private static int getPossibleDate(int refTAG, int refMONAT, int refJAHR) {
        while (!MyDate.isTagExistent(refTAG, refMONAT, refJAHR)) {
            --refTAG;
        }
        return MyDate.getTage(refTAG, refMONAT, refJAHR);
    }
}

