/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.task;

import de.hannse.netobjects.util.ArrayHelper;
import de.hannse.netobjects.util.MilliSpender;
import de.hannse.netobjects.util.MyDate;
import java.util.Iterator;
import java.util.TreeSet;
import mausoleum.helper.DatumFormat;
import mausoleum.mouse.TaskExtended;
import mausoleum.task.PeriodTaskHelper;

public abstract class PeriodTaskHelperTester {
    public static void main(String[] args) {
        System.out.println("**********");
        System.out.println("* Test 1 *");
        System.out.println("**********");
        PeriodTaskHelperTester.test1();
        System.out.println("**********");
        System.out.println("* Test 2 *");
        System.out.println("**********");
        PeriodTaskHelperTester.test2();
    }

    private static void test1() {
        System.out.println("Vortest Millitransplantation");
        long millis = MilliSpender.getMillis();
        int actionDate = MyDate.getTage(28, 7, 2015);
        long finishMillis = millis % 86400000L + (long)actionDate * 86400000L;
        System.out.println("Millis:       " + DatumFormat.getDateTimeString(millis));
        System.out.println("ActionDate:   " + DatumFormat.getDateTimeString(new MyDate(actionDate)));
        System.out.println("finishMillis: " + DatumFormat.getDateTimeString(finishMillis));
        System.out.println("------------------------------------------------------");
        TaskExtended te = new TaskExtended();
        te.ivDatum = MyDate.getTage(3, 6, 2017);
        te.ivPeriodEnd = MyDate.getTage(3, 6, 2019);
        te.ivPeriodFrequency = 2;
        PeriodTaskHelperTester.performTest("2 taegig", te, MyDate.getTage(4, 6, 2017));
        PeriodTaskHelperTester.performTest("2 taegig", te, MyDate.getTage(5, 7, 2017));
        PeriodTaskHelperTester.performTest("2 taegig", te, MyDate.getTage(5, 8, 2017));
        te.ivDatum = MyDate.getTage(3, 6, 2017);
        te.ivPeriodEnd = MyDate.getTage(3, 6, 2019);
        te.ivPeriodFrequency = 74;
        PeriodTaskHelperTester.performTest("Donnerstag", te, MyDate.getTage(5, 7, 2017));
        te.ivDatum = MyDate.getTage(3, 6, 2018);
        te.ivPeriodEnd = MyDate.getTage(3, 6, 2019);
        te.ivPeriodFrequency = 73;
        PeriodTaskHelperTester.performTest("Zukunft", te, MyDate.getTage(4, 6, 2017));
        te.ivDatum = MyDate.getTage(8, 6, 2017);
        te.ivPeriodEnd = MyDate.getTage(12, 6, 2017);
        te.ivPeriodFrequency = 2;
        PeriodTaskHelperTester.performTest("Zukunft 2", te, MyDate.getTage(4, 6, 2017));
        te.ivDatum = MyDate.getTage(3, 6, 2016);
        te.ivPeriodEnd = MyDate.getTage(3, 6, 2017);
        te.ivPeriodFrequency = 75;
        PeriodTaskHelperTester.performTest("Vergangenheit", te, MyDate.getTage(14, 6, 2017));
        te.ivDatum = MyDate.getTage(4, 1, 2015);
        te.ivPeriodEnd = MyDate.getTage(3, 6, 2018);
        te.ivPeriodFrequency = 35;
        PeriodTaskHelperTester.performTest("3 Monate a", te, MyDate.getTage(14, 6, 2017));
        PeriodTaskHelperTester.performTest("3 Monate b", te, MyDate.getTage(14, 7, 2017));
        te.ivDatum = MyDate.getTage(31, 1, 2015);
        te.ivPeriodEnd = MyDate.getTage(3, 6, 2018);
        te.ivPeriodFrequency = 30;
        PeriodTaskHelperTester.performTest("1 Monat", te, MyDate.getTage(14, 6, 2017));
        te.ivDatum = MyDate.getTage(4, 1, 2015);
        te.ivPeriodEnd = MyDate.getTage(3, 6, 2018);
        te.ivPeriodFrequency = 36;
        PeriodTaskHelperTester.performTest("halbjaehrlich a", te, MyDate.getTage(14, 6, 2017));
        PeriodTaskHelperTester.performTest("halbjaehrlich b", te, MyDate.getTage(14, 7, 2017));
        te.ivDatum = MyDate.getTage(4, 1, 2015);
        te.ivPeriodEnd = MyDate.getTage(3, 6, 2018);
        te.ivPeriodFrequency = 37;
        PeriodTaskHelperTester.performTest("jaehrlich a", te, MyDate.getTage(14, 6, 2017));
        PeriodTaskHelperTester.performTest("jaehrlich b", te, MyDate.getTage(14, 7, 2017));
    }

    private static void test2() {
        TaskExtended te = new TaskExtended();
        te.ivDatum = MyDate.getTage(14, 7, 2017);
        te.ivPeriodEnd = MyDate.getTage(14, 8, 2017);
        te.ivPeriodFrequency = 170;
        int aktDatum = MyDate.getTage(14, 7, 2017);
        int testDatum = MyDate.getTage(14, 7, 2017);
        te.ivNextExecDates = PeriodTaskHelper.getDates(te, testDatum);
        PeriodTaskHelperTester.showTask(te);
        PeriodTaskHelperTester.testExecution(te, aktDatum, testDatum);
        testDatum = MyDate.getTage(13, 7, 2017);
        te.ivKnipser = null;
        PeriodTaskHelperTester.testExecution(te, aktDatum, testDatum);
        testDatum = MyDate.getTage(12, 7, 2017);
        te.ivKnipser = null;
        PeriodTaskHelperTester.testExecution(te, aktDatum, testDatum);
        testDatum = MyDate.getTage(12, 6, 2017);
        te.ivKnipser = null;
        PeriodTaskHelperTester.testExecution(te, aktDatum, testDatum);
        testDatum = MyDate.getTage(6, 7, 2017);
        te.ivKnipser = null;
        PeriodTaskHelperTester.testExecution(te, aktDatum, testDatum);
        testDatum = MyDate.getTage(7, 7, 2017);
        te.ivKnipser = null;
        PeriodTaskHelperTester.testExecution(te, aktDatum, testDatum);
    }

    private static void testExecution(TaskExtended te, int aktDatum, int execDatum) {
        te.ivNextExecDates = PeriodTaskHelper.getDates(te, aktDatum);
        System.out.println("Test Ausfuehrung aktuelles Datum:   " + PeriodTaskHelperTester.getDateString(aktDatum));
        System.out.println("Test Ausfuehrung Ausfuehrungsdatum: " + PeriodTaskHelperTester.getDateString(execDatum));
        int knipsDate = PeriodTaskHelper.getKnipsDate(te, execDatum);
        if (knipsDate != Integer.MIN_VALUE) {
            System.out.println("    -> Knipse " + PeriodTaskHelperTester.getDateString(knipsDate));
            te.ivKnipser = ArrayHelper.enlargeIntArray(te.ivKnipser, knipsDate);
            te.ivNextExecDates = PeriodTaskHelper.getDates(te, aktDatum);
            PeriodTaskHelperTester.showDates(te.ivNextExecDates, aktDatum);
        }
        System.out.println("-------------------------------------------------------");
    }

    private static void performTest(String label, TaskExtended te, int datum) {
        System.out.println("Test: " + label);
        PeriodTaskHelperTester.showTask(te);
        System.out.println("Testdatum: " + PeriodTaskHelperTester.getDateString(datum));
        PeriodTaskHelperTester.showDates(PeriodTaskHelper.getDates(te, datum), datum);
    }

    private static void showDates(TreeSet dates, int refDate) {
        System.out.println("........ showDates ReferenceDate: " + PeriodTaskHelperTester.getDateString(refDate) + " ........");
        int nr = 1;
        Iterator iterator = dates.iterator();
        while (iterator.hasNext()) {
            Integer tag = (Integer)iterator.next();
            if (refDate > tag) {
                System.out.println("  date " + nr + ": " + PeriodTaskHelperTester.getDateString(tag));
            } else {
                System.out.println("+ Date " + nr + ": " + PeriodTaskHelperTester.getDateString(tag));
            }
            ++nr;
        }
        System.out.println(".............................................................................");
    }

    private static String getDateString(int tage) {
        return String.valueOf(DatumFormat.getJustDateString(tage)) + " (" + MyDate.WEEKDAYS[MyDate.getWochentag(tage)] + ") [" + tage + "]";
    }

    private static void showTask(TaskExtended te) {
        System.out.println("Task " + te.getDatumString());
        System.out.println("    Start: " + PeriodTaskHelperTester.getDateString(te.ivDatum));
        System.out.println("    Ende:  " + PeriodTaskHelperTester.getDateString(te.ivPeriodEnd));
    }
}

