/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.task;

import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.MyDate;
import java.awt.Color;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import mausoleum.cage.colors.TaskColor;
import mausoleum.factsheets.PrintElementFactSheet;
import mausoleum.helper.DatumFormat;
import mausoleum.helper.FontManager;
import mausoleum.mouse.TaskExtended;
import mausoleum.task.DisplayTask;
import mausoleum.task.TaskSchedule;
import mausoleum.util.calendar.InstituteHolidays;

public class TaskScheduleColumn {
    private static final Color FEIERTAG_COL = Color.red;
    private static final Color WOCHENEND_COL = Color.yellow;
    private final TreeMap ivMorning = new TreeMap();
    private final TreeMap ivNoon = new TreeMap();
    private final TreeMap ivAfternoon = new TreeMap();
    private final TreeMap ivEvening = new TreeMap();
    private final TreeMap ivIrgendwann = new TreeMap();
    private final int ivTage;
    public final Color ivBackground;
    private final int ivDate;
    private final int ivWochentag;
    public final String ivFeiertag;
    public final boolean ivIsWeekend;

    public TaskScheduleColumn(int tage) {
        this.ivTage = tage < 0 ? -1 : tage;
        int ind = this.ivTage + 1;
        if (ind >= TaskColor.TASK_DAYS_SCHEDULE_SPALTEN_BACKGROUNDS.length) {
            ind = TaskColor.TASK_DAYS_SCHEDULE_SPALTEN_BACKGROUNDS.length - 1;
        }
        this.ivBackground = TaskColor.TASK_DAYS_SCHEDULE_SPALTEN_BACKGROUNDS[ind];
        this.ivDate = MyDate.HEUTE + this.ivTage;
        MyDate md = new MyDate(this.ivDate);
        TreeMap tm = InstituteHolidays.getHolidayNamesByDate(md.ivJahr);
        this.ivFeiertag = (String)tm.get(new Integer(md.getTage()));
        this.ivWochentag = MyDate.getWochentag(this.ivDate);
        this.ivIsWeekend = this.ivFeiertag != null ? false : InstituteHolidays.isWeeklyDayOff(this.ivWochentag);
    }

    public void adapt(Vector tasks, Vector[][] printElementSammler, int col, boolean withColor, int heute) {
        this.ivMorning.clear();
        this.ivNoon.clear();
        this.ivAfternoon.clear();
        this.ivEvening.clear();
        this.ivIrgendwann.clear();
        Iterator iter = tasks.iterator();
        while (iter.hasNext()) {
            int dtDays;
            DisplayTask dt = (DisplayTask)iter.next();
            TaskExtended task = dt.ivTask;
            if (task.isFinished()) continue;
            boolean nimms = false;
            if (task.isFixedDayTask()) {
                dtDays = task.getMinimumDays(heute);
                nimms = this.ivTage == -1 ? dtDays < 0 : this.ivTage == dtDays;
            } else if (this.ivTage == -1) {
                dtDays = task.getMinimumDays(heute);
                nimms = dtDays < 0;
            } else {
                boolean bl = nimms = task.ivNextExecDates != null && task.ivNextExecDates.contains(new Integer(heute + this.ivTage));
            }
            if (!nimms) continue;
            if (this.ivTage < 0 || task.ivTime == 0) {
                this.take(dt, this.ivIrgendwann);
                continue;
            }
            if (dt.ivTask.ivTime == -1) {
                this.take(dt, this.ivMorning);
                continue;
            }
            if (dt.ivTask.ivTime == -2) {
                this.take(dt, this.ivNoon);
                continue;
            }
            if (dt.ivTask.ivTime == -3) {
                this.take(dt, this.ivAfternoon);
                continue;
            }
            if (dt.ivTask.ivTime == -4) {
                this.take(dt, this.ivEvening);
                continue;
            }
            this.take(dt, this.ivIrgendwann);
        }
        this.produce(this.ivMorning, printElementSammler, col, 1, withColor);
        this.produce(this.ivNoon, printElementSammler, col, 2, withColor);
        this.produce(this.ivAfternoon, printElementSammler, col, 3, withColor);
        this.produce(this.ivEvening, printElementSammler, col, 4, withColor);
        this.produce(this.ivIrgendwann, printElementSammler, col, 5, withColor);
    }

    public PrintElementFactSheet getDate(boolean withColor) {
        String s = null;
        s = this.ivTage < 0 ? Babel.get("OVER_DUE") : DatumFormat.getWeekDayMonthString(this.ivDate, this.ivWochentag);
        PrintElementFactSheet pfs = PrintElementFactSheet.getTextElement(0, 0, s, FontManager.getFont("SSB12"), 0);
        pfs.ivMargin = TaskSchedule.TEXT_MARGIN;
        if (withColor && this.ivTage >= 0) {
            if (this.ivFeiertag != null) {
                pfs.ivBackground = FEIERTAG_COL;
            } else if (this.ivIsWeekend) {
                pfs.ivBackground = WOCHENEND_COL;
            }
        }
        return pfs;
    }

    private void take(DisplayTask dt, TreeMap target) {
        String key = dt.ivTask.getDescription(dt.getString("IDO_GROUP", ""));
        Vector<DisplayTask> v = (Vector<DisplayTask>)target.get(key);
        if (v == null) {
            v = new Vector<DisplayTask>();
            target.put(key, v);
        }
        v.add(dt);
    }

    private void produce(TreeMap source, Vector[][] printElementSammler, int col, int row, boolean withColor) {
        printElementSammler[col][row].clear();
        Iterator iter = source.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            Vector tasks = (Vector)source.get(key);
            if (tasks == null || tasks.isEmpty()) continue;
            String rein = "[" + tasks.size() + "] " + key;
            PrintElementFactSheet pfs = null;
            if (withColor) {
                Color fg = Color.black;
                Color bg = Color.white;
                int index = this.ivTage + 1;
                if (index < TaskColor.TASK_DAYS_SCHEDULE_BOX_BACKGROUNDS.length) {
                    bg = TaskColor.TASK_DAYS_SCHEDULE_BOX_BACKGROUNDS[index];
                    fg = TaskColor.TASK_DAYS_SCHEDULE_BOX_FOREGROUNDS[index];
                }
                pfs = PrintElementFactSheet.getFilledTextBox(0, 0, 100, 20, rein, FontManager.getFont("SSB11"), bg, fg, null);
            } else {
                pfs = PrintElementFactSheet.getFilledTextBox(0, 0, 100, 20, rein, FontManager.getFont("SSB11"), Color.white, Color.black, null);
            }
            pfs.ivMargin = TaskSchedule.TEXT_MARGIN;
            pfs.ivOrientation = 0;
            StringBuffer msb = new StringBuffer();
            int i = 0;
            while (i < tasks.size()) {
                if (i != 0) {
                    msb.append("|");
                }
                DisplayTask dt = (DisplayTask)tasks.elementAt(i);
                msb.append(dt.ivTask.ivPseudoID);
                ++i;
            }
            pfs.ivLink = msb.toString();
            printElementSammler[col][row].add(pfs);
        }
    }
}

