/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.task;

import de.hannse.netobjects.tools.StringHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import mausoleum.cage.colors.TaskColor;
import mausoleum.helper.FontManager;
import mausoleum.helper.ImageProvider;
import mausoleum.task.TaskTreeNode;
import mausoleum.ui.UIDef;

public class TaskTreeCellRenderer
extends DefaultTreeCellRenderer
implements TreeCellRenderer {
    private static final long serialVersionUID = 1L;

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hatFocus) {
        TaskTreeNode node = (TaskTreeNode)value;
        super.getTreeCellRendererComponent(tree, value, false, expanded, leaf, row, false);
        this.setText(node.toString());
        this.setForeground(Color.black);
        if (isSelected) {
            this.setBackground(UIDef.SELECTED_BACKGROUND);
            this.setOpaque(true);
        } else {
            this.setBackground(null);
            this.setOpaque(false);
        }
        Color back = null;
        int taskDays = node.ivMinDay;
        back = taskDays == Integer.MAX_VALUE ? TaskColor.getFinishedTaskBackground() : TaskColor.getBackgroundByTaskDays(taskDays);
        this.setIcon(ImageProvider.getBulletIcon(back));
        this.setToolTipText(null);
        int stringWidth = StringHelper.getStringWidth(this.getText(), FontManager.getFont("SSB12"), 10);
        int iconWidth = this.getIcon().getIconWidth();
        int gapWidth = UIDef.getScaled(3);
        Dimension ld = this.getPreferredSize();
        ld.width = stringWidth + iconWidth + gapWidth;
        this.setSize(ld);
        this.setPreferredSize(ld);
        this.setBorder(null);
        return this;
    }
}

