/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.task;

import java.util.Iterator;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import mausoleum.task.TaskTreeNode;

public class TaskTreeMerker {
    private String ivSelectedPath = null;
    private Vector ivExpandedPaths = new Vector();

    public TaskTreeMerker(JTree tree, TreePath selectedPath) {
        if (selectedPath != null) {
            this.ivSelectedPath = TaskTreeNode.getIDPath((TaskTreeNode)selectedPath.getLastPathComponent());
        }
        int row = 0;
        while (row < tree.getRowCount()) {
            TaskTreeNode node;
            if (tree.isExpanded(row) && (node = (TaskTreeNode)tree.getPathForRow(row).getLastPathComponent()) != null) {
                this.ivExpandedPaths.addElement(TaskTreeNode.getIDPath(node));
            }
            ++row;
        }
    }

    public void manageTree(JTree tree, TaskTreeNode root) {
        Iterator iter = this.ivExpandedPaths.iterator();
        while (iter.hasNext()) {
            TreePath tp = TaskTreeNode.findNode(root, (String)iter.next());
            if (tp == null) continue;
            tree.expandPath(tp);
        }
        tree.clearSelection();
        TreePath tp = TaskTreeNode.findNode(root, this.ivSelectedPath);
        if (tp != null) {
            tree.setSelectionPath(tp);
        }
    }
}

