/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.task.standards;

import de.hannse.netobjects.user.Privileges;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.Babel;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mausoleum.gui.MGButton;
import mausoleum.gui.NULLLayoutManager;
import mausoleum.gui.RequesterPane;
import mausoleum.gui.SimpleLayoutManager;
import mausoleum.helper.WindowUtils;
import mausoleum.main.MausoleumClient;
import mausoleum.requester.task.WorkFlowRequester;
import mausoleum.tables.MausoleumTable;
import mausoleum.tables.models.MTStandardTask;
import mausoleum.task.standards.CombiTaskRequester;
import mausoleum.task.standards.StandardTask;
import mausoleum.task.standards.StandardTaskRequester;
import mausoleum.ui.UIDef;

public class StandardTaskPanel
extends RequesterPane
implements ActionListener {
    private static final long serialVersionUID = 1234234234L;
    private static final String COM_CREATE_STANDARD_TASKS = "CREATE_STANDARD_TASKS";
    private static final String COM_CREATE_COMBINATION_TASK = "CREATE_COMBINATION_TASK";
    private static final String COM_CREATE_WORKLOW = "CREATE_WORKFLOW";
    private static final String COM_MODIFY_STANDARD_TASKS = "MODIFY_STANDARD_TASKS";
    private static final String COM_DELETE_STANDARD_TASKS = "DELETE_STANDARD_TASKS";
    private static final String COM_REVITALIZE_STANDARD_TASKS = "REVITALIZE_STANDARD_TASKS";
    private static StandardTaskPanel cvInstance = null;
    private final MTStandardTask ivModel = new MTStandardTask();
    private final MausoleumTable ivTable = new MausoleumTable(this.ivModel, false);
    private final HashMap ivButtonsByCom = new HashMap(5);
    private final Vector ivButtons = new Vector(5);

    public static StandardTaskPanel getPanel() {
        if (cvInstance == null) {
            cvInstance = new StandardTaskPanel();
        }
        return cvInstance;
    }

    public static boolean hasPanel() {
        return cvInstance != null;
    }

    public static void adaptForGroupChange() {
        if (StandardTaskPanel.hasPanel()) {
            MTStandardTask mst = (MTStandardTask)StandardTaskPanel.cvInstance.ivTable.ivModel;
            mst.setTable(new Vector());
            StandardTaskPanel.getPanel().standardsChanged();
        }
    }

    private StandardTaskPanel() {
        super(new NULLLayoutManager(UIDef.getScaled(300), UIDef.getScaled(200)));
        this.add(this.ivTable);
        MTStandardTask mst = (MTStandardTask)this.ivTable.ivModel;
        mst.setTable(StandardTask.getAllStandardTasks());
        this.ivTable.ivJTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    StandardTaskPanel.this.checkButtons();
                }
            }
        });
        this.createButton("IBNEW", COM_CREATE_STANDARD_TASKS);
        this.createButton("CREATE_TASK_BUNDLE", COM_CREATE_COMBINATION_TASK);
        this.createButton("EDIT", COM_MODIFY_STANDARD_TASKS);
        this.createButton("IBREMOVE", COM_DELETE_STANDARD_TASKS);
        this.createButton("REACTIVATE", COM_REVITALIZE_STANDARD_TASKS);
        this.setLayout(new SimpleLayoutManager(){

            public void layoutContainer(Container parent) {
                Dimension d = StandardTaskPanel.this.getSize();
                int w = d.width;
                int h = d.height;
                if (StandardTaskPanel.this.ivButtons.isEmpty()) {
                    StandardTaskPanel.this.ivTable.setBounds(0, 0, w, h);
                } else {
                    int oh = h - UIDef.BUT_HEIGHT - UIDef.INNER_RAND;
                    StandardTaskPanel.this.ivTable.setBounds(0, 0, w, oh);
                    int y = oh + UIDef.INNER_RAND;
                    int anzbut = StandardTaskPanel.this.ivButtons.size();
                    int nbw = (w - (anzbut - 1) * UIDef.INNER_RAND) / anzbut;
                    int sbw = w - (anzbut - 1) * (UIDef.INNER_RAND + nbw);
                    int x = 0;
                    int i = 0;
                    while (i < anzbut) {
                        MGButton but = (MGButton)StandardTaskPanel.this.ivButtons.elementAt(i);
                        if (i == 0) {
                            but.setBounds(x, y, sbw, UIDef.BUT_HEIGHT);
                            x += sbw + UIDef.INNER_RAND;
                        } else {
                            but.setBounds(x, y, nbw, UIDef.BUT_HEIGHT);
                            x += nbw + UIDef.INNER_RAND;
                        }
                        ++i;
                    }
                }
            }
        });
        this.checkButtons();
    }

    public void standardsChanged() {
        this.adaptTable(this.ivModel.ivObjects);
    }

    private void createButton(String titleBabel, String privilege) {
        if (Privileges.hasPrivilege(privilege)) {
            MGButton but = new MGButton(Babel.get(titleBabel));
            but.setActionCommand(privilege);
            this.ivButtons.add(but);
            this.ivButtonsByCom.put(privilege, but);
            but.addActionListener(this);
            this.add(but);
        }
    }

    private void checkButtons() {
        if (!this.ivButtons.isEmpty()) {
            this.setButtonState(COM_CREATE_STANDARD_TASKS, true);
            this.setButtonState(COM_CREATE_WORKLOW, true);
            Vector sels = this.ivTable.getSelectedObjects();
            this.setButtonState(COM_CREATE_COMBINATION_TASK, StandardTask.getSexRestrictionForCombinedTaskCreation(sels) != null);
            if (sels.isEmpty() || this.hasSomethingUnchangeable(sels)) {
                this.setButtonState(COM_MODIFY_STANDARD_TASKS, false);
                boolean hosSonderGenehmigung = this.habIchHoSSondergenehmigung(sels);
                this.setButtonState(COM_DELETE_STANDARD_TASKS, hosSonderGenehmigung && this.hasOnlyVisibles(sels));
                this.setButtonState(COM_REVITALIZE_STANDARD_TASKS, hosSonderGenehmigung && this.hasOnlyInvisibles(sels));
                this.setButtonState(COM_CREATE_COMBINATION_TASK, StandardTask.getSexRestrictionForCombinedTaskCreation(sels) != null);
            } else {
                this.setButtonState(COM_MODIFY_STANDARD_TASKS, sels.size() == 1);
                this.setButtonState(COM_DELETE_STANDARD_TASKS, this.hasOnlyVisibles(sels));
                this.setButtonState(COM_REVITALIZE_STANDARD_TASKS, this.hasOnlyInvisibles(sels));
            }
        }
    }

    private void setButtonState(String com, boolean enabled) {
        MGButton but = (MGButton)this.ivButtonsByCom.get(com);
        if (but != null && but.isEnabled() != enabled) {
            but.setEnabled(enabled && Privileges.hasPrivilege(com));
        }
    }

    private boolean habIchHoSSondergenehmigung(Vector sels) {
        boolean res = false;
        if (sels != null && !sels.isEmpty() && MausoleumClient.isHeadOfService()) {
            res = true;
            Iterator iter = sels.iterator();
            while (iter.hasNext() && res) {
                StandardTask st = (StandardTask)iter.next();
                if (!st.isGroupTask()) continue;
                res = false;
            }
        }
        return res;
    }

    private boolean hasSomethingUnchangeable(Vector sels) {
        if (sels != null) {
            Iterator iter = sels.iterator();
            while (iter.hasNext()) {
                StandardTask st = (StandardTask)iter.next();
                if (!st.ivChangeable) {
                    return true;
                }
                if (MausoleumClient.isHeadOfService()) {
                    return !st.isInstituteTask();
                }
                if (!MausoleumClient.isRegularOrTGService()) continue;
                return !st.isGroupTask();
            }
            return false;
        }
        return true;
    }

    private boolean hasOnlyInvisibles(Vector sels) {
        if (sels != null) {
            Iterator iter = sels.iterator();
            while (iter.hasNext()) {
                StandardTask st = (StandardTask)iter.next();
                if (!st.ivVisible) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean hasOnlyVisibles(Vector sels) {
        if (sels != null) {
            Iterator iter = sels.iterator();
            while (iter.hasNext()) {
                StandardTask st = (StandardTask)iter.next();
                if (st.ivVisible) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void adaptTable(Vector oldObjects) {
        MTStandardTask mst = (MTStandardTask)this.ivTable.ivModel;
        Vector newObjects = StandardTask.getAllStandardTasks();
        Vector<StandardTask> setObjects = new Vector<StandardTask>();
        if (oldObjects != null && !oldObjects.isEmpty()) {
            int i = 0;
            while (i < oldObjects.size()) {
                StandardTask st = (StandardTask)oldObjects.elementAt(i);
                StandardTask nst = this.getMatchingTask(st, newObjects);
                if (nst != null) {
                    setObjects.add(nst);
                }
                ++i;
            }
        }
        setObjects.addAll(newObjects);
        newObjects.clear();
        newObjects = null;
        mst.setTable(setObjects, false);
        this.checkButtons();
    }

    private StandardTask getMatchingTask(StandardTask st, Vector newTasks) {
        int i = 0;
        while (i < newTasks.size()) {
            StandardTask nst = (StandardTask)newTasks.elementAt(i);
            if (nst.ivID == st.ivID && (st.isSystemTask() || st.isInstituteTask() || nst.getGroup().equals(st.getGroup()))) {
                newTasks.removeElementAt(i);
                return nst;
            }
            ++i;
        }
        return null;
    }

    public void actionPerformed(ActionEvent e) {
        String com = e.getActionCommand();
        if (Privileges.hasPrivilege(com)) {
            if (com.equals(COM_CREATE_STANDARD_TASKS)) {
                StandardTaskRequester str = new StandardTaskRequester((Frame)WindowUtils.getJFrame(this), null);
                if (str.ivWarOK) {
                    Vector oldTasks = this.ivModel.ivObjects;
                    StandardTask.insertNewStandardTask(str.getDescription(), str.getSexRestriction(), str.getDateRestriction(), str.getAutocompletion(), str.getTriangleColor(), UserManager.getFirstGroup(), str.getAdditionalObjectID(), str.getSingleGroupOnly(), str.getMinimumAge(), str.getMaximumAge());
                    this.adaptTable(oldTasks);
                }
            } else if (com.equals(COM_CREATE_COMBINATION_TASK)) {
                Vector oldTasks = this.ivModel.ivObjects;
                CombiTaskRequester.createNewCombiTask(this.ivTable.getSelectedObjects(), UserManager.getFirstGroup());
                this.adaptTable(oldTasks);
            } else if (com.equals(COM_MODIFY_STANDARD_TASKS)) {
                Vector v = this.ivTable.getSelectedObjects();
                if (v != null && v.size() == 1) {
                    StandardTask st = (StandardTask)v.firstElement();
                    if (st.ivVisible && st.ivChangeable) {
                        if (st.isCombiTask()) {
                            Vector oldTasks = this.ivModel.ivObjects;
                            CombiTaskRequester.modifyCombiTask(st, st.getString("IDO_GROUP", ""));
                            this.adaptTable(oldTasks);
                        } else {
                            StandardTaskRequester str = new StandardTaskRequester((Frame)WindowUtils.getJFrame(this), st);
                            if (str.ivWarOK) {
                                boolean colChanged = false;
                                Color ntc = str.getTriangleColor();
                                Color otc = st.ivTriangleColor;
                                if (ntc == null && otc != null) {
                                    colChanged = true;
                                } else if (ntc != null && otc == null) {
                                    colChanged = true;
                                }
                                if (ntc != null && otc != null && !ntc.equals(otc)) {
                                    colChanged = true;
                                }
                                if (!(st.ivDescrBabel.equals(str.getDescription()) && st.ivSexRestriction.equals(str.getSexRestriction()) && st.getDateRestriction().equals(str.getDateRestriction()) && st.ivSingleGroupOnly == str.getSingleGroupOnly() && st.ivAutocompletion.equals(str.getAutocompletion()) && st.ivAdditionalObjectID == str.getAdditionalObjectID() && st.ivMinimumAge == str.getMinimumAge() && st.ivMaximumAge == str.getMaximumAge() && !colChanged)) {
                                    Vector oldTasks = this.ivModel.ivObjects;
                                    StandardTask.changeStandardTask(st.ivID, str.getDescription(), str.getSexRestriction(), str.getDateRestriction(), str.getAutocompletion(), str.getTriangleColor(), true, st.getString("IDO_GROUP", ""), str.getAdditionalObjectID(), str.getSingleGroupOnly(), str.getMinimumAge(), str.getMaximumAge());
                                    this.adaptTable(oldTasks);
                                }
                            }
                        }
                    }
                }
            } else if (com.equals(COM_DELETE_STANDARD_TASKS)) {
                this.setTasksVisible(false);
            } else if (com.equals(COM_REVITALIZE_STANDARD_TASKS)) {
                this.setTasksVisible(true);
            } else if (COM_CREATE_WORKLOW.equals(com)) {
                new WorkFlowRequester(WindowUtils.getJFrame(this), null).setVisible(true);
            }
        }
    }

    private void setTasksVisible(boolean visible) {
        Vector v = this.ivTable.getSelectedObjects();
        if (v != null && !v.isEmpty()) {
            Vector oldTasks = this.ivModel.ivObjects;
            Iterator iter = v.iterator();
            while (iter.hasNext()) {
                StandardTask st = (StandardTask)iter.next();
                if (!st.ivChangeable && (!st.isSystemTask() || !MausoleumClient.isHeadOfService()) || st.ivVisible == visible) continue;
                StandardTask.setVisibilityOfStandardTask(st.ivID, st.getString("IDO_GROUP", ""), visible);
            }
            this.adaptTable(oldTasks);
        }
    }
}

