/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.task.standards;

import de.hannse.netobjects.util.Babel;
import java.awt.Color;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import mausoleum.cage.colors.TaskColor;
import mausoleum.experiment.Experiment;
import mausoleum.experiment.ExperimentManager;
import mausoleum.gui.IntegerField;
import mausoleum.gui.MGButton;
import mausoleum.gui.PermanentLabel;
import mausoleum.helper.FontManager;
import mausoleum.main.MausoleumClient;
import mausoleum.requester.BasicRequester;
import mausoleum.requester.color.ColorRequester;
import mausoleum.task.standards.StandardTask;
import mausoleum.ui.UIDef;

public class StandardTaskRequester
extends BasicRequester
implements DocumentListener {
    private static final long serialVersionUID = 1L;
    private static final int BREITE = UIDef.getScaled(500);
    private static final int FIELD_HEIGHT = UIDef.LINE_HEIGHT + UIDef.getScaled(4);
    private static final int FIELD_WIDTH = UIDef.getScaled(260);
    private static final int FIELD_X = BREITE - UIDef.RAND - FIELD_WIDTH;
    private static final int COL1W;
    private static final int COL2W;
    private static final int COL3W;
    private static final int COL1X;
    private static final int COL2X;
    private static final int COL3X;
    private static final int NAMEFIELD_Y;
    private static final int SEXFIELD_Y;
    private static final int DATEFIELD_Y;
    private static final int MINIMUMAGE_Y;
    private static final int MAXIMUMAGE_Y;
    private static final int SINGLEFIELD_Y;
    private static final int AUTO_COMPL_Y;
    private static final int EXPERIMENT_Y;
    private static final int COLOR_Y;
    private static final int OKBUT_Y;
    private static final int HOEHE;
    private JTextField ivNameField = new JTextField();
    private JComboBox ivSexCombo = new JComboBox<String>(StandardTask.SEX_RESTRICTIONS_DISPLAY);
    private JComboBox ivDateCombo = new JComboBox<String>(StandardTask.DATE_RESTRICTIONS_DISPLAY);
    private JCheckBox ivSingleGroupBox = new JCheckBox();
    private JComboBox ivAutoCompletionCombo = new JComboBox<String>(MausoleumClient.isHeadOfService() ? StandardTask.AUTO_COMPLETIONS_DISPLAY_HEAD_OF_SERVICE : StandardTask.AUTO_COMPLETIONS_DISPLAY);
    private JComboBox ivExperimentCombo = null;
    private PermanentLabel ivExperimentLabel = null;
    private MGButton ivSetColorButton = new MGButton(String.valueOf(Babel.get("SETZEN")) + "...");
    private MGButton ivClearColorButton = new MGButton(Babel.get("LOESCHEN"));
    private JLabel ivColorLabel = new JLabel();
    private IntegerField ivMinimumAgeField = new IntegerField(true);
    private IntegerField ivMaximumAgeField = new IntegerField(true);
    public final StandardTask ivOriginal;
    public final long[] ivExperimentIDs;

    static {
        COL2W = COL1W = (FIELD_WIDTH - 2 * UIDef.INNER_RAND) / 3;
        COL3W = FIELD_WIDTH - 2 * UIDef.INNER_RAND - COL1W - COL2W;
        COL1X = FIELD_X;
        COL2X = COL1X + COL1W + UIDef.INNER_RAND;
        COL3X = COL2X + COL2W + UIDef.INNER_RAND;
        NAMEFIELD_Y = UIDef.RAND;
        SEXFIELD_Y = NAMEFIELD_Y + FIELD_HEIGHT + UIDef.INNER_RAND;
        DATEFIELD_Y = SEXFIELD_Y + FIELD_HEIGHT + UIDef.INNER_RAND;
        MINIMUMAGE_Y = DATEFIELD_Y + FIELD_HEIGHT + UIDef.INNER_RAND;
        MAXIMUMAGE_Y = MINIMUMAGE_Y + FIELD_HEIGHT + UIDef.INNER_RAND;
        SINGLEFIELD_Y = MAXIMUMAGE_Y + FIELD_HEIGHT + UIDef.INNER_RAND;
        AUTO_COMPL_Y = SINGLEFIELD_Y + FIELD_HEIGHT + UIDef.INNER_RAND;
        EXPERIMENT_Y = AUTO_COMPL_Y + FIELD_HEIGHT + UIDef.INNER_RAND;
        COLOR_Y = EXPERIMENT_Y + FIELD_HEIGHT + UIDef.INNER_RAND;
        OKBUT_Y = COLOR_Y + FIELD_HEIGHT + UIDef.RAND;
        HOEHE = OKBUT_Y + UIDef.BUT_HEIGHT + UIDef.RAND;
    }

    public StandardTaskRequester(Frame sender, StandardTask st) {
        super(sender, BREITE, HOEHE);
        this.ivOriginal = st;
        this.setTitle(Babel.get("EDIT_STANDARD_TASK"));
        this.ivNameField.setFont(FontManager.getFont("SSB12"));
        this.addPermanentLabel(Babel.get("MTST_DESCR"), UIDef.RAND, NAMEFIELD_Y, FIELD_HEIGHT);
        this.addAndApplyBounds(this.ivNameField, FIELD_X, NAMEFIELD_Y, FIELD_WIDTH, FIELD_HEIGHT);
        this.addPermanentLabel(Babel.get("TASK_SEX_RESTRICTION"), UIDef.RAND, SEXFIELD_Y, FIELD_HEIGHT);
        this.addAndApplyBounds(this.ivSexCombo, FIELD_X, SEXFIELD_Y, FIELD_WIDTH, FIELD_HEIGHT);
        this.addPermanentLabel(Babel.get("TASK_DATE_RESTRICTION"), UIDef.RAND, DATEFIELD_Y, FIELD_HEIGHT);
        this.addAndApplyBounds(this.ivDateCombo, FIELD_X, DATEFIELD_Y, FIELD_WIDTH, FIELD_HEIGHT);
        this.addPermanentLabel(Babel.get("MINIMUM_AGE"), UIDef.RAND, MINIMUMAGE_Y, FIELD_HEIGHT);
        this.addAndApplyBounds(this.ivMinimumAgeField, FIELD_X, MINIMUMAGE_Y, FIELD_WIDTH, FIELD_HEIGHT);
        this.addPermanentLabel(Babel.get("MAXIMUM_AGE"), UIDef.RAND, MAXIMUMAGE_Y, FIELD_HEIGHT);
        this.addAndApplyBounds(this.ivMaximumAgeField, FIELD_X, MAXIMUMAGE_Y, FIELD_WIDTH, FIELD_HEIGHT);
        this.ivSingleGroupBox.setSelected(this.ivOriginal != null && this.ivOriginal.ivSingleGroupOnly);
        this.ivSingleGroupBox.setOpaque(false);
        this.addPermanentLabel(Babel.get("TASK_SINGLE_GROUP"), UIDef.RAND, SINGLEFIELD_Y, FIELD_HEIGHT);
        this.addAndApplyBounds(this.ivSingleGroupBox, FIELD_X, SINGLEFIELD_Y, FIELD_HEIGHT, FIELD_HEIGHT);
        this.ivAutoCompletionCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (StandardTaskRequester.this.ivExperimentCombo != null) {
                    boolean acResult = StandardTaskRequester.this.acResultSelected();
                    StandardTaskRequester.this.ivExperimentLabel.setVisible(acResult);
                    StandardTaskRequester.this.ivExperimentCombo.setEnabled(acResult);
                    StandardTaskRequester.this.ivExperimentCombo.setVisible(acResult);
                    if (!acResult) {
                        StandardTaskRequester.this.ivExperimentCombo.setSelectedIndex(0);
                    }
                }
                StandardTaskRequester.this.repaint();
                StandardTaskRequester.this.setOKState();
            }
        });
        this.addPermanentLabel(Babel.get("TASK_AC_TITLE"), UIDef.RAND, AUTO_COMPL_Y, FIELD_HEIGHT);
        this.addAndApplyBounds(this.ivAutoCompletionCombo, FIELD_X, AUTO_COMPL_Y, FIELD_WIDTH, FIELD_HEIGHT);
        Vector v = ExperimentManager.cvInstance.getActualObjectVectorAllGroups();
        if (v == null) {
            v = new Vector();
        }
        String[] names = new String[v.size() + 1];
        this.ivExperimentIDs = new long[v.size() + 1];
        names[0] = "";
        this.ivExperimentIDs[0] = 0L;
        int i = 0;
        while (i < v.size()) {
            Experiment experiment = (Experiment)v.elementAt(i);
            names[i + 1] = experiment.getBrowseNameInclServicePrefix();
            this.ivExperimentIDs[i + 1] = experiment.getID();
            ++i;
        }
        this.ivExperimentCombo = new JComboBox<String>(names);
        this.ivExperimentCombo.setVisible(false);
        this.ivExperimentCombo.setEnabled(false);
        this.ivExperimentCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                StandardTaskRequester.this.setOKState();
            }
        });
        this.ivExperimentLabel = this.addPermanentLabel("   " + Babel.get("TASK_AC_EXPERIMENT"), UIDef.RAND, EXPERIMENT_Y, FIELD_HEIGHT);
        this.ivExperimentLabel.setVisible(false);
        this.addAndApplyBounds(this.ivExperimentCombo, FIELD_X, EXPERIMENT_Y, FIELD_WIDTH, FIELD_HEIGHT);
        this.addPermanentLabel(Babel.get("COLOR"), UIDef.RAND, COLOR_Y, FIELD_HEIGHT);
        this.ivColorLabel.setBorder(new EtchedBorder());
        if (this.ivOriginal != null && this.ivOriginal.ivTriangleColor != null) {
            this.ivColorLabel.setBackground(this.ivOriginal.ivTriangleColor);
            this.ivColorLabel.setOpaque(true);
            this.ivClearColorButton.setEnabled(true);
        } else {
            this.ivColorLabel.setBackground(null);
            this.ivColorLabel.setOpaque(false);
            this.ivClearColorButton.setEnabled(false);
        }
        this.addAndApplyBounds(this.ivColorLabel, COL1X, COLOR_Y, COL1W, FIELD_HEIGHT);
        this.ivSetColorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                Color col;
                Color orig = TaskColor.STANDARD_TASK_TRIANGLE_COLOR;
                if (StandardTaskRequester.this.ivColorLabel.isOpaque()) {
                    orig = StandardTaskRequester.this.ivColorLabel.getBackground();
                }
                if ((col = ColorRequester.getNewColor(orig, false)) != null) {
                    StandardTaskRequester.this.ivColorLabel.setBackground(col);
                    StandardTaskRequester.this.ivColorLabel.setOpaque(true);
                    StandardTaskRequester.this.ivClearColorButton.setEnabled(true);
                }
            }
        });
        this.addAndApplyBounds(this.ivSetColorButton, COL2X, COLOR_Y, COL2W, FIELD_HEIGHT);
        this.ivClearColorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                StandardTaskRequester.this.ivColorLabel.setBackground(null);
                StandardTaskRequester.this.ivColorLabel.setOpaque(false);
                StandardTaskRequester.this.ivClearColorButton.setEnabled(false);
            }
        });
        this.addAndApplyBounds(this.ivClearColorButton, COL3X, COLOR_Y, COL3W, FIELD_HEIGHT);
        this.applyBounds(this.ivOkButton, UIDef.RAND, OKBUT_Y, BREITE - 2 * UIDef.RAND, UIDef.BUT_HEIGHT);
        if (this.ivOriginal != null) {
            this.ivNameField.setText(this.ivOriginal.ivDescrBabel);
            int ind = -1;
            int i2 = 0;
            while (i2 < StandardTask.SEX_RESTRICTIONS.length) {
                if (StandardTask.SEX_RESTRICTIONS[i2].equals(this.ivOriginal.ivSexRestriction)) {
                    ind = i2;
                }
                ++i2;
            }
            if (ind != -1) {
                this.ivSexCombo.setSelectedIndex(ind);
            }
            this.ivMinimumAgeField.setText(this.ivOriginal.ivMinimumAge > 0 ? Integer.toString(this.ivOriginal.ivMinimumAge) : "");
            this.ivMaximumAgeField.setText(this.ivOriginal.ivMaximumAge > 0 ? Integer.toString(this.ivOriginal.ivMaximumAge) : "");
            ind = -1;
            i2 = 0;
            while (i2 < StandardTask.DATE_RESTRICTIONS.length) {
                if (StandardTask.DATE_RESTRICTIONS[i2].equals(this.ivOriginal.ivDateRestriction)) {
                    ind = i2;
                }
                ++i2;
            }
            if (ind != -1) {
                this.ivDateCombo.setSelectedIndex(ind);
            }
            ind = -1;
            String[] completionArray = MausoleumClient.isHeadOfService() ? StandardTask.AUTO_COMPLETIONS_HEAD_OF_SERVICE : StandardTask.AUTO_COMPLETIONS;
            int i3 = 0;
            while (i3 < completionArray.length) {
                if (completionArray[i3].equals(this.ivOriginal.ivAutocompletion)) {
                    ind = i3;
                }
                ++i3;
            }
            if (ind != -1) {
                this.ivAutoCompletionCombo.setSelectedIndex(ind);
                if (this.ivExperimentCombo != null && this.acResultSelected()) {
                    this.ivExperimentLabel.setVisible(true);
                    this.ivExperimentCombo.setVisible(true);
                    this.ivExperimentCombo.setEnabled(true);
                    ind = -1;
                    i3 = 0;
                    while (i3 < this.ivExperimentIDs.length) {
                        if (this.ivOriginal.ivAdditionalObjectID == this.ivExperimentIDs[i3]) {
                            ind = i3;
                        }
                        ++i3;
                    }
                    if (ind != -1) {
                        this.ivExperimentCombo.setSelectedIndex(ind);
                    }
                }
            }
        }
        this.ivNameField.getDocument().addDocumentListener(this);
        this.setVisible(true);
        this.setOKState();
    }

    private boolean acResultSelected() {
        if (this.ivExperimentCombo != null) {
            String ac = StandardTask.AUTO_COMPLETIONS[this.ivAutoCompletionCombo.getSelectedIndex()];
            return ac != null && ac.equals("TASK_AC_RESULT");
        }
        return false;
    }

    public void dispose() {
        super.dispose();
    }

    public boolean okAndNoWanted() {
        return false;
    }

    public boolean onlyOKWanted() {
        return true;
    }

    public String getDescription() {
        return this.ivNameField.getText().trim().replace('|', ' ');
    }

    public String getSexRestriction() {
        return StandardTask.SEX_RESTRICTIONS[this.ivSexCombo.getSelectedIndex()];
    }

    public boolean getSingleGroupOnly() {
        return this.ivSingleGroupBox.isSelected();
    }

    public int getMinimumAge() {
        return this.ivMinimumAgeField.getInt(-1);
    }

    public int getMaximumAge() {
        return this.ivMaximumAgeField.getInt(-1);
    }

    public String getDateRestriction() {
        return StandardTask.DATE_RESTRICTIONS[this.ivDateCombo.getSelectedIndex()];
    }

    public Color getTriangleColor() {
        return this.ivColorLabel.isOpaque() ? this.ivColorLabel.getBackground() : null;
    }

    public String getAutocompletion() {
        String[] completionArray = MausoleumClient.isHeadOfService() ? StandardTask.AUTO_COMPLETIONS_HEAD_OF_SERVICE : StandardTask.AUTO_COMPLETIONS;
        return completionArray[this.ivAutoCompletionCombo.getSelectedIndex()];
    }

    public long getAdditionalObjectID() {
        if (this.ivExperimentIDs != null && this.ivExperimentCombo != null && this.acResultSelected()) {
            return this.ivExperimentIDs[this.ivExperimentCombo.getSelectedIndex()];
        }
        return 0L;
    }

    private void setOKState() {
        boolean en;
        boolean bl = en = this.ivNameField.getText().trim().length() != 0;
        if (this.ivExperimentIDs != null && this.ivExperimentCombo != null && this.acResultSelected()) {
            en &= this.ivExperimentIDs[this.ivExperimentCombo.getSelectedIndex()] > 0L;
        }
        this.ivOkButton.setEnabled(en);
    }

    public void insertUpdate(DocumentEvent e) {
        this.setOKState();
    }

    public void removeUpdate(DocumentEvent e) {
        this.setOKState();
    }

    public void changedUpdate(DocumentEvent e) {
        this.setOKState();
    }
}

