/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.ui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import mausoleum.gui.ColorManager;
import mausoleum.helper.MausoleumImageStore;
import mausoleum.main.DefaultManager;
import mausoleum.ui.UIDef;

public class MausoleumSplitPaneDivider
extends BasicSplitPaneDivider {
    private static final long serialVersionUID = 695796910544414532L;
    private int ivWidth;
    private int ivHeight;
    private Image ivImage;
    private double ivAngle = Math.random() * 88.0 + 1.0;
    private double ivPercent = Math.random();

    public MausoleumSplitPaneDivider(BasicSplitPaneUI ui) {
        super(ui);
        this.dividerSize = UIDef.getScaled(16);
    }

    public void paint(Graphics g) {
        Rectangle r = this.getBounds();
        if (DefaultManager.getDesign().equals("PLAIN")) {
            Color c = ColorManager.getMausoColor("blueButton");
            if (c != null) {
                g.setColor(c);
                g.fillRect(0, 0, r.width, r.height);
            }
        } else {
            boolean newt = false;
            if (this.ivImage == null) {
                newt = true;
            } else if (r.width != this.ivWidth || r.height != this.ivHeight) {
                newt = true;
            }
            if (newt) {
                this.createImage(r);
            }
            if (this.ivImage != null) {
                g.drawImage(this.ivImage, 0, 0, null);
            }
        }
    }

    private void createImage(Rectangle r) {
        this.ivWidth = r.width;
        this.ivHeight = r.height;
        this.ivImage = new BufferedImage(r.width, r.height, 1);
        Graphics g = this.ivImage.getGraphics();
        while (g == null) {
            try {
                System.out.println(String.valueOf(this.getClass().getName()) + " waiting for ivImage");
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            g = this.ivImage.getGraphics();
        }
        MausoleumImageStore.drawImage(g, "blueButton", r, this.ivAngle, this.ivPercent);
        g.setColor(Color.white);
        g.drawLine(0, 0, r.width, 0);
        g.drawLine(0, 0, 0, r.height);
        g.setColor(Color.black);
        g.drawLine(1, r.height - 1, r.width - 1, r.height - 1);
        g.drawLine(r.width - 1, 1, r.width - 1, r.height - 1);
        int wh = r.width / 2;
        int hh = r.height / 2;
        if (g instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        g.setColor(Color.black);
        g.drawLine(wh - 2, hh - 1, wh - 2, hh + 1);
        g.drawLine(wh - 1, hh - 2, wh + 1, hh - 2);
        g.setColor(Color.white);
        g.drawLine(wh + 2, hh - 1, wh + 2, hh + 1);
        g.drawLine(wh - 1, hh + 2, wh + 1, hh + 2);
    }
}

