/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.ui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTextPaneUI;
import mausoleum.gui.ColorManager;
import mausoleum.helper.MausoleumImageStore;
import mausoleum.main.DefaultManager;

public class MausoleumTextPaneUI
extends BasicTextPaneUI {
    private JComponent ivComponent = null;
    private String ivImageKey = null;
    private Image ivBack = null;
    private double ivAngle = Math.random() * 88.0 + 1.0;
    private double ivPercent = Math.random();

    public static ComponentUI createUI(JComponent c) {
        return new MausoleumTextPaneUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        this.ivComponent = c;
    }

    public void setImageKey(String s) {
        this.ivImageKey = s;
        this.ivBack = null;
    }

    protected void paintBackground(Graphics g) {
        Rectangle r = this.ivComponent.getBounds();
        if (this.ivImageKey == null) {
            g.setColor(this.ivComponent.getBackground());
            g.fillRect(0, 0, r.width, r.height);
        } else if (DefaultManager.getDesign().equals("PLAIN")) {
            Color c = ColorManager.getMausoColor(this.ivImageKey);
            if (c != null) {
                g.setColor(c);
                g.fillRect(0, 0, r.width, r.height);
            }
        } else {
            boolean newt = false;
            if (this.ivBack == null) {
                newt = true;
            } else if (r.width != this.ivBack.getWidth(null) || r.height != this.ivBack.getHeight(null)) {
                newt = true;
            }
            if (newt) {
                this.ivBack = MausoleumImageStore.createBack(r, this.ivImageKey, this.ivAngle, this.ivPercent);
            }
            if (this.ivBack != null) {
                g.drawImage(this.ivBack, 0, 0, null);
            }
        }
    }
}

