/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.ui.table;

import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import mausoleum.gui.ScrollPaneHelper;
import mausoleum.ui.table.CopyableTable;
import mausoleum.ui.table.TablePopuMenu;
import mausoleum.ui.table.TableSortable;

public abstract class SortableTable
extends JTable
implements CopyableTable,
TableModel {
    private static final long serialVersionUID = 1234234L;
    public final Vector ivObjects = new Vector();
    private int ivLastSortedColumn = -1;
    private boolean ivInverted = false;
    public JScrollPane ivScrollPane = null;
    static /* synthetic */ Class class$0;

    public abstract Vector fillSortablesVector(int var1);

    public SortableTable() {
        super.setModel(this);
        this.ivScrollPane = new JScrollPane(this);
        super.getTableHeader().setReorderingAllowed(false);
        this.getTableHeader().addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                Point p = e.getPoint();
                int col = SortableTable.this.columnAtPoint(e.getPoint());
                int coll = SortableTable.this.columnAtPoint(new Point(p.x - 3, p.y));
                int colr = SortableTable.this.columnAtPoint(new Point(p.x + 3, p.y));
                if (col == coll && col == colr) {
                    SortableTable.this.sortColumn(col);
                }
            }
        });
        new TablePopuMenu(this, this.getAdditionalPopupMenuItems(), true);
    }

    public Vector getSelectedObjects() {
        Vector<Object> res = new Vector<Object>();
        int[] selrows = this.getSelectedRows();
        if (selrows != null) {
            int i = 0;
            while (i < selrows.length) {
                res.add(this.getObjectAtRow(selrows[i]));
                ++i;
            }
        }
        return res;
    }

    public void setObjects(Vector v) {
        if (this.ivObjects != v) {
            this.ivObjects.clear();
            if (v != null) {
                this.ivObjects.addAll(v);
            }
        }
        this.tableChanged(new TableModelEvent(this));
        this.ivScrollPane.repaint();
    }

    public void setObjectsAndSort(Vector v, int col) {
        this.setObjects(v);
        this.ivInverted = false;
        this.doSortColumn(col);
    }

    public void dispose() {
        this.ivObjects.clear();
    }

    public Vector getAdditionalPopupMenuItems() {
        return null;
    }

    public Object getObjectAtRow(int row) {
        if (this.ivObjects != null && row >= 0 && row < this.ivObjects.size()) {
            return this.ivObjects.elementAt(row);
        }
        return null;
    }

    public void addObject(Object o) {
        if (o != null) {
            this.ivObjects.addElement(o);
            this.resort();
        }
    }

    public void removeObject(Object o) {
        if (o != null) {
            this.ivObjects.removeElement(o);
            this.resort();
        }
    }

    public void sortColumn(int col) {
        if (col < 0 || col > this.getColumnCount()) {
            return;
        }
        this.ivInverted = col == this.ivLastSortedColumn ? !this.ivInverted : false;
        this.doSortColumn(col);
    }

    public void resort() {
        if (this.ivLastSortedColumn < 0 || this.ivLastSortedColumn > this.getColumnCount()) {
            return;
        }
        this.doSortColumn(this.ivLastSortedColumn);
    }

    public void doSortColumn(int col) {
        Vector toSort;
        if (this.getRowCount() > 1 && (toSort = this.fillSortablesVector(col)) != null) {
            int selRowVorher;
            if (this.ivInverted) {
                Collections.sort(toSort, TableSortable.INVERS_SORTER);
            } else {
                Collections.sort(toSort, TableSortable.NORM_SORTER);
            }
            int selRowNachher = selRowVorher = this.getSelectedRow();
            Vector newObjects = new Vector(this.ivObjects.size());
            int i = 0;
            while (i < toSort.size()) {
                TableSortable ts = (TableSortable)toSort.elementAt(i);
                newObjects.addElement(this.ivObjects.elementAt(ts.ivOrigPos));
                if (ts.ivOrigPos == selRowVorher) {
                    selRowNachher = i;
                }
                ts.dispose();
                ++i;
            }
            toSort.clear();
            toSort = null;
            this.ivObjects.clear();
            this.setObjects(newObjects);
            if (selRowNachher != -1 && selRowNachher != selRowVorher) {
                this.getSelectionModel().setSelectionInterval(selRowNachher, selRowNachher);
            }
            this.ivLastSortedColumn = col;
            this.repaint();
        }
    }

    public int getRowCount() {
        if (this.ivObjects == null) {
            return 0;
        }
        return this.ivObjects.size();
    }

    public boolean isCellEditable(int arg0, int arg1) {
        return false;
    }

    public void setValueAt(Object arg0, int arg1, int arg2) {
    }

    public Class getColumnClass(int arg0) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public void addTableModelListener(TableModelListener l) {
    }

    public void removeTableModelListener(TableModelListener l) {
    }

    public JTable getTable() {
        return this;
    }

    public int getAnzColHeaders() {
        return 1;
    }

    public int getAnzRowHeaders() {
        return 0;
    }

    public String getColHeader(int column, int headerRow) {
        if (headerRow == 0) {
            return this.getColumnName(column);
        }
        return "";
    }

    public String getRowHeader(int row, int headerColumn) {
        return "";
    }

    public String getStringValueAt(int col, int row) {
        return (String)this.getValueAt(row, col);
    }

    public void ensureSelectionIsVisible() {
        this.ensureIndexIsVisible(this.getSelectedRow());
    }

    public void ensureIndexIsVisible(int index) {
        if (index >= 0 || index < this.getRowCount() && this.ivScrollPane.getVerticalScrollBar() != null && this.ivScrollPane.getVerticalScrollBar().isVisible()) {
            ScrollPaneHelper.ensureVisibility(this.ivScrollPane.getVerticalScrollBar(), index, this.getRowCount());
        }
    }
}

