/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.ui.table;

import de.hannse.netobjects.util.Babel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.table.TableModel;
import mausoleum.helper.ClipboardObject;
import mausoleum.ui.table.CopyableTable;

public class TablePopuMenu
extends JPopupMenu {
    private static final long serialVersionUID = 18797846846L;
    private CopyableTable ivCopyableTable = null;

    public TablePopuMenu(CopyableTable copyableTable, Vector additionalMenuItems, boolean hasSelectedRow) {
        this.ivCopyableTable = copyableTable;
        this.ivCopyableTable.getTable().addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.isMetaDown()) {
                    TablePopuMenu.this.show(TablePopuMenu.this.ivCopyableTable.getTable(), e.getX(), e.getY());
                }
            }
        });
        JMenuItem item = new JMenuItem(Babel.get("COPYTABLE"));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TablePopuMenu.this.copyTable();
            }
        });
        this.add(item);
        if (hasSelectedRow) {
            item = new JMenuItem(Babel.get("COPYTABLESEL"));
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TablePopuMenu.this.copySelectedRow();
                }
            });
            this.add(item);
        }
        if (additionalMenuItems != null) {
            int i = 0;
            while (i < additionalMenuItems.size()) {
                this.add((JMenuItem)additionalMenuItems.elementAt(i));
                ++i;
            }
        }
    }

    private void copySelectedRow() {
        int row = this.ivCopyableTable.getTable().getSelectedRow();
        if (row != -1) {
            StringBuffer msb = new StringBuffer();
            msb.append(this.getColHeadString());
            msb.append(this.getRowString(row));
            ClipboardObject.manageCopy(null, msb.toString());
        }
    }

    private void copyTable() {
        StringBuffer msb = new StringBuffer();
        msb.append(this.getColHeadString());
        int row = 0;
        while (row < this.ivCopyableTable.getTable().getRowCount()) {
            msb.append(this.getRowString(row));
            ++row;
        }
        ClipboardObject.manageCopy(null, msb.toString());
    }

    private String getRowString(int row) {
        StringBuffer msb = new StringBuffer();
        int i = 0;
        while (i < this.ivCopyableTable.getAnzRowHeaders()) {
            msb.append(this.ivCopyableTable.getRowHeader(row, i)).append("\t");
            ++i;
        }
        TableModel tm = this.ivCopyableTable.getTable().getModel();
        int colCount = tm.getColumnCount();
        int col = 0;
        while (col < colCount) {
            msb.append(this.ivCopyableTable.getStringValueAt(col, row));
            if (col != colCount - 1) {
                msb.append("\t");
            }
            ++col;
        }
        msb.append("\n");
        return msb.toString();
    }

    private String getColHeadString() {
        StringBuffer msb = new StringBuffer();
        int chr = 0;
        while (chr < this.ivCopyableTable.getAnzColHeaders()) {
            int i = 0;
            while (i < this.ivCopyableTable.getAnzRowHeaders()) {
                msb.append("\t");
                ++i;
            }
            TableModel tm = this.ivCopyableTable.getTable().getModel();
            int colCount = tm.getColumnCount();
            int col = 0;
            while (col < colCount) {
                msb.append(this.ivCopyableTable.getColHeader(col, chr));
                if (col != colCount - 1) {
                    msb.append("\t");
                }
                ++col;
            }
            msb.append("\n");
            ++chr;
        }
        return msb.toString();
    }
}

