/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.util;

import de.hannse.netobjects.java.MCLK;
import de.hannse.netobjects.tools.StringHelper;
import java.util.Iterator;

public abstract class InstallationType {
    public static final int MODE_UNDEFINED = 0;
    public static final int MODE_MOUSE = 1;
    public static final int MODE_FISH = 2;
    private static final String TAG_NORMAL = "NORMAL";
    private static final String TAG_TGONLY = "TGONLY";
    private static final String TAG_TGPLUS = "TGPLUS";
    private static final String TAG_FISH = "FISH";
    private static String cvFoundType = null;
    private static boolean cvHasNormalMode = false;
    private static boolean cvHasTGMode = false;
    private static int cvAnimalMode = 0;
    private static int cvObfuscateMode = 0;

    public static synchronized boolean hasNormalMode() {
        if (cvFoundType == null) {
            InstallationType.checkType();
        }
        return cvHasNormalMode;
    }

    public static synchronized boolean hasTGMode() {
        if (cvFoundType == null) {
            InstallationType.checkType();
        }
        return cvHasTGMode;
    }

    public static synchronized boolean isFish() {
        if (cvAnimalMode == 0) {
            InstallationType.checkMode();
        }
        return cvAnimalMode == 2;
    }

    public static synchronized boolean isMouse() {
        if (cvAnimalMode == 0) {
            InstallationType.checkMode();
        }
        return cvAnimalMode == 1;
    }

    public static synchronized boolean useMatings() {
        return InstallationType.isMouse();
    }

    public static String getCapitalProgramName() {
        return InstallationType.isMouse() ? "MAUSOLEUM" : "FISHOLEUM";
    }

    public static String getNormalProgramName() {
        return InstallationType.isMouse() ? "Mausoleum" : "Fisholeum";
    }

    public static String obfuscate(String s) {
        if (s != null && cvObfuscateMode == 1) {
            s = StringHelper.crypt(s);
        }
        return s;
    }

    private static void checkMode() {
        cvAnimalMode = 1;
        Iterator iterator = MCLK.ec.iterator();
        while (iterator.hasNext() && cvFoundType == null) {
            String s = (String)iterator.next();
            if (s.startsWith("MODE:")) {
                if (!(s = s.substring("MODE:".length(), s.length())).equalsIgnoreCase(TAG_FISH)) continue;
                cvAnimalMode = 2;
                continue;
            }
            if (!s.startsWith("OBFUSCATE:")) continue;
            s = s.substring("OBFUSCATE:".length(), s.length());
            try {
                cvObfuscateMode = Integer.parseInt(s);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void checkType() {
        Iterator iterator = MCLK.ec.iterator();
        while (iterator.hasNext() && cvFoundType == null) {
            String s = (String)iterator.next();
            if (!s.startsWith("TYPE:")) continue;
            if ((s = s.substring("TYPE:".length(), s.length())).equalsIgnoreCase(TAG_NORMAL)) {
                cvFoundType = TAG_NORMAL;
                cvHasNormalMode = true;
                cvHasTGMode = false;
                return;
            }
            if (s.equalsIgnoreCase(TAG_TGONLY)) {
                cvFoundType = TAG_TGONLY;
                cvHasNormalMode = false;
                cvHasTGMode = true;
                return;
            }
            if (!s.equalsIgnoreCase(TAG_TGPLUS)) continue;
            cvFoundType = TAG_TGPLUS;
            cvHasNormalMode = true;
            cvHasTGMode = true;
            return;
        }
        cvFoundType = TAG_NORMAL;
        cvHasNormalMode = true;
        cvHasTGMode = false;
    }
}

