/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.util.calendar;

import de.hannse.netobjects.util.ArrayHelper;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.ConfigReader;
import de.hannse.netobjects.util.Log;
import de.hannse.netobjects.util.MyDate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.main.ProcessDefinition;

public class HolidayDef {
    private static final String TAG_MARKE = "MARKE";
    private static final String TAG_FIXED_DAY = "FIXED_DAY";
    private static final String TAG_FIXED_MONTH = "FIXED_MONTH";
    private static final String TAG_WEEKDAY = "WEEKDAY";
    private static final String TAG_WEEKDAY_NUMBER = "WD_NUMBER";
    private static final String TAG_FIXED_ANCHOR = "ANCHOR";
    private static final String TAG_DAYS_OFFSET = "DAYS_OFFSET";
    public static final String TAG_OSTERN = "OSTERSONNTAG";
    public static final String TAG_ADVENT = "ADVENT";
    public static final String POLISH_RULE_WE_MO = "WE-MO";
    public static final String POLISH_RULE_WE_DI = "WE-DI";
    public static final HashMap HOLIDAYS_BY_TAG = new HashMap(30);
    public String ivKennung;
    public HashMap ivBabel = new HashMap();
    public int ivFixedDay;
    public int ivFixedMonth;
    public int ivWeekday;
    public int ivWeekdayNumber;
    public String ivAnchorTag;
    public int ivDaysOffset;
    public int[] ivYearRestrictions;
    static /* synthetic */ Class class$0;

    static {
        if (ProcessDefinition.isClient()) {
            HashMap babels = new HashMap();
            Vector lines = ConfigReader.getLines("data/holidays64.txt", "|", true);
            if (lines != null) {
                Vector defLine = null;
                Iterator iterator = lines.iterator();
                while (iterator.hasNext()) {
                    Vector line = (Vector)iterator.next();
                    if (defLine == null) {
                        defLine = line;
                        continue;
                    }
                    HolidayDef.createHolydayDef(line, defLine, babels);
                }
            }
        }
    }

    public static HashMap getAnchors(int year) {
        HashMap<String, Integer> anchors = new HashMap<String, Integer>();
        anchors.put(TAG_OSTERN, new Integer(HolidayDef.osterSonntag(year)));
        anchors.put(TAG_ADVENT, new Integer(HolidayDef.advent(year)));
        return anchors;
    }

    public static int[] interpretYearRestrictions(String yearRestriction) {
        int[] res = null;
        String s = yearRestriction;
        if (s != null && s.length() != 0) {
            try {
                if (s.startsWith("-")) {
                    res = new int[]{-1, Integer.parseInt(s)};
                } else if (s.endsWith("-")) {
                    res = new int[]{Integer.parseInt(s), -1};
                } else if (s.contains("-")) {
                    int ind = s.indexOf("-");
                    res = new int[]{Integer.parseInt(s.substring(0, ind)), Integer.parseInt(s.substring(ind + 1, s.length()))};
                } else {
                    res = new int[]{Integer.parseInt(s)};
                }
            }
            catch (Exception e) {
                String string = "Problematic YearRestriction-Definition: " + yearRestriction;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("mausoleum.util.calendar.HolidayDef");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.error(string, null, clazz);
                return null;
            }
        }
        return res;
    }

    private static void createHolydayDef(Vector line, Vector defLine, HashMap babels) {
        babels.clear();
        String kennung = null;
        String anchor = null;
        int fixDay = -1;
        int fixMonth = -1;
        int weekday = -1;
        int weekdayNumber = -1;
        int daysOffset = -1;
        int i = 0;
        while (i < line.size()) {
            if (i < defLine.size()) {
                String def;
                String cont = (String)line.elementAt(i);
                if ((cont = cont.trim()).length() != 0 && (def = (String)defLine.elementAt(i)).length() != 0) {
                    try {
                        if (TAG_MARKE.equals(def)) {
                            kennung = cont;
                        } else if (TAG_FIXED_DAY.equals(def)) {
                            fixDay = Integer.parseInt(cont);
                        } else if (TAG_FIXED_MONTH.equals(def)) {
                            fixMonth = Integer.parseInt(cont);
                        } else if (TAG_WEEKDAY.equals(def)) {
                            weekday = ArrayHelper.findStringInArray(cont.toUpperCase().trim(), MyDate.WEEKDAYS);
                        } else if (TAG_WEEKDAY_NUMBER.equals(def)) {
                            weekdayNumber = Integer.parseInt(cont);
                        } else if (TAG_FIXED_ANCHOR.equals(def)) {
                            anchor = cont;
                        } else if (TAG_DAYS_OFFSET.equals(def)) {
                            daysOffset = Integer.parseInt(cont);
                        } else {
                            babels.put(def.toLowerCase(), cont);
                        }
                    }
                    catch (Exception e) {
                        String string = "Problematic HOLIDAY-Definition: " + line;
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("mausoleum.util.calendar.HolidayDef");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        Log.error(string, null, clazz);
                    }
                }
            }
            ++i;
        }
        if (kennung != null) {
            HolidayDef hd = new HolidayDef(kennung, fixDay, fixMonth, weekday, weekdayNumber, anchor, daysOffset, null, babels);
            HOLIDAYS_BY_TAG.put(hd.ivKennung, hd);
        }
    }

    private static int advent(int jahr) {
        int weihTage = MyDate.getTage(25, 12, jahr);
        int weihnachtWota = MyDate.getWochentag(weihTage);
        return weihTage - weihnachtWota - 1 - 21;
    }

    private static int osterSonntag(int jahr) {
        int tag;
        int monat = 3;
        int sGoNum = 1 + jahr % 19;
        int sCentury = 1 + jahr / 100;
        int sGregorian = 3 * sCentury / 4 - 12;
        int sClavi = (sCentury - (16 + (sCentury - 18) / 25)) / 3;
        int sExDays = 5 * jahr / 4 - (sGregorian + 10);
        int sEpact = (11 * sGoNum + 20 + sClavi - sGregorian) % 30;
        if (sEpact < 0) {
            sEpact += 30;
        }
        if (sEpact == 24 || sEpact == 25 && sGoNum > 11) {
            ++sEpact;
        }
        if ((tag = 44 - sEpact) < 21) {
            tag += 30;
        }
        if ((tag = tag + 7 - (sExDays + tag) % 7) > 31) {
            tag -= 31;
            monat = 4;
        }
        return MyDate.getTage(tag, monat, jahr);
    }

    public HolidayDef() {
    }

    public HolidayDef(String kennung, int fixDay, int fixMonth, int weekday, int weekdayNumber, String anchor, int daysOffset, int[] yearRestr, HashMap babels) {
        this.ivKennung = kennung;
        this.ivFixedDay = fixDay;
        this.ivFixedMonth = fixMonth;
        this.ivWeekday = weekday;
        this.ivWeekdayNumber = weekdayNumber;
        this.ivAnchorTag = anchor;
        this.ivDaysOffset = daysOffset;
        this.ivYearRestrictions = yearRestr;
        if (babels != null) {
            this.ivBabel.putAll(babels);
        }
    }

    public String getDisplay() {
        String name = (String)this.ivBabel.get(Babel.cvUserLangue);
        if (name == null) {
            name = (String)this.ivBabel.get("en");
        }
        if (name == null) {
            name = this.ivKennung;
        }
        return name;
    }

    public Integer getTageKey(int year, HashMap anchorsByTag, String polishRule) {
        int myDateInYear = this.getMyDateInYear(year, anchorsByTag, polishRule);
        return myDateInYear == Integer.MIN_VALUE ? null : new Integer(myDateInYear);
    }

    public int getMyDateInYear(int year, HashMap anchorsByTag, String polishRule) {
        int res = Integer.MIN_VALUE;
        if (this.ivAnchorTag != null) {
            Integer aI = (Integer)anchorsByTag.get(this.ivAnchorTag);
            res = aI != null ? aI + this.ivDaysOffset : Integer.MIN_VALUE;
        } else if (this.ivWeekday != -1) {
            int diff = this.ivWeekday - MyDate.getWochentag(1, this.ivFixedMonth, year);
            int n = diff = diff < 0 ? (diff += 7) : diff;
            if (this.ivWeekdayNumber > 0) {
                res = MyDate.getTage(1 + diff, this.ivFixedMonth, year) + (this.ivWeekdayNumber - 1) * 7;
            } else {
                int day = 1 + diff;
                while (MyDate.isTagExistent(day, this.ivFixedMonth, year)) {
                    day += 7;
                }
                res = MyDate.getTage(day += this.ivWeekdayNumber * 7, this.ivFixedMonth, year);
            }
        } else {
            res = MyDate.getTage(this.ivFixedDay, this.ivFixedMonth, year);
        }
        if (polishRule != null && res != Integer.MIN_VALUE) {
            if (POLISH_RULE_WE_MO.equalsIgnoreCase(polishRule)) {
                int wota = MyDate.getWochentag(res);
                if (wota == 5) {
                    res += 2;
                } else if (wota == 6) {
                    ++res;
                }
            } else if (POLISH_RULE_WE_DI.equalsIgnoreCase(polishRule)) {
                int wota = MyDate.getWochentag(res);
                if (wota == 5) {
                    res += 3;
                } else if (wota == 6) {
                    res += 2;
                }
            }
        }
        return res;
    }

    public boolean gibtsMich(int year) {
        if (this.ivYearRestrictions != null) {
            return this.ivYearRestrictions.length == 1 ? this.ivYearRestrictions[0] == year : (this.ivYearRestrictions[0] == -1 ? year <= this.ivYearRestrictions[1] : (this.ivYearRestrictions[1] == -1 ? year >= this.ivYearRestrictions[0] : year >= this.ivYearRestrictions[0] && year <= this.ivYearRestrictions[1]));
        }
        return true;
    }
}

