/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.util.calendar;

import de.hannse.netobjects.util.ConfigReader;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import mausoleum.main.ProcessDefinition;

public class HolidaySet
implements Comparable {
    private static final TreeMap SETS_BY_COUNTRY = new TreeMap();
    private String ivCountry = null;
    private String ivRegion = null;
    private HashSet ivTags = new HashSet();
    private boolean ivIsDefault = false;

    static {
        if (ProcessDefinition.isClient()) {
            boolean first = true;
            Vector lines = ConfigReader.getLines("data/holidaysSets64.txt", "|", true);
            if (lines != null) {
                Iterator iterator = lines.iterator();
                while (iterator.hasNext()) {
                    Vector line = (Vector)iterator.next();
                    if (first) {
                        first = false;
                        continue;
                    }
                    if (line.size() <= 2) continue;
                    new HolidaySet(line);
                }
            }
            new HolidaySet();
        }
    }

    public static Iterator getHDTagIterator(String country, String region) {
        HolidaySet hs;
        TreeMap regions;
        if (country != null && region != null && (regions = (TreeMap)SETS_BY_COUNTRY.get(country)) != null && (hs = (HolidaySet)regions.get(region)) != null) {
            return hs.ivTags.iterator();
        }
        return null;
    }

    public static void fillCountries(Vector target) {
        target.clear();
        target.addAll(SETS_BY_COUNTRY.keySet());
    }

    public static void fillRegions(String country, Vector target) {
        TreeMap regions;
        target.clear();
        if (country != null && (regions = (TreeMap)SETS_BY_COUNTRY.get(country)) != null) {
            target.addAll(regions.keySet());
        }
    }

    public static HolidaySet getSet(String country, String region) {
        TreeMap regions;
        if (country != null && region != null && (regions = (TreeMap)SETS_BY_COUNTRY.get(country)) != null) {
            return (HolidaySet)regions.get(region);
        }
        return null;
    }

    private HolidaySet() {
        this.ivCountry = "";
        this.ivRegion = "";
        this.ivIsDefault = true;
        this.sortIn();
    }

    private HolidaySet(Vector line) {
        this.ivCountry = ((String)line.elementAt(0)).trim();
        this.ivRegion = ((String)line.elementAt(1)).trim();
        int i = 2;
        while (i < line.size()) {
            String s = ((String)line.elementAt(i)).trim();
            if (s.length() != 0) {
                this.ivTags.add(s);
            }
            ++i;
        }
        this.sortIn();
    }

    private void sortIn() {
        TreeMap<String, HolidaySet> regions = (TreeMap<String, HolidaySet>)SETS_BY_COUNTRY.get(this.ivCountry);
        if (regions == null) {
            regions = new TreeMap<String, HolidaySet>();
            SETS_BY_COUNTRY.put(this.ivCountry, regions);
        }
        regions.put(this.ivRegion, this);
    }

    public int compareTo(Object o) {
        int res = 0;
        if (o instanceof HolidaySet) {
            HolidaySet hs = (HolidaySet)o;
            if (this.ivIsDefault) {
                res = -1;
            } else if (hs.ivIsDefault) {
                res = 1;
            } else {
                res = this.ivCountry.compareToIgnoreCase(hs.ivCountry);
                if (res == 0) {
                    res = this.ivRegion.compareToIgnoreCase(hs.ivRegion);
                }
            }
        }
        return res;
    }

    public boolean equals(Object obj) {
        if (obj instanceof HolidaySet) {
            HolidaySet hs = (HolidaySet)obj;
            return hs.ivCountry.equals(this.ivCountry) && hs.ivRegion.equals(this.ivRegion);
        }
        return super.equals(obj);
    }
}

