/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.util.calendar;

import de.hannse.netobjects.tools.FileManager;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.MyDate;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mausoleum.gui.MGButton;
import mausoleum.gui.RequesterPane;
import mausoleum.gui.SimpleLayoutManager;
import mausoleum.gui.WindowMinimalSizer;
import mausoleum.helper.FontManager;
import mausoleum.helper.MausoleumImageStore;
import mausoleum.helper.WindowUtils;
import mausoleum.requester.TablePickRequester;
import mausoleum.requester.calendar.WeekdayPanel;
import mausoleum.ui.UIDef;
import mausoleum.util.calendar.AddedHolidaysTable;
import mausoleum.util.calendar.HolidayDef;
import mausoleum.util.calendar.HolidayInfoTable;
import mausoleum.util.calendar.HolidaySet;
import mausoleum.util.calendar.InstituteHolidays;
import mausoleum.util.calendar.SpecifyPrivateHolidayDialog;

public class InstituteHolidayDialog
extends JDialog {
    private static final long serialVersionUID = 1123423234L;
    public static final Color ADDED_FOREGROUND = new Color(0, 0, 210);
    public static final Color PRIVATE_FOREGROUND = new Color(210, 0, 0);
    private static final int WEEKEND_HEIGHT = UIDef.getScaled(50);
    private static final int ADDED_TABLE_HEIGHT = UIDef.getScaled(180);
    private static final int MIN_BREITE = UIDef.getScaled(600);
    private static final int MIN_HOEHE = UIDef.getScaled(500);
    private static final Dimension STD_DIM = new Dimension(UIDef.getScaled(700), UIDef.getScaled(600));
    public static int cvThisYear;
    public static Vector cvAllYears;
    public static int cvSelectedYear;
    private static InstituteHolidayDialog cvInstance;
    private final Vector ivDisplayHolidays = new Vector();
    private final JComboBox ivYearComboBox;
    private final Vector ivCountryNames = new Vector();
    private final Vector ivRegionNames = new Vector();
    private final JList ivCountryList = new JList();
    private final JPanel ivCountryPane = new JPanel(new BorderLayout());
    private final JList ivRegionList = new JList();
    private final JPanel ivRegionPane = new JPanel(new BorderLayout());
    private final HolidayInfoTable ivHolidayInfoTable = new HolidayInfoTable();
    private final JPanel ivHolidayPane = new JPanel(new BorderLayout(UIDef.INNER_RAND, UIDef.INNER_RAND));
    private final JPanel ivAdditionalsPane = new JPanel(new BorderLayout());
    private AddedHolidaysTable ivAddedHolidaysTable = new AddedHolidaysTable();
    private MGButton ivAddDefinedButton = new MGButton(Babel.get("ADD_DEFINED_HOLIDAY"));
    private MGButton ivAddPrivateButton = new MGButton(Babel.get("ADD_PRIVATE_HOLIDAY"));
    private MGButton ivEditPrivateButton = new MGButton(Babel.get("EDIT_PRIVATE_HOLIDAY"));
    private MGButton ivRemoveHolidayButton = new MGButton(Babel.get("REMOVE_HOLIDAY"));
    private WeekdayPanel ivWeekendPanel = new WeekdayPanel(new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            if (InstituteHolidayDialog.this.ivMyDefinition != null && InstituteHolidayDialog.this.ivWeekendPanel != null) {
                ((InstituteHolidayDialog)InstituteHolidayDialog.this).ivMyDefinition.ivWeeklyOff = InstituteHolidayDialog.this.ivWeekendPanel.getPressedWeekdays();
            }
        }
    }, false);
    private JLabel ivListLabel = new JLabel();
    private MGButton ivOKButton = new MGButton(Babel.get("OK"));
    private MGButton ivNOButton = new MGButton(Babel.get("NO"));
    private ListCellRenderer ivCountryListRender = new ListCellRenderer(){

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                InstituteHolidayDialog.this.ivListLabel.setBackground(UIDef.SELECTED_BACKGROUND);
                InstituteHolidayDialog.this.ivListLabel.setOpaque(true);
            } else {
                InstituteHolidayDialog.this.ivListLabel.setBackground(null);
                InstituteHolidayDialog.this.ivListLabel.setOpaque(false);
            }
            String s = (String)value;
            if (s.length() == 0) {
                InstituteHolidayDialog.this.ivListLabel.setText(" - " + Babel.get("DEFAULT") + " - ");
            } else {
                InstituteHolidayDialog.this.ivListLabel.setText(" " + value.toString() + " ");
            }
            InstituteHolidayDialog.this.ivListLabel.setFont(FontManager.getFont("SSB11"));
            return InstituteHolidayDialog.this.ivListLabel;
        }
    };
    private InstituteHolidays ivMyDefinition;

    static {
        cvInstance = null;
        cvAllYears = new Vector();
        cvSelectedYear = cvThisYear = new MyDate((GregorianCalendar)new GregorianCalendar()).ivJahr;
        int i = cvThisYear - 20;
        while (i <= cvThisYear + 20) {
            cvAllYears.add(new Integer(i));
            ++i;
        }
    }

    public static void editDefinitions(Frame sender) {
        if (cvInstance == null) {
            cvInstance = new InstituteHolidayDialog(sender);
        }
        cvInstance.adaptToDefintion(InstituteHolidays.getSetting());
        WindowUtils.bringUpCenteredDialog(cvInstance, InstituteHolidayDialog.STD_DIM.width, InstituteHolidayDialog.STD_DIM.height, true);
    }

    private InstituteHolidayDialog(Frame sender) {
        super(sender, true);
        this.setTitle(Babel.get("EDIT_HOLIDAY_SETTINGS"));
        this.setIconImage(MausoleumImageStore.getLogo());
        this.ivCountryList.setSelectionMode(0);
        HolidaySet.fillCountries(this.ivCountryNames);
        this.ivCountryList.setListData(this.ivCountryNames);
        this.ivCountryList.setCellRenderer(this.ivCountryListRender);
        this.ivCountryList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    InstituteHolidayDialog.this.countryClicked();
                }
            }
        });
        this.ivRegionList.setSelectionMode(0);
        this.ivRegionList.setCellRenderer(this.ivCountryListRender);
        this.ivRegionList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    InstituteHolidayDialog.this.regionClicked();
                }
            }
        });
        this.ivYearComboBox = new JComboBox(cvAllYears);
        this.ivYearComboBox.setSelectedItem(new Integer(cvThisYear));
        this.ivYearComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                InstituteHolidayDialog.this.holidayDefinitionchanged();
            }
        });
        RequesterPane myPane = new RequesterPane(new SimpleLayoutManager(){

            public void layoutContainer(Container parent) {
                Dimension d = parent.getSize();
                int iw = d.width - 2 * UIDef.RAND;
                int ih = d.height - 2 * UIDef.RAND;
                int oh = ih - UIDef.BUT_HEIGHT - UIDef.INNER_RAND - WEEKEND_HEIGHT - UIDef.INNER_RAND - ADDED_TABLE_HEIGHT - UIDef.BUT_HEIGHT - UIDef.INNER_RAND;
                int lw = (iw - UIDef.INNER_RAND) * 2 / 5;
                int rw = iw - UIDef.INNER_RAND - lw;
                int x = UIDef.RAND;
                int y = UIDef.RAND;
                int oh2 = (oh - UIDef.INNER_RAND) * 3 / 5;
                int uh2 = oh - UIDef.INNER_RAND - oh2;
                InstituteHolidayDialog.this.ivCountryPane.setBounds(x, y, lw, oh2);
                InstituteHolidayDialog.this.ivRegionPane.setBounds(x, y + oh2 + UIDef.INNER_RAND, lw, uh2);
                InstituteHolidayDialog.this.ivHolidayPane.setBounds(x + UIDef.INNER_RAND + lw, y, rw, oh);
                InstituteHolidayDialog.this.ivAdditionalsPane.setBounds(x, y += oh + UIDef.INNER_RAND, iw, ADDED_TABLE_HEIGHT + UIDef.BUT_HEIGHT);
                InstituteHolidayDialog.this.ivWeekendPanel.setBounds(x, y += ADDED_TABLE_HEIGHT + UIDef.BUT_HEIGHT + UIDef.INNER_RAND, iw, WEEKEND_HEIGHT);
                lw = (iw - UIDef.INNER_RAND) / 2;
                rw = iw - UIDef.INNER_RAND - lw;
                InstituteHolidayDialog.this.ivOKButton.setBounds(x, y += WEEKEND_HEIGHT + UIDef.INNER_RAND, lw, UIDef.BUT_HEIGHT);
                InstituteHolidayDialog.this.ivNOButton.setBounds(x + lw + UIDef.INNER_RAND, y, rw, UIDef.BUT_HEIGHT);
            }
        });
        this.ivCountryPane.setOpaque(false);
        this.ivCountryPane.add("Center", new JScrollPane(this.ivCountryList));
        this.ivCountryPane.setBorder(UIDef.getTitleBorder("COUNTRY"));
        this.ivRegionPane.setOpaque(false);
        this.ivRegionPane.add("Center", new JScrollPane(this.ivRegionList));
        this.ivRegionPane.setBorder(UIDef.getTitleBorder("REGION"));
        this.ivHolidayPane.setOpaque(false);
        this.ivHolidayPane.setBorder(UIDef.getTitleBorder("HOLIDAYS"));
        this.ivHolidayPane.add("North", this.ivYearComboBox);
        this.ivHolidayInfoTable.setEnabled(false);
        this.ivHolidayPane.add("Center", new JScrollPane(this.ivHolidayInfoTable));
        this.ivAdditionalsPane.setOpaque(false);
        this.ivAdditionalsPane.setBorder(UIDef.getTitleBorder("ADDITIONAL_HOLIDAYS"));
        this.ivAddedHolidaysTable.getSelectionModel().setSelectionMode(0);
        this.ivAddedHolidaysTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    InstituteHolidayDialog.this.checkButs();
                }
            }
        });
        this.ivAdditionalsPane.add("Center", new JScrollPane(this.ivAddedHolidaysTable));
        JPanel butPan = new JPanel(new GridLayout(1, 4));
        butPan.setOpaque(false);
        this.ivAddDefinedButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                InstituteHolidayDialog.this.addDefineds();
            }
        });
        butPan.add(this.ivAddDefinedButton);
        this.ivAddPrivateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HolidayDef hd = SpecifyPrivateHolidayDialog.specifyPrivateHoliday(null);
                if (hd != null) {
                    ((InstituteHolidayDialog)InstituteHolidayDialog.this).ivMyDefinition.ivPrivateHolidayDefs.add(hd);
                    InstituteHolidayDialog.this.holidayDefinitionchanged();
                }
            }
        });
        butPan.add(this.ivAddPrivateButton);
        this.ivEditPrivateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HolidayDef hdi = SpecifyPrivateHolidayDialog.specifyPrivateHoliday(InstituteHolidayDialog.this.ivAddedHolidaysTable.getSelectedInfo());
                if (hdi != null) {
                    InstituteHolidayDialog.this.holidayDefinitionchanged();
                }
            }
        });
        butPan.add(this.ivEditPrivateButton);
        this.ivRemoveHolidayButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                InstituteHolidays.HolidayInfo hdi = InstituteHolidayDialog.this.ivAddedHolidaysTable.getSelectedInfo();
                if (hdi != null) {
                    if (hdi.ivMode == 2) {
                        ((InstituteHolidayDialog)InstituteHolidayDialog.this).ivMyDefinition.ivAdditionalHolidayTags.remove(hdi.ivHolidayDef.ivKennung);
                    } else if (hdi.ivMode == 3) {
                        ((InstituteHolidayDialog)InstituteHolidayDialog.this).ivMyDefinition.ivPrivateHolidayDefs.removeElement(hdi.ivHolidayDef);
                    }
                    InstituteHolidayDialog.this.holidayDefinitionchanged();
                }
            }
        });
        butPan.add(this.ivRemoveHolidayButton);
        this.ivAdditionalsPane.add("South", butPan);
        this.ivWeekendPanel.setBorder(UIDef.getTitleBorder("WEEKEND"));
        myPane.add(this.ivCountryPane);
        myPane.add(this.ivRegionPane);
        myPane.add(this.ivHolidayPane);
        myPane.add(this.ivAdditionalsPane);
        myPane.add(this.ivWeekendPanel);
        this.ivOKButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String def = InstituteHolidayDialog.this.ivMyDefinition.getTransport();
                FileManager.saveStringContentToServer("data/instHolidays.def", def, null, "service");
                InstituteHolidays.setSetting(InstituteHolidayDialog.this.ivMyDefinition);
                InstituteHolidayDialog.this.dispose();
            }
        });
        myPane.add(this.ivOKButton);
        this.ivNOButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                InstituteHolidayDialog.this.dispose();
            }
        });
        myPane.add(this.ivNOButton);
        this.setContentPane(myPane);
        new WindowMinimalSizer(this, MIN_BREITE, MIN_HOEHE, true);
    }

    private void adaptToDefintion(InstituteHolidays definition) {
        this.ivMyDefinition = definition != null ? new InstituteHolidays(definition) : new InstituteHolidays();
        String country = this.ivMyDefinition.ivCountry;
        String region = this.ivMyDefinition.ivRegion;
        if (country != null) {
            this.ivCountryList.setSelectedValue(country, true);
            this.countryClicked();
        }
        if (region != null) {
            int ind = this.ivRegionNames.indexOf(region);
            this.ivRegionList.setSelectedIndex(ind);
        }
        this.holidayDefinitionchanged();
        this.ivWeekendPanel.setPressedWeekdays(this.ivMyDefinition.ivWeeklyOff);
        this.checkButs();
        this.repaint();
    }

    private void checkButs() {
        InstituteHolidays.HolidayInfo hdi = this.ivAddedHolidaysTable.getSelectedInfo();
        this.ivEditPrivateButton.setEnabled(hdi != null && hdi.ivMode == 3);
        this.ivRemoveHolidayButton.setEnabled(hdi != null);
    }

    private void countryClicked() {
        int ind = this.ivCountryList.getSelectedIndex();
        this.ivMyDefinition.ivCountry = ind != -1 ? (String)this.ivCountryNames.elementAt(ind) : null;
        HolidaySet.fillRegions(this.ivMyDefinition.ivCountry, this.ivRegionNames);
        this.ivRegionList.setListData(this.ivRegionNames);
        this.ivRegionList.setSelectedIndex(0);
    }

    private void regionClicked() {
        int ind = this.ivRegionList.getSelectedIndex();
        this.ivMyDefinition.ivRegion = ind != -1 ? (String)this.ivRegionNames.elementAt(ind) : null;
        this.holidayDefinitionchanged();
    }

    private void holidayDefinitionchanged() {
        int year;
        cvSelectedYear = year = ((Integer)this.ivYearComboBox.getSelectedItem()).intValue();
        this.ivDisplayHolidays.clear();
        InstituteHolidays.fillHolidayNamesByDate(year, this.ivMyDefinition, null, this.ivDisplayHolidays, true, true);
        Collections.sort(this.ivDisplayHolidays);
        this.ivHolidayInfoTable.setObjectsAndSort(this.ivDisplayHolidays, 0);
        Vector v = new Vector();
        InstituteHolidays.fillHolidayNamesByDate(year, this.ivMyDefinition, null, v, false, false);
        InstituteHolidays.HolidayInfo selhdi = this.ivAddedHolidaysTable.getSelectedInfo();
        this.ivAddedHolidaysTable.setData(v);
        this.ivAddedHolidaysTable.select(selhdi);
        this.ivHolidayPane.repaint();
    }

    private void addDefineds() {
        HashMap anchors = HolidayDef.getAnchors(cvThisYear);
        TreeSet<String> schonda = new TreeSet<String>();
        Iterator iterator = this.ivDisplayHolidays.iterator();
        while (iterator.hasNext()) {
            InstituteHolidays.HolidayInfo hdi = (InstituteHolidays.HolidayInfo)iterator.next();
            schonda.add(hdi.ivHolidayDef.ivKennung);
        }
        Vector<InstituteHolidays.HolidayInfo> possibles = new Vector<InstituteHolidays.HolidayInfo>(100);
        Iterator iterator2 = HolidayDef.HOLIDAYS_BY_TAG.keySet().iterator();
        while (iterator2.hasNext()) {
            String key = (String)iterator2.next();
            if (schonda.contains(key)) continue;
            possibles.add(new InstituteHolidays.HolidayInfo((HolidayDef)HolidayDef.HOLIDAYS_BY_TAG.get(key), 0, cvThisYear, anchors, null));
        }
        anchors.clear();
        anchors = null;
        schonda.clear();
        schonda = null;
        Collections.sort(possibles);
        Vector selectedHolidays = TablePickRequester.pickFromList(null, new HolidayInfoTable(), possibles, "ADD_DEFINED_HOLIDAY_LONG", "HOLIDAYS", 2);
        if (selectedHolidays != null && !selectedHolidays.isEmpty()) {
            Iterator iterator3 = selectedHolidays.iterator();
            while (iterator3.hasNext()) {
                InstituteHolidays.HolidayInfo hdi = (InstituteHolidays.HolidayInfo)iterator3.next();
                this.ivMyDefinition.ivAdditionalHolidayTags.add(hdi.ivHolidayDef.ivKennung);
            }
            this.holidayDefinitionchanged();
        }
    }
}

