/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.util.calendar;

import de.hannse.netobjects.objectstore.IDObjectXMLHandler;
import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.tools.FileManager;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.util.ArrayHelper;
import de.hannse.netobjects.util.Log;
import de.hannse.netobjects.util.MyDate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import mausoleum.helper.DatumFormat;
import mausoleum.helper.Zeile;
import mausoleum.main.ProcessDefinition;
import mausoleum.util.calendar.HolidayDef;
import mausoleum.util.calendar.HolidaySet;

public class InstituteHolidays {
    private static final HashMap HOLIDAYS_BY_YEAR = new HashMap(30);
    private static InstituteHolidays cvInstance = null;
    public String ivCountry;
    public String ivRegion;
    public Vector ivAdditionalHolidayTags = new Vector();
    public Vector ivPrivateHolidayDefs = new Vector();
    public int[] ivWeeklyOff;
    static /* synthetic */ Class class$0;

    static {
        if (ProcessDefinition.isClient()) {
            HOLIDAYS_BY_YEAR.clear();
            String s = FileManager.getStringContentFromServer("data/instHolidays.def");
            cvInstance = s != null && s.length() != 0 ? new InstituteHolidays(s) : new InstituteHolidays();
        }
    }

    public static InstituteHolidays getSetting() {
        return cvInstance;
    }

    public static void setSetting(InstituteHolidays ih) {
        cvInstance = ih;
        InstituteHolidays.clearCache();
    }

    public static void clearCache() {
        Iterator iterator = HOLIDAYS_BY_YEAR.values().iterator();
        while (iterator.hasNext()) {
            TreeMap tm = (TreeMap)iterator.next();
            tm.clear();
        }
        HOLIDAYS_BY_YEAR.clear();
    }

    public static boolean isWeeklyDayOff(int weekday) {
        return ArrayHelper.findIndexInArray(weekday, InstituteHolidays.cvInstance.ivWeeklyOff) != -1;
    }

    public static TreeMap getHolidayNamesByDate(int year) {
        Integer key = new Integer(year);
        TreeMap holidayNamesByDate = (TreeMap)HOLIDAYS_BY_YEAR.get(key);
        if (holidayNamesByDate == null) {
            holidayNamesByDate = new TreeMap();
            InstituteHolidays.fillHolidayNamesByDate(year, cvInstance, holidayNamesByDate, null, true, true);
            HOLIDAYS_BY_YEAR.put(key, holidayNamesByDate);
        }
        return holidayNamesByDate;
    }

    public static void fillHolidayNamesByDate(int year, InstituteHolidays intHolidays, TreeMap targetForNames, Vector targetForInfos, boolean checkYear, boolean withSet) {
        Iterator iterator2;
        HashMap anchors = HolidayDef.getAnchors(year);
        if (withSet && intHolidays != null && intHolidays.ivCountry != null && intHolidays.ivRegion != null) {
            Iterator iterator = HolidaySet.getHDTagIterator(intHolidays.ivCountry, intHolidays.ivRegion);
            while (iterator.hasNext()) {
                String polishRule = null;
                String feiertagKennung = (String)iterator.next();
                int ind = feiertagKennung.indexOf("|");
                if (ind != -1) {
                    polishRule = feiertagKennung.substring(ind + 1, feiertagKennung.length()).trim();
                    feiertagKennung = feiertagKennung.substring(0, ind).trim();
                }
                InstituteHolidays.addHolidayDef(1, (HolidayDef)HolidayDef.HOLIDAYS_BY_TAG.get(feiertagKennung), year, anchors, targetForNames, targetForInfos, feiertagKennung, checkYear, polishRule);
            }
        }
        if (intHolidays != null && intHolidays.ivAdditionalHolidayTags != null) {
            iterator2 = intHolidays.ivAdditionalHolidayTags.iterator();
            while (iterator2.hasNext()) {
                String feiertagKennung = (String)iterator2.next();
                InstituteHolidays.addHolidayDef(2, (HolidayDef)HolidayDef.HOLIDAYS_BY_TAG.get(feiertagKennung), year, anchors, targetForNames, targetForInfos, feiertagKennung, checkYear, null);
            }
        }
        if (intHolidays != null && intHolidays.ivPrivateHolidayDefs != null) {
            iterator2 = intHolidays.ivPrivateHolidayDefs.iterator();
            while (iterator2.hasNext()) {
                HolidayDef hdd = (HolidayDef)iterator2.next();
                InstituteHolidays.addHolidayDef(3, hdd, year, anchors, targetForNames, targetForInfos, "", checkYear, null);
            }
        }
    }

    private static void addHolidayDef(int mode, HolidayDef hdd, int year, HashMap anchors, TreeMap targetForNames, Vector targetForInfos, String feiertagKennung, boolean checkYear, String polishRule) {
        if (hdd == null) {
            String string = "Invalid Holiday-Tag " + feiertagKennung;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("mausoleum.util.calendar.HolidayDef");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.error(string, null, clazz);
        } else if (!checkYear || hdd.gibtsMich(year)) {
            if (targetForNames != null) {
                targetForNames.put(hdd.getTageKey(year, anchors, polishRule), hdd.getDisplay());
            } else if (targetForInfos != null) {
                targetForInfos.add(new HolidayInfo(hdd, mode, year, anchors, polishRule));
            }
        }
    }

    public InstituteHolidays() {
        this.ivCountry = "";
        this.ivRegion = "";
        this.ivWeeklyOff = new int[]{5, 6};
    }

    public InstituteHolidays(InstituteHolidays model) {
        this.ivCountry = model.ivCountry;
        this.ivRegion = model.ivRegion;
        this.ivAdditionalHolidayTags.addAll(model.ivAdditionalHolidayTags);
        Iterator iterator = model.ivPrivateHolidayDefs.iterator();
        while (iterator.hasNext()) {
            HolidayDef hdd = (HolidayDef)iterator.next();
            this.ivPrivateHolidayDefs.add(new HolidayDef(hdd.ivKennung, hdd.ivFixedDay, hdd.ivFixedMonth, hdd.ivWeekday, hdd.ivWeekdayNumber, hdd.ivAnchorTag, hdd.ivDaysOffset, hdd.ivYearRestrictions, hdd.ivBabel));
        }
        this.ivWeeklyOff = ArrayHelper.getCopy(model.ivWeeklyOff);
    }

    private InstituteHolidays(String transport) {
        Vector lines = StringHelper.splitStringByAny(transport, "\n");
        int li = 0;
        this.ivCountry = (String)IDObjectXMLHandler.getObject((String)lines.elementAt(li++), null, false);
        this.ivRegion = (String)IDObjectXMLHandler.getObject((String)lines.elementAt(li++), null, false);
        this.ivAdditionalHolidayTags = (Vector)IDObjectXMLHandler.getObject((String)lines.elementAt(li++), null, false);
        String privDef = (String)lines.elementAt(li++);
        if (privDef.length() != 0) {
            privDef = Base64Manager.getDecodedString(privDef);
            Vector pdLines = StringHelper.splitStringByAny(privDef, "\n");
            Iterator iterator = pdLines.iterator();
            while (iterator.hasNext()) {
                String pdLine = (String)iterator.next();
                Zeile z = new Zeile(pdLine, '|');
                String kennung = z.getStringB64(0, null);
                int fday = z.getInt(1, -1);
                int fmonth = z.getInt(2, -1);
                String yrs = z.getStringNONEmpty(3, null);
                int[] ysv = null;
                if (yrs != null) {
                    ysv = (int[])IDObjectXMLHandler.getObject(yrs, null, false);
                }
                this.ivPrivateHolidayDefs.add(new HolidayDef(kennung, fday, fmonth, -1, -1, null, -1, ysv, null));
            }
        }
        this.ivWeeklyOff = (int[])IDObjectXMLHandler.getObject((String)lines.elementAt(li++), null, false);
    }

    public String getTransport() {
        StringBuilder msb = new StringBuilder();
        msb.append(IDObjectXMLHandler.getTransport(this.ivCountry, false, true)).append("\n");
        msb.append(IDObjectXMLHandler.getTransport(this.ivRegion, false, true)).append("\n");
        msb.append(IDObjectXMLHandler.getTransport(this.ivAdditionalHolidayTags, false, true)).append("\n");
        if (!this.ivPrivateHolidayDefs.isEmpty()) {
            StringBuilder psb = new StringBuilder();
            Iterator iterator = this.ivPrivateHolidayDefs.iterator();
            while (iterator.hasNext()) {
                if (psb.length() != 0) {
                    psb.append("\n");
                }
                HolidayDef def = (HolidayDef)iterator.next();
                psb.append(Base64Manager.encodeBase64(def.ivKennung)).append("|");
                psb.append(Integer.toString(def.ivFixedDay)).append("|");
                psb.append(Integer.toString(def.ivFixedMonth)).append("|");
                psb.append(IDObjectXMLHandler.getTransport(def.ivYearRestrictions, false, true)).append("|");
            }
            msb.append(Base64Manager.encodeBase64(psb.toString()));
        }
        msb.append("\n");
        msb.append(IDObjectXMLHandler.getTransport(this.ivWeeklyOff, false, true)).append("\n");
        return msb.toString();
    }

    public static class HolidayInfo
    implements Comparable {
        public static final int MODE_SET = 1;
        public static final int MODE_ADDED_DEFINED = 2;
        public static final int MODE_ADDED_PRIVATE = 3;
        private int ivDate;
        public int ivMode;
        public HolidayDef ivHolidayDef;

        public HolidayInfo(HolidayDef hd, int mode, int year, HashMap anchors, String polishRule) {
            this.setValues(hd, mode, year, anchors, polishRule);
        }

        public void setValues(HolidayDef hd, int mode, int year, HashMap anchors, String polishRule) {
            this.ivDate = hd.getMyDateInYear(year, anchors, polishRule);
            this.ivMode = mode;
            this.ivHolidayDef = hd;
        }

        public int getDate() {
            return this.ivDate;
        }

        public String getDateDisplay() {
            return String.valueOf(DatumFormat.getJustDateString(this.ivDate)) + " (" + DatumFormat.weekday(MyDate.getWochentag(this.ivDate)) + ")";
        }

        public boolean equals(Object obj) {
            if (obj instanceof HolidayInfo) {
                HolidayInfo hdi = (HolidayInfo)obj;
                if (this.ivDate != hdi.ivDate) {
                    return false;
                }
                if (this.ivMode != hdi.ivMode) {
                    return false;
                }
                if (!this.ivHolidayDef.ivKennung.equals(hdi.ivHolidayDef.ivKennung)) {
                    return false;
                }
            }
            return super.equals(obj);
        }

        public int compareTo(Object o) {
            if (o instanceof HolidayInfo) {
                HolidayInfo hdi = (HolidayInfo)o;
                if (this.ivDate < hdi.ivDate) {
                    return -1;
                }
                if (this.ivDate > hdi.ivDate) {
                    return 1;
                }
                if (this.ivMode < hdi.ivMode) {
                    return -1;
                }
                if (this.ivMode > hdi.ivMode) {
                    return 1;
                }
            }
            return 0;
        }

        public String toString() {
            StringBuilder msb = new StringBuilder();
            msb.append(DatumFormat.getJustDateString(this.ivDate)).append(" ").append(this.ivHolidayDef.getDisplay());
            return msb.toString();
        }
    }
}

