/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.windows;

import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.RequestManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import mausoleum.gui.ImageComponent;
import mausoleum.helper.ClipboardObject;
import mausoleum.helper.FontManager;
import mausoleum.helper.ImageCreator;
import mausoleum.helper.MausoleumImageStore;
import mausoleum.helper.WindowUtils;
import mausoleum.result.MResultWrapper;
import mausoleum.ui.UIDef;

public class ImageLoaderWindow
extends JFrame
implements Runnable {
    private static final long serialVersionUID = 7848643153L;
    private Action ivCopyAction = new AbstractAction(Babel.get("COPY_SELECTED_INFO")){
        private static final long serialVersionUID = 1342556L;

        public void actionPerformed(ActionEvent e) {
            ImageLoaderWindow.this.copyImage();
        }
    };
    private KeyStroke ivCopyKS = KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
    private JLabel ivLabel = new JLabel(Babel.get("WAITING_FOR_IMAGE"));
    private ImageComponent ivComponent = new ImageComponent();
    private JScrollPane ivScrollPane = new JScrollPane(this.ivLabel);
    private String ivGroup;
    private long ivResultID;

    public ImageLoaderWindow(MResultWrapper wrapper) {
        super(Babel.get("IMAGE_FOR_RESULT"));
        this.ivGroup = wrapper.ivGroup;
        this.ivResultID = wrapper.ivMresult.ivPseudoID;
        this.setIconImage(MausoleumImageStore.getLogo());
        this.getContentPane().setLayout(new BorderLayout());
        this.ivLabel.setForeground(Color.black);
        this.ivLabel.setFont(FontManager.getFont("SSB22"));
        this.ivLabel.setHorizontalAlignment(0);
        this.getContentPane().add("Center", this.ivScrollPane);
        this.makeAction(this.ivCopyKS, this.ivCopyAction, "control S");
        this.ivComponent.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.isMetaDown()) {
                    JPopupMenu erg = new JPopupMenu();
                    JMenuItem item = new JMenuItem(ImageLoaderWindow.this.ivCopyAction);
                    item.setAccelerator(ImageLoaderWindow.this.ivCopyKS);
                    erg.add(item);
                    erg.show(ImageLoaderWindow.this.ivComponent, e.getX(), e.getY());
                }
            }
        });
        new Thread(this).start();
    }

    public void makeAction(KeyStroke ks, Action action, String keyStrokeAndKey) {
        this.ivComponent.getInputMap().put(ks, keyStrokeAndKey);
        this.ivComponent.getActionMap().put(keyStrokeAndKey, action);
    }

    public void run() {
        this.setSize(UIDef.getScaled(300), UIDef.getScaled(200));
        Vector v = (Vector)RequestManager.createSendAndGetObjectIfFinished((byte)20, new Long(this.ivResultID), this.ivGroup);
        if (v != null) {
            byte[] pixels = (byte[])v.elementAt(1);
            Dimension dim = (Dimension)v.elementAt(2);
            Image img = ImageCreator.createImageFromBytes(pixels, dim.width, dim.height);
            this.ivComponent.setPreferredSize(dim);
            this.ivComponent.setImage(img);
            this.ivScrollPane.setViewportView(this.ivComponent);
            WindowUtils.bringUpCenteredFrame(this, dim.width + 5, dim.height + 5, true);
        } else {
            this.ivLabel.setText(Babel.get("NO_IMAGE_AVAILABLE"));
            this.setVisible(true);
        }
    }

    public void copyImage() {
        Image img = this.ivComponent.getImage();
        if (img != null) {
            ClipboardObject.copy(img);
        }
    }
}

