/*
 * Decompiled with CFR 0.152.
 */
package de.hannse.netobjects.datalayer;

import de.hannse.netobjects.datalayer.DataFileEntry;
import de.hannse.netobjects.datalayer.DataFileHelper;
import de.hannse.netobjects.datalayer.GroupFileManager;
import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.IDObjectXMLHandler;
import de.hannse.netobjects.objectstore.ObjectConsumer;
import de.hannse.netobjects.objectstore.ObjectIndex;
import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.tools.FileManager;
import de.hannse.netobjects.util.Log;
import de.hannse.netobjects.util.MyDate;
import java.awt.Point;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.RandomAccessFile;
import java.util.Collections;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import mausoleum.helper.DatumFormat;
import mausoleum.mouse.Mouse;
import mausoleum.objectstore.DatabaseCheck;

public class DataFile {
    public static final int BLOCK_SIZE = 1024;
    public static final long BLOCK_SIZE_LONG = 1024L;
    private static final int ENTRY_HEADER_SIZE = 8;
    private static final int ENTRY_SIZE = 10;
    public static final int DATA_HEADER_SIZE = 16;
    public static final int DATA_DATA_SIZE = 1008;
    private final String ivGroupname;
    private final String ivTypeString;
    private final String ivFilename;
    private final String ivProtFilename;
    private final int ivType;
    private final Hashtable ivEntries = new Hashtable(100);
    private final byte[] ivReadBuffer = new byte[1024];
    public final byte[] ivWriteBuffer = new byte[1024];
    private int ivNextAvailableBlock = 1;
    private int ivLastEntryBlock = 0;
    private int ivLastEntryOffset = 8;
    private int ivMaximumID = 0;
    public boolean ivCheckMice = true;
    public boolean ivWriteProtocol = true;
    static /* synthetic */ Class class$0;

    public DataFile(String group, String typeString, int type) {
        this.ivTypeString = typeString;
        this.ivGroupname = group;
        this.ivFilename = GroupFileManager.getDataFilePath(group, typeString);
        this.ivProtFilename = GroupFileManager.getTypeProtocolPath(group, typeString);
        this.ivType = type;
        this.ivMaximumID = (int)IDObject.getMinimalID(type, group);
        File f = new File(this.ivFilename);
        if (f.exists()) {
            this.readEntries();
            this.ivNextAvailableBlock = (int)(f.length() / 1024L);
        } else {
            DataFileHelper.clearBuffer(this.ivWriteBuffer);
            try {
                FileOutputStream fos = new FileOutputStream(this.ivFilename);
                fos.write(this.ivWriteBuffer);
                fos.flush();
                fos.close();
            }
            catch (Throwable e) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("de.hannse.netobjects.datalayer.DataFile");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.error("Problem at DataFile Init: ", e, clazz);
            }
        }
    }

    public DataFile(String group, int type, String path) {
        this.ivGroupname = group;
        this.ivFilename = path;
        this.ivProtFilename = String.valueOf(this.ivFilename.substring(0, this.ivFilename.length() - ".data".length())) + ".prot";
        this.ivType = type;
        this.ivTypeString = null;
        this.ivMaximumID = (int)IDObject.getMinimalID(type, group);
        File f = new File(this.ivFilename);
        if (f.exists()) {
            this.readEntries();
            this.ivNextAvailableBlock = (int)(f.length() / 1024L);
        }
    }

    public void dispose() {
        this.ivEntries.clear();
    }

    public int getLastID() {
        return this.ivMaximumID;
    }

    public int getNewID() {
        ++this.ivMaximumID;
        return this.ivMaximumID;
    }

    public String getFilename() {
        return this.ivFilename;
    }

    public int getType() {
        return this.ivType;
    }

    public Point getCounts() {
        Point p = new Point(0, 0);
        Enumeration en = this.ivEntries.elements();
        while (en.hasMoreElements()) {
            DataFileEntry dfe = (DataFileEntry)en.nextElement();
            ++p.y;
            if (!dfe.ivAlive) continue;
            ++p.x;
        }
        return p;
    }

    public Enumeration getIDs() {
        return this.ivEntries.keys();
    }

    public Enumeration getAliveIDs() {
        Vector<Integer> hs = new Vector<Integer>(500);
        Iterator iterator = this.ivEntries.keySet().iterator();
        while (iterator.hasNext()) {
            Integer key = (Integer)iterator.next();
            if (!this.getEntry((Object)key).ivAlive) continue;
            hs.add(key);
        }
        return hs.elements();
    }

    public DataFileEntry getEntry(Object key) {
        return (DataFileEntry)this.ivEntries.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getObjects(boolean alsoDead, ObjectConsumer consumer, IDObject larve, Hashtable erg) {
        Hashtable hashtable = this.ivEntries;
        synchronized (hashtable) {
            try {
                RandomAccessFile raf = new RandomAccessFile(this.ivFilename, "r");
                Enumeration en = this.ivEntries.keys();
                while (en.hasMoreElements()) {
                    Integer idInti = (Integer)en.nextElement();
                    DataFileEntry dfe = (DataFileEntry)this.ivEntries.get(idInti);
                    if (!dfe.ivAlive && !alsoDead) continue;
                    try {
                        IDObject iob = this.readObject(dfe, raf, idInti.longValue(), larve);
                        if (iob == null || !iob.existed()) continue;
                        if (consumer != null) {
                            consumer.handleNewObject(iob);
                            continue;
                        }
                        if (erg == null) continue;
                        erg.put(new Long(iob.getID()), iob);
                    }
                    catch (Exception e) {
                        Log.error("Could not get actual Object: ", e, this);
                    }
                }
                raf.close();
            }
            catch (Throwable e) {
                Log.error("Could not get all actual Objects: ", e, this);
            }
            if (!alsoDead && erg != null) {
                Log.log("DF: " + this.ivGroupname + " " + this.ivTypeString + " T: " + this.ivEntries.size() + " A: " + erg.size(), this);
            }
        }
    }

    private void readEntries() {
        try {
            RandomAccessFile raf = new RandomAccessFile(this.ivFilename, "r");
            this.ivLastEntryBlock = 0;
            boolean cont = true;
            while (cont) {
                raf.readFully(this.ivReadBuffer);
                int nextBlock = DataFileHelper.readInt(this.ivReadBuffer, 0);
                int anzEntries = DataFileHelper.readInt(this.ivReadBuffer, 4);
                this.ivLastEntryOffset = 8;
                int i = 0;
                while (i < anzEntries) {
                    int id = DataFileHelper.readInt(this.ivReadBuffer, this.ivLastEntryOffset);
                    if (id > 0) {
                        if (id > this.ivMaximumID) {
                            this.ivMaximumID = id;
                        }
                        int firstBlock = DataFileHelper.readInt(this.ivReadBuffer, this.ivLastEntryOffset + 4);
                        byte alive = this.ivReadBuffer[this.ivLastEntryOffset + 8];
                        this.ivEntries.put(new Integer(id), new DataFileEntry(firstBlock, alive, this.ivLastEntryBlock, this.ivLastEntryOffset));
                    }
                    this.ivLastEntryOffset += 10;
                    ++i;
                }
                if (nextBlock == 0) {
                    cont = false;
                    continue;
                }
                raf.seek((long)nextBlock * 1024L);
                this.ivLastEntryBlock = nextBlock;
            }
            raf.close();
        }
        catch (Throwable e) {
            Log.error("DataFile Problem bei DataFile Init: ", e, this);
        }
    }

    public Hashtable getAllObjects() {
        return this.getObjects(true);
    }

    public void giveAllObjectsToConsumer(ObjectConsumer consumer) {
        this.getObjects(true, consumer, null, null);
    }

    public void giveAllObjectsToConsumerForCheck(ObjectConsumer consumer) {
        this.getObjects(true, consumer, IDObject.giveNewObjectOfType(this.ivType), null);
    }

    public Hashtable getAllActualObjects() {
        return this.getObjects(false);
    }

    public boolean hasActiveEntries() {
        Enumeration en = this.ivEntries.keys();
        while (en.hasMoreElements()) {
            Integer idInti = (Integer)en.nextElement();
            DataFileEntry dfe = (DataFileEntry)this.ivEntries.get(idInti);
            if (!dfe.ivAlive) continue;
            return true;
        }
        return false;
    }

    public Hashtable getObjects(boolean alsoDead) {
        Hashtable erg = new Hashtable(2000);
        this.getObjects(alsoDead, null, null, erg);
        return erg;
    }

    public Vector getSortedIDs() {
        Vector erg = new Vector();
        Enumeration en = this.ivEntries.keys();
        while (en.hasMoreElements()) {
            erg.add(en.nextElement());
        }
        Collections.sort(erg);
        return erg;
    }

    public Vector getSortedActualIDs() {
        Vector<Integer> erg = new Vector<Integer>();
        Enumeration en = this.ivEntries.keys();
        while (en.hasMoreElements()) {
            Integer idInti = (Integer)en.nextElement();
            DataFileEntry dfe = (DataFileEntry)this.ivEntries.get(idInti);
            if (!dfe.ivAlive) continue;
            erg.add(idInti);
        }
        Collections.sort(erg);
        return erg;
    }

    public String getGroup() {
        return this.ivGroupname;
    }

    public synchronized IDObject getObject(long ID) {
        int myID;
        DataFileEntry dfe;
        IDObject res = null;
        if (ID > 0L && (dfe = (DataFileEntry)this.ivEntries.get(new Integer(myID = (int)ID))) != null) {
            try {
                RandomAccessFile raf = new RandomAccessFile(this.ivFilename, "r");
                try {
                    res = this.readObject(dfe, raf, ID, null);
                }
                catch (Exception e) {
                    Log.error("Could not load Object . inner Problem " + ID + " from File", e, this);
                }
                raf.close();
            }
            catch (Throwable e) {
                Log.error("Could not load Object " + ID + " from File", e, this);
            }
        }
        return res;
    }

    public synchronized IDObject readObject(DataFileEntry dfe, RandomAccessFile raf, long id, IDObject larve) {
        int aktBlock = dfe.ivFirstBlock;
        byte[] gesBytes = null;
        int alreadyCopied = 0;
        try {
            ObjectInputStream ois;
            IDObject iob;
            ByteArrayInputStream bis;
            block24: {
                raf.seek((long)aktBlock * 1024L);
                boolean cont = true;
                while (cont) {
                    raf.readFully(this.ivReadBuffer);
                    if (gesBytes == null) {
                        gesBytes = new byte[DataFileHelper.readInt(this.ivReadBuffer, 12)];
                    }
                    int nextBlock = DataFileHelper.readInt(this.ivReadBuffer, 0);
                    int bytesInBlock = DataFileHelper.readInt(this.ivReadBuffer, 4);
                    System.arraycopy(this.ivReadBuffer, 16, gesBytes, alreadyCopied, bytesInBlock);
                    alreadyCopied += bytesInBlock;
                    if (nextBlock == 0) {
                        cont = false;
                        continue;
                    }
                    raf.seek((long)nextBlock * 1024L);
                    aktBlock = nextBlock;
                }
                bis = new ByteArrayInputStream(gesBytes);
                iob = null;
                ois = new ObjectInputStream(bis);
                if (larve != null) {
                    if (larve.ivProperties != null) {
                        larve.ivProperties.clear();
                        larve.ivProperties = null;
                    }
                    larve.ivProperties = (Hashtable)ois.readObject();
                    iob = larve;
                } else {
                    iob = IDObject.giveNewObjectOfType(this.ivType);
                    iob.ivProperties = (Hashtable)ois.readObject();
                    if (iob.getGroup(null) == null) {
                        iob.set("IDO_GROUP", this.ivGroupname);
                        iob.commit(false);
                    }
                    if (iob.get("IDO_TYPE_ID") == null) {
                        iob.set("IDO_TYPE_ID", new Integer(this.ivType));
                        iob.commit(false);
                    }
                    try {
                        Object ooo = ois.readObject();
                        if (ooo != null) {
                            String sessionInfo;
                            if (ooo instanceof Vector) {
                                iob.setSessions(new TreeSet((Vector)ooo));
                            } else if (ooo instanceof TreeSet) {
                                iob.setSessions((TreeSet)ooo);
                            } else if (ooo instanceof String && (sessionInfo = (String)ooo).length() != 0) {
                                iob.setSessions(IDObjectXMLHandler.getSessionTreset(sessionInfo));
                            }
                            break block24;
                        }
                        String string = "Session info object is null in object " + iob;
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = class$0 = Class.forName("de.hannse.netobjects.datalayer.DataFile");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        Log.log(string, clazz);
                    }
                    catch (Throwable e) {
                        Log.error("Missing session information for " + iob, e, this);
                        this.putObject(iob);
                    }
                }
            }
            ois.close();
            bis.close();
            iob.afterInit();
            if (this.ivCheckMice && iob instanceof Mouse) {
                iob = DatabaseCheck.checkMouse((Mouse)iob);
                ObjectIndex.checkMouseVersion((Mouse)iob);
            }
            return iob;
        }
        catch (Throwable e) {
            Log.error("Problem in file " + this.ivFilename + " Object-ID: " + id + "\n" + dfe + "\n------- readBuffer -------- \n" + Base64Manager.encodeBase64(this.ivReadBuffer) + "\n****\nCREATING SURROGATE\n****\n", e, this);
            try {
                IDObject iob = IDObject.giveNewObjectOfType(this.ivType);
                iob.setLong("IDO_ID", id);
                iob.setDate("IDO_START_DATE", System.currentTimeMillis());
                iob.setDate("IDO_END_DATE", System.currentTimeMillis());
                iob.setBoolean("IDO_NEVER_EXISTED", true);
                iob.setInt("IDO_TYPE_ID", this.ivType);
                iob.set("IDO_GROUP", this.ivGroupname);
                iob.commit(true);
                this.putObject(iob);
                FileManager.appendStringToServerFile(GroupFileManager.getSurrogateFilePath(this.ivGroupname), "Surrogate " + iob.getClass().getName() + " " + iob.getID() + " [" + DatumFormat.getDateTimeString(new MyDate(new GregorianCalendar())) + "]\n");
            }
            catch (Throwable thr) {
                Log.error("Problem beim Schreiben von Surrogat " + this.getFilename() + " ID " + id, thr, this);
            }
            return null;
        }
    }

    public synchronized boolean putObject(IDObject iob) {
        int objectID;
        byte[] objb = DataFileHelper.getObjectAsBytearray(iob);
        if (objb == null) {
            return false;
        }
        if (this.ivWriteProtocol && this.ivType != 5) {
            StringBuilder msb = new StringBuilder();
            msb.append(iob.get("IDO_ID")).append(";");
            msb.append(DatumFormat.getDateTimeString()).append(";");
            msb.append(IDObjectXMLHandler.getXMLString(iob, null, false, true, this.ivGroupname, true));
            FileManager.appendStringToServerFile(this.ivProtFilename, msb.toString());
        }
        if (this.ivType == 1 && this.ivCheckMice) {
            ObjectIndex.handle((Mouse)iob);
        }
        if ((objectID = (int)iob.getID()) > this.ivMaximumID) {
            this.ivMaximumID = objectID;
        }
        try {
            RandomAccessFile raf = new RandomAccessFile(this.ivFilename, "rw");
            DataFileEntry entry = (DataFileEntry)this.ivEntries.get(new Integer(objectID));
            if (entry != null) {
                if (entry.ivAlive) {
                    if (iob.isDead()) {
                        entry.ivAlive = false;
                        this.writeEntry(objectID, entry, raf);
                    }
                } else if (iob.isAlive()) {
                    entry.ivAlive = true;
                    this.writeEntry(objectID, entry, raf);
                }
                this.writeOldObject(objb, entry, raf, objectID);
            } else {
                if (this.ivLastEntryOffset + 10 > 1024) {
                    int merkBlock = this.ivLastEntryBlock;
                    this.ivLastEntryBlock = this.ivNextAvailableBlock++;
                    this.ivLastEntryOffset = 8;
                    DataFileHelper.writeInt(this.ivWriteBuffer, 0, this.ivLastEntryBlock);
                    raf.seek((long)merkBlock * 1024L);
                    raf.write(this.ivWriteBuffer, 0, 4);
                    DataFileHelper.clearBuffer(this.ivWriteBuffer);
                    raf.seek((long)this.ivLastEntryBlock * 1024L);
                    raf.write(this.ivWriteBuffer);
                }
                entry = new DataFileEntry(this.ivNextAvailableBlock++, iob.isAlive(), this.ivLastEntryBlock, this.ivLastEntryOffset);
                this.ivLastEntryOffset += 10;
                int anzEntries = (this.ivLastEntryOffset - 8) / 10;
                DataFileHelper.writeInt(this.ivWriteBuffer, 0, anzEntries);
                raf.seek((long)this.ivLastEntryBlock * 1024L + 4L);
                raf.write(this.ivWriteBuffer, 0, 4);
                this.writeEntry(objectID, entry, raf);
                this.ivEntries.put(new Integer(objectID), entry);
                this.writeNewObject(objb, entry, raf, objectID);
            }
            raf.close();
        }
        catch (Throwable e) {
            Log.error("Could not write Object\nCALL the Mausoleum Hotline", e, this);
            System.exit(0);
        }
        return true;
    }

    private void writeNewObject(byte[] objb, DataFileEntry dfe, RandomAccessFile raf, int ID) throws Exception {
        int geslen = objb.length;
        int alreadyWritten = 0;
        int aktBlock = dfe.ivFirstBlock;
        int nextBlock = 0;
        int bytesInBlock = 0;
        int rest = geslen;
        while (aktBlock != 0) {
            if (rest > 1008) {
                bytesInBlock = 1008;
                ++this.ivNextAvailableBlock;
            } else {
                bytesInBlock = rest;
                nextBlock = 0;
            }
            DataFileHelper.makeObjectHeader(this.ivWriteBuffer, nextBlock, bytesInBlock, ID, geslen);
            int i = 0;
            while (i < bytesInBlock) {
                this.ivWriteBuffer[16 + i] = objb[alreadyWritten + i];
                ++i;
            }
            raf.seek((long)aktBlock * 1024L);
            raf.write(this.ivWriteBuffer);
            alreadyWritten += bytesInBlock;
            rest -= bytesInBlock;
            aktBlock = nextBlock;
        }
    }

    private void writeOldObject(byte[] objb, DataFileEntry dfe, RandomAccessFile raf, int ID) throws Exception {
        int geslen = objb.length;
        int alreadyWritten = 0;
        int aktBlock = dfe.ivFirstBlock;
        int nextBlock = 0;
        int bytesInBlock = 0;
        int rest = geslen;
        boolean habeNochAlteBloecke = true;
        while (aktBlock != 0) {
            if (rest > 1008) {
                bytesInBlock = 1008;
                nextBlock = 0;
                if (habeNochAlteBloecke) {
                    raf.seek((long)aktBlock * 1024L);
                    raf.read(this.ivWriteBuffer, 0, 4);
                    nextBlock = DataFileHelper.readInt(this.ivWriteBuffer, 0);
                }
                if (nextBlock == 0 || nextBlock == aktBlock) {
                    nextBlock = this.ivNextAvailableBlock++;
                    habeNochAlteBloecke = false;
                }
            } else {
                bytesInBlock = rest;
                nextBlock = 0;
            }
            DataFileHelper.makeObjectHeader(this.ivWriteBuffer, nextBlock, bytesInBlock, ID, geslen);
            int i = 0;
            while (i < bytesInBlock) {
                this.ivWriteBuffer[16 + i] = objb[alreadyWritten + i];
                ++i;
            }
            raf.seek((long)aktBlock * 1024L);
            raf.write(this.ivWriteBuffer);
            alreadyWritten += bytesInBlock;
            rest -= bytesInBlock;
            aktBlock = nextBlock;
        }
    }

    private void writeEntry(int ID, DataFileEntry dfe, RandomAccessFile raf) throws Exception {
        DataFileHelper.writeInt(this.ivWriteBuffer, 0, ID);
        DataFileHelper.writeInt(this.ivWriteBuffer, 4, dfe.ivFirstBlock);
        this.ivWriteBuffer[8] = dfe.ivAlive ? (byte)1 : 0;
        this.ivWriteBuffer[9] = 0;
        raf.seek((long)dfe.ivEntryBlock * 1024L + (long)dfe.ivEntryOffset);
        raf.write(this.ivWriteBuffer, 0, 10);
    }
}

