/*
 * Decompiled with CFR 0.152.
 */
package de.hannse.netobjects.datalayer;

import de.hannse.netobjects.datalayer.GroupFileManager;
import de.hannse.netobjects.datalayer.SearchObject;
import de.hannse.netobjects.network.server.ServerCommunicator;
import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.IDObjectXMLHandler;
import de.hannse.netobjects.objectstore.ObjectConsumer;
import de.hannse.netobjects.objectstore.ObjectIndex;
import de.hannse.netobjects.objectstore.ObjectPortal;
import de.hannse.netobjects.objectstore.SearchProcess;
import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.tools.FileManager;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.user.User;
import de.hannse.netobjects.util.Log;
import de.hannse.netobjects.util.MyDate;
import java.awt.Dimension;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.cage.colors.GroupColor;
import mausoleum.datalayer.DataLayerMausoleum;
import mausoleum.datalayer.DataLayerMausoleumDB;
import mausoleum.db.DBAssistant;
import mausoleum.factsheets.groupreport.GroupStatistics;
import mausoleum.helper.DatumFormat;
import mausoleum.main.ProcessDefinition;
import mausoleum.util.InstallationType;
import mausoleum.util.PathStore;

public abstract class DataLayer {
    public static boolean USE_DB = false;
    public static final String SERVICE_GROUP = "service";
    public static final String TG_SERVICE_GROUP = "tgservice";
    public static final String NO_GROUP = "null";
    public static final String ADMIN_GOUP_USER = "Administrator";
    private static final int[] TYPES;
    private static final int[] TYPES_TG_SERVICE;
    private static final int[] TYPES_SERVICE;
    protected static final long NACHSCHAUZEIT = 43200000L;
    protected static final long BACKUPALTERUNGSZEIT = 604800000L;
    protected static final SicherDeleter SICHER_DEL;
    protected static final Vector BACKUP_WARTER;
    public static DataLayer cvDataLayer;
    public static boolean cvActive;
    public static boolean cvWriteSafetyFile;
    public static boolean cvBackupRunning;
    private final Vector ivGroupNames = GroupFileManager.initAndGetGroupnames();
    private final HashSet ivDisabledGroupNames = new HashSet();
    static /* synthetic */ Class class$0;

    static {
        SICHER_DEL = new SicherDeleter();
        BACKUP_WARTER = new Vector();
        cvActive = true;
        cvWriteSafetyFile = true;
        cvBackupRunning = false;
        Vector<Integer> v = new Vector<Integer>();
        v.add(new Integer(2));
        v.add(new Integer(1));
        v.add(new Integer(3));
        v.add(new Integer(5));
        v.add(new Integer(6));
        v.add(new Integer(10));
        v.add(new Integer(7));
        v.add(new Integer(14));
        v.add(new Integer(8));
        v.add(new Integer(11));
        v.add(new Integer(12));
        v.add(new Integer(16));
        v.add(new Integer(19));
        TYPES = new int[v.size()];
        int i = 0;
        while (i < TYPES.length) {
            DataLayer.TYPES[i] = (Integer)v.elementAt(i);
            ++i;
        }
        if (InstallationType.hasTGMode()) {
            v.clear();
            v.add(new Integer(2));
            v.add(new Integer(1));
            v.add(new Integer(3));
            v.add(new Integer(5));
            v.add(new Integer(6));
            v.add(new Integer(10));
            v.add(new Integer(7));
            v.add(new Integer(14));
            v.add(new Integer(8));
            v.add(new Integer(11));
            v.add(new Integer(12));
            v.add(new Integer(16));
            v.add(new Integer(19));
            v.add(new Integer(23));
            TYPES_TG_SERVICE = new int[v.size()];
            i = 0;
            while (i < TYPES_TG_SERVICE.length) {
                DataLayer.TYPES_TG_SERVICE[i] = (Integer)v.elementAt(i);
                ++i;
            }
        } else {
            TYPES_TG_SERVICE = null;
        }
        v.clear();
        v.add(new Integer(3));
        v.add(new Integer(5));
        v.add(new Integer(6));
        v.add(new Integer(10));
        v.add(new Integer(11));
        v.add(new Integer(22));
        v.add(new Integer(7));
        v.add(new Integer(14));
        v.add(new Integer(8));
        v.add(new Integer(16));
        v.add(new Integer(12));
        TYPES_SERVICE = new int[v.size()];
        i = 0;
        while (i < TYPES_SERVICE.length) {
            DataLayer.TYPES_SERVICE[i] = (Integer)v.elementAt(i);
            ++i;
        }
    }

    public static int[] getTypen(String group) {
        if (SERVICE_GROUP.equals(group)) {
            return TYPES_SERVICE;
        }
        if (TG_SERVICE_GROUP.equals(group)) {
            return TYPES_TG_SERVICE;
        }
        return TYPES;
    }

    public static boolean typeIsPossible(String group, int type) {
        int[] typen = DataLayer.getTypen(group);
        if (typen != null) {
            int i = 0;
            while (i < typen.length) {
                if (typen[i] == type) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static DataLayer getAppropriateDatalayer() {
        if (USE_DB) {
            return new DataLayerMausoleumDB();
        }
        return new DataLayerMausoleum();
    }

    public static void init(DataLayer instance) {
        cvDataLayer = instance;
    }

    public static void backup(MyDate md, HashSet excludeDirNames, Vector excludeFileSuffices) {
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("de.hannse.netobjects.datalayer.DataLayer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.log("Starting Statistics", clazz);
            GroupStatistics.saveStatisticsFromServerAllGroups();
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("de.hannse.netobjects.datalayer.DataLayer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.log("Statistics finished", clazz2);
        }
        catch (Exception e) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("de.hannse.netobjects.datalayer.DataLayer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.error("Problem writing Statistics", e, clazz);
        }
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("de.hannse.netobjects.datalayer.DataLayer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.log("Starting Backup", clazz);
            cvDataLayer.backupStarted();
            FileManager.zip(PathStore.getServerDir(), cvDataLayer.getBackupFilePath(md), excludeDirNames, excludeFileSuffices);
            if (!USE_DB) {
                ObjectIndex.rewriteIndices();
            }
            cvDataLayer.backupFinished();
            Class<?> clazz3 = class$0;
            if (clazz3 == null) {
                try {
                    clazz3 = class$0 = Class.forName("de.hannse.netobjects.datalayer.DataLayer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.log("Backup finished", clazz3);
        }
        catch (Throwable e) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("de.hannse.netobjects.datalayer.DataLayer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.error("Problem writing backup", e, clazz);
        }
    }

    public static boolean canBeDisabled(String group) throws Exception {
        return !cvDataLayer.hasActualObjects(group, 1) && !cvDataLayer.hasActualObjects(group, 2);
    }

    public static void digestSingleObject(IDObject ido) {
        Hashtable<String, IDObject> objectBag = new Hashtable<String, IDObject>();
        String key = IDObject.getIdentifierString(ido.getGroup(), ido.getTyp(), ido.getID());
        objectBag.put(key, ido);
        if (!USE_DB) {
            ObjectPortal.digestObjectBag(objectBag);
        }
        cvDataLayer.digestObjectBag(objectBag, ido.getGroup());
        objectBag.clear();
        objectBag = null;
    }

    private static String convertImageKeyToFilename(String key, String groupname) {
        return String.valueOf(GroupFileManager.getResultsPath(groupname)) + "/" + key + ".roi";
    }

    private static String convertImageKeyToThumbFilename(String key, String groupname) {
        return String.valueOf(GroupFileManager.getResultsPath(groupname)) + "/" + key + ".troi";
    }

    public DataLayer() {
        String disabledGroups = FileManager.getStringFromFile(GroupFileManager.getDisabledGroupsPath());
        if (disabledGroups != null) {
            Vector dgv = StringHelper.splitStringByAny(disabledGroups, "\n");
            Iterator iterator = dgv.iterator();
            while (iterator.hasNext()) {
                String line = (String)iterator.next();
                if ((line = line.trim()).length() == 0) continue;
                this.ivDisabledGroupNames.add(Base64Manager.getDecodedString(line));
            }
        }
    }

    public void setSingleGroupName(String singleGroup) {
        this.ivGroupNames.clear();
        this.ivGroupNames.addElement(singleGroup);
        this.ivDisabledGroupNames.clear();
    }

    public boolean isGroupEnabled(String group) {
        return this.getGroups(true).contains(group);
    }

    public Enumeration getAllGroupnames(boolean nurAktive) {
        return this.getGroups(nurAktive).elements();
    }

    public HashSet getAllGroupNamesSet(boolean nurAktive) {
        return new HashSet(this.getGroups(nurAktive));
    }

    public String[] getGroupStringArray(boolean nurAktive) {
        Vector v = this.getGroups(nurAktive);
        if (v.isEmpty()) {
            return new String[0];
        }
        String[] erg = new String[v.size()];
        int i = 0;
        while (i < v.size()) {
            erg[i] = (String)v.elementAt(i);
            ++i;
        }
        return erg;
    }

    public Vector getSortedGroupNames(boolean nurAktive) {
        Vector res = this.getGroups(nurAktive);
        Collections.sort(res, StringHelper.CASE_INSENSITIVE_COMPARER);
        return res;
    }

    public Vector getGroups(boolean nurAktive) {
        Vector<String> res = new Vector<String>(this.ivGroupNames.size());
        if (nurAktive) {
            Iterator iterator = this.ivGroupNames.iterator();
            while (iterator.hasNext()) {
                String name = (String)iterator.next();
                if (this.ivDisabledGroupNames.contains(name)) continue;
                res.add(name);
            }
        } else {
            res.addAll(this.ivGroupNames);
        }
        if (res.contains(NO_GROUP)) {
            res.remove(NO_GROUP);
        }
        return res;
    }

    public boolean enDisAbleGroup(String group, boolean enable) throws Exception {
        if (ProcessDefinition.isServer() && group != null) {
            if (enable && this.getGroups(false).contains(group) && this.ivDisabledGroupNames.contains(group)) {
                this.ivDisabledGroupNames.remove(group);
                this.saveDisableds();
                return true;
            }
            if (!enable && this.getGroups(true).contains(group) && !this.ivDisabledGroupNames.contains(group) && DataLayer.canBeDisabled(group)) {
                ServerCommunicator.killAllCommunicatorsOfGroup(group);
                this.ivDisabledGroupNames.add(group);
                this.saveDisableds();
                return true;
            }
        }
        return false;
    }

    public String getBackupFilePath(MyDate md) {
        GregorianCalendar greg = new GregorianCalendar();
        greg.setTimeInMillis(md.getTime());
        return String.valueOf(GroupFileManager.getBackupsPath()) + "/BackUp_All_" + DatumFormat.getBackupDateTimeString(greg) + ".zip";
    }

    public Vector loadImage(String groupname, String key) throws Exception {
        ObjectInputStream ois = new ObjectInputStream(new FileInputStream(DataLayer.convertImageKeyToFilename(key, groupname)));
        Vector<Object> erg = new Vector<Object>();
        erg.addElement(ois.readObject());
        erg.addElement(ois.readObject());
        erg.addElement(ois.readObject());
        ois.close();
        return erg;
    }

    public Vector loadThumbImage(String groupname, String key) throws Exception {
        ObjectInputStream ois = new ObjectInputStream(new FileInputStream(DataLayer.convertImageKeyToThumbFilename(key, groupname)));
        Vector<Object> erg = new Vector<Object>();
        erg.addElement(ois.readObject());
        erg.addElement(ois.readObject());
        ois.close();
        return erg;
    }

    public void storeImage(String groupname, String ofilename, byte[] data, Dimension d, String key) throws Exception {
        ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(DataLayer.convertImageKeyToFilename(key, groupname)));
        oos.writeObject(ofilename);
        oos.writeObject(data);
        oos.writeObject(d);
        oos.flush();
        oos.close();
    }

    public void storeThumbImage(String groupname, int[] data, Dimension d, String key) throws Exception {
        ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(DataLayer.convertImageKeyToThumbFilename(key, groupname)));
        oos.writeObject(data);
        oos.writeObject(d);
        oos.flush();
        oos.close();
    }

    public void backupStarted() {
        cvBackupRunning = true;
    }

    public void storeGroupName(String groupname) {
        this.ivGroupNames.addElement(groupname);
        GroupColor.fetchGroupnames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void backupFinished() {
        Vector vector = BACKUP_WARTER;
        synchronized (vector) {
            Iterator iterator = BACKUP_WARTER.iterator();
            while (iterator.hasNext()) {
                String s = (String)iterator.next();
                int ind = s.indexOf("|");
                if (ind == -1) continue;
                String group = s.substring(0, ind);
                String path = s.substring(ind + 1, s.length());
                Log.log("Enter data after backup: " + path, this);
                int ind1 = path.lastIndexOf("/");
                if (ind1 == -1) continue;
                this.enterSafetyInformation(path.substring(ind1 + 1, path.length()), group, false);
            }
            BACKUP_WARTER.clear();
        }
        Runtime.getRuntime().gc();
        cvBackupRunning = false;
    }

    public void commitSuicide() {
        SICHER_DEL.doit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void digestObjectBag(Hashtable objectBag, String group) {
        if (cvActive && objectBag != null && !objectBag.isEmpty()) {
            IDObject iob;
            Serializable msb;
            if (group == null) {
                group = SERVICE_GROUP;
            }
            String safetyFilePath = null;
            if (cvWriteSafetyFile) {
                msb = new StringBuilder(objectBag.size() * 200);
                Iterator iterator = objectBag.values().iterator();
                while (iterator.hasNext()) {
                    iob = (IDObject)iterator.next();
                    ((StringBuilder)msb).append(IDObjectXMLHandler.getXMLString(iob, null, true, false, null, true));
                }
                safetyFilePath = GroupFileManager.getNewSafetyFilePath(group);
                FileManager.saveStringToFile(safetyFilePath, ((StringBuilder)msb).toString());
            }
            if (cvBackupRunning) {
                if (safetyFilePath != null) {
                    msb = BACKUP_WARTER;
                    synchronized (msb) {
                        BACKUP_WARTER.add(String.valueOf(group) + "|" + safetyFilePath);
                    }
                }
            } else {
                boolean saveWarOK = true;
                if (cvActive) {
                    Enumeration en = objectBag.elements();
                    while (en.hasMoreElements() && saveWarOK) {
                        iob = (IDObject)en.nextElement();
                        saveWarOK &= this.saveIDObject(iob);
                    }
                } else {
                    saveWarOK = false;
                }
                if (safetyFilePath != null && saveWarOK) {
                    SICHER_DEL.addFile(safetyFilePath);
                }
            }
        }
    }

    protected void enterFromSafeties(String group) {
        Vector safetyFilePaths = GroupFileManager.collectSafetyFileNames(group);
        if (!safetyFilePaths.isEmpty()) {
            Collections.sort(safetyFilePaths);
            Iterator iter = safetyFilePaths.iterator();
            while (iter.hasNext()) {
                String file = (String)iter.next();
                Log.log("Datalayerfilesystem " + group + ": Reentering data from safety file " + file, this);
                this.enterSafetyInformation(file, group, true);
            }
        }
    }

    protected void enterSafetyInformation(String fileName, String group, boolean debugOutput) {
        String filepath = String.valueOf(GroupFileManager.getDataDirPath(group)) + "/" + fileName;
        try {
            String content = FileManager.getStringFromFile(filepath);
            if (content != null) {
                Vector lines = StringHelper.splitStringByAny(content, "\n");
                Iterator iter2 = lines.iterator();
                while (iter2.hasNext()) {
                    String line = (String)iter2.next();
                    if ((line = line.trim()).length() == 0) continue;
                    try {
                        Log.log("              ->  line   " + line, this);
                        IDObject ido = IDObjectXMLHandler.initSimpleObjectFromXMLString(line, group, true);
                        Log.log("              ->  object present " + ido.getIdentifierString(), this);
                        if (ido == null) continue;
                        int version = -1;
                        if (USE_DB) {
                            version = DBAssistant.getVersion(ido.getGroup(), ido.getTyp(), ido.getID(), -1);
                        } else {
                            IDObject schonDa = this.getObject(ido.getGroup(), ido.getTyp(), ido.getID(), false);
                            if (schonDa != null) {
                                version = ido.getInt("IDO_VERSION", -1);
                            }
                        }
                        if (version == -1 || ido.getInt("IDO_VERSION", 0) > version) {
                            ido.commit(false);
                            this.saveIDObject(ido);
                            Log.log("              ->  object " + ido, this);
                            Log.log("                  saved", this);
                            continue;
                        }
                        Log.log("                  not saved because later version of object detected", this);
                    }
                    catch (Exception e) {
                        Log.error("Datalayerfilesystem " + group + ": Could not extract Object from safety file " + line, e, this);
                    }
                }
            }
        }
        catch (Exception e) {
            Log.error("Datalayerfilesystem " + group + ": Reentering data from safety file " + filepath + " crashed", e, this);
        }
        FileManager.copy(String.valueOf(GroupFileManager.getDataDirPath(group)) + "/" + fileName, String.valueOf(GroupFileManager.getOldSafetiesPath(group)) + "/" + fileName);
        SICHER_DEL.addFile(String.valueOf(GroupFileManager.getDataDirPath(group)) + "/" + fileName);
    }

    protected static void clearOldBackupFiles(String dirname) {
        long now = System.currentTimeMillis();
        File f = new File(dirname);
        if (f.exists() && f.isDirectory()) {
            String[] files = f.list();
            int i = 0;
            while (i < files.length) {
                String newPath = String.valueOf(dirname) + "/" + files[i];
                File nf = new File(newPath);
                if (nf.exists() && nf.isDirectory()) {
                    DataLayer.clearOldBackupFiles(newPath);
                } else if (now - nf.lastModified() > 604800000L) {
                    try {
                        nf.delete();
                    }
                    catch (Exception e) {
                        String string = "DataLayerFileSystemMausoleum clearOldBackupFiles cannot delete " + newPath;
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("de.hannse.netobjects.datalayer.DataLayer");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        Log.error(string, e, clazz);
                    }
                }
                ++i;
            }
        }
    }

    private void saveDisableds() {
        if (this.ivDisabledGroupNames.isEmpty()) {
            FileManager.deleteFile(GroupFileManager.getDisabledGroupsPath());
        } else {
            StringBuilder msb = new StringBuilder();
            Iterator iterator = this.ivDisabledGroupNames.iterator();
            while (iterator.hasNext()) {
                String s = (String)iterator.next();
                msb.append(Base64Manager.encodeBase64(s)).append("\n");
            }
            FileManager.saveStringToFile(GroupFileManager.getDisabledGroupsPath(), msb.toString());
        }
    }

    public abstract Hashtable getAllActualObjects(String var1, int var2);

    public abstract Hashtable getAllObjects(String var1, int var2);

    public abstract void giveSuccesivelyAllObjectsForCheck(String var1, int var2, ObjectConsumer var3);

    public abstract int getLastID(String var1, int var2) throws Exception;

    public abstract IDObject getObject(String var1, int var2, long var3, boolean var5);

    public abstract boolean saveIDObject(IDObject var1);

    public abstract boolean provideNewIDToIDObject(IDObject var1);

    public abstract boolean addGroup(String var1, User var2) throws Exception;

    public abstract void deleteGroup(String var1);

    public abstract void performSearch(SearchObject var1, SearchProcess var2) throws Exception;

    public abstract Vector getSortedIDs(String var1, int var2);

    public abstract Vector getSortedActualIDs(String var1, int var2);

    public abstract boolean hasActualObjects(String var1, int var2) throws Exception;

    public abstract void initSingleGroupData(String var1);

    public static class SicherDeleter {
        private static Vector ivFilesToDelete = new Vector();

        public SicherDeleter() {
            Thread t = new Thread(new Runnable(this){
                final /* synthetic */ SicherDeleter this$1;
                {
                    this.this$1 = sicherDeleter;
                }

                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                Thread.sleep(60000L);
                                this.this$1.doit();
                            }
                        }
                        catch (Exception exception) {
                            continue;
                        }
                        break;
                    }
                }
            });
            t.setPriority(1);
            t.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addFile(String path) {
            Vector vector = ivFilesToDelete;
            synchronized (vector) {
                ivFilesToDelete.add(path);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doit() {
            Vector v = null;
            Vector vector = ivFilesToDelete;
            synchronized (vector) {
                if (!ivFilesToDelete.isEmpty()) {
                    v = new Vector(ivFilesToDelete.size());
                    v.addAll(ivFilesToDelete);
                    ivFilesToDelete.clear();
                }
            }
            if (v != null) {
                Iterator iterator = v.iterator();
                while (iterator.hasNext()) {
                    FileManager.deleteFile((String)iterator.next());
                }
            }
        }
    }
}

