/*
 * Decompiled with CFR 0.152.
 */
package de.hannse.netobjects.datalayer.dfa;

import de.hannse.netobjects.datalayer.DataFile;
import de.hannse.netobjects.datalayer.DataFileEntry;
import de.hannse.netobjects.datalayer.GroupFileManager;
import de.hannse.netobjects.datalayer.dfa.DFAscSub;
import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.tools.FileManager;
import de.hannse.netobjects.util.Log;
import java.io.File;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import mausoleum.datalayer.DataLayerMausoleum;

public class DFAConverter {
    private static Long NIX_LONG = new Long(Long.MIN_VALUE);
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        IDObject.init();
        Vector groupNames = GroupFileManager.initAndGetGroupnames();
        if (args.length == 1 && args[0].equalsIgnoreCase("convert")) {
            DFAConverter.clean(groupNames);
            long l1 = System.currentTimeMillis();
            HashMap obPaths = new HashMap();
            HashMap sessPaths = new HashMap();
            HashMap indexPaths = new HashMap();
            StringBuilder msb = new StringBuilder();
            StringBuilder inflSB = new StringBuilder();
            StringBuilder indexSB = new StringBuilder();
            Iterator iterator = groupNames.iterator();
            while (iterator.hasNext()) {
                DFAConverter.doConversion((String)iterator.next(), obPaths, sessPaths, indexPaths, msb, inflSB, indexSB);
            }
            long l2 = System.currentTimeMillis();
            System.out.println("Conversion took " + (l2 - l1) + " ms");
        } else if (args.length == 1 && args[0].equalsIgnoreCase("clean")) {
            long l1 = System.currentTimeMillis();
            DFAConverter.clean(groupNames);
            long l2 = System.currentTimeMillis();
            System.out.println("Cleaning took " + (l2 - l1) + " ms");
        }
        System.exit(0);
    }

    public static void clean(Vector groupNames) {
        Iterator iterator = groupNames.iterator();
        while (iterator.hasNext()) {
            String group = (String)iterator.next();
            System.out.println("Clean group " + group);
            String gdd = GroupFileManager.getDataDirPath(group);
            int[] typen = DataLayerMausoleum.getTypen(group);
            int i = 0;
            while (i < typen.length) {
                String fftss = IDObject.getFilenameForTypeServerSide(typen[i]);
                String possDataDir = String.valueOf(gdd) + "/" + fftss;
                File f = new File(possDataDir);
                if (f.exists() && f.isDirectory()) {
                    System.out.println("  ..  remove dir " + possDataDir);
                    FileManager.deleteDir(possDataDir, true);
                }
                ++i;
            }
        }
    }

    public static boolean isConvertNecessary(String group) {
        int[] typen = DataLayerMausoleum.getTypen(group);
        int i = 0;
        while (i < typen.length) {
            String typeString = IDObject.getFilenameForTypeServerSide(typen[i]);
            String filePath = GroupFileManager.getDataFilePath(group, typeString);
            if (new File(filePath).exists()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static void convertGroup(String group) {
        DFAConverter.doConversion(group, new HashMap(), new HashMap(), new HashMap(), new StringBuilder(), new StringBuilder(), new StringBuilder());
    }

    private static void doConversion(String group, HashMap obPaths, HashMap sessPaths, HashMap indexPaths, StringBuilder msb, StringBuilder inflSB, StringBuilder indexSB) {
        System.out.println("Convert group " + group);
        int[] typen = DataLayerMausoleum.getTypen(group);
        int i = 0;
        while (i < typen.length) {
            String typeString = IDObject.getFilenameForTypeServerSide(typen[i]);
            String filePath = GroupFileManager.getDataFilePath(group, typeString);
            if (new File(filePath).exists()) {
                System.out.println("  ..  Convert file " + typeString);
                DataFile df = new DataFile(group, typeString, typen[i]);
                df.ivCheckMice = false;
                int minID = Integer.MAX_VALUE;
                int maxID = Integer.MIN_VALUE;
                Enumeration en = df.getIDs();
                if (en.hasMoreElements()) {
                    obPaths.clear();
                    sessPaths.clear();
                    indexPaths.clear();
                    String dfaDir = String.valueOf(GroupFileManager.getDataDirPath(group)) + "/" + typeString;
                    FileManager.prepareDirs(dfaDir);
                    try {
                        RandomAccessFile raf = new RandomAccessFile(df.getFilename(), "r");
                        while (en.hasMoreElements()) {
                            Integer idInti = (Integer)en.nextElement();
                            DataFileEntry dfe = df.getEntry(idInti);
                            try {
                                String indexPath;
                                Long oMinID;
                                String dataPath;
                                IDObject ido = df.readObject(dfe, raf, idInti.longValue(), null);
                                if (ido == null || ido.getID() <= 0L) continue;
                                if (ido.getGroup(null) == null) {
                                    ido.set("IDO_GROUP", group);
                                    ido.commit(false);
                                }
                                if (ido.get("IDO_TYPE_ID") == null) {
                                    ido.set("IDO_TYPE_ID", new Integer(typen[i]));
                                    ido.commit(false);
                                }
                                if ((dataPath = (String)obPaths.get(oMinID = new Long(DFAscSub.getMatchingMinID(ido.getID(), typen[i])))) == null) {
                                    dataPath = DFAscSub.getDataPath(dfaDir, oMinID);
                                    obPaths.put(oMinID, dataPath);
                                }
                                if ((indexPath = (String)indexPaths.get(oMinID)) == null) {
                                    indexPath = DFAscSub.getIndexPath(dfaDir, oMinID);
                                    indexPaths.put(oMinID, indexPath);
                                }
                                String dataLine = DFAscSub.getLine(ido, msb, inflSB, indexSB, new File(dataPath).length());
                                FileManager.pureAppend(dataPath, dataLine);
                                FileManager.pureAppend(indexPath, indexSB.toString());
                                int idval = idInti;
                                if (idval > maxID) {
                                    maxID = idval;
                                }
                                if (idval >= minID) continue;
                                minID = idval;
                            }
                            catch (Exception e) {
                                String string = "Could not load Object . inner Problem " + idInti + " from File";
                                Class<?> clazz = class$0;
                                if (clazz == null) {
                                    try {
                                        clazz = Class.forName("de.hannse.netobjects.datalayer.dfa.DFAConverter");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                Log.error(string, e, clazz);
                            }
                        }
                        raf.close();
                        System.out.println("  ..  .. converted IDs: " + minID + " - " + maxID);
                    }
                    catch (Exception e) {
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("de.hannse.netobjects.datalayer.dfa.DFAConverter");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        Log.error("Could not load Objects from File", e, clazz);
                    }
                }
            }
            ++i;
        }
    }

    public static void saveOnlySessions(IDObject ido, TreeSet sessions) {
        if (sessions != null) {
            sessions.remove(NIX_LONG);
        }
        if (ido.storesSession() && sessions != null && !sessions.isEmpty()) {
            String typeString = IDObject.getFilenameForTypeServerSide(ido.getTyp());
            String dir = String.valueOf(GroupFileManager.getDataDirPath(ido.getGroup())) + "/" + typeString;
            FileManager.prepareDirs(dir);
            long minID = DFAscSub.getMatchingMinID(ido.getID(), ido.getTyp());
            String sessionPath = DFAscSub.getSessionPath(dir, minID);
            DFAscSub.saveSessions(ido, sessions, sessionPath);
        }
    }
}

