/*
 * Decompiled with CFR 0.152.
 */
package de.hannse.netobjects.datalayer.dfa;

import de.hannse.netobjects.datalayer.GroupFileManager;
import de.hannse.netobjects.datalayer.dfa.DFAscSub;
import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.ObjectConsumer;
import de.hannse.netobjects.objectstore.ObjectManagerCache;
import de.hannse.netobjects.objectstore.ObjectRequest;
import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.session.ShortSessionInfo;
import de.hannse.netobjects.tools.FileManager;
import de.hannse.netobjects.util.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import mausoleum.datalayer.DataLayerMausoleum;
import mausoleum.helper.Zeile;
import mausoleum.helper.ZeileAbstr;
import mausoleum.objectstore.IndexChecker;

public class DFAsc {
    public static final String DATA_FILE_SUFFIX = ".dasc";
    public static final String SESSION_FILE_SUFFIX = ".sasc";
    public static final String INDEX_FILE_SUFFIX = ".iasc";
    public static final String PROT_FILENAME = "prot.asc";
    public static final HashMap DFA_ASC_BY_GROUP_TYPE = new HashMap();
    public static boolean ivCheckMice = true;
    public static boolean ivWriteProtocol = true;
    private final int ivType;
    private final Integer ivTypeInteger;
    private final String ivDir;
    private final String ivGroup;
    private DFAscSub[] ivSubFiles = null;
    private long ivLastID = 0L;
    static /* synthetic */ Class class$0;

    public static void init(Vector groupNames) {
        Iterator iterator = groupNames.iterator();
        while (iterator.hasNext()) {
            String group = (String)iterator.next();
            String string = "Init group " + group;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("de.hannse.netobjects.datalayer.dfa.DFAsc");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.log(string, clazz);
            DFAsc.addGroup(group);
            Runtime.getRuntime().gc();
        }
    }

    public static void addGroup(String group) {
        int[] typen = DataLayerMausoleum.getTypen(group);
        int i = 0;
        while (i < typen.length) {
            long l1 = System.currentTimeMillis();
            new DFAsc(group, typen[i]);
            long l2 = System.currentTimeMillis();
            System.out.println(String.valueOf(group) + " - " + IDObject.getASCIILabelForType(typen[i]) + " took " + (l2 - l1) + " ms");
            ++i;
        }
    }

    public static boolean saveSession(IDObject ido, long sessionID) {
        if (ido.storesSession()) {
            return DFAsc.getSub(ido).saveSession(ido, sessionID);
        }
        return true;
    }

    public static boolean save(IDObject ido) {
        return DFAsc.getSub(ido).saveObject(ido, true);
    }

    public static Vector getObjects(String group, int type, long[] ids) {
        DFAsc contact;
        Vector<IDObject> v = new Vector<IDObject>(ids.length);
        if (ids != null && ids.length != 0 && (contact = (DFAsc)DFA_ASC_BY_GROUP_TYPE.get(String.valueOf(group) + ":" + type)) != null) {
            Integer typeI = new Integer(type);
            int i = 0;
            while (i < ids.length) {
                IDObject ooo;
                DFAscSub sub = contact.getMatching(ids[i], type, false, group);
                if (sub != null && (ooo = sub.getObject(ids[i], group, typeI, false, false)) != null) {
                    v.add(ooo);
                }
                ++i;
            }
        }
        return v;
    }

    public static IDObject getObject(String group, int type, long id, boolean onlyActual, boolean evenNonExisteds) {
        DFAscSub dfa;
        if (group == null || group.equals("null")) {
            String string = "Groupname is 'null' Type " + IDObject.getASCIILabelForType(type) + " ID " + id;
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("de.hannse.netobjects.datalayer.dfa.DFAsc");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.error(string, illegalArgumentException, clazz);
            return null;
        }
        DFAsc contact = (DFAsc)DFA_ASC_BY_GROUP_TYPE.get(String.valueOf(group) + ":" + type);
        if (contact == null) {
            contact = new DFAsc(group, type);
        }
        if ((dfa = contact.getMatching(id, type, false, group)) != null) {
            return dfa.getObject(id, group, contact.ivTypeInteger, onlyActual, evenNonExisteds);
        }
        return null;
    }

    public static String getTransport(String group, int type, long id) {
        DFAscSub sub = DFAsc.getSub(group, type, id, false);
        return sub == null ? null : sub.getTransport(id);
    }

    public static int getVersion(String group, int type, long id, int defaultValue) {
        DFAscSub sub;
        DFAsc contact = (DFAsc)DFA_ASC_BY_GROUP_TYPE.get(String.valueOf(group) + ":" + type);
        if (contact != null && (sub = contact.getMatching(id, type, false, group)) != null) {
            return sub.getVersion(id);
        }
        return defaultValue;
    }

    public static void addVersionsOfActuals(String group, int type, HashMap target) {
        DFAsc contact = (DFAsc)DFA_ASC_BY_GROUP_TYPE.get(String.valueOf(group) + ":" + type);
        if (contact != null) {
            int i = 0;
            while (i < contact.ivSubFiles.length) {
                if (contact.ivSubFiles[i] != null) {
                    contact.ivSubFiles[i].addVersionsOfActuals(target);
                }
                ++i;
            }
        }
    }

    public static int countActuals(String group, int type) {
        int sum = 0;
        DFAsc contact = (DFAsc)DFA_ASC_BY_GROUP_TYPE.get(String.valueOf(group) + ":" + type);
        if (contact != null) {
            int i = 0;
            while (i < contact.ivSubFiles.length) {
                if (contact.ivSubFiles[i] != null) {
                    sum += contact.ivSubFiles[i].countActuals();
                }
                ++i;
            }
        }
        return sum;
    }

    public static DFAsc getDFAsc(String group, int type) {
        return (DFAsc)DFA_ASC_BY_GROUP_TYPE.get(String.valueOf(group) + ":" + type);
    }

    public static TreeSet getSortedIDs(String group, int type, boolean all, boolean alive, boolean dead) {
        TreeSet ts = new TreeSet();
        DFAsc dfasc = (DFAsc)DFA_ASC_BY_GROUP_TYPE.get(String.valueOf(group) + ":" + type);
        if (dfasc != null) {
            int i = 0;
            while (i < dfasc.ivSubFiles.length) {
                if (dfasc.ivSubFiles[i] != null) {
                    dfasc.ivSubFiles[i].addIDs(ts, all, alive, dead);
                }
                ++i;
            }
        }
        return ts;
    }

    public static void getObjects(boolean alsoDead, ObjectConsumer consumer, IDObject larve, Hashtable erg, String group, int type) {
        DFAsc dfasc = (DFAsc)DFA_ASC_BY_GROUP_TYPE.get(String.valueOf(group) + ":" + type);
        if (dfasc != null) {
            dfasc.getObjectsDO(alsoDead, consumer, larve, erg, group, type);
        }
    }

    public static TreeSet getSessionIDs(String group, int typ, long id) {
        DFAscSub sub = DFAsc.getSub(group, typ, id, false);
        if (sub != null) {
            return sub.getSessionIDs(id);
        }
        return null;
    }

    public static boolean provideNewIDToIDObject(IDObject iob) {
        DFAsc dfasc = DFAsc.getDFAsc(iob.getGroup(), iob.getTyp());
        if (dfasc == null) {
            return false;
        }
        iob.set("IDO_ID", new Long(dfasc.getNewID()));
        return true;
    }

    public static DFAscSub getSubForRead(String group, int typ, long id) {
        DFAsc contact = (DFAsc)DFA_ASC_BY_GROUP_TYPE.get(String.valueOf(group) + ":" + typ);
        return contact != null ? contact.getMatching(id, typ, false, group) : null;
    }

    public static void getGenealogy(ObjectRequest or, String group, long id, boolean parents, int runden) {
        HashSet target = new HashSet(300);
        HashMap target2 = new HashMap(300);
        DFAsc dfasc = DFAsc.getDFAsc(group, 1);
        if (dfasc != null) {
            dfasc.collectRelatives(target, id, target2, parents ? 1 : 8, runden);
        }
        or.ivObject = target;
        or.ivExtraObject = target2;
    }

    public static void fillShortSessionInfos(String group, long userID, Vector target) {
        TreeMap<Long, ShortSessionInfo> tm = new TreeMap<Long, ShortSessionInfo>();
        String typeString = IDObject.getFilenameForTypeServerSide(5);
        String dir = String.valueOf(GroupFileManager.getDataDirPath(group)) + "/" + typeString;
        File f = new File(dir);
        if (f.exists() && f.isDirectory()) {
            String userIDKennung = String.valueOf(userID) + "'";
            String[] files = f.list();
            int i = 0;
            while (i < files.length) {
                if (files[i].endsWith(INDEX_FILE_SUFFIX)) {
                    try {
                        BufferedReader reader = new BufferedReader(new FileReader(String.valueOf(dir) + "/" + files[i]));
                        String line = reader.readLine();
                        while (line != null) {
                            long sessionID;
                            String index = ZeileAbstr.getPart(line, ObjectManagerCache.MAIN_SEP_C, DFAscSub.IF_COL_INDEX, null);
                            if (index != null && index.startsWith(userIDKennung) && (sessionID = ZeileAbstr.getLong(line, ObjectManagerCache.MAIN_SEP_C, DFAscSub.IF_COL_ID, 0L, 0L)) != 0L) {
                                Zeile z = new Zeile(line, '\'');
                                ShortSessionInfo ssi = new ShortSessionInfo(sessionID, userID, z.getLong(1, 0L), z.getLong(2, 0L), z.getInt(3, 0));
                                tm.put(new Long(sessionID), ssi);
                            }
                            line = reader.readLine();
                        }
                        reader.close();
                    }
                    catch (Exception e) {
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("de.hannse.netobjects.datalayer.dfa.DFAsc");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        Log.error("Problem reading session index", e, clazz);
                    }
                    if (!tm.isEmpty()) {
                        target.addAll(tm.values());
                        tm.clear();
                    }
                }
                ++i;
            }
        }
    }

    public static String getIndex(String group, long id) {
        DFAscSub sub = DFAsc.getSubForRead(group, 1, id);
        return sub != null ? sub.getIndex(id) : null;
    }

    public static HashSet getIndexIds(int indexCol, String group, Object key) {
        DFAsc dfasc;
        HashSet hs = null;
        if (indexCol > 0 && indexCol <= 9 && key != null && (dfasc = DFAsc.getDFAsc(group, 1)) != null) {
            String vgl = key.toString();
            String vglV = null;
            String vglH = null;
            String vglM = null;
            if (DFAscSub.isMultipleValueIndex(indexCol)) {
                vglV = String.valueOf(key.toString()) + "|";
                vglH = "|" + key.toString();
                vglM = "|" + key.toString() + "|";
            }
            hs = new HashSet(300);
            int i = 0;
            while (i < dfasc.ivSubFiles.length) {
                if (dfasc.ivSubFiles[i] != null) {
                    dfasc.ivSubFiles[i].addIndexIds(indexCol, vgl, vglV, vglM, vglH, hs);
                }
                ++i;
            }
        }
        return hs;
    }

    public static void giveIndicesToChecker(IndexChecker rep, String group) {
        DFAsc dfasc = DFAsc.getDFAsc(group, 1);
        if (dfasc != null) {
            int i = 0;
            while (i < dfasc.ivSubFiles.length) {
                if (dfasc.ivSubFiles[i] != null) {
                    dfasc.ivSubFiles[i].giveIndicesToChecker(rep);
                }
                ++i;
            }
        }
    }

    private static DFAscSub getSub(IDObject ido) {
        return DFAsc.getSub(ido.getGroup(), ido.getTyp(), ido.getID(), true);
    }

    private static DFAscSub getSub(String group, int type, long id, boolean setMax) {
        if (group.equals("null")) {
            String string = "Groupname is 'null' Type " + IDObject.getASCIILabelForType(type) + " ID " + id;
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("de.hannse.netobjects.datalayer.dfa.DFAsc");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.error(string, illegalArgumentException, clazz);
            return null;
        }
        DFAsc contact = (DFAsc)DFA_ASC_BY_GROUP_TYPE.get(String.valueOf(group) + ":" + type);
        if (contact == null) {
            contact = new DFAsc(group, type);
        }
        if (setMax) {
            contact.setMax(id);
        }
        return contact.getMatching(id, type, true, group);
    }

    private DFAsc(String group, int type) {
        this(group, type, null);
    }

    public DFAsc(String group, int type, String dataPath) {
        this.ivType = type;
        this.ivTypeInteger = new Integer(type);
        this.ivGroup = group;
        String typeString = IDObject.getFilenameForTypeServerSide(type);
        this.ivDir = String.valueOf(dataPath != null ? dataPath : GroupFileManager.getDataDirPath(group)) + "/" + typeString;
        FileManager.prepareDirs(this.ivDir);
        boolean filesDa = false;
        File f = new File(this.ivDir);
        String[] files = f.list();
        int i = 0;
        while (i < files.length) {
            long minid;
            if (files[i].endsWith(DATA_FILE_SUFFIX) && (minid = DFAscSub.getMinID(files[i])) != -1L) {
                this.put(minid, type, new DFAscSub(this.ivDir, type, minid, this, group));
                filesDa = true;
            }
            ++i;
        }
        if (!filesDa) {
            long minimalID = IDObject.getMinimalID(type, group);
            this.put(minimalID, type, new DFAscSub(this.ivDir, type, minimalID, this, group));
        }
        if (dataPath == null) {
            DFA_ASC_BY_GROUP_TYPE.put(String.valueOf(group) + ":" + type, this);
        }
    }

    public synchronized void setMax(long id) {
        if (id > this.ivLastID) {
            this.ivLastID = id;
        }
    }

    public void dispose() {
        this.ivSubFiles = null;
    }

    public int getLastID() {
        return (int)this.ivLastID;
    }

    public long getLastIDL() {
        return (int)this.ivLastID;
    }

    public long getFirstIDL() {
        if (this.ivSubFiles != null) {
            int i = 0;
            while (i < this.ivSubFiles.length) {
                if (this.ivSubFiles[i] != null) {
                    return this.ivSubFiles[i].getMinIDL();
                }
                ++i;
            }
        }
        return -1L;
    }

    public int getNewID() {
        ++this.ivLastID;
        return (int)this.ivLastID;
    }

    public boolean isObjectDa(long id) {
        DFAscSub sub = this.getMatching(id, this.ivType, false, this.ivGroup);
        return sub != null ? sub.isObjectDa(id) : false;
    }

    public boolean isObjectActual(long id) {
        DFAscSub sub = this.getMatching(id, this.ivType, false, this.ivGroup);
        return sub != null ? sub.isObjectActual(id) : false;
    }

    public boolean hasActiveObjects() {
        int i = this.ivSubFiles.length - 1;
        while (i >= 0) {
            if (this.ivSubFiles[i].hasActiveObjects()) {
                return true;
            }
            --i;
        }
        return false;
    }

    public void addObjectsForSpecialObject(String group, Integer type, Object spezObject, Vector target) {
        if (this.ivSubFiles != null) {
            int i = 0;
            while (i < this.ivSubFiles.length) {
                if (this.ivSubFiles[i] != null) {
                    this.ivSubFiles[i].addObjectsForSpecialObject(group, type, spezObject, target);
                }
                ++i;
            }
        }
    }

    public void getObjectsDO(boolean alsoDead, ObjectConsumer consumer, IDObject larve, Hashtable erg, String group, int type) {
        Integer typeI = new Integer(type);
        int i = 0;
        while (i < this.ivSubFiles.length) {
            if (this.ivSubFiles[i] != null) {
                this.ivSubFiles[i].getObjects(alsoDead, consumer, larve, erg, group, typeI);
            }
            ++i;
        }
    }

    public DFAscSub getMatching(long id, int type, boolean create, String group) {
        int posInSubArr = DFAscSub.getMatchingPosInSubArr(id, type);
        if (this.ivSubFiles != null && this.ivSubFiles.length > posInSubArr) {
            if (this.ivSubFiles[posInSubArr] == null && create) {
                this.ivSubFiles[posInSubArr] = new DFAscSub(this.ivDir, this.ivType, DFAscSub.getMatchingMinID(id, type), this, group);
            }
            return this.ivSubFiles[posInSubArr];
        }
        if (create) {
            DFAscSub res = new DFAscSub(this.ivDir, this.ivType, DFAscSub.getMatchingMinID(id, type), this, group);
            this.putInArray(posInSubArr, res);
            return res;
        }
        return null;
    }

    private void put(long minID, int type, DFAscSub sub) {
        int posInSubArr = DFAscSub.getMatchingPosInSubArr(minID, type);
        if (this.ivSubFiles != null && this.ivSubFiles.length > posInSubArr) {
            this.ivSubFiles[posInSubArr] = sub;
        } else {
            this.putInArray(posInSubArr, sub);
        }
    }

    private void putInArray(int posInSubArr, DFAscSub sub) {
        DFAscSub[] newArr = new DFAscSub[posInSubArr + 10];
        int i = 0;
        while (i < newArr.length) {
            newArr[i] = null;
            ++i;
        }
        if (this.ivSubFiles != null) {
            i = 0;
            while (i < this.ivSubFiles.length) {
                newArr[i] = this.ivSubFiles[i];
                ++i;
            }
        }
        newArr[posInSubArr] = sub;
        this.ivSubFiles = newArr;
    }

    private void collectRelatives(HashSet behandelteIDs, long mouseID, HashMap relativesByMouseID, int posInIndex, int runden) {
        Long mouseIDL = new Long(mouseID);
        behandelteIDs.add(mouseIDL);
        long[] srcVerwandtenIDs = this.getLongArr(mouseID, posInIndex);
        if (srcVerwandtenIDs != null && srcVerwandtenIDs.length != 0) {
            int anz = 0;
            int i = 0;
            while (i < srcVerwandtenIDs.length) {
                if (srcVerwandtenIDs[i] != 0L) {
                    ++anz;
                }
                ++i;
            }
            if (anz != 0) {
                long[] tgtVerwandtenIDs = new long[anz];
                int pos = 0;
                int i2 = 0;
                while (i2 < srcVerwandtenIDs.length) {
                    IDObject ido;
                    if (srcVerwandtenIDs[i2] != 0L && (ido = ObjectStore.getObjectDeadOrAlive(1, srcVerwandtenIDs[i2], this.ivGroup, null, false, true)) != null && !ido.neverExisted()) {
                        Long nid = new Long(srcVerwandtenIDs[i2]);
                        if (!behandelteIDs.contains(nid)) {
                            if (runden > 1) {
                                this.collectRelatives(behandelteIDs, srcVerwandtenIDs[i2], relativesByMouseID, posInIndex, runden - 1);
                            }
                            tgtVerwandtenIDs[pos++] = srcVerwandtenIDs[i2];
                        } else {
                            tgtVerwandtenIDs[pos++] = -srcVerwandtenIDs[i2];
                        }
                    }
                    ++i2;
                }
                relativesByMouseID.put(mouseIDL, tgtVerwandtenIDs);
            }
        }
    }

    private long[] getLongArr(long mouseID, int posInIndex) {
        String index;
        DFAscSub sub = this.getMatching(mouseID, 1, false, this.ivGroup);
        if (sub != null && (index = sub.getIndex(mouseID)) != null) {
            return ZeileAbstr.getLongArr(index, '\'', posInIndex, '|');
        }
        return null;
    }

    public static class DFActualIterator
    implements Iterator {
        private final TreeSet ivIDs;
        private final String ivGroup;
        private final int ivType;

        public DFActualIterator(String group, int typ) {
            this.ivGroup = group;
            this.ivType = typ;
            this.ivIDs = DFAsc.getSortedIDs(this.ivGroup, this.ivType, false, true, false);
        }

        public boolean hasNext() {
            return !this.ivIDs.isEmpty();
        }

        public Object next() {
            Long id = (Long)this.ivIDs.first();
            this.ivIDs.remove(id);
            return DFAsc.getObject(this.ivGroup, this.ivType, id, true, false);
        }

        public void remove() {
        }
    }
}

