/*
 * Decompiled with CFR 0.152.
 */
package de.hannse.netobjects.datalayer.dfa;

import de.hannse.netobjects.datalayer.dfa.DFAsc;
import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.IDObjectXMLHandler;
import de.hannse.netobjects.objectstore.ObjectConsumer;
import de.hannse.netobjects.objectstore.ObjectIndex;
import de.hannse.netobjects.objectstore.ObjectManagerCache;
import de.hannse.netobjects.session.Session;
import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.tools.FileManager;
import de.hannse.netobjects.util.Log;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.LineNumberReader;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import mausoleum.cage.Cage;
import mausoleum.cage.cagetalker.CageTalker;
import mausoleum.extras.StrInflDefl;
import mausoleum.helper.Zeile;
import mausoleum.helper.ZeileAbstr;
import mausoleum.mail.Mail;
import mausoleum.mouse.Mouse;
import mausoleum.objectstore.IndexChecker;

public class DFAscSub {
    private static final long OBJECTS_PER_SUB_MINIMUM = 100L;
    private static final int OBJECTS_PER_SUB_DEFAULT = 100;
    private static final int[] OBJECTS_PER_SUB_BY_TYPE = new int[50];
    private static final int MIN_NUM_LENGTH = 7;
    public static int IF_COL_ID = 0;
    public static int IF_COL_VERSION = 1;
    public static int IF_COL_ACTIVE = 2;
    public static int IF_COL_POSITION = 3;
    public static int IF_COL_DATE = 4;
    public static int IF_COL_INDEX = 5;
    public static int RF_COL_ID = 0;
    public static int RF_COL_VERSION = 1;
    public static int RF_COL_ACTIVE = 2;
    public static int RF_COL_DATA = 3;
    public static int RF_COL_DATE = 4;
    public static int RF_COL_INDEX = 5;
    public static final int COL_SEX = 0;
    public static final int COL_PARENTS = 1;
    public static final int COL_START = 2;
    public static final int COL_BIRTHDAY = 3;
    public static final int COL_END = 4;
    public static final int COL_LICENSE = 5;
    public static final int COL_LINE = 6;
    public static final int COL_STRAINS = 7;
    public static final int COL_KIDS = 8;
    public static final int COL_RESULTS = 9;
    public static final int MAX_COL = 9;
    protected static final char INDEX_SEP = '\'';
    protected static final String INDEX_SEP_S = "'";
    private static final int[] MULTIPLE_VALUE_COLUMNS = new int[]{1, 7, 8, 9, 5};
    private final long ivMinID;
    private long ivMaxID;
    private final String ivFilename;
    private final String ivSessFilename;
    private final String ivProtFilename;
    private final String ivIndexFilename;
    private final int[] ivVersions;
    private final Object[] ivContent;
    private final String[] ivIndices;
    private final StringBuilder ivMSB = new StringBuilder(1000);
    private final StringBuilder ivInflSB = new StringBuilder(1000);
    private final StringBuilder ivProtSB = new StringBuilder(1000);
    private final StringBuilder ivIndexSB = new StringBuilder(100);
    private HashMap ivSpezalIndexForActuals = null;
    static /* synthetic */ Class class$0;

    static {
        int i = 0;
        while (i < OBJECTS_PER_SUB_BY_TYPE.length) {
            DFAscSub.OBJECTS_PER_SUB_BY_TYPE[i] = 100;
            ++i;
        }
        DFAscSub.OBJECTS_PER_SUB_BY_TYPE[1] = 1000;
        DFAscSub.OBJECTS_PER_SUB_BY_TYPE[2] = 1000;
        DFAscSub.OBJECTS_PER_SUB_BY_TYPE[5] = 1000;
        DFAscSub.OBJECTS_PER_SUB_BY_TYPE[11] = 1000;
    }

    public static long getMinID(String filename) {
        if (filename.endsWith(".dasc")) {
            String s = filename.substring(0, filename.length() - ".dasc".length());
            while (s.startsWith("0") && s.length() > 1) {
                s = s.substring(1, s.length());
            }
            try {
                return Long.parseLong(s) * 100L;
            }
            catch (Exception e) {
                String string = "Malformed filename " + filename;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("de.hannse.netobjects.datalayer.dfa.DFAscSub");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.error(string, e, clazz);
            }
        }
        return -1L;
    }

    public static int getBlockSize(int type) {
        return OBJECTS_PER_SUB_BY_TYPE[type];
    }

    public static int getMatchingPosInSubArr(long id, int type) {
        return (int)(id / (long)OBJECTS_PER_SUB_BY_TYPE[type]);
    }

    public static long getMatchingMinID(long id, int type) {
        return id / (long)OBJECTS_PER_SUB_BY_TYPE[type] * (long)OBJECTS_PER_SUB_BY_TYPE[type];
    }

    public static String getDataPath(String dir, long minID) {
        String numStr = DFAscSub.getNumStr(minID);
        return String.valueOf(dir) + "/" + numStr + ".dasc";
    }

    public static String getSessionPath(String dir, long minID) {
        String numStr = DFAscSub.getNumStr(minID);
        return String.valueOf(dir) + "/" + numStr + ".sasc";
    }

    public static String getIndexPath(String dir, long minID) {
        String numStr = DFAscSub.getNumStr(minID);
        return String.valueOf(dir) + "/" + numStr + ".iasc";
    }

    private static String getNumStr(long minID) {
        long startNumber = minID / 100L;
        String numStr = Long.toString(startNumber);
        while (numStr.length() < 7) {
            numStr = "0" + numStr;
        }
        return numStr;
    }

    private static byte[] getData(IDObject ido, StringBuilder inflSB) {
        inflSB.setLength(0);
        ido.appendValueString(inflSB);
        return StrInflDefl.deflateToByteArray(inflSB.toString());
    }

    protected static String getLine(IDObject ido, StringBuilder msb, StringBuilder inflSB, StringBuilder indexSB, long position) {
        msb.setLength(0);
        inflSB.setLength(0);
        indexSB.setLength(0);
        ido.appendCacheString(msb, false, inflSB, indexSB);
        int hc = DFAscSub.hc(msb);
        msb.append(ObjectManagerCache.MAIN_SEP).append(hc);
        indexSB.append(position).append(ObjectManagerCache.MAIN_SEP);
        if (ido instanceof Mouse) {
            if (ido.existed()) {
                ObjectIndex.appendIndexInfo((Mouse)ido, indexSB, '\'');
            }
        } else if (ido instanceof Session) {
            ObjectIndex.appendIndexInfo((Session)ido, indexSB, '\'');
        } else if (ido instanceof Mail && ido.isAlive()) {
            indexSB.append(((Mail)ido).getSpecialIndex());
        } else if (ido instanceof Cage && ido.isAlive() && CageTalker.useCageTalker()) {
            indexSB.append(((Cage)ido).getSpecialIndex());
        }
        msb.append("\n");
        indexSB.append("\n");
        return msb.toString();
    }

    public static synchronized boolean saveSessions(IDObject ido, TreeSet sessionIDs, String filename) {
        if (sessionIDs != null && !sessionIDs.isEmpty() && ido.storesSession()) {
            if (filename.contains("/null/")) {
                String string = "Filename contains 'null' " + ido + " -> " + filename;
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("de.hannse.netobjects.datalayer.dfa.DFAscSub");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.error(string, illegalArgumentException, clazz);
            } else {
                return FileManager.pureAppend(filename, String.valueOf(ido.getID()) + ":*" + IDObjectXMLHandler.getSessionString(sessionIDs) + "\n");
            }
        }
        return true;
    }

    private static int hc(String s) {
        int h = 0;
        int len = s.length();
        int i = len - 1;
        while (i >= 0) {
            h = h * 37 + s.charAt(i);
            --i;
        }
        return h;
    }

    public static int hc(StringBuilder s) {
        int h = 0;
        int len = s.length();
        int i = len - 1;
        while (i >= 0) {
            h = h * 37 + s.charAt(i);
            --i;
        }
        return h;
    }

    public DFAscSub(String dir, int type, long minID, DFAsc target, String group) {
        int blockSize = OBJECTS_PER_SUB_BY_TYPE[type];
        this.ivVersions = new int[blockSize];
        this.ivContent = new Object[blockSize];
        this.ivIndices = type == 1 ? new String[blockSize] : null;
        int i = 0;
        while (i < this.ivVersions.length) {
            this.ivVersions[i] = 0;
            this.ivContent[i] = null;
            ++i;
        }
        this.ivMinID = minID;
        this.ivMaxID = minID;
        this.ivFilename = DFAscSub.getDataPath(dir, minID);
        this.ivSessFilename = DFAscSub.getSessionPath(dir, minID);
        this.ivIndexFilename = DFAscSub.getIndexPath(dir, minID);
        this.ivProtFilename = String.valueOf(dir) + "/" + "prot.asc";
        File indexFile = new File(this.ivIndexFilename);
        if (indexFile.exists()) {
            long fpos = 0L;
            try {
                BufferedReader reader = new BufferedReader(new FileReader(indexFile));
                String line = reader.readLine();
                while (line != null) {
                    if (line.length() != 0 && !line.startsWith("#")) {
                        this.createNewEntry(line, fpos, type, group);
                    }
                    fpos += (long)line.length() + 1L;
                    line = reader.readLine();
                }
                reader.close();
            }
            catch (Throwable e) {
                String string = "Problem initializing data file " + this.ivFilename;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("de.hannse.netobjects.datalayer.dfa.DFAscSub");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.error(string, e, clazz);
            }
        }
        target.setMax(this.ivMaxID);
        Runtime.getRuntime().gc();
    }

    public synchronized boolean saveSession(IDObject ido, long sessionID) {
        if (ido.storesSession()) {
            return FileManager.pureAppend(this.ivSessFilename, String.valueOf(ido.getID()) + ":" + sessionID + "\n");
        }
        return true;
    }

    public synchronized boolean saveObject(IDObject ido, boolean mitProt) {
        boolean res = true;
        long aktsize = new File(this.ivFilename).length();
        byte[] data = DFAscSub.getData(ido, this.ivInflSB);
        if (data != null) {
            int date = (int)(System.currentTimeMillis() / 86400000L);
            int version = ido.getInt("IDO_VERSION");
            boolean alive = ido.isAlive();
            long id = ido.getID();
            this.ivMSB.setLength(0);
            this.ivProtSB.setLength(0);
            this.ivIndexSB.setLength(0);
            this.ivIndexSB.append(id).append(ObjectManagerCache.MAIN_SEP);
            this.ivIndexSB.append(version).append(ObjectManagerCache.MAIN_SEP);
            this.ivIndexSB.append(alive ? "1" : "0").append(ObjectManagerCache.MAIN_SEP);
            this.ivIndexSB.append(aktsize).append(ObjectManagerCache.MAIN_SEP);
            this.ivIndexSB.append(date).append(ObjectManagerCache.MAIN_SEP);
            this.ivProtSB.append(id).append(ObjectManagerCache.MAIN_SEP);
            this.ivProtSB.append(version).append(ObjectManagerCache.MAIN_SEP);
            this.ivProtSB.append(alive ? "1" : "0").append(ObjectManagerCache.MAIN_SEP);
            this.ivProtSB.append(Base64Manager.encodeBase64(data)).append(ObjectManagerCache.MAIN_SEP);
            this.ivProtSB.append(date).append(ObjectManagerCache.MAIN_SEP);
            if (ido instanceof Mouse) {
                if (ido.existed()) {
                    ObjectIndex.appendIndexInfo((Mouse)ido, this.ivMSB, '\'');
                }
            } else if (ido instanceof Session) {
                ObjectIndex.appendIndexInfo((Session)ido, this.ivMSB, '\'');
            } else if (ido instanceof Mail && ido.isAlive()) {
                this.ivMSB.append(((Mail)ido).getSpecialIndex());
            } else if (ido instanceof Cage && ido.isAlive() && CageTalker.useCageTalker()) {
                this.ivMSB.append(((Cage)ido).getSpecialIndex());
            }
            String index = this.ivMSB.toString();
            this.ivIndexSB.append(index);
            this.ivProtSB.append(index);
            this.ivIndexSB.append("\n");
            this.ivProtSB.append("\n");
            boolean bl = res = mitProt ? FileManager.pureAppend(this.ivProtFilename, this.ivProtSB.toString()) : true;
            if (res) {
                try {
                    FileOutputStream fos = new FileOutputStream(this.ivFilename, true);
                    DataOutputStream dos = new DataOutputStream(fos);
                    dos.writeInt(data.length);
                    dos.writeInt(Arrays.hashCode(data));
                    dos.write(data);
                    dos.close();
                    res = true;
                }
                catch (Throwable e) {
                    String string = "Problem saving IDObject " + ido;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("de.hannse.netobjects.datalayer.dfa.DFAscSub");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Log.error(string, e, clazz);
                }
                if (res) {
                    res = FileManager.pureAppend(this.ivIndexFilename, this.ivIndexSB.toString());
                }
                if (res) {
                    Object object;
                    int arrPos = (int)(id - this.ivMinID);
                    if (alive) {
                        object = data;
                    } else {
                        Long l;
                        object = l;
                        l = new Long(aktsize);
                    }
                    this.ivContent[arrPos] = object;
                    int n = this.ivVersions[arrPos] = alive ? version : -version;
                    if (this.ivIndices != null) {
                        this.ivIndices[arrPos] = index;
                    }
                    Object spezIndObject = null;
                    boolean useSpezInd = false;
                    if (ido instanceof Mail) {
                        useSpezInd = true;
                        if (ido.isAlive()) {
                            Mail mail = (Mail)ido;
                            spezIndObject = mail.getSpecialIndexObject();
                        }
                    }
                    if (useSpezInd) {
                        if (spezIndObject != null) {
                            if (this.ivSpezalIndexForActuals == null) {
                                this.ivSpezalIndexForActuals = new HashMap();
                            }
                            this.ivSpezalIndexForActuals.put(ido.getLongID(), spezIndObject);
                        } else if (this.ivSpezalIndexForActuals != null) {
                            this.ivSpezalIndexForActuals.remove(ido.getLongID());
                        }
                    }
                    if (id > this.ivMaxID) {
                        this.ivMaxID = id;
                    }
                }
            }
        }
        return res;
    }

    private synchronized void createNewEntry(String indexString, long filePos, int type, String group) {
        int[] arr = Zeile.getTrenner(indexString, ObjectManagerCache.MAIN_SEP_C, '\u0000');
        long id = Zeile.getLong(indexString, arr, '\u0000', IF_COL_ID, 0L);
        if (id > 0L) {
            String cageTalkerID;
            int arrPos = (int)(id - this.ivMinID);
            boolean alive = Zeile.getString(indexString, IF_COL_ACTIVE, "", arr, '\u0000').equals("1");
            int version = Zeile.getInt(indexString, arr, '\u0000', IF_COL_VERSION, 0);
            this.ivVersions[arrPos] = alive ? version : -version;
            String indexInfo = Zeile.getString(indexString, IF_COL_INDEX, "", arr, '\u0000');
            if (this.ivIndices != null) {
                this.ivIndices[arrPos] = indexInfo;
            }
            this.ivContent[arrPos] = new Long(Zeile.getLong(indexString, arr, '\u0000', IF_COL_POSITION, 0L));
            Object spezIndObject = null;
            if (type == 11) {
                if (alive) {
                    spezIndObject = Mail.getObjectForIndex(indexInfo);
                }
            } else if (type == 2 && CageTalker.useCageTalker() && alive && (cageTalkerID = (String)Cage.getObjectForIndex(indexInfo)) != null) {
                CageTalker.addUsedCagetalkerID(cageTalkerID);
            }
            if (spezIndObject != null) {
                if (this.ivSpezalIndexForActuals == null) {
                    this.ivSpezalIndexForActuals = new HashMap();
                }
                this.ivSpezalIndexForActuals.put(new Long(id), spezIndObject);
            }
            if (id > this.ivMaxID) {
                this.ivMaxID = id;
            }
        } else {
            String string = "Serious problem in Datafile " + this.ivFilename + " with line: " + indexString;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("de.hannse.netobjects.datalayer.dfa.DFAscSub");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.error(string, null, clazz);
        }
    }

    public void addObjectsForSpecialObject(String group, Integer type, Object spezObject, Vector target) {
        if (this.ivSpezalIndexForActuals != null) {
            Iterator iterator = this.ivSpezalIndexForActuals.keySet().iterator();
            while (iterator.hasNext()) {
                IDObject ido;
                Long id = (Long)iterator.next();
                Object ooo = this.ivSpezalIndexForActuals.get(id);
                if (!spezObject.equals(ooo) || (ido = this.getObject(id, group, type, true, false)) == null) continue;
                target.add(ido);
            }
        }
    }

    public IDObject getObject(long id, String group, Integer type, boolean onlyActual, boolean evenNonExisteds) {
        IDObject res;
        int arrPos = (int)(id - this.ivMinID);
        if (!(this.ivContent[arrPos] == null || this.ivVersions[arrPos] <= 0 && onlyActual || !(res = this.getObject(this.ivContent[arrPos], group, type, arrPos)).existed() && !evenNonExisteds)) {
            return res;
        }
        return null;
    }

    private IDObject getObject(Object content, String group, Integer type, int arrPos) {
        if (content != null) {
            if (content instanceof IDObject) {
                return (IDObject)content;
            }
            String zeile = this.getTransport(content);
            if (zeile != null) {
                IDObject ido;
                if (this.ivVersions[arrPos] > 0 && (this.ivContent[arrPos] == null || this.ivContent[arrPos] instanceof Long)) {
                    this.ivContent[arrPos] = zeile.getBytes();
                }
                if ((ido = IDObject.initObjectFromTransport(type, group, zeile)) != null) {
                    ido.afterInit();
                }
                return ido;
            }
        }
        return null;
    }

    public String getIndex(long id) {
        return this.ivIndices[(int)(id - this.ivMinID)];
    }

    public void addIndexIds(int indexCol, String vgl, String vglV, String vglM, String vglH, HashSet target) {
        int i = 0;
        while (i < this.ivIndices.length) {
            String s;
            if (this.ivIndices[i] != null && (s = ZeileAbstr.getPart(this.ivIndices[i], '\'', indexCol, null)) != null) {
                if (s.equals(vgl)) {
                    target.add(new Long((long)i + this.ivMinID));
                } else if (vglV != null && (s.startsWith(vglV) || s.endsWith(vglH) || s.contains(vglM))) {
                    target.add(new Long((long)i + this.ivMinID));
                }
            }
            ++i;
        }
    }

    public void giveIndicesToChecker(IndexChecker rep) {
        int i = 0;
        while (i < this.ivIndices.length) {
            if (this.ivIndices[i] != null) {
                rep.checkIndex(new Long((long)i + this.ivMinID), this.ivIndices[i]);
            }
            ++i;
        }
    }

    public static boolean isMultipleValueIndex(int indexCol) {
        int i = 0;
        while (i < MULTIPLE_VALUE_COLUMNS.length) {
            if (indexCol == MULTIPLE_VALUE_COLUMNS[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int getVersion(long id) {
        int arrPos = (int)(id - this.ivMinID);
        if (this.ivContent[arrPos] != null) {
            return this.ivVersions[arrPos] > 0 ? this.ivVersions[arrPos] : -this.ivVersions[arrPos];
        }
        return 0;
    }

    public void addIDs(TreeSet ts, boolean all, boolean alive, boolean dead) {
        int i = 0;
        while (i < this.ivContent.length) {
            if (this.ivContent[i] != null) {
                if (all) {
                    ts.add(new Long(this.ivMinID + (long)i));
                } else if (alive && this.ivVersions[i] > 0) {
                    ts.add(new Long(this.ivMinID + (long)i));
                } else if (dead && this.ivVersions[i] < 0) {
                    ts.add(new Long(this.ivMinID + (long)i));
                }
            }
            ++i;
        }
    }

    public void addVersionsOfActuals(HashMap hm) {
        int i = 0;
        while (i < this.ivContent.length) {
            if (this.ivContent[i] != null && this.ivVersions[i] > 0) {
                hm.put(new Long(this.ivMinID + (long)i), new Integer(this.ivVersions[i]));
            }
            ++i;
        }
    }

    public int countActuals() {
        int sum = 0;
        int i = 0;
        while (i < this.ivContent.length) {
            if (this.ivContent[i] != null && this.ivVersions[i] > 0) {
                ++sum;
            }
            ++i;
        }
        return sum;
    }

    public String getTransport(long id) {
        int arrPos = (int)(id - this.ivMinID);
        return this.getTransport(this.ivContent[arrPos]);
    }

    public boolean isObjectDa(long id) {
        int arrPos = (int)(id - this.ivMinID);
        return this.ivContent[arrPos] != null;
    }

    public boolean isObjectActual(long id) {
        int arrPos = (int)(id - this.ivMinID);
        if (this.ivContent[arrPos] != null) {
            return this.ivVersions[arrPos] > 0;
        }
        return false;
    }

    public boolean hasActiveObjects() {
        int i = 0;
        while (i < this.ivVersions.length) {
            if (this.ivVersions[i] > 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private String getTransport(Object content) {
        if (content != null) {
            String zeile = null;
            if (content instanceof byte[]) {
                zeile = Base64Manager.encodeBase64((byte[])content);
            } else if (content instanceof Long) {
                try {
                    RandomAccessFile raf = new RandomAccessFile(this.ivFilename, "r");
                    raf.seek((Long)content);
                    int len = raf.readInt();
                    int hashCode = raf.readInt();
                    byte[] arr = new byte[len];
                    raf.readFully(arr);
                    raf.close();
                }
                catch (Exception e) {
                    Log.error("Problem opening file >" + this.ivFilename + "< while getting object", e, this);
                }
            }
            return zeile;
        }
        return null;
    }

    public TreeSet getSessionIDs(long id) {
        TreeSet ts = new TreeSet();
        String starter = String.valueOf(id) + ":";
        int slen = starter.length();
        try {
            LineNumberReader lnr = new LineNumberReader(new FileReader(this.ivSessFilename));
            String line = lnr.readLine();
            while (line != null) {
                if (line.startsWith(starter)) {
                    String hinten = line.substring(slen, line.length());
                    if (hinten.startsWith("*")) {
                        ts.clear();
                        hinten = hinten.substring(1, hinten.length());
                    }
                    IDObjectXMLHandler.appendToSessionTreeset(hinten, ts);
                }
                line = lnr.readLine();
            }
            lnr.close();
        }
        catch (Throwable e) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("de.hannse.netobjects.datalayer.dfa.DFAscSub");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.error("Problem beim Ermitteln der Sessions", e, clazz);
        }
        return ts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getObjects(boolean alsoDead, ObjectConsumer consumer, IDObject larve, Hashtable erg, String group, Integer type) {
        Object[] objectArray = this.ivContent;
        synchronized (this.ivContent) {
            try {
                int arrpos = 0;
                while (arrpos < this.ivContent.length) {
                    if (this.ivContent[arrpos] != null && (this.ivVersions[arrpos] > 0 || alsoDead)) {
                        try {
                            IDObject iob = this.getObject(this.ivContent[arrpos], group, type, arrpos);
                            if (iob != null) {
                                if (consumer != null) {
                                    consumer.handleNewObject(iob);
                                    iob.dispose();
                                } else if (erg != null) {
                                    erg.put(iob.getLongID(), iob);
                                }
                            }
                        }
                        catch (Exception e) {
                            Log.error("Could not get actual Object: ", e, this);
                        }
                    }
                    ++arrpos;
                }
            }
            catch (Throwable e) {
                Log.error("Could not get all actual Objects: ", e, this);
            }
            return;
        }
    }

    public long getMinIDL() {
        return this.ivMinID;
    }
}

