/*
 * Decompiled with CFR 0.152.
 */
package de.hannse.netobjects.java;

import de.hannse.netobjects.java.CreatorField;
import de.hannse.netobjects.java.CreatorMethod;
import de.hannse.netobjects.java.CreatorOpcodes;
import de.hannse.netobjects.java.PoolHolder;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class CreatorClass {
    public static final int CONST_UTF8 = 1;
    public static final int CONST_INTEGER = 3;
    public static final int CONST_FLOAT = 4;
    public static final int CONST_LONG = 5;
    public static final int CONST_DOUBLE = 6;
    public static final int CONST_CLASS = 7;
    public static final int CONST_STRING = 8;
    public static final int CONST_FIELDREF = 9;
    public static final int CONST_METHODREF = 10;
    public static final int CONST_INTERFACEMETHODREF = 11;
    public static final int CONST_NAMEANDTYPE = 12;
    public String ivClassName;
    public String ivSuperClassName;
    public int ivMagic = -889275714;
    public int ivMinVersion = 3;
    public int ivMaxVersion = 45;
    public Vector ivPool = new Vector();
    public Vector ivInterfaces = new Vector();
    public Vector ivFields = new Vector();
    public Vector ivMethods = new Vector();
    public Vector ivAttributes = new Vector();
    public PoolHolder ivThisClassHolder;
    public PoolHolder ivSuperClassHolder;
    protected CreatorMethod cm;

    public void init(String name, String sname) {
        this.ivClassName = name;
        this.ivSuperClassName = sname;
        if (this.ivSuperClassName == null) {
            this.ivSuperClassName = "java/lang/Object";
        }
        this.ivPool.addElement("ELIAS");
        this.ivThisClassHolder = this.createClassHolder(this.ivClassName);
        this.ivPool.addElement(this.ivThisClassHolder);
        this.ivSuperClassHolder = this.createClassHolder(this.ivSuperClassName);
        this.ivPool.addElement(this.ivSuperClassHolder);
        this.create();
    }

    public abstract void create();

    public void finishMethod(CreatorMethod icm) {
        icm.ivCodeAttribute.codeIt();
        this.ivMethods.addElement(icm);
    }

    public byte[] writeToBytes() {
        try {
            ByteArrayOutputStream bas = new ByteArrayOutputStream();
            this.writeIt(bas);
            bas.flush();
            bas.close();
            return bas.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void writeToFile() {
        File f = new File(String.valueOf(this.ivClassName) + ".class");
        try {
            this.writeIt(new FileOutputStream(f));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void writeIt(OutputStream os) {
        try {
            DataOutputStream das = new DataOutputStream(os);
            das.writeInt(this.ivMagic);
            das.writeShort(this.ivMinVersion);
            das.writeShort(this.ivMaxVersion);
            das.writeShort(this.ivPool.size());
            int i = 1;
            while (i < this.ivPool.size()) {
                PoolHolder ph = (PoolHolder)this.ivPool.elementAt(i);
                ph.writeIt(das, this);
                ++i;
            }
            das.writeShort(33);
            das.writeShort(this.getIndexOfPoolholder(this.ivThisClassHolder));
            das.writeShort(this.getIndexOfPoolholder(this.ivSuperClassHolder));
            das.writeShort(0);
            das.writeShort(this.ivFields.size());
            i = 0;
            while (i < this.ivFields.size()) {
                CreatorField cf = (CreatorField)this.ivFields.elementAt(i);
                cf.writeIt(das, this);
                ++i;
            }
            das.writeShort(this.ivMethods.size());
            i = 0;
            while (i < this.ivMethods.size()) {
                CreatorMethod icm = (CreatorMethod)this.ivMethods.elementAt(i);
                icm.writeIt(das, this);
                ++i;
            }
            das.writeShort(0);
            das.flush();
            das.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getIndexOfPoolholder(PoolHolder ph) {
        return this.ivPool.indexOf(ph);
    }

    public PoolHolder getUTFPoolholder(String s) {
        if (s == null) {
            return null;
        }
        int i = 1;
        while (i < this.ivPool.size()) {
            PoolHolder ph = (PoolHolder)this.ivPool.elementAt(i);
            if (ph.typ == 1 && s.equals(ph.strVal)) {
                return ph;
            }
            ++i;
        }
        return null;
    }

    public PoolHolder getClassPoolholder(String s) {
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return null;
        }
        int i = 1;
        while (i < this.ivPool.size()) {
            PoolHolder ph = (PoolHolder)this.ivPool.elementAt(i);
            if (ph.typ == 7 && ph.ph1 != null && s.equals(ph.ph1.strVal)) {
                return ph;
            }
            ++i;
        }
        return null;
    }

    public PoolHolder getStringPoolholder(String s) {
        if (s == null) {
            return null;
        }
        int i = 1;
        while (i < this.ivPool.size()) {
            PoolHolder ph = (PoolHolder)this.ivPool.elementAt(i);
            if (ph.typ == 8 && ph.ph1 != null && s.equals(ph.ph1.strVal)) {
                return ph;
            }
            ++i;
        }
        return null;
    }

    public PoolHolder getFieldPoolholder(String s) {
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return null;
        }
        int i = 1;
        while (i < this.ivPool.size()) {
            PoolHolder ph = (PoolHolder)this.ivPool.elementAt(i);
            if (ph.typ == 9 && ph.ph2 != null) {
                PoolHolder naty = ph.ph2;
                PoolHolder utfh = naty.ph1;
                if (s.equals(utfh.strVal)) {
                    return ph;
                }
            }
            ++i;
        }
        return null;
    }

    public PoolHolder createMethodHolder(String className, String methodName, String methodDescriptor) {
        PoolHolder methy = new PoolHolder(10);
        this.ivPool.addElement(methy);
        methy.ph1 = this.createClassHolder(className);
        methy.ph2 = this.createNameAndTypeHolder(methodName, methodDescriptor);
        return methy;
    }

    public PoolHolder createFieldHolder(String className, String fieldName, String fieldDescriptor) {
        PoolHolder methy = new PoolHolder(9);
        this.ivPool.addElement(methy);
        methy.ph1 = this.createClassHolder(className);
        methy.ph2 = this.createNameAndTypeHolder(fieldName, fieldDescriptor);
        return methy;
    }

    public PoolHolder createClassHolder(String className) {
        PoolHolder ch = this.getClassPoolholder(className);
        if (ch == null) {
            PoolHolder chnh = this.getUTFPoolholder(className);
            if (chnh == null) {
                chnh = new PoolHolder(1, className);
                this.ivPool.addElement(chnh);
            }
            ch = new PoolHolder(7);
            this.ivPool.addElement(ch);
            ch.ph1 = chnh;
        }
        return ch;
    }

    public PoolHolder createStringHolder(String stri) {
        PoolHolder ch = this.getStringPoolholder(stri);
        if (ch == null) {
            PoolHolder chnh = this.getUTFPoolholder(stri);
            if (chnh == null) {
                chnh = new PoolHolder(1, stri);
                this.ivPool.addElement(chnh);
            }
            ch = new PoolHolder(8);
            this.ivPool.addElement(ch);
            ch.ph1 = chnh;
        }
        return ch;
    }

    public PoolHolder createUTFHolder(String name) {
        PoolHolder erg = this.getUTFPoolholder(name);
        if (erg == null) {
            erg = new PoolHolder(1, name);
            this.ivPool.addElement(erg);
        }
        return erg;
    }

    public PoolHolder createNameAndTypeHolder(String name, String type) {
        PoolHolder naty = new PoolHolder(12);
        this.ivPool.addElement(naty);
        PoolHolder nh = this.getUTFPoolholder(name);
        if (nh == null) {
            nh = new PoolHolder(1, name);
            this.ivPool.addElement(nh);
        }
        naty.ph1 = nh;
        PoolHolder dh = this.getUTFPoolholder(type);
        if (dh == null) {
            dh = new PoolHolder(1, type);
            this.ivPool.addElement(dh);
        }
        naty.ph2 = dh;
        return naty;
    }

    public void mafi(String s) {
        StringTokenizer st = new StringTokenizer(s, "|");
        while (st.hasMoreTokens()) {
            String efs = st.nextToken();
            StringTokenizer st2 = new StringTokenizer(efs, ":");
            this.ivFields.addElement(new CreatorField(this, this.ivClassName, st2.nextToken(), st2.nextToken(), Integer.parseInt(st2.nextToken())));
        }
    }

    protected void aL(String s) {
        CreatorOpcodes.addLine(this.cm.ivCodeAttribute, s);
    }

    protected void nM(String s1, String s2, int i1, int i2, int i3, int i4) {
        this.cm = new CreatorMethod(this, s1, s2, i1);
        this.cm.ivCodeAttribute.ivMaxStack = i2;
        this.cm.ivCodeAttribute.ivMaxLocals = i3;
        this.cm.ivCodeAttribute.ivCodeLength = i4;
    }
}

