/*
 * Decompiled with CFR 0.152.
 */
package de.hannse.netobjects.objectstore;

import de.hannse.netobjects.datalayer.DataLayer;
import de.hannse.netobjects.datalayer.GroupFileManager;
import de.hannse.netobjects.network.server.ServerCommunicator;
import de.hannse.netobjects.objectstore.CommandManagerExecutive;
import de.hannse.netobjects.objectstore.CommandRequestBroadcaster;
import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.ObjectRequest;
import de.hannse.netobjects.objectstore.ObjectStoreServer;
import de.hannse.netobjects.session.Session;
import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.tools.FileManager;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.util.ArrayHelper;
import de.hannse.netobjects.util.Log;
import de.hannse.netobjects.util.MilliSpender;
import java.io.File;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.cage.cagetalker.CageTalker;
import mausoleum.helper.LongPunkt;
import mausoleum.helper.Zeile;
import mausoleum.helper.ZeileAbstr;
import mausoleum.objectstore.CommandManagerAllgemein;
import mausoleum.objectstore.CommandManagerBuilding;
import mausoleum.objectstore.CommandManagerCage;
import mausoleum.objectstore.CommandManagerExperiment;
import mausoleum.objectstore.CommandManagerLine;
import mausoleum.objectstore.CommandManagerLocus;
import mausoleum.objectstore.CommandManagerMail;
import mausoleum.objectstore.CommandManagerMouse;
import mausoleum.objectstore.CommandManagerObjectGroup;
import mausoleum.objectstore.CommandManagerQuotable;
import mausoleum.objectstore.CommandManagerRack;
import mausoleum.objectstore.CommandManagerRoom;
import mausoleum.objectstore.CommandManagerStrain;
import mausoleum.objectstore.CommandManagerTask;
import mausoleum.objectstore.CommandManagerUser;
import mausoleum.objectstore.CommandmanagerLicense;
import mausoleum.reports.TrafficReport;

public class CommandManager {
    private static final HashMap CMES_BY_COMMANDNAME = new HashMap();
    public static final CommandManager INSTANCE = new CommandManager();
    public static final String TRAFFIC_CHECK = "##TC|";
    public static final String TRAFFIC_DATE = "##TD|";
    public static final String TRAFFIC_DESC = "##TDESC|";
    private static final String[] SPECIAL_COMMANDS = new String[]{"MR", "CCONTIG", "MFULI", "MFULIET", "MI", "MIRID", "MTAKEMICE", "MAI_EXTRACT", "MAI_IMPORT_WITH_ROOM", "MAI_IMPORT"};
    public static boolean cvActive = true;
    private final Hashtable ivObjectBag = new Hashtable();
    private final Vector ivNewObjectsTarget = new Vector();
    private final HashSet ivWeanedMiceIentifiers = new HashSet();
    private final HashSet ivSpecialCommands = new HashSet();
    private long ivTrafficDateMillis = -1L;
    private final HashMap ivTrafficChecks = new HashMap();
    private boolean ivCheckTraffic = false;
    private String ivTrafficDescrBabel = null;
    private final HashMap ivTrafficProtsByGroup = new HashMap();
    private final LongPunkt ivTrafficTarget = new LongPunkt(-1L, -1L);
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static void init() {
        try {
            CommandManager.enterExecutive(new CommandManagerUser());
            CommandManager.enterExecutive(new CommandManagerStrain());
            CommandManager.enterExecutive(new CommandManagerLine());
            CommandManager.enterExecutive(new CommandManagerLocus());
            CommandManager.enterExecutive(new CommandManagerCage());
            CommandManager.enterExecutive(new CommandManagerRoom());
            CommandManager.enterExecutive(new CommandManagerRack());
            CommandManager.enterExecutive(new CommandManagerMail());
            CommandManager.enterExecutive(new CommandManagerMouse());
            CommandManager.enterExecutive(new CommandManagerExperiment());
            CommandManager.enterExecutive(new CommandManagerTask());
            CommandManager.enterExecutive(new CommandmanagerLicense());
            CommandManager.enterExecutive(new CommandManagerObjectGroup());
            CommandManager.enterExecutive(new CommandManagerAllgemein());
            CommandManager.enterExecutive(new CommandManagerBuilding());
            CommandManager.enterExecutive(new CommandManagerQuotable());
            new SessLogger();
        }
        catch (Exception e) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("de.hannse.netobjects.objectstore.CommandManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.error("Problem bei CommandManager-Initialisierung (aussen)", e, clazz);
        }
    }

    private static void enterExecutive(CommandManagerExecutive cme) {
        try {
            Enumeration en = cme.getKnownCommands();
            while (en.hasMoreElements()) {
                CMES_BY_COMMANDNAME.put(en.nextElement(), cme);
            }
        }
        catch (Exception e) {
            String string = "Problem bei CommandManager-Initialisierung (innen) " + cme.getClass().getName();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("de.hannse.netobjects.objectstore.CommandManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.error(string, e, clazz);
        }
    }

    public static CommandManagerExecutive getExecutive(String comm) {
        return (CommandManagerExecutive)CMES_BY_COMMANDNAME.get(comm);
    }

    public synchronized boolean handleCommand(ObjectRequest objectRequest, Session session, ServerCommunicator communicator) {
        boolean res = false;
        if (objectRequest != null) {
            Object[] commandsAndGroups = (Object[])objectRequest.ivObject;
            if (commandsAndGroups == null) {
                objectRequest.ivObject = "\n<no command specified>\n";
            } else {
                String[] groups = (String[])commandsAndGroups[0];
                String[] commands = (String[])commandsAndGroups[1];
                Object[] extraObjects = (Object[])objectRequest.ivExtraObject;
                HashMap serviceRoomOverides = new HashMap();
                boolean[] broadCastWanted = new boolean[1];
                res = true;
                this.ivObjectBag.clear();
                this.ivNewObjectsTarget.clear();
                this.ivWeanedMiceIentifiers.clear();
                this.ivSpecialCommands.clear();
                this.ivTrafficDateMillis = -1L;
                this.ivTrafficChecks.clear();
                this.ivCheckTraffic = false;
                this.ivTrafficDescrBabel = null;
                int guci = 0;
                while (guci < commands.length && res) {
                    String group = groups[guci];
                    String command = commands[guci];
                    Object extraObject = extraObjects == null ? null : extraObjects[guci];
                    long tid = MilliSpender.getMillis();
                    if (Log.shouldLog(0)) {
                        Log.subdebug("handleCommand (" + tid + "): " + command, this);
                    }
                    if (command.length() == 0) {
                        objectRequest.ivObject = "\n<invalid command specified: " + command + ">\n";
                    } else {
                        if (session != null) {
                            String sessionGroup = session.getGroup();
                            SessLogger.tempLog(Base64Manager.encodeBase64(sessionGroup), Base64Manager.encodeBase64(group), command, session.getID());
                            GroupFileManager.addToCommandProtocol(sessionGroup, command, session);
                        }
                        String[] reasonForDenial = new String[1];
                        Zeile commandLines = new Zeile(command, '\n');
                        int i = 0;
                        while (i < commandLines.size() && cvActive && res) {
                            String sComLine = commandLines.getStringNONEmpty(i, null);
                            if (Log.shouldLog(0)) {
                                Log.subdebug("handleCommand (" + tid + ") single line: " + sComLine, this);
                            }
                            if (sComLine != null && sComLine.length() >= 2 && cvActive) {
                                if (sComLine.startsWith(TRAFFIC_DATE)) {
                                    this.ivCheckTraffic = true;
                                    try {
                                        this.ivTrafficDateMillis = Long.parseLong(sComLine.substring(TRAFFIC_DATE.length(), sComLine.length()));
                                    }
                                    catch (Exception e) {
                                        Log.error("Problem etracting traffic date " + sComLine, e, this);
                                    }
                                } else if (sComLine.startsWith(TRAFFIC_CHECK)) {
                                    this.ivCheckTraffic = true;
                                    if (sComLine.length() > TRAFFIC_CHECK.length()) {
                                        Zeile z = new Zeile(sComLine, '|');
                                        this.ivTrafficChecks.put(z.getStringB64(1, ""), new LongPunkt(z.getLong(2, -1L), z.getLong(3, -1L)));
                                    }
                                } else if (sComLine.startsWith(TRAFFIC_DESC)) {
                                    this.ivCheckTraffic = true;
                                    this.ivTrafficDescrBabel = sComLine.substring(TRAFFIC_DESC.length(), sComLine.length());
                                } else if (!(res &= this.handleSingleCommandLine(group, sComLine, this.ivObjectBag, objectRequest, extraObject, broadCastWanted, this.ivNewObjectsTarget, reasonForDenial, this.ivWeanedMiceIentifiers, serviceRoomOverides))) {
                                    Iterator iter = this.ivObjectBag.values().iterator();
                                    while (iter.hasNext()) {
                                        Object ooo = iter.next();
                                        if (!(ooo instanceof IDObject)) continue;
                                        IDObject iob = (IDObject)ooo;
                                        iob.rollBack();
                                    }
                                    StringBuilder msb = new StringBuilder();
                                    msb.append("\n<").append(reasonForDenial[0]).append(">\n");
                                    objectRequest.ivObject = msb.toString();
                                    int j = 0;
                                    while (j < groups.length) {
                                        msb.append("\n").append(groups[j]).append(": ").append(commands[j]);
                                        ++j;
                                    }
                                    String string = "Command " + sComLine + " could not be exectuted. Modifications will be removed. All commands: " + msb.toString();
                                    Class<?> clazz = class$1;
                                    if (clazz == null) {
                                        try {
                                            clazz = Class.forName("de.hannse.netobjects.objectstore.CommandManager");
                                        }
                                        catch (ClassNotFoundException classNotFoundException) {
                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                        }
                                    }
                                    Log.error(string, null, clazz);
                                }
                            }
                            ++i;
                        }
                    }
                    if (Log.shouldLog(0)) {
                        Log.subdebug("handleCommand (" + tid + "): finished", this);
                    }
                    ++guci;
                }
                if (CageTalker.useCageTalker()) {
                    CageTalker.handleAfterCommand(this.ivObjectBag);
                }
                if (res && this.ivCheckTraffic) {
                    TrafficReport.checkTraffic(this.ivTrafficProtsByGroup, this.ivTrafficChecks, this.ivTrafficTarget, this.ivTrafficDateMillis, this.ivTrafficDescrBabel, this.ivNewObjectsTarget, this.ivObjectBag);
                }
                if (res && cvActive) {
                    if (broadCastWanted[0]) {
                        new CommandRequestBroadcaster(this.ivObjectBag, objectRequest, this.ivSpecialCommands, session, communicator, this.ivNewObjectsTarget, this.ivWeanedMiceIentifiers, serviceRoomOverides);
                    } else {
                        objectRequest.finish();
                        communicator.sendObjectAndUR(objectRequest, false);
                    }
                }
                this.ivNewObjectsTarget.clear();
                this.ivWeanedMiceIentifiers.clear();
                this.ivObjectBag.clear();
                this.ivSpecialCommands.clear();
            }
        }
        return res;
    }

    /*
     * Unable to fully structure code
     */
    private boolean handleSingleCommandLine(String group, String commandLine, Hashtable objectBag, ObjectRequest objectRequest, Object extraObject, boolean[] broadCastWanted, Vector newObjectsTarget, String[] reasonForDenial, HashSet weanedMiceIdentifiers, HashMap serviceRoomOverides) {
        if (commandLine != null) ** GOTO lbl5
        reasonForDenial[0] = "\n<invalid command specified: " + commandLine + ">\n";
        return false;
lbl-1000:
        // 1 sources

        {
            commandLine = commandLine.substring(1, commandLine.length());
lbl5:
            // 2 sources

            ** while (commandLine.startsWith((String)" "))
        }
lbl6:
        // 1 sources

        srid = new Long[1];
        commandElements = StringHelper.splitStringBySpacesWithEmpties(commandLine = CommandManagerExecutive.checkServiceRoomTag(commandLine, srid));
        if (commandElements == null || commandElements.isEmpty()) {
            reasonForDenial[0] = "\n<invalid command specified: " + commandLine + ">\n";
            return false;
        }
        comm = (String)commandElements.elementAt(0);
        cme = CommandManager.getExecutive(comm);
        if (cme != null) {
            if (ArrayHelper.findStringInArray(comm, CommandManager.SPECIAL_COMMANDS) != -1) {
                this.ivSpecialCommands.add(comm);
            }
            cme.ivBugString = null;
            if (cme.wantsBroadcastOfObjects(comm)) {
                broadCastWanted[0] = true;
            }
            if (!(res = cme.handleSingleCommandLine(commandElements, objectBag, group, objectRequest, extraObject, newObjectsTarget, weanedMiceIdentifiers, serviceRoomOverides, srid[0]))) {
                reasonForDenial[0] = cme.ivBugString != null ? cme.ivBugString : "unknown reason";
            }
            return res;
        }
        reasonForDenial[0] = "no Manager for command: " + commandLine;
        return false;
    }

    private static class SessLogger {
        private static final long SES_LOG_WAIT = 600000L;
        private static HashMap ivFilesBySessionGroupAndSessionID = new HashMap();

        private static void tempLog(String sessionGroupB64, String objectGroupB64, String comm, long sessionID) {
            FileManager.saveStringToFile("files/log/sesslogs/" + sessionGroupB64 + "_" + sessionID + "_" + MilliSpender.getMillis() + "_" + objectGroupB64, comm);
        }

        private SessLogger() {
            FileManager.prepareDirs("files/log/sesslogs");
            this.scan();
            Thread thread = new Thread(new Runnable(this){
                final /* synthetic */ SessLogger this$1;
                {
                    this.this$1 = sessLogger;
                }

                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                Thread.sleep(600000L);
                                SessLogger.access$0(this.this$1);
                            }
                        }
                        catch (Exception e) {
                            Class<?> clazz = class$0;
                            if (clazz == null) {
                                try {
                                    clazz = Class.forName("de.hannse.netobjects.objectstore.CommandManager$SessLogger");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            Log.error("Problem with SessionLog", e, clazz);
                            continue;
                        }
                        break;
                    }
                }
            });
            thread.setPriority(1);
            thread.start();
        }

        private synchronized void scan() {
            String[] files;
            File f = new File("files/log/sesslogs");
            if (f.exists() && f.isDirectory() && (files = f.list()) != null && files.length != 0) {
                String sessionID;
                Vector<String> filenames;
                Vector<String> vfiles = new Vector<String>();
                int i = 0;
                while (i < files.length) {
                    vfiles.add(files[i]);
                    ++i;
                }
                Collections.sort(vfiles);
                ivFilesBySessionGroupAndSessionID.clear();
                Iterator<Object> iterator = vfiles.iterator();
                while (iterator.hasNext()) {
                    String filename = (String)iterator.next();
                    Zeile z = new Zeile(filename, '_');
                    if (z.size() < 3) continue;
                    String sessionGroup = z.getString(0);
                    HashMap<String, Vector<String>> filenamesBySessionID = (HashMap<String, Vector<String>>)ivFilesBySessionGroupAndSessionID.get(sessionGroup);
                    if (filenamesBySessionID == null) {
                        filenamesBySessionID = new HashMap<String, Vector<String>>();
                        ivFilesBySessionGroupAndSessionID.put(sessionGroup, filenamesBySessionID);
                    }
                    if ((filenames = (Vector<String>)filenamesBySessionID.get(sessionID = z.getString(1))) == null) {
                        filenames = new Vector<String>();
                        filenamesBySessionID.put(sessionID, filenames);
                    }
                    filenames.add(filename);
                }
                iterator = ivFilesBySessionGroupAndSessionID.keySet().iterator();
                while (iterator.hasNext()) {
                    String sessionGroupB64 = (String)iterator.next();
                    String sessionGroup = Base64Manager.getDecodedString(sessionGroupB64);
                    HashMap filenamesBySessionID = (HashMap)ivFilesBySessionGroupAndSessionID.get(sessionGroupB64);
                    Iterator iterator2 = filenamesBySessionID.keySet().iterator();
                    while (iterator2.hasNext()) {
                        sessionID = (String)iterator2.next();
                        filenames = (Vector)filenamesBySessionID.get(sessionID);
                        Session session = (Session)ObjectStoreServer.getObjectDeadOrAlive(5, Long.parseLong(sessionID), sessionGroup, null, false, false);
                        if (session != null) {
                            boolean didIt = false;
                            Iterator iterator3 = filenames.iterator();
                            while (iterator3.hasNext()) {
                                String filename = (String)iterator3.next();
                                String objectGroup = ZeileAbstr.getStringB64(filename, '_', 3, sessionGroup);
                                String path = "files/log/sesslogs/" + filename;
                                String commands = FileManager.getStringFromFile(path);
                                if (commands == null || commands.length() == 0) continue;
                                session.addToLog(new Zeile(commands, '\n'), objectGroup, new File(path).lastModified());
                                didIt = true;
                            }
                            if (didIt) {
                                session.commit(true);
                                DataLayer.cvDataLayer.saveIDObject(session);
                            }
                        } else {
                            String string = "Session missing for SessionLog " + sessionGroup + " " + sessionID;
                            Class<?> clazz = class$0;
                            if (clazz == null) {
                                try {
                                    clazz = Class.forName("de.hannse.netobjects.objectstore.CommandManager$SessLogger");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            Log.error(string, null, clazz);
                        }
                        Iterator iterator3 = filenames.iterator();
                        while (iterator3.hasNext()) {
                            FileManager.deleteFile("files/log/sesslogs/" + (String)iterator3.next());
                        }
                    }
                }
            }
        }

        static /* synthetic */ void access$0(SessLogger sessLogger) {
            sessLogger.scan();
        }
    }
}

