/*
 * Decompiled with CFR 0.152.
 */
package de.hannse.netobjects.objectstore;

import de.hannse.netobjects.datalayer.DataLayer;
import de.hannse.netobjects.objectstore.CMMethodHolder;
import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.ObjectRequest;
import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.objectstore.ObjectStoreServer;
import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.util.Log;
import java.awt.Color;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.cage.Cage;
import mausoleum.gui.MusterColor;
import mausoleum.helper.AllgUtils;
import mausoleum.helper.Zeile;
import mausoleum.main.ProcessDefinition;
import mausoleum.mouse.Mouse;
import mausoleum.room.Room;

public abstract class CommandManagerExecutive {
    public static final String COL_TR = "@S@";
    private static final String SERVICE_ROOM_TAG = "!SRT:";
    public static final Boolean JAWOLL = new Boolean(true);
    private final Hashtable ivCommandHashtable = new Hashtable();
    private final int ivObjectType;
    protected Hashtable ivObjectBag;
    protected HashMap ivServiceRoomOverride;
    protected Vector ivNewObjectsTarget = null;
    protected HashSet ivWeanedMiceIdentifiers = null;
    protected String ivGroupname;
    protected String[] ivLine;
    public String ivBugString;
    protected IDObject ivObjectForCommand;
    protected ObjectRequest ivObjectRequest;
    protected Object ivExtraObject;
    protected Long ivGeneralSRId;

    public static String getServiceRoomTag(String group, int type, long id, String defVal) {
        return CommandManagerExecutive.getServiceRoomTag(ObjectStore.getObjectDeadOrAlive(type, id, group, null, true), defVal);
    }

    public static String getServiceRoomTag(IDObject ido, String defVal) {
        if (ProcessDefinition.isClient() && ido != null && ido.canSitInRoom()) {
            Long srID = ido.getServiceRoomID();
            return SERVICE_ROOM_TAG + (srID != null ? srID.toString() : "-1") + " ";
        }
        return defVal;
    }

    public static String checkServiceRoomTag(String commandLine, Long[] srid) {
        int ind;
        if (srid != null) {
            srid[0] = null;
        }
        if (commandLine.startsWith(SERVICE_ROOM_TAG) && (ind = commandLine.indexOf(" ")) != -1) {
            if (srid != null) {
                srid[0] = new Long(commandLine.substring(SERVICE_ROOM_TAG.length(), ind));
            }
            commandLine = commandLine.substring(ind + 1, commandLine.length());
        }
        return commandLine;
    }

    public CommandManagerExecutive(int t) {
        this.ivObjectType = t;
    }

    public void addMeth(String kennung, String methodName, int anzArguments, boolean wantsObject) {
        this.ivCommandHashtable.put(kennung, new CMMethodHolder(methodName, anzArguments, wantsObject, this.getClass()));
    }

    public Enumeration getKnownCommands() {
        return this.ivCommandHashtable.keys();
    }

    public boolean wantsBroadcastOfObjects(String command) {
        return true;
    }

    public abstract String getParsedCommandIfTouched(String var1, Zeile var2, String var3, int var4, long var5, String var7);

    public static String getPB64String(String pre, Zeile z, int pos) {
        if (z != null) {
            return String.valueOf(pre) + Base64Manager.getDecodedString(z.getString(pos, ""));
        }
        return pre;
    }

    public IDObject getIDObject(String group, int type, long id) {
        return ObjectStore.getObjectDeadOrAlive(type, id, group, this.ivObjectBag, false);
    }

    protected String getIDObjectRef(String group, int type, long id, String objectGroup) {
        IDObject ido = null;
        if (objectGroup != null && DataLayer.typeIsPossible(objectGroup, type)) {
            ido = ObjectStore.getObjectDeadOrAlive(type, id, objectGroup, this.ivObjectBag, false);
        }
        if (ido == null && DataLayer.typeIsPossible(group, type)) {
            ido = ObjectStore.getObjectDeadOrAlive(type, id, group, this.ivObjectBag, false);
        }
        if (ido != null) {
            if (ido instanceof Mouse) {
                Mouse mouse = (Mouse)ido;
                return mouse.getIDStringForReports(false);
            }
            if (ido instanceof Cage) {
                Cage cage = (Cage)ido;
                return cage.getLabelIDString();
            }
            return ido.getBrowseName();
        }
        return "<" + IDObject.getASCIILabelForType(type) + " ID " + id + ">";
    }

    public synchronized boolean handleSingleCommandLine(Vector commandLineVector, Hashtable objectBag, String groupForCommandLine, ObjectRequest or, Object extraObject, Vector newObjectsTarget, HashSet weanedMiceIdentifiers, HashMap serviceRoomOverides, Long generalServiceRoomID) {
        String com = (String)commandLineVector.elementAt(0);
        CMMethodHolder cmmh = (CMMethodHolder)this.ivCommandHashtable.get(com);
        if (cmmh == null) {
            Log.error("Method for " + com + " not provided", null, this);
            or.ivObject = "\n<Method for " + com + " not provided>\n";
            return false;
        }
        if (cmmh.ivNumParams != -1 && commandLineVector.size() != cmmh.ivNumParams) {
            Log.error(String.valueOf(com) + "Wrong number of Arguments [" + cmmh.ivNumParams + "] -> " + commandLineVector.size(), null, this);
            or.ivObject = "\n<Wrong number of Arguments [" + cmmh.ivNumParams + "] -> " + commandLineVector.size() + ">\n";
            return false;
        }
        Method m = cmmh.ivMethod;
        if (m == null) {
            Log.error("Method for " + com + " not present", null, this);
            or.ivObject = "\n<Method for " + com + " not specified>\n";
            return false;
        }
        this.ivObjectBag = objectBag;
        this.ivGroupname = groupForCommandLine;
        this.ivNewObjectsTarget = newObjectsTarget;
        this.ivWeanedMiceIdentifiers = weanedMiceIdentifiers;
        this.ivServiceRoomOverride = serviceRoomOverides;
        this.ivGeneralSRId = generalServiceRoomID;
        this.ivExtraObject = extraObject;
        this.ivLine = new String[commandLineVector.size()];
        int i = 0;
        while (i < commandLineVector.size()) {
            this.ivLine[i] = (String)commandLineVector.elementAt(i);
            ++i;
        }
        if (cmmh.ivWantsObject) {
            this.ivObjectForCommand = ObjectStoreServer.getObjectToUpdate(this.ivObjectType, Long.parseLong(this.ivLine[1]), groupForCommandLine, objectBag);
            if (this.ivObjectForCommand == null) {
                Log.error("couldn't get Object to Update Group: " + this.ivGroupname + " Type: " + IDObject.getFilenameForTypeServerSide(this.ivObjectType) + " ID: " + this.ivLine[1], null, this);
                or.ivObject = "\n<couldn't get Object to Update>\n";
                return false;
            }
            if (this.ivGeneralSRId != null && IDObject.canSitInRoom(this.ivObjectType)) {
                this.ivServiceRoomOverride.put(this.ivObjectForCommand.getIdentifierString(), this.ivGeneralSRId);
            }
        }
        Object oo = null;
        try {
            this.ivObjectRequest = or;
            oo = m.invoke((Object)this, null);
            this.ivObjectRequest = null;
        }
        catch (Throwable e) {
            Log.error("Invocation of " + cmmh.ivMethod.getName() + " leads to Exception", e, this);
            or.ivObject = "\n<Invocation of " + cmmh.ivMethod.getName() + " leads to Exception>\n";
            this.ivObjectRequest = null;
            return false;
        }
        if (oo == null) {
            Log.error("Invocation of " + cmmh.ivMethod.getName() + " gives no Return-Value.", null, this);
            or.ivObject = "\n<Invocation of " + cmmh.ivMethod.getName() + " gives no Return-Value.>\n";
            return false;
        }
        if (!(oo instanceof Boolean)) {
            Log.error("Invocation of " + cmmh.ivMethod.getName() + " gives not a Boolean as Return-Value.", null, this);
            or.ivObject = "\n<Invocation of " + cmmh.ivMethod.getName() + " gives not a Boolean as Return-Value.>\n";
            return false;
        }
        Boolean bb = (Boolean)oo;
        return bb;
    }

    public static long[] extractIDs(String s) {
        long[] idArray = null;
        if (s != null && s.length() != 0 && !s.equals("0")) {
            Zeile z = new Zeile(s, '|');
            idArray = new long[z.size()];
            int i = 0;
            while (i < idArray.length) {
                idArray[i] = z.getLong(i, 0L);
                ++i;
            }
        }
        return idArray;
    }

    public boolean removeComObject() {
        this.ivObjectForCommand.set("IDO_END_DATE", new Date());
        if (this.isServiceGroup() && this.ivObjectForCommand.isFullServicableObject()) {
            this.ivObjectForCommand.setAndPropagateAttributes(this.ivObjectBag, null, null, null);
        }
        return true;
    }

    public boolean setVisible() {
        this.ivObjectForCommand.set("IDO_VISIBLE", new Boolean(true));
        this.ivObjectForCommand.set("IDO_END_DATE", null);
        if (this.ivObjectForCommand instanceof Mouse) {
            Mouse mouse = (Mouse)this.ivObjectForCommand;
            mouse.set("MOS_ENDMODE", null);
        }
        if (this.isServiceGroup() && this.ivObjectForCommand.isFullServicableObject()) {
            this.ivObjectForCommand.setAndPropagateAttributes(this.ivObjectBag, null, null, null);
        }
        return true;
    }

    public boolean setInvisible() {
        this.ivObjectForCommand.set("IDO_VISIBLE", new Boolean(false));
        if (this.isServiceGroup() && this.ivObjectForCommand.isFullServicableObject()) {
            this.ivObjectForCommand.setAndPropagateAttributes(this.ivObjectBag, null, null, null);
        }
        return true;
    }

    protected boolean finishNewObject(IDObject obi, String millis) {
        if (millis == null) {
            obi.set("IDO_START_DATE", new Date());
        } else {
            obi.set("IDO_START_DATE", new Date(Long.parseLong(millis)));
        }
        obi.set("IDO_GROUP", this.ivGroupname);
        if (!DataLayer.cvDataLayer.provideNewIDToIDObject(obi)) {
            Log.error("couldn't get ID for new Object", null, this);
            return false;
        }
        this.ivObjectBag.put(obi.getIdentifierString(), obi);
        this.ivNewObjectsTarget.add(obi);
        return true;
    }

    public static Color convertToColor(String s) {
        String zs = StringHelper.gSub(s, COL_TR, "|");
        Zeile z = new Zeile(zs, '|');
        if (z.size() == 3) {
            return new Color(z.getInt(0, 0), z.getInt(1, 0), z.getInt(2, 0));
        }
        if (z.size() == 7) {
            Color c1 = new Color(z.getInt(0, 0), z.getInt(1, 0), z.getInt(2, 0));
            Color c2 = new Color(z.getInt(3, 0), z.getInt(4, 0), z.getInt(5, 0));
            return new MusterColor(c1, c2, z.getInt(6, 0));
        }
        return Color.white;
    }

    public static String convertColor(Color c) {
        StringBuffer msb = new StringBuffer();
        if (c instanceof MusterColor) {
            MusterColor mc = (MusterColor)c;
            msb.append(mc.getRed()).append(COL_TR);
            msb.append(mc.getGreen()).append(COL_TR);
            msb.append(mc.getBlue()).append(COL_TR);
            Color c2 = mc.ivSecondColor;
            msb.append(c2.getRed()).append(COL_TR);
            msb.append(c2.getGreen()).append(COL_TR);
            msb.append(c2.getBlue()).append(COL_TR);
            msb.append(mc.ivMuster);
        } else {
            msb.append(c.getRed()).append(COL_TR);
            msb.append(c.getGreen()).append(COL_TR);
            msb.append(c.getBlue());
        }
        return msb.toString();
    }

    public static String getDescr(Color col) {
        if (col instanceof MusterColor) {
            MusterColor mc = (MusterColor)col;
            return "Pattern Nr.: " + mc.ivMuster + " Color 1:" + mc.getRed() + "," + mc.getGreen() + "," + mc.getBlue() + " Color 2:" + mc.ivSecondColor.getRed() + "," + mc.ivSecondColor.getGreen() + "," + mc.ivSecondColor.getBlue();
        }
        return String.valueOf(col.getRed()) + "," + col.getGreen() + "," + col.getBlue();
    }

    public boolean setStringAndPropagate(int posInIvLine, String tag, boolean withB64) {
        String string = withB64 ? Base64Manager.getDecodedString(this.ivLine[posInIvLine]).trim() : this.ivLine[posInIvLine].trim();
        this.ivObjectForCommand.setAndPropagateAttributes(this.ivObjectBag, null, tag, string.length() != 0 ? string : null);
        return true;
    }

    public void markObjectsForServiceRoom(Vector objects, Long serviceRoomID) {
        if (objects != null && serviceRoomID != null && this.ivServiceRoomOverride != null) {
            Iterator iterator = objects.iterator();
            while (iterator.hasNext()) {
                IDObject ido = (IDObject)iterator.next();
                this.ivServiceRoomOverride.put(ido.getIdentifierString(), serviceRoomID);
            }
        }
    }

    public void markObjectForServiceRoom(IDObject ido, long groupRoomID) {
        Long serviceRoomID = null;
        Room toRoom = (Room)ObjectStore.getObjectDeadOrAlive(10, groupRoomID, this.ivGroupname, this.ivObjectBag, false);
        if (toRoom != null) {
            serviceRoomID = toRoom.getServiceRoomID();
        }
        Vector<IDObject> v = new Vector<IDObject>();
        v.add(ido);
        this.markObjectsForServiceRoom(v, serviceRoomID != null ? serviceRoomID : AllgUtils.NIX_ROOM);
    }

    public boolean setIntAttributeAndPropagate(int posInIvLine, String attributeTag, int nullValue) {
        boolean res = this.setIntAttribute(posInIvLine, attributeTag, nullValue);
        if (res) {
            this.ivObjectForCommand.setAndPropagateAttributes(this.ivObjectBag, null, null, null);
        }
        return res;
    }

    public boolean setIntAttribute(int posInIvLine, String attributeTag, int nullValue) {
        try {
            int value = Integer.parseInt(this.ivLine[posInIvLine]);
            this.ivObjectForCommand.set(attributeTag, value == nullValue ? null : new Integer(value));
            return true;
        }
        catch (Exception e) {
            Log.error("Problem bei setIntAttribute " + this.ivLine[posInIvLine], e, this);
            return false;
        }
    }

    public boolean isServiceGroup() {
        return this.ivGroupname.equals("service");
    }
}

